/*
 * Decompiled with CFR 0.152.
 */
package com.hjimi.api.iminect;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.os.AsyncTask;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.hjimi.api.iminect.ImiBitPerPixelType;
import com.hjimi.api.iminect.ImiCameraFrame;
import com.hjimi.api.iminect.ImiCameraFrameMode;
import com.hjimi.api.iminect.ImiCameraIntrinsic;
import com.hjimi.api.iminect.ImiCameraParaData;
import com.hjimi.api.iminect.ImiCameraPixelFormat;
import com.hjimi.api.iminect.ImiDeviceAttribute;
import com.hjimi.api.iminect.ImiDeviceFlags;
import com.hjimi.api.iminect.ImiDeviceParamsStatus;
import com.hjimi.api.iminect.ImiDeviceState;
import com.hjimi.api.iminect.ImiDeviceTemperature;
import com.hjimi.api.iminect.ImiDriverInfo;
import com.hjimi.api.iminect.ImiDriverType;
import com.hjimi.api.iminect.ImiErrorCode;
import com.hjimi.api.iminect.ImiFrameMode;
import com.hjimi.api.iminect.ImiFrameType;
import com.hjimi.api.iminect.ImiImageFrame;
import com.hjimi.api.iminect.ImiLoaderTask;
import com.hjimi.api.iminect.ImiLog;
import com.hjimi.api.iminect.ImiNect;
import com.hjimi.api.iminect.ImiPermissionCallbacks;
import com.hjimi.api.iminect.ImiPictureType;
import com.hjimi.api.iminect.ImiPixelFormat;
import com.hjimi.api.iminect.ImiRotationAngle;
import com.hjimi.api.iminect.ImiRtIntrinsic;
import com.hjimi.api.iminect.ImiSkeletonData;
import com.hjimi.api.iminect.ImiSkeletonJointOrientation;
import com.hjimi.api.iminect.ImiSupportCapacity;
import com.hjimi.api.iminect.ImiUpgradeRomPath;
import com.hjimi.api.iminect.ImiUsbPermissionHelper;
import com.hjimi.api.iminect.ImiVector4;
import com.hjimi.api.iminect.ImiVector4I;
import com.hjimi.api.iminect.ImiVersions;
import com.hjimi.api.iminect.IniFile;
import com.hjimi.api.iminect.NativeMethods;
import com.hjimi.api.iminect.OutArg;
import com.hjimi.api.iminect.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ImiDevice {
    private Context m_context = null;
    private ImiUsbPermissionHelper m_UsbHelper = null;
    private ImiUsbPermissionHelper.ImiDeviceWrapper m_Dw = null;
    private OpenDeviceListener m_openlistener = null;
    private long m_deviceHandle = -1L;
    private long m_cameraHandle = -1L;
    private ImiDeviceAttribute m_DeviceAttribute = null;
    private boolean bSupportUVC = false;
    private boolean bSupportColorStream = true;
    private boolean b_DeviceOpened = false;
    private boolean b_CameraOpened = false;
    private boolean b_DeviceOpenning = false;
    private volatile boolean b_DeviceClosing = false;
    private boolean b_DevicePermissionGranted = false;
    private boolean b_CameraPermissionGranted = false;
    private boolean b_StreamStarting = false;
    private boolean b_StreamStopping = false;
    private boolean b_EnableFramesSync = true;
    private boolean b_SyncFramesOn = false;
    private boolean b_SyncFramesExecuting = false;
    private int m_CameraAEMode = 0;
    private int tmp_CameraErrorCode = -1;
    private int tmp_DeviceErrorCode = -1;
    private ImiStatus m_Status = null;
    private boolean b_Instance = false;
    private static ImiDevice m_Device = null;
    private DeviceStateListener m_deviceStateListener = null;
    private static ImiDriverInfo m_driverInfo = null;
    private ImiUsbPermissionHelper.ImiDeviceWrapper m_CurDeviceWrapper = null;
    private CountDownLatch m_openDeviceLatch = null;
    private CountDownLatch m_startStreamLatch = null;
    private CountDownLatch m_stopStreamLatch = null;
    private HashMap<ImiStreamType, ImiFrameType> SFM = null;
    private HashMap<ImiFrameType, ImiStreamType> FSM = null;
    private HashMap<ImiStreamType, String> streamNames = null;
    private HashMap<ImiStreamType, ImiStream> m_Streams = null;
    private static final long timediffmax = 60000L;
    private static final long timediffmin = 20000L;
    private static final long depthcolortimediffmax = 20000L;
    private static final long depthcolortimediffmin = -10000L;
    private static final long ircolortimediff = 20000L;
    private Timer m_timer = null;
    private boolean bGroupFrame = false;
    private Queue<ImiFrame> colorFrameQueue = new LinkedList<ImiFrame>();
    private Queue<ImiGroupFrames> groupFramesQueueback = new LinkedList<ImiGroupFrames>();
    private Queue<ByteBuffer> colorDataQueueFree = new LinkedList<ByteBuffer>();
    private Queue<ByteBuffer> depthirDataQueueFree = new LinkedList<ByteBuffer>();
    private ImiGroupFrames groupFrames = new ImiGroupFrames();
    private byte[] depthirBuffer;
    private Queue<ImiGroupFrames> groupFramesQueueFront = new LinkedList<ImiGroupFrames>();
    private ImiMultiFrames m_multiFrames = new ImiMultiFrames();
    private final int MIN_STREAM_FLAGS = 0;
    private final int MAX_STREAM_FLAGS = ImiStreamType.DEPTH.toNative() | ImiStreamType.COLOR.toNative() | ImiStreamType.IR.toNative() | ImiStreamType.DEPTH_SKELETON.toNative() | ImiStreamType.USER_INDEX_SKELETON.toNative() | ImiStreamType.SKELETON.toNative() | ImiStreamType.DEPTH_IR.toNative() | ImiStreamType.FLOOD_IR.toNative();
    private int[] EXP_TIMES = new int[]{5000, 2500, 1250, 625, 312, 156, 78, 39, 20, 10, 5, 2, 1};
    private long tmpDeviceTime = 0L;
    private long tmpCameraTime = 0L;
    private ExecutorService m_multiFrameThreadPool = Executors.newFixedThreadPool(4);
    private int m_readMutilFrameTimeOut = 0;
    private int m_readMutilFrameOtherTimeOut = 5;
    private CountDownLatch m_multiLatch = null;
    private boolean m_multiUpdateColor = false;
    private boolean m_multiUpdateDepthorIR = false;

    private ImiDevice(ImiUsbPermissionHelper.ImiDeviceWrapper deviceWrapper) {
        this.m_Status = new ImiStatus();
        this.SFM = new HashMap();
        this.FSM = new HashMap();
        this.streamNames = new HashMap();
        this.m_Streams = new HashMap();
        this.SFM.put(ImiStreamType.COLOR, ImiFrameType.COLOR);
        this.SFM.put(ImiStreamType.DEPTH, ImiFrameType.DEPTH);
        this.SFM.put(ImiStreamType.IR, ImiFrameType.IR);
        this.SFM.put(ImiStreamType.DEPTH_SKELETON, ImiFrameType.DEPTH_SKELETON);
        this.SFM.put(ImiStreamType.USER_INDEX_SKELETON, ImiFrameType.USER_INDEX_SKELETON);
        this.SFM.put(ImiStreamType.SKELETON, ImiFrameType.SKELETON);
        this.SFM.put(ImiStreamType.DEPTH_IR, ImiFrameType.DEPTH_IR);
        this.SFM.put(ImiStreamType.FLOOD_IR, ImiFrameType.FLOOD_IR);
        this.FSM.put(ImiFrameType.COLOR, ImiStreamType.COLOR);
        this.FSM.put(ImiFrameType.DEPTH, ImiStreamType.DEPTH);
        this.FSM.put(ImiFrameType.IR, ImiStreamType.IR);
        this.FSM.put(ImiFrameType.DEPTH_SKELETON, ImiStreamType.DEPTH_SKELETON);
        this.FSM.put(ImiFrameType.USER_INDEX_SKELETON, ImiStreamType.USER_INDEX_SKELETON);
        this.FSM.put(ImiFrameType.SKELETON, ImiStreamType.SKELETON);
        this.FSM.put(ImiFrameType.DEPTH_IR, ImiStreamType.DEPTH_IR);
        this.FSM.put(ImiFrameType.FLOOD_IR, ImiStreamType.FLOOD_IR);
        this.streamNames.put(ImiStreamType.COLOR, "Color");
        this.streamNames.put(ImiStreamType.DEPTH, "Depth");
        this.streamNames.put(ImiStreamType.IR, "IR");
        this.streamNames.put(ImiStreamType.DEPTH_SKELETON, "DepthSK");
        this.streamNames.put(ImiStreamType.USER_INDEX_SKELETON, "Uindex");
        this.streamNames.put(ImiStreamType.SKELETON, "Skeleton");
        this.streamNames.put(ImiStreamType.DEPTH_IR, "Depth_IR");
        this.streamNames.put(ImiStreamType.FLOOD_IR, "Flood_IR");
        this.m_Streams.put(ImiStreamType.COLOR, new ImiStream(ImiStreamType.COLOR));
        this.m_Streams.put(ImiStreamType.DEPTH, new ImiStream(ImiStreamType.DEPTH));
        this.m_Streams.put(ImiStreamType.IR, new ImiStream(ImiStreamType.IR));
        this.m_Streams.put(ImiStreamType.DEPTH_SKELETON, new ImiStream(ImiStreamType.DEPTH_SKELETON));
        this.m_Streams.put(ImiStreamType.USER_INDEX_SKELETON, new ImiStream(ImiStreamType.USER_INDEX_SKELETON));
        this.m_Streams.put(ImiStreamType.SKELETON, new ImiStream(ImiStreamType.SKELETON));
        this.m_Streams.put(ImiStreamType.DEPTH_IR, new ImiStream(ImiStreamType.DEPTH_IR));
        this.m_Streams.put(ImiStreamType.FLOOD_IR, new ImiStream(ImiStreamType.FLOOD_IR));
        this.m_Dw = deviceWrapper;
    }

    private void updateSystemIniFile() {
        String bindSmallCpu;
        String s = ImiDevice.getApplicationByReflection().getFilesDir().getAbsolutePath() + "/sysModel.ini";
        IniFile file = new IniFile(new File(s));
        String model = (String)file.get("System", "Model");
        if (model == null || !model.equals(Build.MODEL)) {
            file.set("System", "Model", Build.MODEL);
        }
        if ((bindSmallCpu = (String)file.get("Cpu", "bindSmallCpu")) == null || !bindSmallCpu.equals("true") && !bindSmallCpu.equals("false")) {
            file.set("Cpu", "bindSmallCpu", "false");
        }
        file.save();
    }

    public boolean addDeviceStateListener(DeviceStateListener listener) {
        if (this.m_UsbHelper != null && this.m_UsbHelper.addDeviceListener(listener)) {
            this.m_deviceStateListener = listener;
            return true;
        }
        return false;
    }

    public boolean removeDeviceStateListener(DeviceStateListener listener) {
        if (this.m_UsbHelper != null && this.m_UsbHelper.removeDeviceListener(listener)) {
            this.m_deviceStateListener = null;
            return true;
        }
        return false;
    }

    private static Application getApplicationByReflection() {
        try {
            return (Application)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ImiDevice getInstance() {
        if (!ImiNect.isInitialized()) {
            ImiLog.e("ImiNect not Initialized !!!");
            return null;
        }
        if (m_Device == null) {
            m_driverInfo = ImiNect.get_DriverInfo();
            m_Device = new ImiDevice(null);
            ImiDevice.m_Device.b_Instance = true;
        }
        return m_Device;
    }

    @TargetApi(value=21)
    public static List<ImiDevice> getDeviceList() {
        if (!ImiNect.isInitialized()) {
            ImiLog.e("ImiNect not Initialized !!!");
            return null;
        }
        Context context = ImiDevice.getApplicationByReflection().getApplicationContext();
        m_driverInfo = ImiNect.get_DriverInfo();
        ImiUsbPermissionHelper usbHelper = new ImiUsbPermissionHelper(context);
        HashMap<String, UsbDevice> devList = usbHelper.getDeviceList(ImiDeviceFlags.IMI_DEVICE);
        HashMap<String, UsbDevice> camList = usbHelper.getDeviceList(ImiDeviceFlags.IMI_CAMERA);
        if (devList.size() <= 0) {
            ImiLog.e("no device found");
            return null;
        }
        if (devList.size() != camList.size()) {
            ImiLog.e("mismatched number of devices");
            return null;
        }
        ArrayList<ImiDevice> deviceList = new ArrayList<ImiDevice>();
        Iterator<Map.Entry<String, UsbDevice>> itDev = devList.entrySet().iterator();
        Iterator<Map.Entry<String, UsbDevice>> itCam = camList.entrySet().iterator();
        block0: while (itDev.hasNext()) {
            while (itCam.hasNext()) {
                Map.Entry<String, UsbDevice> entryDev = itDev.next();
                Map.Entry<String, UsbDevice> entryCam = itCam.next();
                if (!entryDev.getValue().getSerialNumber().equals(entryCam.getValue().getSerialNumber())) continue;
                deviceList.add(new ImiDevice(new ImiUsbPermissionHelper.ImiDeviceWrapper(usbHelper.getDeviceType(entryDev.getValue()), entryDev.getValue(), entryCam.getValue())));
                ImiLog.e("matched " + entryDev.getKey() + " and " + entryCam.getKey());
                itCam.remove();
                itDev.remove();
                continue block0;
            }
        }
        usbHelper.destroy();
        return deviceList;
    }

    public static void destroyDeviceList(List<ImiDevice> deviceList) {
        if (deviceList != null && deviceList.size() > 0) {
            for (ImiDevice device : deviceList) {
                device.destroyImp();
            }
            deviceList.clear();
        }
    }

    public int startUpgradeOffLine(ImiUpgradeRomPath upgradeRomPath) {
        if (!ImiNect.isInitialized()) {
            return ImiErrorCode.IMI_NOT_INITIALIZED.toNative();
        }
        if (!this.b_DeviceOpened) {
            return ImiErrorCode.IMI_NOT_OPEN.toNative();
        }
        return NativeMethods.imiDeviceStartUpgradeOffLine(this.m_deviceHandle, upgradeRomPath.getFwRomPath(), upgradeRomPath.getUvcColorRomPath(), upgradeRomPath.getBridgeFwRomPath());
    }

    private void destroyImp() {
        if (this.SFM != null) {
            this.SFM.clear();
            this.SFM = null;
        }
        if (this.FSM != null) {
            this.FSM.clear();
            this.FSM = null;
        }
        if (this.streamNames != null) {
            this.streamNames.clear();
            this.streamNames = null;
        }
        if (this.m_Streams != null) {
            this.m_Streams.clear();
            this.m_Streams = null;
        }
        if (this.bGroupFrame) {
            this.bGroupFrame = false;
            this.m_timer.cancel();
            this.m_timer = null;
        }
        this.m_Status = null;
        this.m_Dw = null;
        if (this.colorFrameQueue != null) {
            this.colorFrameQueue.clear();
            this.colorFrameQueue = null;
        }
        if (this.groupFramesQueueback != null) {
            this.groupFramesQueueback.clear();
            this.groupFramesQueueback = null;
        }
        if (this.colorDataQueueFree != null) {
            this.colorDataQueueFree.clear();
            this.colorDataQueueFree = null;
        }
        if (this.depthirDataQueueFree != null) {
            this.depthirDataQueueFree.clear();
            this.depthirDataQueueFree = null;
        }
        this.groupFrames = null;
        this.depthirBuffer = null;
        if (this.groupFramesQueueFront != null) {
            this.groupFramesQueueFront.clear();
            this.groupFramesQueueFront = null;
        }
        this.m_multiFrames = null;
        if (this.m_multiFrameThreadPool != null && !this.m_multiFrameThreadPool.isShutdown()) {
            this.m_multiFrameThreadPool.shutdown();
        }
        this.m_multiFrameThreadPool = null;
    }

    public static void destroy() {
        if (m_Device != null && ImiDevice.m_Device.b_Instance) {
            m_Device.destroyImp();
            ImiDevice.m_Device.b_Instance = false;
            m_Device = null;
        }
    }

    private void setContext(Context context) {
        this.m_context = context;
        this.pushConfig(this.m_context);
        if (this.m_UsbHelper != null) {
            if (!this.b_DeviceOpenning) {
                this.m_UsbHelper.close();
            }
            this.m_UsbHelper.destroy();
            this.m_UsbHelper = null;
        }
        this.m_UsbHelper = new ImiUsbPermissionHelper(this.m_context);
        if (this.m_deviceStateListener != null) {
            this.m_UsbHelper.addDeviceListener(this.m_deviceStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(Context context, int streamFlags, OpenDeviceListener listener) {
        if (listener == null) {
            this.m_Status.setStatus(3, ImiErrorCode.IMI_INVALID_PARAM.toNative());
            ImiLog.d("OpenDeviceListener listener is null");
            return;
        }
        if (context == null) {
            this.m_Status.setStatus(1, ImiErrorCode.IMI_INVALID_PARAM.toNative());
            listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_INVALID_PARAM.toNative() + "] context can not be null");
            return;
        }
        if (streamFlags < 0 || streamFlags > this.MAX_STREAM_FLAGS) {
            ImiLog.w("params streamFlags is invalide");
            this.m_Status.setStatus(2, ImiErrorCode.IMI_INVALID_PARAM.toNative());
            listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_INVALID_PARAM.toNative() + "] streamFlags is invalid");
            return;
        }
        ImiDevice imiDevice = this;
        synchronized (imiDevice) {
            ImiUsbPermissionHelper.ImiDeviceWrapper dw;
            if (this.b_DeviceClosing) {
                ImiLog.w("Device is closing !");
                listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_FAILURE.toNative() + "] device is closing");
                return;
            }
            if (this.b_DeviceOpenning) {
                this.m_Status.setStatus(4, ImiErrorCode.IMI_NOT_IMPLEMENTED.toNative());
                ImiLog.w("Device is openning !");
                listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_FAILURE.toNative() + "] device is opening");
                return;
            }
            if (this.b_DeviceOpened && (!this.bSupportUVC || this.b_CameraOpened)) {
                this.m_Status.setStatus(11, ImiErrorCode.IMI_NOT_IMPLEMENTED.toNative());
                listener.onOpenDeviceSuccess();
                ImiLog.w("Device is already opened");
                return;
            }
            this.setContext(context);
            if (this.open(streamFlags, listener)) {
                return;
            }
            if (this.m_Dw == null) {
                this.m_Dw = this.m_UsbHelper.checkDevice();
            }
            if ((dw = this.m_Dw) == null) {
                this.m_Status.setStatus(5, ImiErrorCode.IMI_NOT_FOUND.toNative());
                ImiLog.d("@@@@@", "m_UsbHelper.checkDevice() return null");
                listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_NOT_FOUND.toNative() + "] no device found");
                return;
            }
            if (dw.getUvcDev() != null) {
                Log.d((String)"JAVAAPI", (String)"support UVC");
                this.bSupportUVC = true;
            }
            if (!this.bSupportUVC) {
                if (dw.getDeviceType() == ImiUsbPermissionHelper.ImiDeviceType.IMI_A100S_PLUS) {
                    this.bSupportColorStream = false;
                    if (this.isFlagOn(streamFlags, ImiStreamType.COLOR)) {
                        this.m_Status.setStatus(7, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
                        listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_NOT_SUPPORTED.toNative() + "] this Device is not support Color Stream");
                        ImiLog.w("this Device is not support Color Stream");
                        return;
                    }
                }
                if (dw.getDeviceType() != ImiUsbPermissionHelper.ImiDeviceType.IMI_A200 && this.isFlagOn(streamFlags, ImiStreamType.COLOR) && this.isFlagOn(streamFlags, ImiStreamType.IR)) {
                    this.m_Status.setStatus(8, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
                    listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_NOT_SUPPORTED.toNative() + "] this Device is not support Color and IR together");
                    ImiLog.w("this Device is not support Color and IR together");
                    return;
                }
            }
            if (dw.getDeviceType() == ImiUsbPermissionHelper.ImiDeviceType.IMI_A200 && this.isFlagOn(streamFlags, ImiStreamType.DEPTH) && this.isFlagOn(streamFlags, ImiStreamType.IR)) {
                this.m_Status.setStatus(9, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
                listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_NOT_SUPPORTED.toNative() + "] this Device is not support Depth and IR together");
                ImiLog.w("this Device is not support Depth and IR together");
                return;
            }
            if (dw.getDeviceType() == ImiUsbPermissionHelper.ImiDeviceType.IMI_A200 && this.isFlagOn(streamFlags, ImiStreamType.DEPTH) && this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR)) {
                this.m_Status.setStatus(9, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
                listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_NOT_SUPPORTED.toNative() + "] this Device is not support Depth and Flood_IR together");
                ImiLog.w("this Device is not support Depth and Flood_IR together");
                return;
            }
            if (this.isStreamFlagsInvalid(streamFlags)) {
                this.m_Status.setStatus(10, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
                listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_NOT_SUPPORTED.toNative() + "] this Device is not support Depth/DepthSK/UIndex/Skeleton/Depth_IR together");
                ImiLog.w("this Device is not support Depth/DepthSK/UIndex/Skeleton/Depth_IR together");
                return;
            }
            this.b_DeviceOpenning = true;
            this.b_DevicePermissionGranted = false;
            this.b_CameraPermissionGranted = false;
        }
        this.open(this.m_Dw, streamFlags, listener);
    }

    public boolean isOpenning() {
        return this.b_DeviceOpenning;
    }

    private ImiDeviceAttribute[] getImiDeviceList() {
        return NativeMethods.imiGetDeviceList();
    }

    private void pushConfig(Context context) {
        String[] files;
        try {
            files = context.getResources().getAssets().list("");
        }
        catch (IOException e1) {
            return;
        }
        String workingPath = context.getFilesDir().getAbsolutePath() + "/";
        for (int i = 0; i < files.length; ++i) {
            try {
                int len;
                File outFile;
                String fileName = files[i];
                if (fileName.contains(".sh") || (outFile = new File(workingPath + fileName)).exists()) continue;
                InputStream in = context.getAssets().open(fileName);
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
                continue;
            }
            catch (FileNotFoundException fileName) {
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean open(int streamFlags, OpenDeviceListener listener) {
        if (m_driverInfo != null) {
            switch (m_driverInfo.getDriverType()) {
                case IMI_DRIVER_FILE: 
                case IMI_DRIVER_NET: {
                    if (this.isFlagOn(streamFlags, ImiStreamType.IR) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) || this.isStreamFlagsInvalid(streamFlags)) {
                        this.m_Status.setStatus(6, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
                        listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_NOT_SUPPORTED.toNative() + "] not support streams");
                        return true;
                    }
                    ImiDeviceAttribute[] deviceList = this.getImiDeviceList();
                    if (deviceList == null || deviceList.length == 0 || TextUtils.isEmpty((CharSequence)deviceList[0].getUri())) {
                        this.m_Status.setStatus(5, ImiErrorCode.IMI_NOT_FOUND.toNative());
                        listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_NOT_FOUND.toNative() + "] no device found");
                        return true;
                    }
                    try {
                        this.b_DeviceOpenning = true;
                        int ret = this.openDevice(deviceList[0].getUri());
                        if (ret == ImiErrorCode.IMI_OK.toNative()) {
                            this.m_DeviceAttribute = deviceList[0];
                            this.b_DeviceOpened = true;
                            this.m_Streams.get((Object)ImiStreamType.IR).getSupportFrameMode();
                            this.m_Streams.get((Object)ImiStreamType.DEPTH).getSupportFrameMode();
                            this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).getSupportFrameMode();
                            this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).getSupportFrameMode();
                            this.m_Streams.get((Object)ImiStreamType.SKELETON).getSupportFrameMode();
                            this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).getSupportFrameMode();
                            this.m_Streams.get((Object)ImiStreamType.COLOR).getSupportFrameMode();
                            ret = this.startStream(streamFlags);
                        } else {
                            this.m_Status.setStatus(16, ret);
                        }
                        if (ret == ImiErrorCode.IMI_OK.toNative()) {
                            this.m_Status.setStatus(0, 0);
                            listener.onOpenDeviceSuccess();
                        } else {
                            listener.onOpenDeviceFailed("[" + ret + "] open device failed");
                        }
                    }
                    catch (Exception e) {
                        listener.onOpenDeviceFailed("open device catch Exception = " + e.getMessage());
                    }
                    this.b_DeviceOpenning = false;
                    return true;
                }
            }
        }
        return false;
    }

    private void open(final ImiUsbPermissionHelper.ImiDeviceWrapper dw, final int streamFlags, final OpenDeviceListener listener) {
        this.m_openlistener = listener;
        this.m_CurDeviceWrapper = dw;
        if (this.bSupportUVC) {
            if (dw.getImiDev() != null) {
                this.m_openDeviceLatch = new CountDownLatch(2);
                this.tmpDeviceTime = System.currentTimeMillis();
                this.m_UsbHelper.requestDevice(ImiDeviceFlags.IMI_DEVICE, dw.getImiDev(), new ImiPermissionCallbacks(){

                    @Override
                    public void onDevicePermissionGranted(int fd, UsbDevice device) {
                        if (ImiDevice.this.b_DevicePermissionGranted) {
                            ImiDevice.this.m_Status.setStatus(12, ImiErrorCode.IMI_NOT_IMPLEMENTED.toNative());
                            ImiLog.w("Device is already PermissionGranted");
                            return;
                        }
                        ImiDevice.this.b_DevicePermissionGranted = true;
                        ImiLog.d("Device PermissionGranted use " + (System.currentTimeMillis() - ImiDevice.this.tmpDeviceTime));
                        ImiDevice.this.tmpDeviceTime = System.currentTimeMillis();
                        ImiDevice.this.tmpCameraTime = ImiDevice.this.tmpDeviceTime;
                        ImiLog.d("request IMI_CAMERA " + dw.getUvcDev().getDeviceName());
                        ImiDevice.this.m_UsbHelper.requestDevice(ImiDeviceFlags.IMI_CAMERA, dw.getUvcDev(), new ImiPermissionCallbacks(){

                            @Override
                            public void onDevicePermissionGranted(int fd, UsbDevice device) {
                                if (ImiDevice.this.b_CameraPermissionGranted) {
                                    ImiDevice.this.m_Status.setStatus(13, ImiErrorCode.IMI_NOT_IMPLEMENTED.toNative());
                                    ImiLog.w("Camera is already PermissionGranted");
                                }
                                ImiDevice.this.b_CameraPermissionGranted = true;
                                ImiLog.d("Camera PermissionGranted use " + (System.currentTimeMillis() - ImiDevice.this.tmpCameraTime));
                                ImiDevice.this.tmpCameraTime = System.currentTimeMillis();
                                ImiDevice.this.m_multiFrameThreadPool.execute(new OpenCameraThread(ImiDevice.this, fd, device, streamFlags));
                            }

                            @Override
                            public void onDevicePermissionDenied() {
                                ImiDevice.this.m_Status.setStatus(15, ImiErrorCode.IMI_NOT_PERMITTED.toNative());
                                ImiLog.w("Camera Permission denied");
                                listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_NOT_PERMITTED.toNative() + "] Camera Permission denied");
                                ImiDevice.this.m_openDeviceLatch.countDown();
                            }
                        });
                        ImiDevice.this.m_multiFrameThreadPool.execute(new OpenDeviceThread(ImiDevice.this, fd, device, streamFlags));
                    }

                    @Override
                    public void onDevicePermissionDenied() {
                        ImiDevice.this.m_Status.setStatus(14, ImiErrorCode.IMI_NOT_PERMITTED.toNative());
                        ImiLog.w("Device Permission denied");
                        listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_NOT_PERMITTED.toNative() + "] Device Permission denied");
                        ImiDevice.this.m_openDeviceLatch.countDown();
                        ImiDevice.this.m_openDeviceLatch.countDown();
                    }
                });
                this.m_multiFrameThreadPool.execute(new AwaitThread(this, this.m_openDeviceLatch, streamFlags));
            }
        } else if (dw.getImiDev() != null) {
            this.tmpDeviceTime = System.currentTimeMillis();
            this.m_UsbHelper.requestDevice(ImiDeviceFlags.IMI_DEVICE, dw.getImiDev(), new ImiPermissionCallbacks(){

                @Override
                public void onDevicePermissionGranted(int fd, UsbDevice device) {
                    if (ImiDevice.this.b_DevicePermissionGranted) {
                        ImiLog.w("Device is already PermissionGranted");
                        return;
                    }
                    ImiDevice.this.b_DevicePermissionGranted = true;
                    ImiLog.d("Device PermissionGranted use " + (System.currentTimeMillis() - ImiDevice.this.tmpDeviceTime));
                    ImiDevice.this.tmpDeviceTime = System.currentTimeMillis();
                    ImiDevice.this.m_multiFrameThreadPool.execute(new OpenDeviceThread(ImiDevice.this, fd, device, streamFlags));
                }

                @Override
                public void onDevicePermissionDenied() {
                    listener.onOpenDeviceFailed("[" + ImiErrorCode.IMI_NOT_PERMITTED.toNative() + "] Device Permission denied");
                    ImiDevice.this.b_DeviceOpenning = false;
                }
            });
        }
    }

    private void openDeviceInTask(final ImiDevice imidevice, final int fd, final UsbDevice device, final int streamFlags) {
        new ImiLoaderTask(){

            @Override
            protected int doTask() throws IOException {
                ImiLog.d("ImiLoaderTask openimidevice");
                int ret = -1;
                try {
                    ret = imidevice.openDevice(device.getVendorId(), device.getProductId(), fd, device.getDeviceName());
                }
                catch (IllegalStateException e) {
                    ImiLog.e("IllegalStateException open device");
                    ImiDevice.this.m_openlistener.onOpenDeviceFailed("[" + ret + "] InTask open device catch Exception = " + e.getMessage());
                }
                if (ret == 0) {
                    if (!ImiDevice.this.b_Instance) {
                        ImiDevice.this.m_Status.setStatus(18, ImiErrorCode.IMI_NOT_IMPLEMENTED.toNative());
                        ImiLog.d("ImiDevice Instance was destroyed");
                        return ret;
                    }
                    ImiLog.d("Device Opened use " + (System.currentTimeMillis() - ImiDevice.this.tmpDeviceTime));
                    ImiDevice.this.b_DeviceOpened = true;
                    ImiDevice.this.tmpDeviceTime = System.currentTimeMillis();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.IR)).getSupportFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH)).getSupportFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON)).getSupportFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON)).getSupportFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.SKELETON)).getSupportFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).getSupportFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.FLOOD_IR)).getSupportFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.IR)).getCurrentFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH)).getCurrentFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON)).getCurrentFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON)).getCurrentFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.SKELETON)).getCurrentFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).getCurrentFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.FLOOD_IR)).getCurrentFrameMode();
                    if (!ImiDevice.this.bSupportUVC) {
                        ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).getSupportFrameMode();
                        ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).getCurrentFrameMode();
                    }
                    Object obj = ImiDevice.this.getProperty(1);
                    ImiDevice.this.m_DeviceAttribute = new ImiDeviceAttribute(device.getVendorId(), (short)device.getProductId(), device.getDeviceId(), obj != null ? (String)obj : "", device.getDeviceName());
                    if (ImiDevice.this.bSupportUVC) {
                        if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.IR)) {
                            ret = imidevice.startStream(ImiStreamType.IR.toNative());
                        }
                        if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.DEPTH)) {
                            ret = imidevice.startStream(ImiStreamType.DEPTH.toNative());
                        }
                        if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON)) {
                            ret = imidevice.startStream(ImiStreamType.DEPTH_SKELETON.toNative());
                        }
                        if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON)) {
                            ret = imidevice.startStream(ImiStreamType.USER_INDEX_SKELETON.toNative());
                        }
                        if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.SKELETON)) {
                            ret = imidevice.startStream(ImiStreamType.SKELETON.toNative());
                        }
                        if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR)) {
                            ret = imidevice.startStream(ImiStreamType.DEPTH_IR.toNative());
                        }
                        if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR)) {
                            ret = imidevice.startStream(ImiStreamType.FLOOD_IR.toNative());
                        }
                    } else {
                        ret = imidevice.startStream(streamFlags);
                    }
                } else {
                    ImiDevice.this.m_Status.setStatus(16, ret);
                    ImiLog.e("Device open failed ret = " + ret);
                }
                ImiDevice.this.tmp_DeviceErrorCode = ret;
                if (ImiDevice.this.bSupportUVC) {
                    ImiDevice.this.m_openDeviceLatch.countDown();
                } else {
                    ImiDevice.this.b_DeviceOpenning = false;
                    if (ImiDevice.this.b_DeviceOpened && ImiDevice.this.isStreamOn(streamFlags)) {
                        ImiDevice.this.m_Status.setStatus(0, 0);
                        ImiDevice.this.m_openlistener.onOpenDeviceSuccess();
                    } else {
                        int deviceErrorCode = ImiDevice.this.tmp_DeviceErrorCode;
                        ImiLog.e("OPEN failed");
                        imidevice.close();
                        String errmsg = "open device failed";
                        if (deviceErrorCode == ImiErrorCode.IMI_DEVICE_BUSY.toNative()) {
                            errmsg = "device busy";
                        } else if (deviceErrorCode == ImiErrorCode.IMI_INVALID_DEVICE.toNative()) {
                            errmsg = "Device is not UVC-compliant";
                        } else if (deviceErrorCode == ImiErrorCode.IMI_INVALID_MODE.toNative()) {
                            errmsg = "Mode not supported";
                        }
                        ImiDevice.this.m_openlistener.onOpenDeviceFailed("[" + ret + "]" + errmsg);
                    }
                }
                return ret;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private void openCameraInTask(final ImiDevice imicamera, final int fd, final UsbDevice device, final int streamFlags) {
        new ImiLoaderTask(){

            @Override
            protected int doTask() throws IOException {
                Thread.currentThread().setPriority(10);
                String name = device.getDeviceName();
                ImiLog.d("ImiLoaderTask openimicamera " + name);
                String[] v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
                int busnum = 0;
                int devnum = 0;
                if (v != null) {
                    busnum = Integer.parseInt(v[v.length - 2]);
                    devnum = Integer.parseInt(v[v.length - 1]);
                }
                int ret = -1;
                try {
                    ImiDevice.this.SetSonixFwFd(fd);
                    ImiLog.d("imicamera.openCamera before");
                    ret = imicamera.openCamera(device.getVendorId(), device.getProductId(), fd, busnum, devnum, ImiDevice.this.getUSBFSName(name));
                    ImiLog.d("imicamera.openCamera after");
                }
                catch (IllegalStateException e) {
                    ImiLog.e("IllegalStateException open camera");
                    ImiDevice.this.m_openlistener.onOpenDeviceFailed("[" + ret + "] InTask open camera catch Exception = " + e.getMessage());
                }
                if (ret == 0) {
                    ImiLog.d("Camera Opened use " + (System.currentTimeMillis() - ImiDevice.this.tmpCameraTime));
                    ImiDevice.this.tmpCameraTime = System.currentTimeMillis();
                    ImiDevice.this.b_CameraOpened = true;
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).getSupportFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).getCurrentFrameMode();
                    if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.COLOR)) {
                        ret = imicamera.startStream(ImiStreamType.COLOR.toNative());
                    }
                } else {
                    ImiDevice.this.m_Status.setStatus(17, ret);
                    ImiLog.e("Camera open failed ret = " + ret);
                }
                ImiDevice.this.tmp_CameraErrorCode = ret;
                ImiDevice.this.m_openDeviceLatch.countDown();
                return ret;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private void awaitInTask(final ImiDevice imidevice, final CountDownLatch latch, final int streamFlags) {
        new ImiLoaderTask(){

            @Override
            protected int doTask() throws IOException {
                ImiLog.d("!!ImiLoaderTask awaitInTask");
                Thread.currentThread().setPriority(10);
                try {
                    latch.await(120L, TimeUnit.SECONDS);
                    ImiDevice.this.b_DeviceOpenning = false;
                    ImiLog.d("!!end open");
                    if (ImiDevice.this.b_DeviceOpened && ImiDevice.this.b_CameraOpened && ImiDevice.this.isStreamOn(streamFlags)) {
                        ImiDevice.this.m_Status.setStatus(0, 0);
                        ImiDevice.this.m_openlistener.onOpenDeviceSuccess();
                    } else {
                        int deviceErrorCode = ImiDevice.this.tmp_DeviceErrorCode;
                        int cameraErrorCode = ImiDevice.this.tmp_CameraErrorCode;
                        ImiLog.e("awaitInTask OPEN failed");
                        imidevice.close();
                        String errmsg = "open device failed";
                        if (cameraErrorCode == ImiErrorCode.IMI_DEVICE_BUSY.toNative() || deviceErrorCode == ImiErrorCode.IMI_DEVICE_BUSY.toNative()) {
                            errmsg = "device busy";
                        } else if (cameraErrorCode == ImiErrorCode.IMI_INVALID_DEVICE.toNative() || deviceErrorCode == ImiErrorCode.IMI_INVALID_DEVICE.toNative()) {
                            errmsg = "Device is not UVC-compliant";
                        } else if (cameraErrorCode == ImiErrorCode.IMI_INVALID_MODE.toNative() || deviceErrorCode == ImiErrorCode.IMI_INVALID_MODE.toNative()) {
                            errmsg = "Mode not supported";
                        } else if (cameraErrorCode == -9 || deviceErrorCode == -9) {
                            errmsg = "UVC pipe error";
                        } else if (ImiDevice.this.b_CameraOpened && ImiDevice.this.b_DeviceOpened && cameraErrorCode != 0 && deviceErrorCode != 0) {
                            errmsg = "start Camera+Device stream failed";
                        } else if (cameraErrorCode != 0 && ImiDevice.this.b_CameraOpened) {
                            errmsg = "start Camera stream failed";
                        } else if (deviceErrorCode != 0 && ImiDevice.this.b_DeviceOpened) {
                            errmsg = "start Device stream failed";
                        }
                        if (cameraErrorCode != 0) {
                            ImiDevice.this.m_openlistener.onOpenDeviceFailed("[" + cameraErrorCode + "] " + errmsg);
                        } else if (deviceErrorCode != 0) {
                            ImiDevice.this.m_openlistener.onOpenDeviceFailed("[" + deviceErrorCode + "] " + errmsg);
                        }
                    }
                }
                catch (InterruptedException e) {
                    ImiLog.e("awaitInTask OPEN failed catch " + e.toString());
                }
                return 0;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private void SetSonixFwFd(int fd) {
        ImiLog.d("set Sonix fd = " + fd);
        File filepath = null;
        if (ImiNect.getConfigureDataPath() != null) {
            try {
                filepath = new File(ImiNect.getConfigureDataPath());
                if (!filepath.exists()) {
                    filepath.mkdirs();
                }
            }
            catch (Exception e) {
                ImiLog.d("@@@@@ set Sonix fd file path error ");
                e.printStackTrace();
            }
        } else {
            filepath = this.m_context.getFilesDir();
        }
        File file = new File(filepath, "sonixfwfd.txt");
        try {
            if (file.exists()) {
                ImiLog.d("sonixfwfd.txt exsit and delete");
                file.delete();
            }
            if (file.createNewFile()) {
                ImiLog.d("create sonixfwfd.txt success");
                RandomAccessFile raf = new RandomAccessFile(file, "rwd");
                raf.seek(file.length());
                String strcontext = String.format(Locale.getDefault(), "%d", fd);
                raf.write(strcontext.getBytes());
                raf.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getUSBFSName(String name) {
        String[] v;
        String result = null;
        String[] stringArray = v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
        if (v != null && v.length > 2) {
            StringBuilder sb = new StringBuilder(v[0]);
            for (int i = 1; i < v.length - 2; ++i) {
                sb.append("/").append(v[i]);
            }
            result = sb.toString();
        }
        return result;
    }

    private int openDevice(int vid, int pid, int fd, String usbFsPath) {
        if (fd <= 0 || TextUtils.isEmpty((CharSequence)usbFsPath)) {
            return -1;
        }
        return NativeMethods.checkReturnStatus(NativeMethods.imiOpenDevice2(vid, pid, fd, usbFsPath, this, ImiDeviceFlags.IMI_DEVICE.toNative()));
    }

    private int openDevice(@NonNull String deviceUri) {
        if (TextUtils.isEmpty((CharSequence)deviceUri)) {
            return ImiErrorCode.IMI_INVALID_PARAM.toNative();
        }
        return NativeMethods.checkReturnStatus(NativeMethods.imiOpenDevice(deviceUri, this, ImiDeviceFlags.IMI_DEVICE.toNative()));
    }

    private int openCamera(int venderId, int productId, int fd, int busNum, int devAddr, String usbfs) {
        return NativeMethods.nativeOpenCamera2(this, venderId, productId, fd, busNum, devAddr, usbfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int syncFrames(boolean bsync) {
        ImiDevice imiDevice = this;
        synchronized (imiDevice) {
            if (this.b_SyncFramesExecuting || this.b_SyncFramesOn == bsync) {
                return 0;
            }
            if (!this.b_EnableFramesSync && !this.b_SyncFramesOn) {
                ImiLog.d("FramesSync is Off");
                return ImiErrorCode.IMI_NOT_PERMITTED.toNative();
            }
            this.b_SyncFramesExecuting = true;
            int ret = NativeMethods.nativeSetFramesSync(this.m_cameraHandle, bsync);
            if (ret != 0) {
                if (this.b_DeviceOpenning) {
                    this.m_Status.setStatus(27, ret);
                } else {
                    this.m_Status.setStatus(58, ret);
                }
            }
            ImiLog.d("syncFrames " + bsync + " ret = " + ret);
            this.b_SyncFramesOn = bsync;
            this.b_SyncFramesExecuting = false;
            return ret;
        }
    }

    public int setExposureArea(int startX, int startY, int areaWidth, int areaHeight) {
        int ret = -1;
        if (this.m_CurDeviceWrapper != null && this.m_CurDeviceWrapper.getDeviceType() == ImiUsbPermissionHelper.ImiDeviceType.IMI_A200 && this.m_Streams.get((Object)ImiStreamType.COLOR).isOpened()) {
            ret = NativeMethods.nativeSetExposureArea(this.m_cameraHandle, startX, startY, areaWidth, areaHeight);
        }
        ImiLog.d("SetExposureArea  ret = " + ret);
        return ret;
    }

    public int clearExposureArea() {
        int ret = -1;
        if (this.m_CurDeviceWrapper != null && this.m_CurDeviceWrapper.getDeviceType() == ImiUsbPermissionHelper.ImiDeviceType.IMI_A200 && this.m_Streams.get((Object)ImiStreamType.COLOR).isOpened()) {
            ret = NativeMethods.nativeClearExposureArea(this.m_cameraHandle);
        }
        ImiLog.d("ClearExposureArea  ret = " + ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close() {
        int ret;
        ImiDevice imiDevice = this;
        synchronized (imiDevice) {
            if (this.b_DeviceClosing) {
                ImiLog.w("Device is closing !");
                return ImiErrorCode.IMI_NOT_PERMITTED.toNative();
            }
            if (this.b_DeviceOpenning) {
                ImiLog.w("Device is openning !");
                return ImiErrorCode.IMI_NOT_PERMITTED.toNative();
            }
            this.b_DeviceClosing = true;
            if (!(this.b_DeviceOpened || this.bSupportUVC && this.b_CameraOpened)) {
                if (this.m_UsbHelper != null) {
                    this.m_UsbHelper.close();
                    this.m_UsbHelper.destroy();
                    this.m_UsbHelper = null;
                }
                this.b_DeviceClosing = false;
                return ImiErrorCode.IMI_NOT_OPEN.toNative();
            }
        }
        this.m_deviceStateListener = null;
        long stopTime = System.currentTimeMillis();
        this.stopStream(this.MAX_STREAM_FLAGS);
        ImiLog.d("stopStream all use " + (System.currentTimeMillis() - stopTime));
        if (this.b_CameraOpened) {
            this.tmpCameraTime = System.currentTimeMillis();
            ret = NativeMethods.nativeCloseCamera(this.m_cameraHandle);
            if (0 == ret) {
                ImiLog.d("Camera Closed use " + (System.currentTimeMillis() - this.tmpCameraTime));
            } else {
                ImiLog.e("Camera Close failed ret = " + ret);
            }
        }
        if (this.b_DeviceOpened) {
            this.tmpDeviceTime = System.currentTimeMillis();
            ret = NativeMethods.checkReturnStatus(NativeMethods.imiCloseDevice(this.m_deviceHandle));
            if (ret == ImiErrorCode.IMI_OK.toNative()) {
                ImiLog.d("Device Closed use " + (System.currentTimeMillis() - this.tmpDeviceTime));
            } else {
                ImiLog.e("Device Close failed ret = " + ret);
            }
        }
        this.m_context = null;
        if (this.m_UsbHelper != null) {
            if (!this.b_DeviceOpenning) {
                this.m_UsbHelper.close();
            }
            this.m_UsbHelper.destroy();
            this.m_UsbHelper = null;
        }
        this.m_CurDeviceWrapper = null;
        this.bSupportColorStream = true;
        this.b_EnableFramesSync = true;
        this.b_SyncFramesOn = false;
        this.b_SyncFramesExecuting = false;
        this.m_CameraAEMode = 0;
        this.tmp_CameraErrorCode = -1;
        this.tmp_DeviceErrorCode = -1;
        this.m_DeviceAttribute = null;
        this.m_deviceHandle = -1L;
        this.b_DeviceOpened = false;
        this.m_cameraHandle = -1L;
        this.b_CameraOpened = false;
        this.bSupportUVC = false;
        for (ImiStream s : this.m_Streams.values()) {
            s.reset();
        }
        this.m_openDeviceLatch = null;
        this.m_startStreamLatch = null;
        this.m_stopStreamLatch = null;
        this.b_DeviceClosing = false;
        this.setEnableGroup(false);
        ImiLog.d("close end");
        return 0;
    }

    private void startDeviceStreamInTask(ImiDevice imidevice, final int streamFlags) {
        new ImiLoaderTask(){

            @Override
            protected int doTask() throws IOException {
                ImiLog.d("ImiLoaderTask startDeviceStream");
                Thread.currentThread().setPriority(10);
                int ret = -1;
                try {
                    if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.DEPTH)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH)).open();
                    } else if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON)).open();
                    } else if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON)).open();
                    } else if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.SKELETON)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.SKELETON)).open();
                    }
                    if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.IR)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.IR)).open();
                    }
                    if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).open();
                    }
                    if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.FLOOD_IR)).open();
                    }
                }
                catch (IllegalStateException e) {
                    ImiLog.e("IllegalStateException start Device stream");
                }
                ImiDevice.this.tmp_DeviceErrorCode = ret;
                ImiDevice.this.m_startStreamLatch.countDown();
                return ret;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private void startCameraStreamInTask(ImiDevice imidevice) {
        new ImiLoaderTask(){

            @Override
            protected int doTask() throws IOException {
                Thread.currentThread().setPriority(10);
                ImiLog.d("ImiLoaderTask startColorStream");
                int ret = -1;
                try {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).open();
                }
                catch (IllegalStateException e) {
                    ImiLog.e("IllegalStateException start Camera stream");
                }
                ImiDevice.this.tmp_CameraErrorCode = ret;
                ImiDevice.this.m_startStreamLatch.countDown();
                return ret;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private void stopDeviceStreamInTask(ImiDevice imidevice, final int streamFlags) {
        new ImiLoaderTask(){

            @Override
            protected int doTask() throws IOException {
                ImiLog.d("ImiLoaderTask stopDepthStream");
                Thread.currentThread().setPriority(10);
                int ret = -1;
                try {
                    if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.DEPTH)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH)).close();
                    }
                    if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON)).close();
                    }
                    if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON)).close();
                    }
                    if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.SKELETON)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.SKELETON)).close();
                    }
                    if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.IR)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.IR)).close();
                    }
                    if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).close();
                    }
                    if (ImiDevice.this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR)) {
                        ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.FLOOD_IR)).close();
                    }
                }
                catch (IllegalStateException e) {
                    ImiLog.e("IllegalStateException stop Device stream");
                }
                ImiDevice.this.m_stopStreamLatch.countDown();
                return ret;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private void stopCameraStreamInTask(ImiDevice imidevice) {
        new ImiLoaderTask(){

            @Override
            protected int doTask() throws IOException {
                ImiLog.d("ImiLoaderTask stopColorStream");
                Thread.currentThread().setPriority(10);
                int ret = -1;
                try {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).close();
                }
                catch (IllegalStateException e) {
                    ImiLog.e("IllegalStateException stop Camera stream");
                }
                ImiDevice.this.m_stopStreamLatch.countDown();
                return ret;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private ImiCameraFrameMode FrameModeToCameraFrameMode(ImiFrameMode mode) {
        ImiCameraPixelFormat format = ImiCameraPixelFormat.IMI_CAMERA_PIXEL_FORMAT_RGB888;
        switch (mode.getFormat()) {
            case IMI_PIXEL_FORMAT_IMAGE_YUV422: {
                format = ImiCameraPixelFormat.IMI_CAMERA_PIXEL_FORMAT_YUYV;
                break;
            }
            case IMI_PIXEL_FORMAT_IMAGE_RGB24: {
                format = ImiCameraPixelFormat.IMI_CAMERA_PIXEL_FORMAT_RGB888;
                break;
            }
            case IMI_PIXEL_FORMAT_IMAGE_YUV420SP: {
                format = ImiCameraPixelFormat.IMI_CAMERA_PIXEL_FORMAT_YUV420SP;
                break;
            }
            case IMI_PIXEL_FORMAT_IMAGE_MJPEG: {
                format = ImiCameraPixelFormat.IMI_CAMERA_PIXEL_FORMAT_MJPEG;
            }
        }
        return new ImiCameraFrameMode(format, mode.getResolutionX(), mode.getResolutionY(), mode.getFramerate());
    }

    private ImiFrameMode CameraFrameModeToFrameMode(ImiCameraFrameMode mode) {
        ImiPixelFormat format = ImiPixelFormat.IMI_PIXEL_FORMAT_IMAGE_RGB24;
        switch (mode.getPixelFormat()) {
            case IMI_CAMERA_PIXEL_FORMAT_YUYV: {
                format = ImiPixelFormat.IMI_PIXEL_FORMAT_IMAGE_YUV422;
                break;
            }
            case IMI_CAMERA_PIXEL_FORMAT_RGB888: {
                format = ImiPixelFormat.IMI_PIXEL_FORMAT_IMAGE_RGB24;
                break;
            }
            case IMI_CAMERA_PIXEL_FORMAT_YUV420SP: {
                format = ImiPixelFormat.IMI_PIXEL_FORMAT_IMAGE_YUV420SP;
                break;
            }
            case IMI_CAMERA_PIXEL_FORMAT_MJPEG: {
                format = ImiPixelFormat.IMI_PIXEL_FORMAT_IMAGE_MJPEG;
            }
        }
        return new ImiFrameMode(format, mode.getWidth(), mode.getHeight(), mode.getFps());
    }

    private boolean isFlagOn(int streamFlags, ImiStreamType streamType) {
        return (streamFlags & streamType.toNative()) > 0;
    }

    private boolean isFlagOff(int streamFlags, ImiStreamType streamType) {
        return (streamFlags & streamType.toNative()) == 0;
    }

    private boolean isStreamOn(int streamFlags) {
        return (this.isFlagOff(streamFlags, ImiStreamType.DEPTH) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH) && this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.COLOR) || this.isFlagOn(streamFlags, ImiStreamType.COLOR) && this.m_Streams.get((Object)ImiStreamType.COLOR).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.IR) || this.isFlagOn(streamFlags, ImiStreamType.IR) && this.m_Streams.get((Object)ImiStreamType.IR).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.DEPTH_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON) && this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.USER_INDEX_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON) && this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.SKELETON) && this.m_Streams.get((Object)ImiStreamType.SKELETON).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.DEPTH_IR) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) && this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.FLOOD_IR) || this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR) && this.m_Streams.get((Object)ImiStreamType.FLOOD_IR).isOpened());
    }

    private boolean isStreamOff(int streamFlags) {
        return (this.isFlagOff(streamFlags, ImiStreamType.DEPTH) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH) && !this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.COLOR) || this.isFlagOn(streamFlags, ImiStreamType.COLOR) && !this.m_Streams.get((Object)ImiStreamType.COLOR).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.IR) || this.isFlagOn(streamFlags, ImiStreamType.IR) && !this.m_Streams.get((Object)ImiStreamType.IR).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.DEPTH_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON) && !this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.USER_INDEX_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON) && !this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.SKELETON) && !this.m_Streams.get((Object)ImiStreamType.SKELETON).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.DEPTH_IR) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) && !this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).isOpened()) && (this.isFlagOff(streamFlags, ImiStreamType.FLOOD_IR) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) && !this.m_Streams.get((Object)ImiStreamType.FLOOD_IR).isOpened());
    }

    private boolean isStreamFlagsInvalid(int streamFlags) {
        int mutexNum = 0;
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH)) {
            ++mutexNum;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON)) {
            ++mutexNum;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON)) {
            ++mutexNum;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.SKELETON)) {
            ++mutexNum;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR)) {
            ++mutexNum;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR)) {
            ++mutexNum;
        }
        return mutexNum > 1;
    }

    public int setFramesSync(boolean bSync) {
        this.b_EnableFramesSync = bSync;
        return 0;
    }

    public boolean isFramesSyncEnable() {
        return this.b_EnableFramesSync;
    }

    public void setEnableGroup(boolean bGroup) {
        if (bGroup && !this.bGroupFrame) {
            this.m_timer = new Timer();
            this.m_timer.schedule((TimerTask)new GetFramesTask(), 0L, 15L);
            this.bGroupFrame = true;
        } else if (!bGroup && this.bGroupFrame) {
            this.m_timer.cancel();
            this.bGroupFrame = false;
        }
    }

    private void clearGroupBuffers() {
        this.colorFrameQueue.clear();
        this.groupFramesQueueback.clear();
        this.groupFramesQueueFront.clear();
    }

    public boolean isGroupFramesEnable() {
        return this.bGroupFrame;
    }

    public int hotStartOrStopStream(int streamFlags, boolean isOpen) {
        int ret = ImiErrorCode.IMI_INVALID_OPERATION.toNative();
        int nType = 0;
        if (this.isFlagOn(streamFlags, ImiStreamType.IR) && this.m_Streams.get((Object)ImiStreamType.IR).isOpened()) {
            nType = 3;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH) && this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened()) {
            nType = 1;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) && this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).isOpened()) {
            nType = 4;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR) && this.m_Streams.get((Object)ImiStreamType.FLOOD_IR).isOpened()) {
            nType = 5;
        }
        if (nType <= 0) {
            return ImiErrorCode.IMI_INVALID_OPERATION.toNative();
        }
        ByteBuffer bf1 = ByteBuffer.allocateDirect(10);
        bf1.order(ByteOrder.nativeOrder());
        bf1.put((byte)1);
        bf1.put((byte)0);
        bf1.put((byte)50);
        bf1.put((byte)2);
        bf1.put((byte)0);
        bf1.put((byte)4);
        bf1.put((byte)nType);
        bf1.put((byte)(isOpen ? 5 : 4));
        bf1.put((byte)-1);
        bf1.put((byte)-1);
        ret = this.setProperty(4095, bf1);
        if (!this.isFlagOn(streamFlags, ImiStreamType.COLOR) || !this.m_Streams.get((Object)ImiStreamType.COLOR).isOpened()) {
            return ImiErrorCode.IMI_INVALID_OPERATION.toNative();
        }
        ret = NativeMethods.nativeStartOrStopCameraStream(this.m_cameraHandle, isOpen);
        return ret;
    }

    private int initStream(int streamFlags) {
        if (streamFlags < 0 || streamFlags > this.MAX_STREAM_FLAGS) {
            if (this.b_DeviceOpenning) {
                this.m_Status.setStatus(2, ImiErrorCode.IMI_INVALID_PARAM.toNative());
            } else {
                this.m_Status.setStatus(45, ImiErrorCode.IMI_INVALID_PARAM.toNative());
            }
            return ImiErrorCode.IMI_INVALID_PARAM.toNative();
        }
        if (!this.b_DeviceOpened && (this.bSupportUVC && !this.b_CameraOpened || !this.bSupportUVC)) {
            this.m_Status.setStatus(44, ImiErrorCode.IMI_NOT_OPEN.toNative());
            return ImiErrorCode.IMI_NOT_OPEN.toNative();
        }
        if (this.isStreamOn(streamFlags)) {
            ImiLog.w("streams was already started");
            return ImiErrorCode.IMI_OK.toNative();
        }
        if (this.m_CurDeviceWrapper != null && this.m_CurDeviceWrapper.getDeviceType() != ImiUsbPermissionHelper.ImiDeviceType.IMI_A200) {
            if ((!this.m_Streams.get((Object)ImiStreamType.COLOR).isOpened() || !this.isFlagOn(streamFlags, ImiStreamType.IR)) && this.m_Streams.get((Object)ImiStreamType.IR).isOpened() && this.isFlagOn(streamFlags, ImiStreamType.COLOR)) {
                // empty if block
            }
        } else {
            if (this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened() && this.isFlagOn(streamFlags, ImiStreamType.IR) || this.m_Streams.get((Object)ImiStreamType.IR).isOpened() && this.isFlagOn(streamFlags, ImiStreamType.DEPTH)) {
                this.m_Status.setStatus(48, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
                ImiLog.w("this Device is not support Depth and IR together");
                return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
            }
            if (this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened() && this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR) || this.m_Streams.get((Object)ImiStreamType.FLOOD_IR).isOpened() && this.isFlagOn(streamFlags, ImiStreamType.DEPTH)) {
                this.m_Status.setStatus(48, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
                ImiLog.w("this Device is not support Depth and FLOOD_IR together");
                return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
            }
        }
        if (m_driverInfo != null && m_driverInfo.getDriverType() != ImiDriverType.IMI_DRIVER_USB && (this.isFlagOn(streamFlags, ImiStreamType.IR) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR))) {
            ImiLog.w("this Device is not support IR/Depth_IR");
            return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
        }
        if (this.isStreamFlagsInvalid(streamFlags)) {
            this.m_Status.setStatus(49, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
            ImiLog.w("this Device is not support Depth/DepthSK/UIndex/Skeleton/Depth_IR together");
            return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH) && (this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).isOpened()) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON) && (this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened() || this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).isOpened()) || this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON) && (this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).isOpened()) || this.isFlagOn(streamFlags, ImiStreamType.SKELETON) && (this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).isOpened()) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) && (this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.SKELETON).isOpened())) {
            this.m_Status.setStatus(49, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
            ImiLog.w("this Device is not support Depth/DepthSK/UIndex/Skeleton/Depth_IR together");
            return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
        }
        int ret = -1;
        if (this.bSupportUVC && (this.isFlagOn(streamFlags, ImiStreamType.DEPTH) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.IR) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) || this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR)) && this.isFlagOn(streamFlags, ImiStreamType.COLOR)) {
            if (this.b_StreamStarting) {
                ImiLog.w("Stream is starting !");
                return ImiErrorCode.IMI_NOT_PERMITTED.toNative();
            }
            if (this.b_DeviceOpened && this.b_CameraOpened) {
                this.b_StreamStarting = true;
                this.m_startStreamLatch = new CountDownLatch(2);
                this.m_multiFrameThreadPool.execute(new StartMixCameraDeviceStreamThread(this, streamFlags));
                try {
                    this.m_startStreamLatch.await(20L, TimeUnit.SECONDS);
                    if (this.isStreamOn(streamFlags)) {
                        if (this.m_CurDeviceWrapper != null && this.m_CurDeviceWrapper.getDeviceType() == ImiUsbPermissionHelper.ImiDeviceType.IMI_A200 && (this.isFlagOn(streamFlags, ImiStreamType.DEPTH) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.IR) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) || this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR)) && this.isFlagOn(streamFlags, ImiStreamType.COLOR)) {
                            if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) && this.m_DeviceAttribute.isPortraitDevice()) {
                                ImiLog.d("portrait  deivce open depth_ir stream no need set sync");
                            } else {
                                this.syncFrames(true);
                            }
                        }
                        ret = 0;
                    }
                }
                catch (InterruptedException e) {
                    ImiLog.e("startStream:InterruptedException catch Exception = " + e.getMessage());
                }
                this.b_StreamStarting = false;
            } else {
                ret = ImiErrorCode.IMI_NOT_OPEN.toNative();
            }
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.IR) && (ret = this.m_Streams.get((Object)ImiStreamType.IR).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH) && (ret = this.m_Streams.get((Object)ImiStreamType.DEPTH).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.COLOR) && (ret = this.m_Streams.get((Object)ImiStreamType.COLOR).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON) && (ret = this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON) && (ret = this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.SKELETON) && (ret = this.m_Streams.get((Object)ImiStreamType.SKELETON).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) && (ret = this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR) && (ret = this.m_Streams.get((Object)ImiStreamType.FLOOD_IR).open()) != 0) {
            return ret;
        }
        if (!this.b_DeviceOpenning) {
            this.m_Status.setStatus(0, 0);
        }
        return ret;
    }

    public int startStream(int streamFlags) {
        if (streamFlags < 0 || streamFlags > this.MAX_STREAM_FLAGS) {
            this.m_Status.setStatus(45, ImiErrorCode.IMI_INVALID_PARAM.toNative());
            return ImiErrorCode.IMI_INVALID_PARAM.toNative();
        }
        if (this.b_DeviceOpenning || this.b_DeviceClosing) {
            this.m_Status.setStatus(2, ImiErrorCode.IMI_INVALID_OPERATION.toNative());
        }
        if (!(this.b_DeviceOpened || this.bSupportUVC && this.b_CameraOpened)) {
            this.m_Status.setStatus(44, ImiErrorCode.IMI_NOT_OPEN.toNative());
            return ImiErrorCode.IMI_NOT_OPEN.toNative();
        }
        if (this.isStreamOn(streamFlags)) {
            ImiLog.w("streams was already started");
            return ImiErrorCode.IMI_OK.toNative();
        }
        if (this.m_CurDeviceWrapper != null && this.m_CurDeviceWrapper.getDeviceType() != ImiUsbPermissionHelper.ImiDeviceType.IMI_A200) {
            if ((!this.m_Streams.get((Object)ImiStreamType.COLOR).isOpened() || !this.isFlagOn(streamFlags, ImiStreamType.IR)) && this.m_Streams.get((Object)ImiStreamType.IR).isOpened() && this.isFlagOn(streamFlags, ImiStreamType.COLOR)) {
                // empty if block
            }
        } else {
            if (this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened() && this.isFlagOn(streamFlags, ImiStreamType.IR) || this.m_Streams.get((Object)ImiStreamType.IR).isOpened() && this.isFlagOn(streamFlags, ImiStreamType.DEPTH)) {
                this.m_Status.setStatus(48, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
                ImiLog.w("this Device is not support Depth and IR together");
                return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
            }
            if (this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened() && this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR) || this.m_Streams.get((Object)ImiStreamType.FLOOD_IR).isOpened() && this.isFlagOn(streamFlags, ImiStreamType.DEPTH)) {
                this.m_Status.setStatus(48, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
                ImiLog.w("this Device is not support Depth and FLOOD_IR together");
                return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
            }
        }
        if (m_driverInfo != null && m_driverInfo.getDriverType() != ImiDriverType.IMI_DRIVER_USB && (this.isFlagOn(streamFlags, ImiStreamType.IR) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR))) {
            ImiLog.w("this Device is not support IR/Depth_IR");
            return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
        }
        if (this.isStreamFlagsInvalid(streamFlags)) {
            this.m_Status.setStatus(49, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
            ImiLog.w("this Device is not support Depth/DepthSK/UIndex/Skeleton/Depth_IR together");
            return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH) && (this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).isOpened()) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON) && (this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened() || this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).isOpened()) || this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON) && (this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).isOpened()) || this.isFlagOn(streamFlags, ImiStreamType.SKELETON) && (this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).isOpened()) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) && (this.m_Streams.get((Object)ImiStreamType.DEPTH).isOpened() || this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).isOpened() || this.m_Streams.get((Object)ImiStreamType.SKELETON).isOpened())) {
            this.m_Status.setStatus(49, ImiErrorCode.IMI_NOT_SUPPORTED.toNative());
            ImiLog.w("this Device is not support Depth/DepthSK/UIndex/Skeleton/Depth_IR together");
            return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
        }
        int ret = -1;
        this.clearGroupBuffers();
        if (this.bSupportUVC && (this.isFlagOn(streamFlags, ImiStreamType.DEPTH) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.IR) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) || this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR)) && this.isFlagOn(streamFlags, ImiStreamType.COLOR)) {
            if (this.b_StreamStarting) {
                ImiLog.w("Stream is starting !");
                return ImiErrorCode.IMI_NOT_PERMITTED.toNative();
            }
            if (this.b_DeviceOpened && this.b_CameraOpened) {
                this.b_StreamStarting = true;
                this.m_startStreamLatch = new CountDownLatch(2);
                this.m_multiFrameThreadPool.execute(new StartMixCameraDeviceStreamThread(this, streamFlags));
                try {
                    this.m_startStreamLatch.await(20L, TimeUnit.SECONDS);
                    if (this.isStreamOn(streamFlags)) {
                        if (this.m_CurDeviceWrapper != null && this.m_CurDeviceWrapper.getDeviceType() == ImiUsbPermissionHelper.ImiDeviceType.IMI_A200 && (this.isFlagOn(streamFlags, ImiStreamType.DEPTH) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.IR) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) || this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR)) && this.isFlagOn(streamFlags, ImiStreamType.COLOR)) {
                            if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) && this.m_DeviceAttribute.isPortraitDevice()) {
                                ImiLog.d("portrait  deivce open depth_ir stream no need set sync");
                            } else {
                                this.syncFrames(true);
                            }
                        }
                        ret = 0;
                    }
                }
                catch (InterruptedException e) {
                    ImiLog.e("startStream:InterruptedException catch Exception = " + e.getMessage());
                }
                this.b_StreamStarting = false;
            } else {
                ret = ImiErrorCode.IMI_NOT_OPEN.toNative();
            }
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.IR) && (ret = this.m_Streams.get((Object)ImiStreamType.IR).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH) && (ret = this.m_Streams.get((Object)ImiStreamType.DEPTH).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.COLOR) && (ret = this.m_Streams.get((Object)ImiStreamType.COLOR).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON) && (ret = this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON) && (ret = this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.SKELETON) && (ret = this.m_Streams.get((Object)ImiStreamType.SKELETON).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) && (ret = this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).open()) != 0) {
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR) && (ret = this.m_Streams.get((Object)ImiStreamType.FLOOD_IR).open()) != 0) {
            return ret;
        }
        if (!this.b_DeviceOpenning) {
            this.m_Status.setStatus(0, 0);
        }
        return ret;
    }

    public int stopStream(int streamFlags) {
        if (streamFlags < 0 || streamFlags > this.MAX_STREAM_FLAGS) {
            return ImiErrorCode.IMI_INVALID_PARAM.toNative();
        }
        if (this.b_DeviceOpenning) {
            this.m_Status.setStatus(4, ImiErrorCode.IMI_INVALID_OPERATION.toNative());
        }
        if (!(this.b_DeviceOpened || this.bSupportUVC && this.b_CameraOpened)) {
            return ImiErrorCode.IMI_NOT_OPEN.toNative();
        }
        if (this.isStreamOff(streamFlags)) {
            ImiLog.w("streams was already stoped");
            return ImiErrorCode.IMI_OK.toNative();
        }
        int ret = -1;
        this.setEnableGroup(false);
        if (this.bSupportUVC && (this.isFlagOn(streamFlags, ImiStreamType.DEPTH) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.SKELETON) || this.isFlagOn(streamFlags, ImiStreamType.IR) || this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) || this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR)) && this.isFlagOn(streamFlags, ImiStreamType.COLOR)) {
            if (this.b_StreamStopping) {
                ImiLog.w("Stream is stopping !");
                return ImiErrorCode.IMI_NOT_PERMITTED.toNative();
            }
            if (this.b_DeviceOpened && this.b_CameraOpened) {
                this.b_StreamStopping = true;
                this.m_stopStreamLatch = new CountDownLatch(2);
                if (this.m_CurDeviceWrapper != null && this.m_CurDeviceWrapper.getDeviceType() == ImiUsbPermissionHelper.ImiDeviceType.IMI_A200 && this.m_Streams.get((Object)ImiStreamType.COLOR).isOpened()) {
                    if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR) && this.m_DeviceAttribute.isPortraitDevice()) {
                        ImiLog.d("portrait  deivce close depth_ir stream no need set sync");
                    } else {
                        this.syncFrames(false);
                    }
                }
                this.m_multiFrameThreadPool.execute(new StopCameraStreamThread(this));
                this.m_multiFrameThreadPool.execute(new StopDeviceStreamThread(this, streamFlags));
                try {
                    this.m_stopStreamLatch.await(20L, TimeUnit.SECONDS);
                    if (this.isStreamOff(streamFlags)) {
                        ret = 0;
                    }
                }
                catch (InterruptedException e) {
                    ImiLog.e("stopStream:InterruptedException catch Exception = " + e.getMessage());
                }
                this.b_StreamStopping = false;
            } else {
                ret = ImiErrorCode.IMI_NOT_OPEN.toNative();
            }
            return ret;
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH)) {
            ret = this.m_Streams.get((Object)ImiStreamType.DEPTH).close();
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.IR)) {
            ret = this.m_Streams.get((Object)ImiStreamType.IR).close();
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.COLOR)) {
            ret = this.m_Streams.get((Object)ImiStreamType.COLOR).close();
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH_SKELETON)) {
            ret = this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON).close();
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.USER_INDEX_SKELETON)) {
            ret = this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON).close();
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.SKELETON)) {
            ret = this.m_Streams.get((Object)ImiStreamType.SKELETON).close();
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.DEPTH_IR)) {
            ret = this.m_Streams.get((Object)ImiStreamType.DEPTH_IR).close();
        }
        if (this.isFlagOn(streamFlags, ImiStreamType.FLOOD_IR)) {
            ret = this.m_Streams.get((Object)ImiStreamType.FLOOD_IR).close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushbackFreeBuffer(ImiGroupFrames groupFrames) {
        Queue<ByteBuffer> queue;
        if (groupFrames.colorFrame != null && groupFrames.colorFrame.getData() != null) {
            queue = this.colorDataQueueFree;
            synchronized (queue) {
                this.colorDataQueueFree.offer(groupFrames.colorFrame.getData());
            }
        }
        if (groupFrames.depthIrFrame != null && groupFrames.depthIrFrame.getData() != null) {
            queue = this.depthirDataQueueFree;
            synchronized (queue) {
                this.depthirDataQueueFree.offer(groupFrames.depthIrFrame.getData());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImiGroupFrames readNextGroupFrames(int timeout) throws InterruptedException {
        if (!this.bGroupFrame) {
            ImiLog.w("group frame is not enabled!");
            return null;
        }
        ImiGroupFrames g = null;
        Queue<ImiGroupFrames> queue = this.groupFramesQueueFront;
        synchronized (queue) {
            g = this.groupFramesQueueFront.poll();
            if (g == null) {
                this.groupFramesQueueFront.wait(timeout);
                g = this.groupFramesQueueFront.poll();
            }
        }
        if (g != null) {
            this.groupFrames.frameType = g.frameType;
            this.pushbackFreeBuffer(this.groupFrames);
            this.groupFrames.colorFrame = g.colorFrame;
            this.groupFrames.depthIrFrame = g.depthIrFrame;
            return this.groupFrames;
        }
        return null;
    }

    public ImiFrame readNextFrame(ImiStreamType streamType, int timeout) {
        if (!(this.b_DeviceOpened || streamType != ImiStreamType.DEPTH && streamType != ImiStreamType.IR && streamType != ImiStreamType.DEPTH_SKELETON && streamType != ImiStreamType.USER_INDEX_SKELETON && streamType != ImiStreamType.SKELETON && streamType != ImiStreamType.DEPTH_IR && streamType != ImiStreamType.FLOOD_IR)) {
            SystemClock.sleep((long)10L);
            return null;
        }
        if (streamType == ImiStreamType.COLOR && (this.bSupportUVC && !this.b_CameraOpened || !this.bSupportUVC && !this.b_DeviceOpened || !this.bSupportColorStream)) {
            SystemClock.sleep((long)10L);
            return null;
        }
        if (this.m_Streams == null || this.m_Streams.get((Object)streamType) == null) {
            SystemClock.sleep((long)10L);
            return null;
        }
        return this.m_Streams.get((Object)streamType).readNextFrame(timeout);
    }

    public ImiMultiFrames readNextMultiFrames(int timeout) {
        if (!this.b_DeviceOpened && !this.b_CameraOpened) {
            SystemClock.sleep((long)10L);
            return null;
        }
        if (this.m_Streams == null) {
            SystemClock.sleep((long)10L);
            return null;
        }
        int countNum = 0;
        ImiStream colorStream = this.m_Streams.get((Object)ImiStreamType.COLOR);
        if (this.b_CameraOpened && colorStream != null && colorStream.isOpened()) {
            ++countNum;
        }
        ImiStream depthStream = this.m_Streams.get((Object)ImiStreamType.DEPTH);
        if (this.b_DeviceOpened && depthStream != null && depthStream.isOpened()) {
            ++countNum;
        }
        ImiStream depthIRStream = this.m_Streams.get((Object)ImiStreamType.DEPTH_IR);
        if (this.b_DeviceOpened && depthIRStream != null && depthIRStream.isOpened()) {
            ++countNum;
        }
        ImiStream floodIRStream = this.m_Streams.get((Object)ImiStreamType.FLOOD_IR);
        if (this.b_DeviceOpened && floodIRStream != null && floodIRStream.isOpened()) {
            ++countNum;
        }
        if (countNum == 0) {
            SystemClock.sleep((long)10L);
            return null;
        }
        this.m_multiLatch = new CountDownLatch(countNum);
        this.m_readMutilFrameTimeOut = timeout;
        this.m_multiUpdateColor = false;
        this.m_multiUpdateDepthorIR = false;
        boolean updateFlag = true;
        this.m_readMutilFrameOtherTimeOut = timeout;
        if (this.b_CameraOpened && colorStream != null && colorStream.isOpened()) {
            updateFlag = false;
            this.m_readMutilFrameOtherTimeOut = 1;
            this.m_multiFrameThreadPool.execute(new ColorFrameThread());
        }
        if (this.b_DeviceOpened && depthStream != null && depthStream.isOpened()) {
            this.m_multiFrameThreadPool.execute(new DepthFrameThread());
        }
        if (this.b_DeviceOpened && depthIRStream != null && depthIRStream.isOpened()) {
            this.m_multiFrameThreadPool.execute(new DepthIRFrameThread());
        }
        if (this.b_DeviceOpened && floodIRStream != null && floodIRStream.isOpened()) {
            this.m_multiFrameThreadPool.execute(new FloodIRFrameThread());
        }
        try {
            this.m_multiLatch.await(timeout * 2, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!updateFlag ? !this.m_multiUpdateColor : !this.m_multiUpdateDepthorIR) {
            return null;
        }
        return this.m_multiFrames;
    }

    public long getDeviceHandle() {
        if (!this.b_DeviceOpened) {
            return 0L;
        }
        return this.m_deviceHandle;
    }

    public long getStreamHandle(ImiStreamType streamType) {
        if (!this.b_DeviceOpened) {
            return 0L;
        }
        if (streamType == ImiStreamType.COLOR && this.bSupportUVC) {
            return 0L;
        }
        return this.m_Streams.get((Object)streamType).getHandle();
    }

    public int setImageRegistration(boolean bEnable) {
        if (!this.b_DeviceOpened) {
            return ImiErrorCode.IMI_NOT_OPEN.toNative();
        }
        return NativeMethods.checkReturnStatus(NativeMethods.imiSetImageRegistration(this.m_deviceHandle, bEnable));
    }

    public int setIRFaceAEEnable(boolean bEnable) {
        if (!this.b_DeviceOpened) {
            return ImiErrorCode.IMI_NOT_OPEN.toNative();
        }
        return NativeMethods.checkReturnStatus(NativeMethods.imiSetIRFaceAEEnable(this.m_deviceHandle, bEnable));
    }

    public int setOutput8BitIrData(boolean bEnable) {
        if (!this.b_DeviceOpened) {
            return ImiErrorCode.IMI_NOT_OPEN.toNative();
        }
        return NativeMethods.checkReturnStatus(NativeMethods.imiSetOutput8BitIrData(this.m_deviceHandle, bEnable));
    }

    public int setRotationAngle(ImiRotationAngle rotationAngle) {
        int ret = ImiErrorCode.IMI_FAILURE.toNative();
        if (this.b_DeviceOpened) {
            ret = NativeMethods.checkReturnStatus(NativeMethods.imiSetRotationAngle(this.m_deviceHandle, rotationAngle.toNative()));
        }
        if (ret != ImiErrorCode.IMI_OK.toNative()) {
            return ret;
        }
        if (this.b_CameraOpened) {
            ret = NativeMethods.checkReturnStatus(NativeMethods.nativeSetRotationAngle(this.m_cameraHandle, rotationAngle.toNative()));
        }
        return ret;
    }

    public int setRGB2Gray(boolean bEnable) {
        if (!this.b_CameraOpened) {
            return ImiErrorCode.IMI_NOT_OPEN.toNative();
        }
        return NativeMethods.checkReturnStatus(NativeMethods.nativeSetRGB2Gray(this.m_cameraHandle, bEnable));
    }

    public boolean isRegistrationEnable() {
        if (!this.b_DeviceOpened) {
            return false;
        }
        return NativeMethods.imiIsImageRegistrationEnable(this.m_deviceHandle);
    }

    public int setIRDist(short uValue) {
        if (!this.b_DeviceOpened) {
            return ImiErrorCode.IMI_NOT_OPEN.toNative();
        }
        if (uValue >= 0 && uValue <= 255) {
            ByteBuffer propdata = ByteBuffer.allocateDirect(2);
            propdata.order(ByteOrder.nativeOrder());
            propdata.asShortBuffer().put(uValue);
            return NativeMethods.checkReturnStatus(NativeMethods.imiSetDevProperty(this.m_deviceHandle, 7, propdata));
        }
        return ImiErrorCode.IMI_INVALID_PARAM.toNative();
    }

    public short getIRDist() {
        if (!this.b_DeviceOpened) {
            return -1;
        }
        ByteBuffer propdata = ByteBuffer.allocateDirect(2);
        propdata.order(ByteOrder.nativeOrder());
        if (0 == NativeMethods.imiGetDevProperty(this.m_deviceHandle, 7, propdata)) {
            propdata.order(ByteOrder.nativeOrder());
            ShortBuffer fb = propdata.asShortBuffer();
            fb.position(0);
            return fb.get(0);
        }
        return -1;
    }

    public int setDataOutPutTimeOut(int timeout) {
        int ret1 = this.setProperty(4129, timeout);
        int ret2 = this.setProperty(783, timeout);
        ImiLog.d("ret1 = " + ret1 + " ret2 " + ret2);
        if (ret1 == 0 && ret2 == 0) {
            return 0;
        }
        return -1;
    }

    public int setProperty(int propertyId, Object obj) {
        if (!this.b_DeviceOpened && (this.bSupportUVC && !this.b_CameraOpened || !this.bSupportUVC)) {
            return ImiErrorCode.IMI_NOT_OPEN.toNative();
        }
        ByteBuffer propdata = null;
        switch (propertyId) {
            case 19: {
                if (!(obj instanceof Boolean)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                if (this.bSupportUVC) {
                    int ret = NativeMethods.nativeSetCameraMirrorCapability(this.m_cameraHandle, (Boolean)obj);
                    if (0 == ret) {
                        this.m_Streams.get((Object)ImiStreamType.COLOR).setMirror((Boolean)obj);
                    }
                    return ret;
                }
                if (!this.bSupportColorStream) {
                    ImiLog.e("setProperty:this Device is not support Color stream");
                    return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
                }
                propdata = ByteBuffer.allocateDirect(1);
                propdata.order(ByteOrder.nativeOrder());
                byte val = (Boolean)obj != false ? (byte)1 : 0;
                propdata.put(val);
                return NativeMethods.checkReturnStatus(NativeMethods.imiSetDevProperty(this.m_deviceHandle, propertyId, propdata));
            }
            case 3: 
            case 6: 
            case 9: 
            case 51: 
            case 52: 
            case 55: 
            case 65: 
            case 87: 
            case 112: 
            case 113: 
            case 128: 
            case 144: 
            case 153: 
            case 258: 
            case 261: 
            case 266: 
            case 1513: 
            case 4165: {
                if (!(obj instanceof Boolean)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                propdata = ByteBuffer.allocateDirect(1);
                propdata.order(ByteOrder.nativeOrder());
                byte val = (Boolean)obj != false ? (byte)1 : 0;
                propdata.put(val);
                return NativeMethods.checkReturnStatus(NativeMethods.imiSetDevProperty(this.m_deviceHandle, propertyId, propdata));
            }
            case 4211: {
                if (!(obj instanceof Boolean)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                propdata = ByteBuffer.allocateDirect(1);
                propdata.order(ByteOrder.nativeOrder());
                byte val = (Boolean)obj != false ? (byte)0 : 1;
                propdata.put(val);
                return NativeMethods.checkReturnStatus(NativeMethods.imiSetDevProperty(this.m_deviceHandle, propertyId, propdata));
            }
            case 4212: {
                if (!(obj instanceof Boolean)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                byte val = (Boolean)obj != false ? (byte)0 : 1;
                return NativeMethods.checkReturnStatus(NativeMethods.nativeImiCamSetByteProperty(this.m_cameraHandle, 4211, val));
            }
            case 256: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 525: 
            case 526: {
                if (!(obj instanceof Short)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                short val = (Short)obj;
                propdata = ByteBuffer.allocateDirect(2);
                propdata.order(ByteOrder.nativeOrder());
                propdata.asShortBuffer().put(val);
                return NativeMethods.checkReturnStatus(NativeMethods.imiSetDevProperty(this.m_deviceHandle, propertyId, propdata));
            }
            case 4095: {
                if (!(obj instanceof ByteBuffer)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                ByteBuffer bf = (ByteBuffer)obj;
                return NativeMethods.checkReturnStatus(NativeMethods.imiSetDevProperty(this.m_deviceHandle, 4095, bf));
            }
            case 257: 
            case 4129: {
                if (!(obj instanceof Integer)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                int val = (Integer)obj;
                propdata = ByteBuffer.allocateDirect(4);
                propdata.order(ByteOrder.nativeOrder());
                propdata.asIntBuffer().put(val);
                return NativeMethods.checkReturnStatus(NativeMethods.imiSetDevProperty(this.m_deviceHandle, propertyId, propdata));
            }
            case 29: 
            case 54: 
            case 96: {
                if (!(obj instanceof ImiCameraIntrinsic)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                ImiCameraIntrinsic val = (ImiCameraIntrinsic)obj;
                propdata = ByteBuffer.allocateDirect(36);
                propdata.order(ByteOrder.nativeOrder());
                FloatBuffer fb = propdata.asFloatBuffer();
                fb.position(0);
                fb.put(val.getfxParam());
                fb.put(val.getfyParam());
                fb.put(val.getcxParam());
                fb.put(val.getcyParam());
                fb.put(val.getk1Param());
                fb.put(val.getk2Param());
                fb.put(val.getk3Param());
                fb.put(val.getp1Param());
                fb.put(val.getp2Param());
                return NativeMethods.checkReturnStatus(NativeMethods.imiSetDevProperty(this.m_deviceHandle, propertyId, propdata));
            }
            case 262: {
                if (!(obj instanceof ImiRtIntrinsic)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                ImiRtIntrinsic val = (ImiRtIntrinsic)obj;
                propdata = ByteBuffer.allocateDirect(48);
                propdata.order(ByteOrder.nativeOrder());
                FloatBuffer fb = propdata.asFloatBuffer();
                fb.position(0);
                fb.put(val.getRotateParam1());
                fb.put(val.getRotateParam2());
                fb.put(val.getRotateParam3());
                fb.put(val.getRotateParam4());
                fb.put(val.getRotateParam5());
                fb.put(val.getRotateParam6());
                fb.put(val.getRotateParam7());
                fb.put(val.getRotateParam8());
                fb.put(val.getRotateParam9());
                fb.put(val.getTransParam1());
                fb.put(val.getTransParam2());
                fb.put(val.getTransParam3());
                return NativeMethods.checkReturnStatus(NativeMethods.imiSetDevProperty(this.m_deviceHandle, propertyId, propdata));
            }
            case 263: {
                if (!(obj instanceof ImiIRRect)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                ImiIRRect val = (ImiIRRect)obj;
                propdata = ByteBuffer.allocateDirect(16);
                propdata.order(ByteOrder.nativeOrder());
                IntBuffer fb = propdata.asIntBuffer();
                fb.position(0);
                fb.put(val.x);
                fb.put(val.y);
                fb.put(val.width);
                fb.put(val.height);
                return NativeMethods.checkReturnStatus(NativeMethods.imiSetDevProperty(this.m_deviceHandle, propertyId, propdata));
            }
            case 83: 
            case 84: 
            case 85: 
            case 520: 
            case 521: 
            case 522: {
                if (!(obj instanceof Byte)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                propdata = ByteBuffer.allocateDirect(1);
                propdata.order(ByteOrder.nativeOrder());
                byte val = (Byte)obj;
                propdata.put(val);
                return NativeMethods.checkReturnStatus(NativeMethods.imiSetDevProperty(this.m_deviceHandle, propertyId, propdata));
            }
            case 160: {
                if (!this.bSupportUVC) {
                    return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
                }
                if (!(obj instanceof Byte)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                byte val = (Byte)obj;
                if (val != 0 && val != 1) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                int ret = NativeMethods.checkReturnStatus(NativeMethods.nativeImiCamSetByteProperty(this.m_cameraHandle, 0, val));
                if (0 == ret) {
                    this.m_CameraAEMode = val;
                }
                return ret;
            }
            case 161: {
                if (!this.bSupportUVC) {
                    return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
                }
                if (!(obj instanceof Integer)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                if (0 == this.m_CameraAEMode) {
                    ImiLog.w("automatic exposure mode does not allow set exposure time");
                    return ImiErrorCode.IMI_NOT_PERMITTED.toNative();
                }
                int val = (Integer)obj;
                boolean bValid = false;
                return NativeMethods.checkReturnStatus(NativeMethods.nativeImiCamSetIntProperty(this.m_cameraHandle, 1, val));
            }
            case 162: {
                if (!this.bSupportUVC) {
                    return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
                }
                if (!(obj instanceof Integer)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                if (1 == this.m_CameraAEMode) {
                    ImiLog.w("manual exposure mode does not allow set backlight compensation");
                    return ImiErrorCode.IMI_NOT_PERMITTED.toNative();
                }
                int val = (Integer)obj;
                int ret = NativeMethods.checkReturnStatus(NativeMethods.nativeImiCamSetIntProperty(this.m_cameraHandle, 2, val));
                return ret;
            }
            case 783: {
                if (!this.bSupportUVC) {
                    return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
                }
                if (!(obj instanceof Integer)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                int val = (Integer)obj;
                int ret = NativeMethods.checkReturnStatus(NativeMethods.nativeImiCamSetIntProperty(this.m_cameraHandle, propertyId, val));
                return ret;
            }
            case 768: 
            case 769: 
            case 770: 
            case 771: 
            case 772: 
            case 773: 
            case 774: 
            case 775: 
            case 776: 
            case 777: 
            case 778: 
            case 779: 
            case 780: 
            case 781: 
            case 782: {
                if (!this.bSupportUVC) {
                    return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
                }
                if (!(obj instanceof Integer)) {
                    return ImiErrorCode.IMI_INVALID_PARAM.toNative();
                }
                int val = (Integer)obj;
                int ret = NativeMethods.checkReturnStatus(NativeMethods.nativeImiCamSetIntProperty(this.m_cameraHandle, propertyId, val));
                return ret;
            }
        }
        return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
    }

    public Object getProperty(int propertyId) {
        if (!this.b_DeviceOpened && (this.bSupportUVC && !this.b_CameraOpened || !this.bSupportUVC)) {
            return null;
        }
        ByteBuffer propdata = null;
        switch (propertyId) {
            case 19: {
                if (this.bSupportUVC) {
                    return this.m_Streams.get((Object)ImiStreamType.COLOR).isMirror();
                }
                if (!this.bSupportColorStream) {
                    ImiLog.e("getProperty:this Device is not support Color stream");
                    return null;
                }
                propdata = ByteBuffer.allocateDirect(1);
                propdata.order(ByteOrder.nativeOrder());
                if (0 != NativeMethods.imiGetDevProperty(this.m_deviceHandle, propertyId, propdata)) break;
                propdata.order(ByteOrder.nativeOrder());
                propdata.position(0);
                boolean data = propdata.get(0) != 0;
                return data;
            }
            case 3: 
            case 51: 
            case 52: 
            case 55: 
            case 65: 
            case 87: 
            case 128: 
            case 144: 
            case 153: 
            case 258: 
            case 261: 
            case 1513: 
            case 4165: {
                propdata = ByteBuffer.allocateDirect(1);
                propdata.order(ByteOrder.nativeOrder());
                if (0 != NativeMethods.imiGetDevProperty(this.m_deviceHandle, propertyId, propdata)) break;
                propdata.order(ByteOrder.nativeOrder());
                propdata.position(0);
                boolean data = propdata.get(0) != 0;
                return data;
            }
            case 83: 
            case 264: 
            case 520: 
            case 521: 
            case 522: {
                propdata = ByteBuffer.allocateDirect(1);
                propdata.order(ByteOrder.nativeOrder());
                if (0 != NativeMethods.imiGetDevProperty(this.m_deviceHandle, propertyId, propdata)) break;
                propdata.order(ByteOrder.nativeOrder());
                propdata.position(0);
                byte data = propdata.get(0);
                return data;
            }
            case 256: 
            case 259: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 523: 
            case 524: 
            case 525: 
            case 526: {
                propdata = ByteBuffer.allocateDirect(2);
                propdata.order(ByteOrder.nativeOrder());
                if (0 != NativeMethods.imiGetDevProperty(this.m_deviceHandle, propertyId, propdata)) break;
                propdata.order(ByteOrder.nativeOrder());
                ShortBuffer fb = propdata.asShortBuffer();
                fb.position(0);
                return fb.get(0);
            }
            case 257: 
            case 260: {
                propdata = ByteBuffer.allocateDirect(4);
                propdata.order(ByteOrder.nativeOrder());
                if (0 != NativeMethods.imiGetDevProperty(this.m_deviceHandle, propertyId, propdata)) break;
                propdata.order(ByteOrder.nativeOrder());
                IntBuffer fb = propdata.asIntBuffer();
                fb.position(0);
                return fb.get(0);
            }
            case 4194: {
                propdata = ByteBuffer.allocateDirect(8);
                propdata.order(ByteOrder.nativeOrder());
                if (0 != NativeMethods.imiGetDevProperty(this.m_deviceHandle, propertyId, propdata)) break;
                propdata.order(ByteOrder.nativeOrder());
                ShortBuffer fb = propdata.asShortBuffer();
                fb.position(0);
                return new ImiDeviceTemperature(fb.get(0), fb.get(1), fb.get(2), fb.get(3));
            }
            case 29: 
            case 54: 
            case 96: {
                propdata = ByteBuffer.allocateDirect(36);
                propdata.order(ByteOrder.nativeOrder());
                if (0 != NativeMethods.imiGetDevProperty(this.m_deviceHandle, propertyId, propdata)) break;
                propdata.order(ByteOrder.nativeOrder());
                FloatBuffer fb = propdata.asFloatBuffer();
                fb.position(0);
                return new ImiCameraIntrinsic(fb.get(0), fb.get(1), fb.get(2), fb.get(3), fb.get(4), fb.get(5), fb.get(6), fb.get(7), fb.get(8));
            }
            case 265: {
                propdata = ByteBuffer.allocateDirect(32);
                propdata.order(ByteOrder.nativeOrder());
                if (0 != NativeMethods.imiGetDevProperty(this.m_deviceHandle, propertyId, propdata)) break;
                propdata.order(ByteOrder.nativeOrder());
                FloatBuffer fb = propdata.asFloatBuffer();
                fb.position(0);
                return new ImiCameraParaData(fb.get(0), fb.get(1), fb.get(2), fb.get(3), fb.get(4), fb.get(5), fb.get(6), fb.get(7));
            }
            case 262: {
                propdata = ByteBuffer.allocateDirect(48);
                propdata.order(ByteOrder.nativeOrder());
                int ret = NativeMethods.imiGetDevProperty(this.m_deviceHandle, propertyId, propdata);
                if (0 != ret) break;
                propdata.order(ByteOrder.nativeOrder());
                FloatBuffer fb = propdata.asFloatBuffer();
                fb.position(0);
                return new ImiRtIntrinsic(fb.get(0), fb.get(1), fb.get(2), fb.get(3), fb.get(4), fb.get(5), fb.get(6), fb.get(7), fb.get(8), fb.get(9), fb.get(10), fb.get(11));
            }
            case 1: {
                propdata = ByteBuffer.allocateDirect(65);
                propdata.order(ByteOrder.nativeOrder());
                if (0 != NativeMethods.imiGetDevProperty(this.m_deviceHandle, propertyId, propdata)) break;
                propdata.order(ByteOrder.nativeOrder());
                propdata.position(0);
                byte size = propdata.get(0);
                propdata.position(1);
                CharBuffer cb = Charset.forName("UTF-8").decode(propdata);
                String data = new String(cb.array());
                data = data.substring(0, size);
                return data;
            }
            case 160: {
                OutArg<Byte> byteValue;
                int result;
                if (!this.bSupportUVC || (result = NativeMethods.checkReturnStatus(NativeMethods.nativeImiCamGetByteProperty(this.m_cameraHandle, 0, byteValue = new OutArg<Byte>()))) != 0) break;
                this.m_CameraAEMode = ((Byte)byteValue.mData).byteValue();
                return byteValue.mData;
            }
            case 163: {
                if (!this.bSupportUVC) break;
                if (0 == this.m_CameraAEMode) {
                    ImiLog.w("automatic exposure mode does not allow get exposure time");
                    break;
                }
                OutArg<Integer> intValue = new OutArg<Integer>();
                int result = NativeMethods.checkReturnStatus(NativeMethods.nativeImiCamGetIntProperty(this.m_cameraHandle, 3, intValue));
                if (result != 0) break;
                return intValue.mData;
            }
            case 164: {
                if (!this.bSupportUVC) break;
                if (0 == this.m_CameraAEMode) {
                    ImiLog.w("automatic exposure mode does not allow get exposure time");
                    break;
                }
                OutArg<Integer> intValue = new OutArg<Integer>();
                int result = NativeMethods.checkReturnStatus(NativeMethods.nativeImiCamGetIntProperty(this.m_cameraHandle, 4, intValue));
                if (result != 0) break;
                return intValue.mData;
            }
            case 161: {
                if (!this.bSupportUVC) break;
                if (0 == this.m_CameraAEMode) {
                    ImiLog.w("automatic exposure mode does not allow get exposure time");
                    break;
                }
                OutArg<Integer> intValue = new OutArg<Integer>();
                int result = NativeMethods.checkReturnStatus(NativeMethods.nativeImiCamGetIntProperty(this.m_cameraHandle, 1, intValue));
                if (result != 0) break;
                return intValue.mData;
            }
            case 162: {
                if (!this.bSupportUVC) break;
                if (1 == this.m_CameraAEMode) {
                    ImiLog.w("manual exposure mode does not allow get backlight compensation");
                    break;
                }
                OutArg<Integer> intValue = new OutArg<Integer>();
                int result = NativeMethods.checkReturnStatus(NativeMethods.nativeImiCamGetIntProperty(this.m_cameraHandle, 2, intValue));
                if (result != 0) break;
                return intValue.mData;
            }
            case 766: 
            case 767: 
            case 768: 
            case 769: 
            case 770: 
            case 771: 
            case 772: 
            case 773: 
            case 774: 
            case 775: 
            case 776: 
            case 777: 
            case 778: 
            case 779: 
            case 780: 
            case 781: 
            case 782: {
                OutArg<Integer> intValue;
                int result;
                if (!this.bSupportUVC || (result = NativeMethods.checkReturnStatus(NativeMethods.nativeImiCamGetIntProperty(this.m_cameraHandle, propertyId, intValue = new OutArg<Integer>()))) != 0) break;
                return intValue.mData;
            }
        }
        return null;
    }

    public Object getProperty(ByteBuffer propdata) {
        if (0 == NativeMethods.imiGetDevProperty(this.m_deviceHandle, 4095, propdata)) {
            propdata.order(ByteOrder.nativeOrder());
            propdata.position(0);
            return propdata;
        }
        return null;
    }

    public ImiDeviceAttribute getAttribute() {
        if (!this.b_DeviceOpened || this.b_DeviceOpenning) {
            return null;
        }
        return this.m_DeviceAttribute;
    }

    public ImiVersions getVersions() {
        if (!this.b_DeviceOpened || this.b_DeviceOpenning) {
            return null;
        }
        ImiVersions versions = new ImiVersions();
        NativeMethods.checkReturnStatus(NativeMethods.imiGetVersion(this.m_deviceHandle, versions));
        String vinfo = String.format(Locale.getDefault(), "SN(%s)vid(0x%04x)pid(0x%04x)sdk(%d.%d.%d)hw(%s)fw(%d.%d.%d)ufw(%s)bfw(%s)", this.m_DeviceAttribute.getSerialNumber(), this.m_DeviceAttribute.getVendorId(), this.m_DeviceAttribute.getProductId(), versions.getSdkMajor(), versions.getSdkMinor(), versions.getSdkRevision(), versions.getHwVersion(), versions.getFwMajor(), versions.getFwMinor(), versions.getFwRevision(), versions.getUvcColorVersion(), versions.getBridgeFwVersion());
        ImiLog.i(vinfo);
        return versions;
    }

    public ImiSupportCapacity getSupportCapacity() {
        if (!this.b_DeviceOpened || this.b_DeviceOpenning) {
            return null;
        }
        ImiSupportCapacity capacity = new ImiSupportCapacity();
        NativeMethods.checkReturnStatus(NativeMethods.imiGetSupportCapacity(this.m_deviceHandle, capacity));
        return capacity;
    }

    public ImiDeviceParamsStatus getDeviceParamsStatus() {
        if (!this.b_DeviceOpened || this.b_DeviceOpenning) {
            return null;
        }
        ImiDeviceParamsStatus paramseStatus = new ImiDeviceParamsStatus();
        int result = NativeMethods.checkReturnStatus(NativeMethods.imiGetDeviceParamsStatus(this.m_deviceHandle, paramseStatus));
        if (result == 0) {
            return paramseStatus;
        }
        return null;
    }

    public int setFrameMode(ImiStreamType streamType, ImiFrameMode mode) {
        if (mode == null || mode.getFormat() == null) {
            return ImiErrorCode.IMI_INVALID_PARAM.toNative();
        }
        return this.m_Streams.get((Object)streamType).setFrameMode(mode);
    }

    public ImiFrameMode getCurrentFrameMode(ImiStreamType streamType) {
        return this.m_Streams.get((Object)streamType).getCurrentFrameMode();
    }

    public ArrayList<ImiFrameMode> getSupportFrameMode(ImiStreamType streamType) {
        return this.m_Streams.get((Object)streamType).getSupportFrameMode();
    }

    public int[] getSupportedExposureAbsoluteTimes() {
        return this.EXP_TIMES;
    }

    public int saveFrameToRaw(ImiFrame frame) {
        int frameType = -1;
        if (frame.getType() == ImiStreamType.DEPTH.toNative()) {
            frameType = 0;
        } else if (frame.getType() == ImiStreamType.IR.toNative()) {
            frameType = 1;
        } else if (frame.getType() == ImiStreamType.COLOR.toNative()) {
            frameType = 2;
        } else if (frame.getType() == ImiStreamType.USER_INDEX_SKELETON.toNative()) {
            frameType = 3;
        } else if (frame.getType() == ImiStreamType.FLOOD_IR.toNative()) {
            frameType = 4;
        } else if (frame.getType() == ImiStreamType.DEPTH_IR.toNative()) {
            frameType = 5;
        } else {
            return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
        }
        int ret = NativeMethods.imiSaveRawData(frameType, frame.getData(), frame.getWidth(), frame.getHeight(), frame.getSize());
        ImiLog.d("save " + this.streamNames.get((Object)ImiStreamType.fromNative(frame.getType())) + " frame to raw file = " + ret);
        return ret;
    }

    public int saveFrameToPicture(ImiFrame frame) {
        ByteBuffer frameData = frame.getData();
        int frameType = -1;
        if (frame.getType() == ImiStreamType.DEPTH.toNative()) {
            frameType = 0;
            frameData = Utils.depth2RGB888(frame, true, false);
        } else if (frame.getType() == ImiStreamType.IR.toNative()) {
            frameType = 1;
            frameData = Utils.ir2RGB888(frame, false);
        } else if (frame.getType() == ImiStreamType.COLOR.toNative()) {
            frameType = 2;
        } else if (frame.getType() == ImiStreamType.USER_INDEX_SKELETON.toNative()) {
            frameType = 3;
            frameData = Utils.depth2RGB888(frame, true, true);
        } else if (frame.getType() == ImiStreamType.FLOOD_IR.toNative()) {
            frameType = 4;
            frameData = Utils.ir2RGB888(frame, false);
        } else if (frame.getType() == ImiStreamType.DEPTH_IR.toNative()) {
            frameType = 5;
            frameData = frame.getData();
        } else {
            return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
        }
        int ret = NativeMethods.imiSavePicture(frameType, frameData, frame.getWidth(), frame.getHeight());
        ImiLog.d("save " + this.streamNames.get((Object)ImiStreamType.fromNative(frame.getType())) + " frame to picture file = " + ret);
        return ret;
    }

    public ImiSkeletonJointOrientation getSkeletonJointOrientation(ImiVector4[] skeletonPositions) {
        OutArg<ImiSkeletonJointOrientation> outSkeletonJointOrientation = new OutArg<ImiSkeletonJointOrientation>();
        NativeMethods.imiGetSkeletonJointOrientation(skeletonPositions, outSkeletonJointOrientation);
        return (ImiSkeletonJointOrientation)outSkeletonJointOrientation.mData;
    }

    public ImiVector4 imiConvertCoordinateDepthToWorld(ImiVector4I src, int width, int height) {
        OutArg<ImiVector4> outArg = new OutArg<ImiVector4>();
        NativeMethods.imiConvertCoordinateDepthToWorld(src, width, height, outArg);
        return (ImiVector4)outArg.mData;
    }

    public ImiVector4I imiConvertCoordinateWorldToDepth(ImiVector4 src, int width, int height) {
        OutArg<ImiVector4I> outArg = new OutArg<ImiVector4I>();
        NativeMethods.imiConvertCoordinateWorldToDepth(src, width, height, outArg);
        return (ImiVector4I)outArg.mData;
    }

    public int imiConvertDepthToPointCloud(ImiFrame frame, float factor, float fx, float fy, float cx, float cy, FloatBuffer pointClouds) {
        return NativeMethods.imiConvertDepthToPointCloud(frame.getData(), this.SFM.get((Object)ImiStreamType.fromNative(frame.getType())).toNative(), frame.getWidth(), frame.getHeight(), factor, fx, fy, cx, cy, pointClouds);
    }

    public int imiGetLastError() {
        return NativeMethods.imiGetLastError();
    }

    public String imiGetErrorString(int errorCode) {
        return NativeMethods.imiGetErrorString(errorCode);
    }

    public ImiStatus getRuntimeStatus() {
        return this.m_Status;
    }

    static /* synthetic */ byte[] access$4802(ImiDevice x0, byte[] x1) {
        x0.depthirBuffer = x1;
        return x1;
    }

    private class GetFramesTask
    extends TimerTask {
        private GetFramesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImiFrame depthIRFrame;
            Queue queue;
            ImiFrame colorFrame;
            Thread.currentThread().setPriority(10);
            if (!ImiDevice.this.b_DeviceOpened && !ImiDevice.this.b_CameraOpened) {
                return;
            }
            if (ImiDevice.this.m_Streams == null) {
                return;
            }
            ImiStream colorStream = (ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR);
            if (ImiDevice.this.b_CameraOpened && colorStream != null && colorStream.isOpened() && (colorFrame = ImiDevice.this.readNextFrame(ImiStreamType.COLOR, 0)) != null) {
                ByteBuffer colorData = colorFrame.getData();
                ByteBuffer colorData1 = null;
                Queue queue2 = ImiDevice.this.colorDataQueueFree;
                synchronized (queue2) {
                    colorData1 = (ByteBuffer)ImiDevice.this.colorDataQueueFree.poll();
                }
                if (colorData1 == null || colorData1.capacity() != colorData.capacity()) {
                    colorData1 = ByteBuffer.allocateDirect(colorData.capacity());
                }
                colorData1.position(0);
                colorData1.order(ByteOrder.nativeOrder());
                colorData1.put(colorData);
                colorData1.position(0);
                ImiFrame colorFrame1 = new ImiFrame(ImiStreamType.COLOR.toNative(), colorFrame.getmPixelFormat(), colorFrame.getFrameNum(), colorFrame.getFps(), colorFrame.getWidth(), colorFrame.getHeight(), colorFrame.getSize(), colorFrame.getTimeStamp(), colorData1, null, colorFrame.getRotationAngle().toNative(), colorFrame.getBitPerPixelType().toNative(), colorFrame.getPictureType().toNative());
                if (ImiDevice.this.colorFrameQueue.size() > 6) {
                    ImiGroupFrames g = new ImiGroupFrames();
                    g.colorFrame = (ImiFrame)ImiDevice.this.colorFrameQueue.poll();
                    g.frameType = ImiGroupFrameType.COLOR;
                    while (ImiDevice.this.groupFramesQueueback.size() > 6) {
                        ImiDevice.this.groupFramesQueueback.poll();
                    }
                    ImiDevice.this.groupFramesQueueback.offer(g);
                }
                ImiDevice.this.colorFrameQueue.offer(colorFrame1);
                if (ImiDevice.this.groupFramesQueueback.size() > 0) {
                    ImiGroupFrames g1 = null;
                    queue = ImiDevice.this.groupFramesQueueFront;
                    synchronized (queue) {
                        if (ImiDevice.this.groupFramesQueueFront.size() > 6) {
                            g1 = (ImiGroupFrames)ImiDevice.this.groupFramesQueueFront.poll();
                        }
                        ImiGroupFrames g = (ImiGroupFrames)ImiDevice.this.groupFramesQueueback.poll();
                        ImiDevice.this.groupFramesQueueFront.offer(g);
                        ImiDevice.this.groupFramesQueueFront.notify();
                    }
                    if (g1 != null) {
                        ImiDevice.this.pushbackFreeBuffer(g1);
                    }
                }
            }
            ImiStream depthIRStream = (ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR);
            if (ImiDevice.this.b_DeviceOpened && depthIRStream != null && depthIRStream.isOpened() && (depthIRFrame = ImiDevice.this.readNextFrame(ImiStreamType.DEPTH_IR, 0)) != null) {
                ByteBuffer depthIRData = depthIRFrame.getData();
                if (ImiDevice.this.depthirBuffer == null || ImiDevice.this.depthirBuffer.length != depthIRData.capacity()) {
                    ImiDevice.access$4802(ImiDevice.this, new byte[depthIRData.capacity()]);
                }
                depthIRData.get(ImiDevice.this.depthirBuffer);
                ByteBuffer depthData = null;
                ByteBuffer irData = null;
                queue = ImiDevice.this.depthirDataQueueFree;
                synchronized (queue) {
                    depthData = (ByteBuffer)ImiDevice.this.depthirDataQueueFree.poll();
                    if (depthData == null || depthData.capacity() != depthIRData.capacity() / 2) {
                        depthData = ByteBuffer.allocateDirect(depthIRData.capacity() / 2);
                    }
                    if ((irData = (ByteBuffer)ImiDevice.this.depthirDataQueueFree.poll()) == null || irData.capacity() != depthIRData.capacity() / 2) {
                        irData = ByteBuffer.allocateDirect(depthIRData.capacity() / 2);
                    }
                }
                depthData.position(0);
                depthData.order(ByteOrder.nativeOrder());
                depthData.put(ImiDevice.this.depthirBuffer, 0, depthIRData.capacity() / 2);
                depthData.position(0);
                ImiFrame depthFrame = new ImiFrame(ImiStreamType.DEPTH.toNative(), depthIRFrame.getmPixelFormat(), depthIRFrame.getFrameNum(), depthIRFrame.getFps(), depthIRFrame.getWidth(), depthIRFrame.getHeight(), depthIRFrame.getSize() / 2, depthIRFrame.getTimeStamp(), depthData, null, depthIRFrame.getRotationAngle().toNative(), depthIRFrame.getBitPerPixelType().toNative(), depthIRFrame.getPictureType().toNative());
                irData.position(0);
                irData.order(ByteOrder.nativeOrder());
                irData.put(ImiDevice.this.depthirBuffer, depthIRData.capacity() / 2, depthIRData.capacity() / 2);
                irData.position(0);
                ImiFrame irFrame = new ImiFrame(ImiStreamType.IR.toNative(), depthIRFrame.getmPixelFormat(), depthIRFrame.getFrameNum(), depthIRFrame.getFps(), depthIRFrame.getWidth(), depthIRFrame.getHeight(), depthIRFrame.getSize() / 2, depthIRFrame.getTimeStamp() - (long)depthIRFrame.frameNum, irData, null, depthIRFrame.getRotationAngle().toNative(), depthIRFrame.getBitPerPixelType().toNative(), depthIRFrame.getPictureType().toNative());
                if (Math.abs(depthIRFrame.frameNum) > 100000) {
                    depthIRFrame.frameNum = depthIRFrame.frameNum > 0 ? 36000 : -36000;
                }
                ImiGroupFrames irColorGropu = new ImiGroupFrames();
                ImiGroupFrames depthColorGropu = new ImiGroupFrames();
                boolean matchdepth = false;
                boolean matchir = false;
                int nIrColorDif = 0;
                int nDepthDif = 0;
                while (ImiDevice.this.colorFrameQueue.size() > 0) {
                    ImiGroupFrames colorGroup;
                    if (matchir && matchdepth) {
                        ImiLog.d("### match both break");
                        break;
                    }
                    ImiFrame c = (ImiFrame)ImiDevice.this.colorFrameQueue.peek();
                    ImiLog.d("###colorsize-color-ir-depth-dif " + ImiDevice.this.colorFrameQueue.size() + " " + c.getTimeStamp() / 1000L + " " + irFrame.getTimeStamp() / 1000L + " " + depthFrame.getTimeStamp() / 1000L + " " + depthFrame.getFrameNum() / 1000 + " " + (irFrame.getTimeStamp() / 1000L - c.getTimeStamp() / 1000L) + " " + (depthFrame.getTimeStamp() / 1000L - c.getTimeStamp() / 1000L));
                    nIrColorDif = (int)(irFrame.getTimeStamp() - c.getTimeStamp() - 20000L);
                    nDepthDif = (int)(depthFrame.getTimeStamp() - c.getTimeStamp());
                    if (depthIRFrame.frameNum > 0) {
                        if ((long)Math.abs(nIrColorDif) <= 20000L && !matchir) {
                            ImiLog.d("### ir front matched color pts is [" + ImiDevice.this.colorFrameQueue.size() + "] " + c.getTimeStamp() / 1000L + " irFrame pts is " + irFrame.getTimeStamp() / 1000L);
                            c = (ImiFrame)ImiDevice.this.colorFrameQueue.poll();
                            irColorGropu.depthIrFrame = irFrame;
                            irColorGropu.frameType = ImiGroupFrameType.IR_COLOR;
                            irColorGropu.colorFrame = c;
                            ImiDevice.this.groupFramesQueueback.offer(irColorGropu);
                            matchir = true;
                            c = (ImiFrame)ImiDevice.this.colorFrameQueue.poll();
                            if (c == null) continue;
                            ImiLog.d("### depth front-second matched color pts is [" + ImiDevice.this.colorFrameQueue.size() + "] " + c.getTimeStamp() / 1000L + " depthFrame pts is " + depthFrame.getTimeStamp() / 1000L);
                            depthColorGropu.frameType = ImiGroupFrameType.DEPTH_COLOR;
                            depthColorGropu.colorFrame = c;
                            depthColorGropu.depthIrFrame = depthFrame;
                            ImiDevice.this.groupFramesQueueback.offer(depthColorGropu);
                            matchdepth = true;
                            break;
                        }
                        if ((long)(-nIrColorDif) > 20000L && !matchir) {
                            matchir = true;
                        } else if ((long)nIrColorDif >= 20000L) {
                            c = (ImiFrame)ImiDevice.this.colorFrameQueue.poll();
                            colorGroup = new ImiGroupFrames();
                            colorGroup.colorFrame = c;
                            colorGroup.frameType = ImiGroupFrameType.COLOR;
                            ImiDevice.this.groupFramesQueueback.offer(colorGroup);
                            continue;
                        }
                        if (!matchdepth && (long)nDepthDif >= -10000L && (long)nDepthDif <= 20000L) {
                            ImiLog.d("### depth second matched color pts is [" + ImiDevice.this.colorFrameQueue.size() + "] " + c.getTimeStamp() / 1000L + " depthFrame pts is " + depthFrame.getTimeStamp() / 1000L);
                            c = (ImiFrame)ImiDevice.this.colorFrameQueue.poll();
                            depthColorGropu.frameType = ImiGroupFrameType.DEPTH_COLOR;
                            depthColorGropu.colorFrame = c;
                            depthColorGropu.depthIrFrame = depthFrame;
                            ImiDevice.this.groupFramesQueueback.offer(depthColorGropu);
                            matchdepth = true;
                            break;
                        }
                        if (!matchdepth && (long)nDepthDif < -10000L) {
                            matchdepth = true;
                            break;
                        }
                        if (!matchdepth) {
                            c = (ImiFrame)ImiDevice.this.colorFrameQueue.poll();
                            colorGroup = new ImiGroupFrames();
                            colorGroup.colorFrame = c;
                            colorGroup.frameType = ImiGroupFrameType.COLOR;
                            ImiDevice.this.groupFramesQueueback.offer(colorGroup);
                            continue;
                        }
                        if (ImiDevice.this.colorFrameQueue.size() < 5) continue;
                        c = (ImiFrame)ImiDevice.this.colorFrameQueue.poll();
                        colorGroup = new ImiGroupFrames();
                        colorGroup.colorFrame = c;
                        colorGroup.frameType = ImiGroupFrameType.COLOR;
                        ImiDevice.this.groupFramesQueueback.offer(colorGroup);
                        continue;
                    }
                    if (!matchdepth && (long)nDepthDif >= -10000L && (long)nDepthDif <= 20000L) {
                        ImiLog.d("### depth front matched color pts is [" + ImiDevice.this.colorFrameQueue.size() + "] " + c.getTimeStamp() / 1000L + " ir pts is " + depthFrame.getTimeStamp() / 1000L);
                        c = (ImiFrame)ImiDevice.this.colorFrameQueue.poll();
                        depthColorGropu.frameType = ImiGroupFrameType.DEPTH_COLOR;
                        depthColorGropu.colorFrame = c;
                        depthColorGropu.depthIrFrame = depthFrame;
                        ImiDevice.this.groupFramesQueueback.offer(depthColorGropu);
                        matchdepth = true;
                        continue;
                    }
                    if (!matchdepth && (long)nDepthDif < -10000L) {
                        matchdepth = true;
                    } else if (!matchdepth && (long)nDepthDif > 20000L) {
                        c = (ImiFrame)ImiDevice.this.colorFrameQueue.poll();
                        colorGroup = new ImiGroupFrames();
                        colorGroup.colorFrame = c;
                        colorGroup.frameType = ImiGroupFrameType.COLOR;
                        ImiDevice.this.groupFramesQueueback.offer(colorGroup);
                        ImiLog.d("### Only single Color =" + c.getTimeStamp() / 1000L);
                        continue;
                    }
                    if (!matchir && (long)Math.abs(nIrColorDif) <= 20000L) {
                        ImiLog.d("### ir second matched color pts is [" + ImiDevice.this.colorFrameQueue.size() + "] " + c.getTimeStamp() / 1000L + " ir pts is " + irFrame.getTimeStamp() / 1000L);
                        c = (ImiFrame)ImiDevice.this.colorFrameQueue.poll();
                        irColorGropu.depthIrFrame = irFrame;
                        irColorGropu.frameType = ImiGroupFrameType.IR_COLOR;
                        irColorGropu.colorFrame = c;
                        ImiDevice.this.groupFramesQueueback.offer(irColorGropu);
                        matchir = true;
                        break;
                    }
                    if (!matchir && (long)(-nIrColorDif) > 20000L) {
                        matchir = true;
                        break;
                    }
                    if (!matchir) {
                        c = (ImiFrame)ImiDevice.this.colorFrameQueue.poll();
                        colorGroup = new ImiGroupFrames();
                        colorGroup.colorFrame = c;
                        colorGroup.frameType = ImiGroupFrameType.COLOR;
                        ImiDevice.this.groupFramesQueueback.offer(colorGroup);
                        continue;
                    }
                    if (ImiDevice.this.colorFrameQueue.size() < 5) continue;
                    c = (ImiFrame)ImiDevice.this.colorFrameQueue.poll();
                    colorGroup = new ImiGroupFrames();
                    colorGroup.colorFrame = c;
                    colorGroup.frameType = ImiGroupFrameType.COLOR;
                    ImiDevice.this.groupFramesQueueback.offer(colorGroup);
                }
            }
        }
    }

    private class FloodIRFrameThread
    implements Runnable {
        private FloodIRFrameThread() {
        }

        @Override
        public void run() {
            ImiFrame floodIRFrame = ImiDevice.this.readNextFrame(ImiStreamType.FLOOD_IR, ImiDevice.this.m_readMutilFrameOtherTimeOut);
            if (floodIRFrame != null) {
                ByteBuffer buffer = ((ImiStream)((ImiDevice)ImiDevice.this).m_Streams.get((Object)((Object)ImiStreamType.FLOOD_IR))).m_multiBuffer;
                if (buffer == null || buffer.capacity() != floodIRFrame.getData().capacity()) {
                    buffer = ((ImiStream)((ImiDevice)ImiDevice.this).m_Streams.get((Object)((Object)ImiStreamType.FLOOD_IR))).m_multiBuffer = ByteBuffer.allocateDirect(floodIRFrame.getData().capacity());
                }
                buffer.position(0);
                buffer.order(ByteOrder.nativeOrder());
                buffer.put(floodIRFrame.getData());
                buffer.position(0);
                ((ImiDevice)ImiDevice.this).m_multiFrames.irFrame = floodIRFrame;
                ((ImiDevice)ImiDevice.this).m_multiFrames.irFrame.setData(buffer);
                ImiDevice.this.m_multiUpdateDepthorIR = true;
            }
            ImiDevice.this.m_multiLatch.countDown();
        }
    }

    private class DepthIRFrameThread
    implements Runnable {
        private DepthIRFrameThread() {
        }

        @Override
        public void run() {
            ImiFrame depthIRFrame = ImiDevice.this.readNextFrame(ImiStreamType.DEPTH_IR, ImiDevice.this.m_readMutilFrameOtherTimeOut);
            if (depthIRFrame != null) {
                ByteBuffer depthIRData = depthIRFrame.getData();
                ByteBuffer bufferDepth = ((ImiStream)((ImiDevice)ImiDevice.this).m_Streams.get((Object)((Object)ImiStreamType.DEPTH))).m_multiBuffer;
                if (bufferDepth.capacity() != depthIRData.capacity() / 2) {
                    bufferDepth = ((ImiStream)((ImiDevice)ImiDevice.this).m_Streams.get((Object)((Object)ImiStreamType.DEPTH))).m_multiBuffer = ByteBuffer.allocateDirect(depthIRData.capacity() / 2);
                }
                byte[] bufferTemp = new byte[depthIRData.capacity()];
                depthIRData.get(bufferTemp);
                bufferDepth.position(0);
                bufferDepth.order(ByteOrder.nativeOrder());
                bufferDepth.put(bufferTemp, 0, depthIRData.capacity() / 2);
                bufferDepth.position(0);
                ((ImiDevice)ImiDevice.this).m_multiFrames.depthFrame = new ImiFrame(ImiStreamType.DEPTH.toNative(), depthIRFrame.getmPixelFormat(), depthIRFrame.getFrameNum(), depthIRFrame.getFps(), depthIRFrame.getWidth(), depthIRFrame.getHeight(), depthIRFrame.getSize() / 2, depthIRFrame.getTimeStamp(), bufferDepth, null, depthIRFrame.getRotationAngle().toNative(), depthIRFrame.getBitPerPixelType().toNative(), depthIRFrame.getPictureType().toNative());
                ByteBuffer bufferIR = ((ImiStream)((ImiDevice)ImiDevice.this).m_Streams.get((Object)((Object)ImiStreamType.IR))).m_multiBuffer;
                if (bufferIR == null || bufferIR.capacity() != depthIRData.capacity() / 2) {
                    bufferIR = ((ImiStream)((ImiDevice)ImiDevice.this).m_Streams.get((Object)((Object)ImiStreamType.IR))).m_multiBuffer = ByteBuffer.allocateDirect(depthIRData.capacity() / 2);
                }
                bufferIR.position(0);
                bufferIR.order(ByteOrder.nativeOrder());
                bufferIR.put(bufferTemp, depthIRData.capacity() / 2, depthIRData.capacity() / 2);
                bufferIR.position(0);
                ((ImiDevice)ImiDevice.this).m_multiFrames.irFrame = new ImiFrame(ImiStreamType.IR.toNative(), depthIRFrame.getmPixelFormat(), depthIRFrame.getFrameNum(), depthIRFrame.getFps(), depthIRFrame.getWidth(), depthIRFrame.getHeight(), depthIRFrame.getSize() / 2, depthIRFrame.getTimeStamp(), bufferIR, null, depthIRFrame.getRotationAngle().toNative(), depthIRFrame.getBitPerPixelType().toNative(), depthIRFrame.getPictureType().toNative());
                ImiDevice.this.m_multiUpdateDepthorIR = true;
            }
            ImiDevice.this.m_multiLatch.countDown();
        }
    }

    private class DepthFrameThread
    implements Runnable {
        private DepthFrameThread() {
        }

        @Override
        public void run() {
            ImiFrame depthFrame = ImiDevice.this.readNextFrame(ImiStreamType.DEPTH, ImiDevice.this.m_readMutilFrameOtherTimeOut);
            if (depthFrame != null) {
                ByteBuffer buffer = ((ImiStream)((ImiDevice)ImiDevice.this).m_Streams.get((Object)((Object)ImiStreamType.DEPTH))).m_multiBuffer;
                if (buffer == null || buffer.capacity() != depthFrame.getData().capacity()) {
                    buffer = ((ImiStream)((ImiDevice)ImiDevice.this).m_Streams.get((Object)((Object)ImiStreamType.DEPTH))).m_multiBuffer = ByteBuffer.allocateDirect(depthFrame.getData().capacity());
                }
                buffer.position(0);
                buffer.order(ByteOrder.nativeOrder());
                buffer.put(depthFrame.getData());
                buffer.position(0);
                ((ImiDevice)ImiDevice.this).m_multiFrames.depthFrame = depthFrame;
                ((ImiDevice)ImiDevice.this).m_multiFrames.depthFrame.setData(buffer);
                ImiDevice.this.m_multiUpdateDepthorIR = true;
            }
            ImiDevice.this.m_multiLatch.countDown();
        }
    }

    private class ColorFrameThread
    implements Runnable {
        private ColorFrameThread() {
        }

        @Override
        public void run() {
            ImiFrame colorFrame = ImiDevice.this.readNextFrame(ImiStreamType.COLOR, ImiDevice.this.m_readMutilFrameTimeOut);
            if (colorFrame != null) {
                ByteBuffer buffer = ((ImiStream)((ImiDevice)ImiDevice.this).m_Streams.get((Object)((Object)ImiStreamType.COLOR))).m_multiBuffer;
                if (buffer == null || buffer.capacity() != colorFrame.getData().capacity()) {
                    buffer = ((ImiStream)((ImiDevice)ImiDevice.this).m_Streams.get((Object)((Object)ImiStreamType.COLOR))).m_multiBuffer = ByteBuffer.allocateDirect(colorFrame.getData().capacity());
                }
                buffer.position(0);
                buffer.order(ByteOrder.nativeOrder());
                buffer.put(colorFrame.getData());
                buffer.position(0);
                ((ImiDevice)ImiDevice.this).m_multiFrames.colorFrame = colorFrame;
                ((ImiDevice)ImiDevice.this).m_multiFrames.colorFrame.setData(buffer);
                ImiDevice.this.m_multiUpdateColor = true;
            }
            ImiDevice.this.m_multiLatch.countDown();
        }
    }

    private class StopCameraStreamThread
    implements Runnable {
        private final ImiDevice imidevice;

        public StopCameraStreamThread(ImiDevice imidevice) {
            this.imidevice = imidevice;
        }

        @Override
        public void run() {
            ImiLog.d("StopCameraStreamThread stopColorStream");
            int ret = -1;
            try {
                ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).close();
                ImiLog.d("colorStream has stopped");
            }
            catch (IllegalStateException e) {
                ImiLog.e("IllegalStateException stop Camera stream");
            }
            ImiDevice.this.m_stopStreamLatch.countDown();
        }
    }

    private class StopDeviceStreamThread
    implements Runnable {
        private final ImiDevice imidevice;
        private final int streamFlags;

        public StopDeviceStreamThread(ImiDevice imidevice, int streamFlags) {
            this.imidevice = imidevice;
            this.streamFlags = streamFlags;
        }

        @Override
        public void run() {
            ImiLog.d("StopDeviceStreamThread stopDeviceStream");
            int ret = -1;
            try {
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.DEPTH)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH)).close();
                }
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.DEPTH_SKELETON)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON)).close();
                }
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.USER_INDEX_SKELETON)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON)).close();
                }
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.SKELETON)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.SKELETON)).close();
                }
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.IR)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.IR)).close();
                }
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.DEPTH_IR)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).close();
                }
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.FLOOD_IR)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.FLOOD_IR)).close();
                }
                ImiLog.d("device stream has stopped");
            }
            catch (IllegalStateException e) {
                ImiLog.e("IllegalStateException stop Device stream");
            }
            ImiDevice.this.m_stopStreamLatch.countDown();
        }
    }

    private class StartCameraStreamThread
    implements Runnable {
        private final ImiDevice imidevice;

        public StartCameraStreamThread(ImiDevice imidevice) {
            this.imidevice = imidevice;
        }

        @Override
        public void run() {
            ImiLog.d("StartCameraStreamThread startColorStream");
            int ret = -1;
            try {
                ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).open();
            }
            catch (IllegalStateException e) {
                ImiLog.e("IllegalStateException start Camera stream");
            }
            ImiDevice.this.tmp_CameraErrorCode = ret;
            ImiDevice.this.m_startStreamLatch.countDown();
        }
    }

    private class StartDeviceStreamThread
    implements Runnable {
        private final ImiDevice imidevice;
        private final int streamFlags;

        public StartDeviceStreamThread(ImiDevice imidevice, int streamFlags) {
            this.imidevice = imidevice;
            this.streamFlags = streamFlags;
        }

        @Override
        public void run() {
            ImiLog.d("StartDeviceStreamThread startDeviceStream");
            int ret = -1;
            try {
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.DEPTH)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH)).open();
                } else if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.DEPTH_SKELETON)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON)).open();
                } else if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.USER_INDEX_SKELETON)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON)).open();
                } else if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.SKELETON)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.SKELETON)).open();
                }
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.IR)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.IR)).open();
                }
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.DEPTH_IR)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).open();
                }
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.FLOOD_IR)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.FLOOD_IR)).open();
                }
            }
            catch (IllegalStateException e) {
                ImiLog.e("IllegalStateException start Device stream");
            }
            ImiDevice.this.tmp_DeviceErrorCode = ret;
            ImiDevice.this.m_startStreamLatch.countDown();
        }
    }

    private class StartMixCameraDeviceStreamThread
    implements Runnable {
        private final ImiDevice imidevice;
        private final int streamFlags;

        public StartMixCameraDeviceStreamThread(ImiDevice imidevice, int streamFlags) {
            this.imidevice = imidevice;
            this.streamFlags = streamFlags;
        }

        @Override
        public void run() {
            ImiLog.d("StartDeviceStreamThread startDeviceStream");
            int ret = -1;
            try {
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.DEPTH)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH)).open();
                } else if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.DEPTH_SKELETON)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON)).open();
                } else if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.USER_INDEX_SKELETON)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON)).open();
                } else if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.SKELETON)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.SKELETON)).open();
                }
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.IR)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.IR)).open();
                }
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.DEPTH_IR)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).open();
                }
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.FLOOD_IR)) {
                    ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.FLOOD_IR)).open();
                }
                ret = ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).open();
            }
            catch (IllegalStateException e) {
                ImiLog.e("IllegalStateException start Device stream");
            }
            ImiDevice.this.tmp_DeviceErrorCode = ret;
            ImiDevice.this.m_startStreamLatch.countDown();
            ImiDevice.this.m_startStreamLatch.countDown();
        }
    }

    private class AwaitThread
    implements Runnable {
        private final ImiDevice imidevice;
        private final CountDownLatch latch;
        private final int streamFlags;

        public AwaitThread(ImiDevice imidevice, CountDownLatch latch, int streamFlags) {
            this.imidevice = imidevice;
            this.latch = latch;
            this.streamFlags = streamFlags;
        }

        @Override
        public void run() {
            try {
                this.latch.await(120L, TimeUnit.SECONDS);
                ImiDevice.this.b_DeviceOpenning = false;
                if (ImiDevice.this.b_DeviceOpened && ImiDevice.this.b_CameraOpened && ImiDevice.this.isStreamOn(this.streamFlags)) {
                    ImiDevice.this.m_Status.setStatus(0, 0);
                    ImiDevice.this.m_openlistener.onOpenDeviceSuccess();
                } else {
                    int deviceErrorCode = ImiDevice.this.tmp_DeviceErrorCode;
                    int cameraErrorCode = ImiDevice.this.tmp_CameraErrorCode;
                    ImiLog.e("AwaitThread OPEN failed");
                    this.imidevice.close();
                    String errmsg = "open device failed";
                    if (cameraErrorCode == ImiErrorCode.IMI_DEVICE_BUSY.toNative() || deviceErrorCode == ImiErrorCode.IMI_DEVICE_BUSY.toNative()) {
                        errmsg = "device busy";
                    } else if (cameraErrorCode == ImiErrorCode.IMI_INVALID_DEVICE.toNative() || deviceErrorCode == ImiErrorCode.IMI_INVALID_DEVICE.toNative()) {
                        errmsg = "Device is not UVC-compliant";
                    } else if (cameraErrorCode == ImiErrorCode.IMI_INVALID_MODE.toNative() || deviceErrorCode == ImiErrorCode.IMI_INVALID_MODE.toNative()) {
                        errmsg = "Mode not supported";
                    } else if (cameraErrorCode == -9 || deviceErrorCode == -9) {
                        errmsg = "UVC pipe error";
                    } else if (ImiDevice.this.b_CameraOpened && ImiDevice.this.b_DeviceOpened && cameraErrorCode != 0 && deviceErrorCode != 0) {
                        errmsg = "start Camera+Device stream failed";
                    } else if (cameraErrorCode != 0 && ImiDevice.this.b_CameraOpened) {
                        errmsg = "start Camera stream failed";
                    } else if (deviceErrorCode != 0 && ImiDevice.this.b_DeviceOpened) {
                        errmsg = "start Device stream failed";
                    }
                    if (cameraErrorCode != 0) {
                        ImiDevice.this.m_openlistener.onOpenDeviceFailed("[" + cameraErrorCode + "] " + errmsg);
                    } else if (deviceErrorCode != 0) {
                        ImiDevice.this.m_openlistener.onOpenDeviceFailed("[" + deviceErrorCode + "] " + errmsg);
                    }
                }
            }
            catch (InterruptedException e) {
                ImiLog.e("awaitInTask OPEN failed catch " + e.toString());
            }
        }
    }

    private class OpenCameraThread
    implements Runnable {
        private final ImiDevice imicamera;
        private final int fd;
        private final UsbDevice device;
        private final int streamFlags;

        public OpenCameraThread(ImiDevice imicamera, int fd, UsbDevice device, int streamFlags) {
            this.imicamera = imicamera;
            this.fd = fd;
            this.device = device;
            this.streamFlags = streamFlags;
        }

        @Override
        public void run() {
            String name = this.device.getDeviceName();
            ImiLog.d("OpenCameraThread openimicamera " + name);
            String[] v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
            int busnum = 0;
            int devnum = 0;
            if (v != null) {
                busnum = Integer.parseInt(v[v.length - 2]);
                devnum = Integer.parseInt(v[v.length - 1]);
            }
            int ret = -1;
            try {
                ImiDevice.this.SetSonixFwFd(this.fd);
                ImiLog.d("imicamera.openCamera before");
                ret = this.imicamera.openCamera(this.device.getVendorId(), this.device.getProductId(), this.fd, busnum, devnum, ImiDevice.this.getUSBFSName(name));
                ImiLog.d("imicamera.openCamera after");
            }
            catch (IllegalStateException e) {
                ImiLog.e("IllegalStateException open camera");
                ImiDevice.this.m_openlistener.onOpenDeviceFailed("[" + ret + "] InTask open camera catch Exception = " + e.getMessage());
            }
            if (ret == 0) {
                ImiLog.d("Camera Opened use " + (System.currentTimeMillis() - ImiDevice.this.tmpCameraTime));
                ImiDevice.this.tmpCameraTime = System.currentTimeMillis();
                ImiDevice.this.b_CameraOpened = true;
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).getSupportFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).getCurrentFrameMode();
                if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.COLOR)) {
                    ret = this.imicamera.startStream(ImiStreamType.COLOR.toNative());
                }
            } else {
                ImiDevice.this.m_Status.setStatus(17, ret);
                ImiLog.e("Camera open failed ret = " + ret);
            }
            ImiDevice.this.tmp_CameraErrorCode = ret;
            ImiDevice.this.m_openDeviceLatch.countDown();
        }
    }

    private class OpenDeviceThread
    implements Runnable {
        private final ImiDevice imidevice;
        private final int fd;
        private final UsbDevice device;
        private final int streamFlags;

        public OpenDeviceThread(ImiDevice imidevice, int fd, UsbDevice device, int streamFlags) {
            this.imidevice = imidevice;
            this.fd = fd;
            this.device = device;
            this.streamFlags = streamFlags;
        }

        @Override
        public void run() {
            ImiLog.d("OpenDeviceThread openimidevice");
            int ret = -1;
            try {
                ret = this.imidevice.openDevice(this.device.getVendorId(), this.device.getProductId(), this.fd, this.device.getDeviceName());
            }
            catch (IllegalStateException e) {
                ImiLog.e("IllegalStateException open device");
                ImiDevice.this.m_openlistener.onOpenDeviceFailed("[" + ret + "] InTask open device catch Exception = " + e.getMessage());
            }
            if (ret == 0) {
                ImiLog.d("Device Opened use " + (System.currentTimeMillis() - ImiDevice.this.tmpDeviceTime));
                ImiDevice.this.b_DeviceOpened = true;
                ImiDevice.this.tmpDeviceTime = System.currentTimeMillis();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.IR)).getSupportFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH)).getSupportFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON)).getSupportFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON)).getSupportFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.SKELETON)).getSupportFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).getSupportFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.FLOOD_IR)).getSupportFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.IR)).getCurrentFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH)).getCurrentFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON)).getCurrentFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON)).getCurrentFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.SKELETON)).getCurrentFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).getCurrentFrameMode();
                ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.FLOOD_IR)).getCurrentFrameMode();
                if (!ImiDevice.this.bSupportUVC) {
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).getSupportFrameMode();
                    ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).getCurrentFrameMode();
                }
                Object obj = ImiDevice.this.getProperty(1);
                ImiDevice.this.m_DeviceAttribute = new ImiDeviceAttribute(this.device.getVendorId(), (short)this.device.getProductId(), this.device.getDeviceId(), obj != null ? (String)obj : "", this.device.getDeviceName());
                if (ImiDevice.this.bSupportUVC) {
                    if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.IR)) {
                        ret = this.imidevice.startStream(ImiStreamType.IR.toNative());
                    }
                    if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.DEPTH)) {
                        ret = this.imidevice.startStream(ImiStreamType.DEPTH.toNative());
                    }
                    if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.DEPTH_SKELETON)) {
                        ret = this.imidevice.startStream(ImiStreamType.DEPTH_SKELETON.toNative());
                    }
                    if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.USER_INDEX_SKELETON)) {
                        ret = this.imidevice.startStream(ImiStreamType.USER_INDEX_SKELETON.toNative());
                    }
                    if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.SKELETON)) {
                        ret = this.imidevice.startStream(ImiStreamType.SKELETON.toNative());
                    }
                    if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.DEPTH_IR)) {
                        ret = this.imidevice.startStream(ImiStreamType.DEPTH_IR.toNative());
                    }
                    if (ImiDevice.this.isFlagOn(this.streamFlags, ImiStreamType.FLOOD_IR)) {
                        ret = this.imidevice.startStream(ImiStreamType.FLOOD_IR.toNative());
                    }
                } else {
                    ret = this.imidevice.startStream(this.streamFlags);
                }
            } else {
                ImiDevice.this.m_Status.setStatus(16, ret);
                ImiLog.e("Device open failed ret = " + ret);
            }
            ImiDevice.this.tmp_DeviceErrorCode = ret;
            if (ImiDevice.this.bSupportUVC) {
                ImiDevice.this.m_openDeviceLatch.countDown();
            } else {
                ImiDevice.this.b_DeviceOpenning = false;
                if (ImiDevice.this.b_DeviceOpened && ImiDevice.this.isStreamOn(this.streamFlags)) {
                    ImiDevice.this.m_Status.setStatus(0, 0);
                    ImiDevice.this.m_openlistener.onOpenDeviceSuccess();
                } else {
                    int deviceErrorCode = ImiDevice.this.tmp_DeviceErrorCode;
                    ImiLog.e("OPEN failed");
                    this.imidevice.close();
                    String errmsg = "open device failed";
                    if (deviceErrorCode == ImiErrorCode.IMI_DEVICE_BUSY.toNative()) {
                        errmsg = "device busy";
                    } else if (deviceErrorCode == ImiErrorCode.IMI_INVALID_DEVICE.toNative()) {
                        errmsg = "Device is not UVC-compliant";
                    } else if (deviceErrorCode == ImiErrorCode.IMI_INVALID_MODE.toNative()) {
                        errmsg = "Mode not supported";
                    }
                    ImiDevice.this.m_openlistener.onOpenDeviceFailed("[" + ret + "]" + errmsg);
                }
            }
        }
    }

    public static interface DeviceStateListener {
        public void onDeviceStateChanged(String var1, ImiDeviceState var2);
    }

    public static interface OpenDeviceListener {
        public void onOpenDeviceSuccess();

        public void onOpenDeviceFailed(String var1);
    }

    private class ImiStream {
        private long streamHandle = -1L;
        private ImiStreamType streamType;
        private ImiFrameMode frameMode = null;
        private ArrayList<ImiFrameMode> supFrameModes = null;
        private boolean b_StreamOpened = false;
        private boolean b_StreamMirror = true;
        private boolean b_GetFirstFrame = false;
        private int tmp_ErrorCode = 0;
        public ByteBuffer m_multiBuffer = null;

        public ImiStream(ImiStreamType streamType) {
            this.streamType = streamType;
            this.resetFrameMode();
            this.m_multiBuffer = streamType == ImiStreamType.COLOR ? ByteBuffer.allocateDirect(921600) : ByteBuffer.allocateDirect(614400);
        }

        public void reset() {
            this.streamHandle = -1L;
            this.resetFrameMode();
            this.supFrameModes = null;
            this.b_StreamMirror = true;
            this.b_StreamOpened = false;
            this.b_GetFirstFrame = false;
            this.tmp_ErrorCode = 0;
        }

        private void resetFrameMode() {
            if (this.streamType == ImiStreamType.COLOR) {
                this.frameMode = new ImiFrameMode(ImiPixelFormat.IMI_PIXEL_FORMAT_IMAGE_RGB24, 640, 480, 30);
            } else if (this.streamType == ImiStreamType.DEPTH) {
                this.frameMode = new ImiFrameMode(ImiPixelFormat.IMI_PIXEL_FORMAT_DEP_16BIT, 640, 480, 30);
            } else if (this.streamType == ImiStreamType.IR) {
                this.frameMode = new ImiFrameMode(ImiPixelFormat.IMI_PIXEL_FORMAT_IR_16BIT, 640, 480, 30);
            } else if (this.streamType == ImiStreamType.DEPTH_SKELETON) {
                this.frameMode = new ImiFrameMode(ImiPixelFormat.IMI_PIXEL_FORMAT_DEP_16BIT, 640, 480, 30);
            } else if (this.streamType == ImiStreamType.USER_INDEX_SKELETON) {
                this.frameMode = new ImiFrameMode(ImiPixelFormat.IMI_PIXEL_FORMAT_DEP_16BIT, 640, 480, 30);
            } else if (this.streamType == ImiStreamType.SKELETON) {
                this.frameMode = new ImiFrameMode(ImiPixelFormat.IMI_PIXEL_FORMAT_DEP_16BIT, 640, 480, 30);
            } else if (this.streamType == ImiStreamType.DEPTH_IR) {
                this.frameMode = new ImiFrameMode(ImiPixelFormat.IMI_PIXEL_FORMAT_DEP_IR_16BIT, 640, 480, 30);
            } else if (this.streamType == ImiStreamType.FLOOD_IR) {
                this.frameMode = new ImiFrameMode(ImiPixelFormat.IMI_PIXEL_FORMAT_IR_16BIT, 480, 640, 30);
            }
        }

        public int setFrameMode(ImiFrameMode mode) {
            if (this.streamType == ImiStreamType.COLOR && ImiDevice.this.bSupportUVC && !ImiDevice.this.b_CameraOpened) {
                return ImiErrorCode.IMI_INVALID_OPERATION.toNative();
            }
            if (this.streamType == ImiStreamType.COLOR && !ImiDevice.this.bSupportUVC && !ImiDevice.this.b_DeviceOpened) {
                return ImiErrorCode.IMI_INVALID_OPERATION.toNative();
            }
            if (this.streamType != ImiStreamType.COLOR && !ImiDevice.this.b_DeviceOpened) {
                return ImiErrorCode.IMI_INVALID_OPERATION.toNative();
            }
            if (this.b_StreamOpened) {
                ImiDevice.this.m_Status.setStatus(68, ImiErrorCode.IMI_NOT_PERMITTED.toNative());
                ImiLog.w((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " Stream is running, if setFrameMode please stop stream first");
                return ImiErrorCode.IMI_NOT_PERMITTED.toNative();
            }
            if (this.streamType == ImiStreamType.COLOR && !ImiDevice.this.bSupportColorStream) {
                ImiLog.e("setFrameMode:this Device is not support Color stream");
                return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
            }
            if (!this.isFrameModeValid(mode, this.supFrameModes)) {
                ImiDevice.this.m_Status.setStatus(67, ImiErrorCode.IMI_INVALID_PARAM.toNative());
                ImiLog.e("frameMode for " + (String)ImiDevice.this.streamNames.get((Object)this.streamType) + " Stream is invalid");
                return ImiErrorCode.IMI_INVALID_PARAM.toNative();
            }
            if (this.streamType == ImiStreamType.COLOR && ImiDevice.this.bSupportUVC) {
                ImiCameraFrameMode camframeMode = ImiDevice.this.FrameModeToCameraFrameMode(mode);
                int ret = NativeMethods.nativeSetCameraFrameMode(ImiDevice.this.m_cameraHandle, camframeMode.getWidth(), camframeMode.getHeight(), camframeMode.getPixelFormat().toNative(), camframeMode.getFps());
                if (0 == ret) {
                    this.frameMode = mode;
                } else {
                    ImiLog.e("set frameMode for " + (String)ImiDevice.this.streamNames.get((Object)this.streamType) + " failed");
                    if (ImiDevice.this.b_DeviceOpenning) {
                        ImiDevice.this.m_Status.setStatus(29, ret);
                    } else {
                        ImiDevice.this.m_Status.setStatus(60, ret);
                    }
                }
                return ret;
            }
            int ret = NativeMethods.checkReturnStatus(NativeMethods.imiSetFrameMode(ImiDevice.this.m_deviceHandle, ((ImiFrameType)((Object)ImiDevice.this.SFM.get((Object)this.streamType))).toNative(), mode.getResolutionX(), mode.getResolutionY(), mode.getFramerate(), mode.getFormat().toNative(), 0));
            if (0 == ret) {
                this.frameMode = mode;
            } else {
                switch (this.streamType) {
                    case COLOR: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(29, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(60, ret);
                        break;
                    }
                    case DEPTH: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(30, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(61, ret);
                        break;
                    }
                    case IR: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(31, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(62, ret);
                        break;
                    }
                    case DEPTH_SKELETON: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(34, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(65, ret);
                        break;
                    }
                    case USER_INDEX_SKELETON: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(33, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(64, ret);
                        break;
                    }
                    case SKELETON: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(35, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(66, ret);
                        break;
                    }
                    case DEPTH_IR: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(32, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(63, ret);
                        break;
                    }
                    case FLOOD_IR: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(37, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(70, ret);
                    }
                }
                ImiLog.e((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " SetFrameMode failed ret = " + ret);
            }
            return ret;
        }

        public ImiFrameMode getCurrentFrameMode() {
            if (this.streamType == ImiStreamType.COLOR && ImiDevice.this.bSupportUVC && !ImiDevice.this.b_CameraOpened) {
                return null;
            }
            if (this.streamType == ImiStreamType.COLOR && !ImiDevice.this.bSupportUVC && !ImiDevice.this.b_DeviceOpened) {
                return null;
            }
            if (this.streamType != ImiStreamType.COLOR && !ImiDevice.this.b_DeviceOpened) {
                return null;
            }
            if (this.streamType == ImiStreamType.COLOR) {
                if (!ImiDevice.this.b_DeviceOpened && !ImiDevice.this.b_CameraOpened) {
                    return this.frameMode;
                }
                if (ImiDevice.this.bSupportUVC ? !ImiDevice.this.b_CameraOpened : !ImiDevice.this.b_DeviceOpened) {
                    return this.frameMode;
                }
                if (!ImiDevice.this.bSupportColorStream) {
                    ImiLog.e("getSupportFrameMode:this Device is not support Color stream");
                    return this.frameMode;
                }
            } else if (!ImiDevice.this.b_DeviceOpened) {
                return this.frameMode;
            }
            if (this.streamType != ImiStreamType.COLOR || this.streamType == ImiStreamType.COLOR && !ImiDevice.this.bSupportUVC) {
                NativeMethods.imiGetCurrentFrameMode(ImiDevice.this.m_deviceHandle, ((ImiFrameType)((Object)ImiDevice.this.SFM.get((Object)this.streamType))).toNative(), this.frameMode);
            }
            if (this.streamType == ImiStreamType.COLOR && ImiDevice.this.bSupportUVC) {
                ImiCameraFrameMode cameraFrameMode = new ImiCameraFrameMode();
                NativeMethods.nativeGetCameraCurrentFrameMode(ImiDevice.this.m_cameraHandle, cameraFrameMode);
                this.frameMode = ImiDevice.this.CameraFrameModeToFrameMode(cameraFrameMode);
            }
            return this.frameMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<ImiFrameMode> getSupportFrameMode() {
            ImiStream imiStream = this;
            synchronized (imiStream) {
                if (this.supFrameModes != null && this.supFrameModes.size() > 0) {
                    ImiLog.e("framemode list is exist,no need get again!");
                    return this.supFrameModes;
                }
                ImiLog.e("getSupportFrameMode (" + (Object)((Object)this.streamType) + "): start");
                if (this.streamType == ImiStreamType.COLOR) {
                    if (ImiDevice.this.bSupportUVC) {
                        if (!ImiDevice.this.b_CameraOpened) {
                            return null;
                        }
                    } else if (!ImiDevice.this.b_DeviceOpened) {
                        return null;
                    }
                    if (!ImiDevice.this.bSupportColorStream) {
                        ImiLog.e("getSupportFrameMode:this Device is not support Color stream");
                        return null;
                    }
                } else if (!ImiDevice.this.b_DeviceOpened) {
                    return null;
                }
                if (this.supFrameModes == null) {
                    this.supFrameModes = new ArrayList();
                }
                this.supFrameModes.clear();
                if (this.streamType == ImiStreamType.COLOR && ImiDevice.this.bSupportUVC) {
                    ArrayList<ImiCameraFrameMode> modes = new ArrayList<ImiCameraFrameMode>();
                    NativeMethods.nativeGetCameraSupportFrameModes(ImiDevice.this.m_cameraHandle, modes);
                    for (int i = 0; i < modes.size(); ++i) {
                        this.supFrameModes.add(ImiDevice.this.CameraFrameModeToFrameMode(modes.get(i)));
                    }
                    return this.supFrameModes;
                }
                NativeMethods.checkReturnStatus(NativeMethods.imiGetSupportFrameMode(ImiDevice.this.m_deviceHandle, ((ImiFrameType)((Object)ImiDevice.this.SFM.get((Object)this.streamType))).toNative(), this.supFrameModes));
                return this.supFrameModes;
            }
        }

        private boolean isFrameModeValid(ImiFrameMode mode, ArrayList<ImiFrameMode> m_supModes) {
            if (m_supModes == null) {
                ImiLog.e((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " supModes == null");
                return false;
            }
            boolean bValid = false;
            for (int i = 0; i < m_supModes.size(); ++i) {
                if (mode.getFormat() != m_supModes.get(i).getFormat() || mode.getResolutionX() != m_supModes.get(i).getResolutionX() || mode.getResolutionY() != m_supModes.get(i).getResolutionY()) continue;
                bValid = true;
                break;
            }
            return bValid;
        }

        public int open() {
            if (this.b_StreamOpened) {
                ImiLog.w((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " stream is already started");
                return ImiErrorCode.IMI_OK.toNative();
            }
            int ret = -1;
            if (this.streamType == ImiStreamType.COLOR && ImiDevice.this.bSupportUVC) {
                ImiDevice.this.tmpCameraTime = System.currentTimeMillis();
                ret = this.setFrameMode(this.frameMode);
                ImiLog.d((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " setFrameMode = " + ret + ", use " + (System.currentTimeMillis() - ImiDevice.this.tmpCameraTime));
                ImiDevice.this.tmpCameraTime = System.currentTimeMillis();
                ImiCameraFrameMode camframeMode = ImiDevice.this.FrameModeToCameraFrameMode(this.frameMode);
                ret = NativeMethods.nativeStartCameraStream(ImiDevice.this.m_cameraHandle, camframeMode.getWidth(), camframeMode.getHeight(), camframeMode.getPixelFormat().toNative(), camframeMode.getFps());
                if (ret == ImiErrorCode.IMI_OK.toNative()) {
                    ImiLog.d((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " Stream Started use " + (System.currentTimeMillis() - ImiDevice.this.tmpCameraTime));
                    this.b_StreamOpened = true;
                    if (ImiDevice.this.m_CurDeviceWrapper != null && ImiDevice.this.m_CurDeviceWrapper.getDeviceType() == ImiUsbPermissionHelper.ImiDeviceType.IMI_A200 && (((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH)).isOpened() || ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.IR)).isOpened() || ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON)).isOpened() || ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON)).isOpened() || ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.SKELETON)).isOpened() || ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).isOpened() || ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.FLOOD_IR)).isOpened())) {
                        if (((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).isOpened() && ImiDevice.this.m_DeviceAttribute.isPortraitDevice()) {
                            ImiLog.d("portrait  deivce open depth_ir stream no need set sync");
                        } else {
                            ImiDevice.this.syncFrames(true);
                        }
                    }
                } else {
                    if (ImiDevice.this.b_DeviceOpenning) {
                        ImiDevice.this.m_Status.setStatus(19, ret);
                    } else {
                        ImiDevice.this.m_Status.setStatus(50, ret);
                    }
                    ImiLog.e((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " stream start failed ret = " + ret);
                }
                this.tmp_ErrorCode = ret;
                return ret;
            }
            ImiDevice.this.tmpDeviceTime = System.currentTimeMillis();
            ret = this.setFrameMode(this.frameMode);
            ImiLog.d((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " setFrameMode = " + ret + ", use " + (System.currentTimeMillis() - ImiDevice.this.tmpDeviceTime));
            ImiDevice.this.tmpDeviceTime = System.currentTimeMillis();
            OutArg<Long> sHandle = new OutArg<Long>();
            ret = NativeMethods.checkReturnStatus(NativeMethods.imiOpenStream(ImiDevice.this.m_deviceHandle, ((ImiFrameType)((Object)ImiDevice.this.SFM.get((Object)this.streamType))).toNative(), sHandle));
            if (ret == ImiErrorCode.IMI_OK.toNative()) {
                ImiLog.d((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " Stream Started use " + (System.currentTimeMillis() - ImiDevice.this.tmpDeviceTime));
                this.streamHandle = (Long)sHandle.mData;
                if (ImiDevice.this.m_CurDeviceWrapper != null && ImiDevice.this.m_CurDeviceWrapper.getDeviceType() == ImiUsbPermissionHelper.ImiDeviceType.IMI_A200 && (this.streamType == ImiStreamType.IR || this.streamType == ImiStreamType.DEPTH || this.streamType == ImiStreamType.DEPTH_SKELETON || this.streamType == ImiStreamType.USER_INDEX_SKELETON || this.streamType == ImiStreamType.SKELETON || this.streamType == ImiStreamType.DEPTH_IR || this.streamType == ImiStreamType.FLOOD_IR) && ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).isOpened()) {
                    if (this.streamType == ImiStreamType.DEPTH_IR && ImiDevice.this.m_DeviceAttribute.isPortraitDevice()) {
                        ImiLog.d("portrait  deivce open depth_ir stream no need set sync");
                    } else {
                        ImiDevice.this.syncFrames(true);
                    }
                }
                this.b_StreamOpened = true;
            } else {
                switch (this.streamType) {
                    case COLOR: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(20, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(51, ret);
                        break;
                    }
                    case DEPTH: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(21, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(52, ret);
                        break;
                    }
                    case IR: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(22, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(53, ret);
                        break;
                    }
                    case DEPTH_SKELETON: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(25, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(56, ret);
                        break;
                    }
                    case USER_INDEX_SKELETON: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(24, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(55, ret);
                        break;
                    }
                    case SKELETON: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(26, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(57, ret);
                        break;
                    }
                    case DEPTH_IR: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(23, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(54, ret);
                        break;
                    }
                    case FLOOD_IR: {
                        if (ImiDevice.this.b_DeviceOpenning) {
                            ImiDevice.this.m_Status.setStatus(36, ret);
                            break;
                        }
                        ImiDevice.this.m_Status.setStatus(69, ret);
                    }
                }
                ImiLog.e((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " stream start failed ret = " + ret);
            }
            this.tmp_ErrorCode = ret;
            return ret;
        }

        public int close() {
            if (!this.b_StreamOpened) {
                return ImiErrorCode.IMI_OK.toNative();
            }
            int ret = -1;
            if (this.streamType == ImiStreamType.COLOR && ImiDevice.this.bSupportUVC) {
                if (ImiDevice.this.m_CurDeviceWrapper != null && ImiDevice.this.m_CurDeviceWrapper.getDeviceType() == ImiUsbPermissionHelper.ImiDeviceType.IMI_A200 && (((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH)).isOpened() || ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.IR)).isOpened() || ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_SKELETON)).isOpened() || ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.USER_INDEX_SKELETON)).isOpened() || ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.SKELETON)).isOpened() || ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).isOpened() || ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.FLOOD_IR)).isOpened())) {
                    if (((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.DEPTH_IR)).isOpened() && ImiDevice.this.m_DeviceAttribute.isPortraitDevice()) {
                        ImiLog.d("portrait  deivce close depth_ir stream no need set sync");
                    } else {
                        ImiDevice.this.syncFrames(false);
                    }
                }
                ImiDevice.this.tmpCameraTime = System.currentTimeMillis();
                ret = NativeMethods.nativeStopCameraStream(ImiDevice.this.m_cameraHandle);
                if (ret == ImiErrorCode.IMI_OK.toNative()) {
                    ImiLog.d((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " stream Stoped use " + (System.currentTimeMillis() - ImiDevice.this.tmpCameraTime));
                    this.b_StreamOpened = false;
                    this.b_GetFirstFrame = false;
                } else {
                    ImiLog.e((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " stream stop failed ret = " + ret);
                }
                return ret;
            }
            if (ImiDevice.this.m_CurDeviceWrapper != null && ImiDevice.this.m_CurDeviceWrapper.getDeviceType() == ImiUsbPermissionHelper.ImiDeviceType.IMI_A200 && (this.streamType == ImiStreamType.IR || this.streamType == ImiStreamType.DEPTH || this.streamType == ImiStreamType.DEPTH_SKELETON || this.streamType == ImiStreamType.USER_INDEX_SKELETON || this.streamType == ImiStreamType.SKELETON || this.streamType == ImiStreamType.DEPTH_IR || this.streamType == ImiStreamType.FLOOD_IR) && ((ImiStream)ImiDevice.this.m_Streams.get((Object)ImiStreamType.COLOR)).isOpened()) {
                if (this.streamType == ImiStreamType.DEPTH_IR && ImiDevice.this.m_DeviceAttribute.isPortraitDevice()) {
                    ImiLog.d("portrait  deivce close depth_ir stream no need set sync");
                } else {
                    ImiDevice.this.syncFrames(false);
                }
            }
            ImiDevice.this.tmpDeviceTime = System.currentTimeMillis();
            ret = NativeMethods.checkReturnStatus(NativeMethods.imiCloseStream(this.streamHandle));
            if (ret == ImiErrorCode.IMI_OK.toNative()) {
                ImiLog.d((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " stream Stoped use " + (System.currentTimeMillis() - ImiDevice.this.tmpDeviceTime));
                this.streamHandle = -1L;
                this.b_StreamOpened = false;
                this.b_GetFirstFrame = false;
            } else {
                ImiLog.e((String)ImiDevice.this.streamNames.get((Object)this.streamType) + " stream stop failed ret = " + ret);
            }
            return ret;
        }

        public ImiFrame readNextFrame(int timeout) {
            ImiImageFrame tmp;
            ImiFrame mframe = null;
            if (this.streamType == ImiStreamType.COLOR && ImiDevice.this.bSupportUVC) {
                ImiCameraFrame tmp2;
                OutArg<ImiCameraFrame> out = new OutArg<ImiCameraFrame>();
                if (0 == NativeMethods.nativeReadNextFrame(ImiDevice.this.m_cameraHandle, timeout, out) && (tmp2 = (ImiCameraFrame)out.mData) != null) {
                    mframe = new ImiFrame(ImiStreamType.COLOR.toNative(), this.frameMode.getFormat().toNative(), tmp2.getFrameNum(), tmp2.getFps(), tmp2.getWidth(), tmp2.getHeight(), tmp2.getSize(), tmp2.getTimeStamp(), tmp2.getData(), null, tmp2.getRotationAngle(), tmp2.getBitPerPixel(), tmp2.getPictureMode());
                    if (!this.b_GetFirstFrame) {
                        this.b_GetFirstFrame = true;
                        ImiLog.i("get first " + (String)ImiDevice.this.streamNames.get((Object)this.streamType) + "(uvc) frame");
                    }
                }
                return mframe;
            }
            OutArg<ImiImageFrame> frame = new OutArg<ImiImageFrame>();
            if (0 == NativeMethods.imiReadNextFrame(this.streamHandle, frame, timeout) && (tmp = (ImiImageFrame)frame.mData) != null) {
                mframe = new ImiFrame(((ImiStreamType)((Object)ImiDevice.this.FSM.get((Object)ImiFrameType.fromNative(tmp.getType())))).toNative(), this.frameMode.getFormat().toNative(), tmp.getFrameNum(), tmp.getFps(), tmp.getWidth(), tmp.getHeight(), tmp.getSize(), tmp.getTimeStamp(), tmp.getData(), tmp.getSkeletonData(), tmp.getRotationAngle(), tmp.getBitPerPixel(), 0);
                if (!this.b_GetFirstFrame) {
                    this.b_GetFirstFrame = true;
                    ImiLog.i("get first " + (String)ImiDevice.this.streamNames.get((Object)this.streamType) + " frame");
                }
            }
            return mframe;
        }

        public long getHandle() {
            return this.streamHandle;
        }

        public boolean isOpened() {
            return this.b_StreamOpened;
        }

        public void setMirror(boolean bMirror) {
            this.b_StreamMirror = bMirror;
        }

        public boolean isMirror() {
            return this.b_StreamMirror;
        }
    }

    public static class ImiFrame {
        private int type;
        private int frameNum;
        private int mPixelFormat;
        private int fps;
        private int width;
        private int height;
        private int size;
        private long timeStamp;
        private ByteBuffer mData;
        private ImiSkeletonData[] skeletonDatas;
        private int rotationAngle;
        private int bitPerPixel;
        private int pictureType;

        public int getType() {
            return this.type;
        }

        public int getmPixelFormat() {
            return this.mPixelFormat;
        }

        public int getFrameNum() {
            return this.frameNum;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public int getFps() {
            return this.fps;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public ByteBuffer getData() {
            return this.mData;
        }

        public void setData(ByteBuffer buffer) {
            this.mData = buffer;
        }

        public ImiSkeletonData[] getSkeletonData() {
            return this.skeletonDatas;
        }

        public int getSize() {
            return this.size;
        }

        public ImiRotationAngle getRotationAngle() {
            return ImiRotationAngle.fromNative(this.rotationAngle);
        }

        public ImiPictureType getPictureType() {
            return ImiPictureType.fromNative(this.pictureType);
        }

        public ImiBitPerPixelType getBitPerPixelType() {
            return ImiBitPerPixelType.fromNative(this.bitPerPixel);
        }

        public ImiFrame(int type, int mPixelFormat, int frameNum, int fps, int width, int height, int size, long timeStamp, ByteBuffer mData, ImiSkeletonData[] skeletonDatas, int rotationAngle, int bitPerPixel, int pictureType) {
            this.type = type;
            this.mPixelFormat = mPixelFormat;
            this.frameNum = frameNum;
            this.fps = fps;
            this.width = width;
            this.height = height;
            this.size = size;
            this.timeStamp = timeStamp;
            this.mData = mData;
            this.skeletonDatas = skeletonDatas;
            this.rotationAngle = rotationAngle;
            this.bitPerPixel = bitPerPixel;
            this.pictureType = pictureType;
        }
    }

    public static class ImiGroupFrames {
        public ImiFrame depthIrFrame = null;
        public ImiFrame colorFrame = null;
        public ImiGroupFrameType frameType = ImiGroupFrameType.NONE;
    }

    public static class ImiMultiFrames {
        public ImiFrame depthFrame = null;
        public ImiFrame irFrame = null;
        public ImiFrame colorFrame = null;
    }

    public static class ImiStatus {
        public static final int IMI_STATUS_NO_ERROR = 0;
        public static final int IMI_STATUS_open_context_is_null = 1;
        public static final int IMI_STATUS_open_streamFlags_invalid = 2;
        public static final int IMI_STATUS_open_listener_is_null = 3;
        public static final int IMI_STATUS_open_is_opening = 4;
        public static final int IMI_STATUS_open_no_device_found = 5;
        public static final int IMI_STATUS_open_not_support_streams = 6;
        public static final int IMI_STATUS_open_not_support_Color = 7;
        public static final int IMI_STATUS_open_not_support_Color_IR_together = 8;
        public static final int IMI_STATUS_open_not_support_Depth_IR_together = 9;
        public static final int IMI_STATUS_open_not_support_Depth_5_together = 10;
        public static final int IMI_STATUS_open_was_opened = 11;
        public static final int IMI_STATUS_open_Device_already_PermissionGranted = 12;
        public static final int IMI_STATUS_open_Camera_already_PermissionGranted = 13;
        public static final int IMI_STATUS_open_Device_PermissionDenied = 14;
        public static final int IMI_STATUS_open_Camera_PermissionDenied = 15;
        public static final int IMI_STATUS_open_Device_openFailed = 16;
        public static final int IMI_STATUS_open_Camera_openFailed = 17;
        public static final int IMI_STATUS_open_ImiDevice_was_destroyed = 18;
        public static final int IMI_STATUS_open_start_UVC_Stream_Failed = 19;
        public static final int IMI_STATUS_open_start_Color_Stream_Failed = 20;
        public static final int IMI_STATUS_open_start_Depth_Stream_Failed = 21;
        public static final int IMI_STATUS_open_start_IR_Stream_Failed = 22;
        public static final int IMI_STATUS_open_start_Depth_IR_Stream_Failed = 23;
        public static final int IMI_STATUS_open_start_UserIndex_Stream_Failed = 24;
        public static final int IMI_STATUS_open_start_DepthSK_Stream_Failed = 25;
        public static final int IMI_STATUS_open_start_Skeleton_Stream_Failed = 26;
        public static final int IMI_STATUS_open_SyncFrames_Failed = 27;
        public static final int IMI_STATUS_open_setFrameMode_UVC_Failed = 28;
        public static final int IMI_STATUS_open_setFrameMode_Color_Failed = 29;
        public static final int IMI_STATUS_open_setFrameMode_Depth_Failed = 30;
        public static final int IMI_STATUS_open_setFrameMode_IR_Failed = 31;
        public static final int IMI_STATUS_open_setFrameMode_Depth_IR_Failed = 32;
        public static final int IMI_STATUS_open_setFrameMode_UserIndex_Failed = 33;
        public static final int IMI_STATUS_open_setFrameMode_DepthSK_Failed = 34;
        public static final int IMI_STATUS_open_setFrameMode_Skeleton_Failed = 35;
        public static final int IMI_STATUS_open_start_FLOOD_IR_Stream_Failed = 36;
        public static final int IMI_STATUS_open_setFrameMode_FLOOD_IR_Failed = 37;
        public static final int IMI_STATUS_startStream_device_not_opened = 44;
        public static final int IMI_STATUS_startStream_streamFlags_invalid = 45;
        public static final int IMI_STATUS_startStream_not_support_streams = 46;
        public static final int IMI_STATUS_startStream_not_support_Color_IR_together = 47;
        public static final int IMI_STATUS_startStream_not_support_Depth_IR_together = 48;
        public static final int IMI_STATUS_startStream_not_support_Depth_5_together = 49;
        public static final int IMI_STATUS_startStream_UVC_Failed = 50;
        public static final int IMI_STATUS_startStream_Color_Failed = 51;
        public static final int IMI_STATUS_startStream_Depth_Failed = 52;
        public static final int IMI_STATUS_startStream_IR_Failed = 53;
        public static final int IMI_STATUS_startStream_Depth_IR_Failed = 54;
        public static final int IMI_STATUS_startStream_UserIndex_Failed = 55;
        public static final int IMI_STATUS_startStream_DepthSK_Failed = 56;
        public static final int IMI_STATUS_startStream_Skeleton_Failed = 57;
        public static final int IMI_STATUS_startStream_SyncFrames_Failed = 58;
        public static final int IMI_STATUS_startStream_setFrameMode_UVC_Failed = 59;
        public static final int IMI_STATUS_startStream_setFrameMode_Color_Failed = 60;
        public static final int IMI_STATUS_startStream_setFrameMode_Depth_Failed = 61;
        public static final int IMI_STATUS_startStream_setFrameMode_IR_Failed = 62;
        public static final int IMI_STATUS_startStream_setFrameMode_Depth_IR_Failed = 63;
        public static final int IMI_STATUS_startStream_setFrameMode_UserIndex_Failed = 64;
        public static final int IMI_STATUS_startStream_setFrameMode_DepthSK_Failed = 65;
        public static final int IMI_STATUS_startStream_setFrameMode_Skeleton_Failed = 66;
        public static final int IMI_STATUS_startStream_setFrameMode_mode_invalid = 67;
        public static final int IMI_STATUS_startStream_setFrameMode_stream_is_running = 68;
        public static final int IMI_STATUS_startStream_FLOOD_IR_Failed = 69;
        public static final int IMI_STATUS_startStream_setFrameMode_FLOOD_IR_Failed = 70;
        private int status = 0;
        private String statusInfo = "no error";
        private int errCode = 0;
        private static HashMap<Integer, String> statusMap = new HashMap();

        public ImiStatus() {
            statusMap.put(0, "no error");
            statusMap.put(1, "[open] parameter context is null");
            statusMap.put(2, "[open] parameter streamFlags invalid");
            statusMap.put(3, "[open] parameter listener is null");
            statusMap.put(4, "[open] Device is opening");
            statusMap.put(5, "[open] no device found");
            statusMap.put(6, "[open] not support streams");
            statusMap.put(7, "[open] not support Color");
            statusMap.put(8, "[open] not support Color+IR together");
            statusMap.put(9, "[open] not support Depth+IR together");
            statusMap.put(10, "[open] not support Depth/DepthSK/UIndex/Skeleton/Depth_IR together");
            statusMap.put(11, "[open] Device was opened");
            statusMap.put(12, "[open] Device already PermissionGranted");
            statusMap.put(13, "[open] Camera already PermissionGranted");
            statusMap.put(14, "[open] Device PermissionDenied");
            statusMap.put(15, "[open] Camera PermissionDenied");
            statusMap.put(16, "[open] Device openFailed");
            statusMap.put(17, "[open] Camera openFailed");
            statusMap.put(18, "[open] ImiDevice was destroyed");
            statusMap.put(19, "[open] start UVC Stream Failed");
            statusMap.put(20, "[open] start Color Stream Failed");
            statusMap.put(21, "[open] start Depth Stream Failed");
            statusMap.put(22, "[open] start IR Stream Failed");
            statusMap.put(23, "[open] start Depth_IR Stream Failed");
            statusMap.put(24, "[open] start UserIndex Stream Failed");
            statusMap.put(25, "[open] start DepthSK Stream Failed");
            statusMap.put(26, "[open] start Skeleton Stream Failed");
            statusMap.put(27, "[open] SyncFrames Failed");
            statusMap.put(28, "[open] setFrameMode UVC Failed");
            statusMap.put(29, "[open] setFrameMode Color Failed");
            statusMap.put(30, "[open] setFrameMode Depth Failed");
            statusMap.put(31, "[open] setFrameMode IR Failed");
            statusMap.put(32, "[open] setFrameMode Depth_IR Failed");
            statusMap.put(33, "[open] setFrameMode UserIndex Failed");
            statusMap.put(34, "[open] setFrameMode DepthSK Failed");
            statusMap.put(35, "[open] setFrameMode Skeleton Failed");
            statusMap.put(44, "[startStream] device not opened");
            statusMap.put(45, "[startStream] streamFlags invalid");
            statusMap.put(46, "[startStream] not support streams");
            statusMap.put(47, "[startStream] not support Color+IR together");
            statusMap.put(48, "[startStream] not support Depth+IR together");
            statusMap.put(49, "[startStream] not support Depth/DepthSK/UIndex/Skeleton/Depth_IR together");
            statusMap.put(50, "[startStream] start UVC Failed");
            statusMap.put(51, "[startStream] start Color Failed");
            statusMap.put(52, "[startStream] start Depth Failed");
            statusMap.put(53, "[startStream] start IR Failed");
            statusMap.put(54, "[startStream] start Depth_IR Failed");
            statusMap.put(55, "[startStream] start UserIndex Failed");
            statusMap.put(56, "[startStream] start DepthSK Failed");
            statusMap.put(57, "[startStream] start Skeleton Failed");
            statusMap.put(58, "[startStream] SyncFrames Failed");
            statusMap.put(59, "[startStream] setFrameMode UVC Failed");
            statusMap.put(60, "[startStream] setFrameMode Color Failed");
            statusMap.put(61, "[startStream] setFrameMode Depth Failed");
            statusMap.put(62, "[startStream] setFrameMode IR Failed");
            statusMap.put(63, "[startStream] setFrameMode Depth_IR Failed");
            statusMap.put(64, "[startStream] setFrameMode UserIndex Failed");
            statusMap.put(65, "[startStream] setFrameMode DepthSK Failed");
            statusMap.put(66, "[startStream] setFrameMode Skeleton Failed");
            statusMap.put(67, "[startStream] setFrameMode mode invalid");
            statusMap.put(68, "[startStream] setFrameMode stream is running, please stop first");
        }

        public void setStatus(int status, int errCode) {
            this.status = status;
            this.errCode = errCode;
        }

        public int getStatus() {
            return this.status;
        }

        public String getStatusInfo() {
            this.statusInfo = statusMap.get(this.status);
            return this.statusInfo;
        }

        public int getErrCode() {
            return this.errCode;
        }
    }

    public static class ImiIRRect {
        public int x;
        public int y;
        public int width;
        public int height;
    }

    public static enum ImiStreamType {
        COLOR(1),
        DEPTH(2),
        IR(4),
        DEPTH_SKELETON(8),
        USER_INDEX_SKELETON(16),
        SKELETON(32),
        DEPTH_IR(64),
        FLOOD_IR(128);

        private final int mValue;

        public int toNative() {
            return this.mValue;
        }

        public static ImiStreamType fromNative(int value) {
            for (ImiStreamType type : ImiStreamType.values()) {
                if (type.mValue != value) continue;
                return type;
            }
            throw new NoSuchElementException();
        }

        private ImiStreamType(int value) {
            this.mValue = value;
        }
    }

    public static enum ImiGroupFrameType {
        NONE,
        DEPTH_COLOR,
        IR_COLOR,
        COLOR,
        IR,
        DEPTH;

    }
}

