/*
 * Decompiled with CFR 0.152.
 */
package com.hjimi.api.iminect;

public class ImiDeviceAttribute {
    private static final String[] DEVICE_BASE_TYPES = new String[]{"A100", "A200"};
    private static final String HJIMI = "Hjimi";
    private static final String BLANK = " ";
    private int vendorId;
    private short productId;
    private int deviceAddress;
    private String serialNumber;
    private String uri;
    private String deviceDescribeName;

    ImiDeviceAttribute(int vendorId, short productId, int deviceAddress, String serialNumber, String uri) {
        this.vendorId = vendorId;
        this.productId = productId;
        this.deviceAddress = deviceAddress;
        this.serialNumber = serialNumber;
        this.uri = uri;
        this.deviceDescribeName = this.getNameFromSerialNumber(this.serialNumber);
    }

    private String getNameFromSerialNumber(String serialNumber) {
        String deviceBaseType = this.getBaseTypeFromSerialNumber(serialNumber);
        if (deviceBaseType != null) {
            char subtype;
            StringBuffer sb = new StringBuffer(HJIMI).append(BLANK).append(deviceBaseType);
            String[] splits = serialNumber.split(deviceBaseType);
            int subTypeIndex = 0;
            if ((subtype = splits[1].charAt(subTypeIndex++)) == 'S' || subtype == 'M' || subtype == 'C') {
                sb.append(subtype);
            }
            if ((subtype = splits[1].charAt(subTypeIndex++)) == 'P') {
                sb.append(BLANK).append("Pro");
            }
            if ((subtype = splits[1].charAt(subTypeIndex)) == 'M') {
                sb.append(BLANK).append("Mini");
            }
            return sb.toString();
        }
        return null;
    }

    private String getBaseTypeFromSerialNumber(String serialNumber) {
        String bsType = null;
        for (int i = 0; i < DEVICE_BASE_TYPES.length; ++i) {
            if (!serialNumber.contains(DEVICE_BASE_TYPES[i])) continue;
            bsType = DEVICE_BASE_TYPES[i];
            break;
        }
        return bsType;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public short getProductId() {
        return this.productId;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getUri() {
        return this.uri;
    }

    public int getDeviceAddress() {
        return this.deviceAddress;
    }

    public String getDeviceDescribeName() {
        return this.deviceDescribeName;
    }

    public boolean isPortraitDevice() {
        return this.productId == 771 && this.vendorId == 11707 || this.productId == 772 && this.vendorId == 11707 || this.productId == 773 && this.vendorId == 11707 || this.productId == 775 && this.vendorId == 11707 || this.productId == 776 && this.vendorId == 11707 || this.productId == 777 && this.vendorId == 11707 || this.productId == 816 && this.vendorId == 11707;
    }
}

