/*
 * Decompiled with CFR 0.152.
 */
package com.hjimi.api.iminect;

import android.annotation.TargetApi;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Log;
import java.util.LinkedList;
import java.util.Queue;

public class ImiDeviceDispatchThread
extends Thread {
    private static final String TAG = "ImiDeviceDispatchThread";
    private static final long MAX_MESSAGE_QUEUE_LENGTH = 256L;
    private final Queue<Runnable> mJobQueue = new LinkedList<Runnable>();
    private Boolean mIsEnded = new Boolean(false);
    private Handler mDeviceHandler;
    private HandlerThread mCameraHandlerThread;

    public ImiDeviceDispatchThread(Handler deviceHandler, HandlerThread cameraHandlerThread) {
        super("ImiDevice Job Dispatch Thread");
        this.mDeviceHandler = deviceHandler;
        this.mCameraHandlerThread = cameraHandlerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob(Runnable job) {
        if (this.isEnded()) {
            throw new IllegalStateException("Trying to run job on interrupted dispatcher thread");
        }
        Queue<Runnable> queue = this.mJobQueue;
        synchronized (queue) {
            if ((long)this.mJobQueue.size() == 256L) {
                throw new RuntimeException("Camera master thread job queue full");
            }
            this.mJobQueue.add(job);
            this.mJobQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJobSync(Runnable job, Object waitLock, long timeoutMs, String jobMsg) {
        String timeoutMsg = "Timeout waiting " + timeoutMs + "ms for " + jobMsg;
        Object object = waitLock;
        synchronized (object) {
            block6: {
                long timeoutBound = SystemClock.uptimeMillis() + timeoutMs;
                try {
                    this.runJob(job);
                    waitLock.wait(timeoutMs);
                    if (SystemClock.uptimeMillis() > timeoutBound) {
                        throw new IllegalStateException(timeoutMsg);
                    }
                }
                catch (InterruptedException ex) {
                    if (SystemClock.uptimeMillis() <= timeoutBound) break block6;
                    throw new IllegalStateException(timeoutMsg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        Object object = this.mIsEnded;
        synchronized (object) {
            this.mIsEnded = true;
        }
        object = this.mJobQueue;
        synchronized (object) {
            this.mJobQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnded() {
        Boolean bl = this.mIsEnded;
        synchronized (bl) {
            return this.mIsEnded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=18)
    public void run() {
        while (true) {
            Runnable job = null;
            Object object = this.mJobQueue;
            synchronized (object) {
                while (this.mJobQueue.size() == 0 && !this.isEnded()) {
                    try {
                        this.mJobQueue.wait();
                    }
                    catch (InterruptedException ex) {
                        Log.w((String)TAG, (String)"Dispatcher thread wait() interrupted, exiting");
                        break;
                    }
                }
                job = this.mJobQueue.poll();
            }
            if (job == null) {
                if (!this.isEnded()) continue;
                break;
            }
            job.run();
            object = this;
            synchronized (object) {
                this.mDeviceHandler.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ImiDeviceDispatchThread imiDeviceDispatchThread = ImiDeviceDispatchThread.this;
                        synchronized (imiDeviceDispatchThread) {
                            ImiDeviceDispatchThread.this.notifyAll();
                        }
                    }
                });
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.mCameraHandlerThread.quitSafely();
    }
}

