/*
 * Decompiled with CFR 0.152.
 */
package com.hjimi.api.iminect;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.hjimi.api.iminect.ImiDevice;
import com.hjimi.api.iminect.ImiDeviceState;
import com.hjimi.api.iminect.ImiErrorCode;
import com.hjimi.api.iminect.ImiFrameMode;
import com.hjimi.api.iminect.ImiLog;
import com.hjimi.api.iminect.ImiNect;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImiDeviceSelfTest
implements ImiDevice.OpenDeviceListener,
ImiDevice.DeviceStateListener {
    private static final int IMI_DEVICE_VID_0x2DBB = 11707;
    private static final int IMI_DEVICE_PID_0x0004 = 4;
    private static final int IMI_DEVICE_PID_0x0300 = 768;
    private static final int IMI_DEVICE_PID_0x0303 = 771;
    private static final int IMI_DEVICE_TYPE_DEPTH = 1;
    private static final int TEST_START = 0;
    private static final int TEST_ABORT = 1;
    private static final int TEST_COMPLETE = 2;
    private static final int OPEN_DEVICE_SUCCEED = 3;
    private static final int OPEN_DEVICE_FALIED = 4;
    private static final int START_STREAM_TEST = 5;
    private static final int STOP_TEST = 6;
    private static final int DISCONNECT = 7;
    private static final int TIME_UP = 8;
    private final String SelfTestTAG = "selfTest";
    private static ImiDeviceSelfTest mInstance = null;
    private ImiDeviceTestData mTestData = null;
    private boolean bStarted = false;
    private boolean bStarting = false;
    private boolean bClosing = false;
    private HandlerThread handlerThread = new HandlerThread("handlerThread");
    private ImiDeviceSelfTestCallback mCallback = null;
    private CalculateFps calculateFpsColor = null;
    private CalculateFps calculateFpsDepthIr = null;
    private int needTestStreamFlag = 0;
    private int testStreamFlagComplete = 0;
    private MainMsgHandler mainHandler = null;
    private long mOpenDeviceStartTime = 0L;
    private long startColorStreamTime = 0L;
    private long startDepthStreamTime = 0L;
    private long startIrStreamTime = 0L;
    private long mUpTime = 0L;

    @Override
    public void onOpenDeviceSuccess() {
        if (!this.mTestData.bDisconnectedDuringTest) {
            this.mainHandler.sendEmptyMessage(3);
        }
    }

    @Override
    public void onOpenDeviceFailed(String errorMsg) {
        if (!this.mTestData.bDisconnectedDuringTest) {
            this.mainHandler.sendMessage(this.mainHandler.obtainMessage(4, errorMsg));
        }
    }

    @Override
    public void onDeviceStateChanged(String deviceInfo, ImiDeviceState state) {
        if (state == ImiDeviceState.IMI_DEVICE_STATE_DISCONNECT && !this.mTestData.bDisconnectedDuringTest) {
            this.mTestData.bDisconnectedDuringTest = true;
            this.mainHandler.sendEmptyMessage(7);
        }
    }

    public static ImiDeviceSelfTest getInstance() {
        if (mInstance == null) {
            mInstance = new ImiDeviceSelfTest();
        }
        return mInstance;
    }

    public static void destroy() {
        if (mInstance != null) {
            mInstance.exit();
        }
        mInstance = null;
    }

    private ImiDeviceSelfTest() {
        this.handlerThread.setPriority(10);
        this.handlerThread.start();
        this.mainHandler = new MainMsgHandler(this.handlerThread.getLooper(), new WeakReference<ImiDeviceSelfTest>(this));
    }

    public int startSelfTest(long time, ImiDeviceSelfTestCallback callback) {
        if (time < 3L) {
            ImiLog.d("selfTest", "time can not be less than 3");
            return ImiErrorCode.IMI_INVALID_PARAM.toNative();
        }
        if (callback == null) {
            ImiLog.d("selfTest", "callback can not be null");
            return ImiErrorCode.IMI_INVALID_PARAM.toNative();
        }
        if (this.bClosing) {
            ImiLog.d("selfTest", "self test is closing!");
            return ImiErrorCode.IMI_INVALID_OPERATION.toNative();
        }
        if (this.bStarting) {
            ImiLog.d("selfTest", "self test is starting!");
            return ImiErrorCode.IMI_INVALID_OPERATION.toNative();
        }
        if (this.bStarted) {
            ImiLog.d("selfTest", "self test is started!");
            return ImiErrorCode.IMI_INVALID_OPERATION.toNative();
        }
        this.bStarting = true;
        this.mCallback = callback;
        this.mUpTime = time;
        this.mTestData = new ImiDeviceTestData();
        UsbManager manager = (UsbManager)ImiDeviceSelfTest.getApplicationByReflection().getSystemService("usb");
        this.mTestData.deviceList = manager.getDeviceList();
        if (ImiNect.isInitialized()) {
            ImiDevice imiDevice = ImiDevice.getInstance();
            assert (imiDevice != null);
            imiDevice.close();
            ImiDevice.destroy();
            ImiNect.destroy();
        }
        this.mainHandler.sendEmptyMessage(0);
        int ret = ImiNect.initialize();
        if (ret == 0) {
            ImiDevice imiDevice = ImiDevice.getInstance();
            assert (imiDevice != null);
            this.mOpenDeviceStartTime = System.currentTimeMillis();
            imiDevice.open((Context)ImiDeviceSelfTest.getApplicationByReflection(), 0, (ImiDevice.OpenDeviceListener)this);
            imiDevice.addDeviceStateListener(this);
        }
        return ret;
    }

    public void stopSelfTest() {
        if (this.bClosing) {
            ImiLog.d("selfTest", "self test is closing!");
            return;
        }
        if (this.bStarting) {
            ImiLog.d("selfTest", "self test is starting wait for a while!");
        }
        while (this.bStarting) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.bClosing = true;
        this.mainHandler.sendEmptyMessage(6);
    }

    private void stopTest() {
        if (this.mainHandler != null && this.mainHandler.hasMessages(8)) {
            this.mainHandler.removeMessages(8);
        }
        if (null != this.calculateFpsColor) {
            this.calculateFpsColor.onStop();
            this.calculateFpsColor = null;
        }
        if (null != this.calculateFpsDepthIr) {
            this.calculateFpsDepthIr.onStop();
            this.calculateFpsDepthIr = null;
        }
        this.needTestStreamFlag = 0;
        this.testStreamFlagComplete = 0;
        if (ImiNect.isInitialized()) {
            ImiDevice imiDevice = ImiDevice.getInstance();
            imiDevice.close();
            ImiDevice.destroy();
            ImiNect.destroy();
        }
        this.bStarted = false;
        this.bClosing = false;
        this.mainHandler.sendEmptyMessage(1);
    }

    private void exit() {
        if (this.bStarting) {
            ImiLog.d("selfTest", "self test is starting wait for a while!");
        }
        while (this.bStarting) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.bStarted = false;
        if (this.mainHandler != null && this.mainHandler.hasMessages(8)) {
            this.mainHandler.removeMessages(8);
            this.mainHandler = null;
        }
        if (this.handlerThread != null && this.handlerThread.isAlive()) {
            this.handlerThread.quit();
            this.handlerThread = null;
        }
        if (null != this.calculateFpsColor) {
            this.calculateFpsColor.onStop();
            this.calculateFpsColor = null;
        }
        if (null != this.calculateFpsDepthIr) {
            this.calculateFpsDepthIr.onStop();
            this.calculateFpsDepthIr = null;
        }
        this.mTestData = null;
        this.mCallback = null;
        this.needTestStreamFlag = 0;
        this.testStreamFlagComplete = 0;
        if (ImiNect.isInitialized()) {
            ImiDevice imiDevice = ImiDevice.getInstance();
            imiDevice.close();
            ImiDevice.destroy();
            ImiNect.destroy();
        }
    }

    private void onSelfTest(int msg) {
        if (this.mCallback != null) {
            switch (msg) {
                case 0: {
                    this.mCallback.onSelfTestStart();
                    break;
                }
                case 2: {
                    if (ImiNect.isInitialized()) {
                        ImiDevice imiDevice = ImiDevice.getInstance();
                        imiDevice.close();
                        ImiDevice.destroy();
                        ImiNect.destroy();
                    }
                    this.bStarted = false;
                    this.needTestStreamFlag = 0;
                    this.testStreamFlagComplete = 0;
                    this.mCallback.onSelfTestComplete(this.mTestData);
                    break;
                }
                case 1: {
                    this.mCallback.onSelfTestAbort();
                    break;
                }
            }
        }
    }

    public boolean started() {
        return this.bStarted;
    }

    private void openDevicefailed(String err) {
        if (this.bStarting) {
            this.bStarting = false;
            this.mTestData.openDeviceErrorCode = this.getErrorCode(err);
            this.mainHandler.sendEmptyMessage(2);
        }
    }

    private void startStreamTest(ImiDevice.ImiStreamType streamFlag, long millisTimes) {
        ImiDevice imiDevice = ImiDevice.getInstance();
        ImiFrameMode frameMode = imiDevice.getCurrentFrameMode(streamFlag);
        imiDevice.setFrameMode(streamFlag, frameMode);
        if (streamFlag == ImiDevice.ImiStreamType.COLOR) {
            this.startColorStreamTime = System.currentTimeMillis();
            int ret = imiDevice.startStream(streamFlag.toNative());
            this.mTestData.bStartColorStreamSucceed = ret == 0;
            this.mTestData.startColorStreamCostTime = System.currentTimeMillis() - this.startColorStreamTime;
            this.mTestData.startColorStreamErrorCode = ret;
            if (ret == 0) {
                this.calculateFpsColor = new CalculateFps(imiDevice, ImiDevice.ImiStreamType.COLOR, millisTimes);
                this.calculateFpsColor.onStart();
            } else {
                this.mainHandler.sendMessage(this.mainHandler.obtainMessage(8, (Object)streamFlag));
            }
        } else if (streamFlag == ImiDevice.ImiStreamType.DEPTH) {
            this.startDepthStreamTime = System.currentTimeMillis();
            int ret = imiDevice.startStream(streamFlag.toNative());
            this.mTestData.bStartDepthStreamSucceed = ret == 0;
            this.mTestData.startDepthStreamCostTime = System.currentTimeMillis() - this.startDepthStreamTime;
            this.mTestData.startDepthStreamErrorCode = ret;
            if (ret == 0) {
                this.calculateFpsDepthIr = new CalculateFps(imiDevice, ImiDevice.ImiStreamType.DEPTH, millisTimes);
                this.calculateFpsDepthIr.onStart();
            } else {
                this.mainHandler.sendMessage(this.mainHandler.obtainMessage(8, (Object)streamFlag));
            }
        } else if (streamFlag == ImiDevice.ImiStreamType.IR) {
            this.startIrStreamTime = System.currentTimeMillis();
            int ret = imiDevice.startStream(streamFlag.toNative());
            this.mTestData.bStartIrStreamSucceed = ret == 0;
            this.mTestData.startIrStreamCostTime = System.currentTimeMillis() - this.startIrStreamTime;
            this.mTestData.startIrStreamErrorCode = ret;
            if (ret == 0) {
                this.calculateFpsDepthIr = new CalculateFps(imiDevice, ImiDevice.ImiStreamType.IR, millisTimes);
                this.calculateFpsDepthIr.onStart();
            } else {
                this.mainHandler.sendMessage(this.mainHandler.obtainMessage(8, (Object)streamFlag));
            }
        } else if (streamFlag == ImiDevice.ImiStreamType.DEPTH_IR) {
            this.startIrStreamTime = this.startDepthStreamTime = System.currentTimeMillis();
            int ret = imiDevice.startStream(streamFlag.toNative());
            this.mTestData.bStartDepthStreamSucceed = ret == 0;
            this.mTestData.bStartIrStreamSucceed = this.mTestData.bStartDepthStreamSucceed;
            this.mTestData.startIrStreamCostTime = this.mTestData.startDepthStreamCostTime = System.currentTimeMillis() - this.startIrStreamTime;
            this.mTestData.startIrStreamErrorCode = this.mTestData.startDepthStreamErrorCode = ret;
            if (ret == 0) {
                this.calculateFpsDepthIr = new CalculateFps(imiDevice, ImiDevice.ImiStreamType.DEPTH_IR, millisTimes);
                this.calculateFpsDepthIr.onStart();
            } else {
                this.mainHandler.sendMessage(this.mainHandler.obtainMessage(8, (Object)streamFlag));
            }
        }
    }

    private void disconnect() {
        if (this.bStarted || this.bStarting) {
            if (this.mainHandler != null && this.mainHandler.hasMessages(8)) {
                this.mainHandler.removeMessages(8);
            }
            if (null != this.calculateFpsColor) {
                this.calculateFpsColor.onStop();
            }
            if (null != this.calculateFpsDepthIr) {
                this.calculateFpsDepthIr.onStop();
            }
            this.needTestStreamFlag = 0;
            this.testStreamFlagComplete = 0;
            this.bStarting = false;
            this.bStarted = false;
            this.mainHandler.sendEmptyMessage(2);
        }
    }

    private void startTest() {
        this.mTestData.openDeviceCostTime = System.currentTimeMillis() - this.mOpenDeviceStartTime;
        this.mTestData.bOpenSucceed = true;
        this.mTestData.openDeviceErrorCode = 0;
        ImiDevice imiDevice = ImiDevice.getInstance();
        this.needTestStreamFlag |= ImiDevice.ImiStreamType.COLOR.toNative();
        this.startStreamTest(ImiDevice.ImiStreamType.COLOR, this.mUpTime * 1000L);
        int deviceType = this.getDeviceType(this.mTestData.deviceList, imiDevice);
        if (deviceType == 0) {
            this.needTestStreamFlag |= ImiDevice.ImiStreamType.DEPTH_IR.toNative();
            this.startStreamTest(ImiDevice.ImiStreamType.DEPTH_IR, this.mUpTime * 1000L);
        } else if (deviceType == 1) {
            this.mTestData.startIrStreamErrorCode = 999;
            this.mTestData.firstIrFrameTime = 999L;
            this.mTestData.irFps = 999L;
            this.needTestStreamFlag |= ImiDevice.ImiStreamType.DEPTH.toNative();
            this.startStreamTest(ImiDevice.ImiStreamType.DEPTH, this.mUpTime * 1000L);
        }
        this.bStarting = false;
        this.bStarted = true;
    }

    private void upToTime(ImiDevice.ImiStreamType streamFlag) {
        if (streamFlag == ImiDevice.ImiStreamType.COLOR) {
            if (this.calculateFpsColor != null) {
                this.mTestData.colorFps = this.calculateFpsColor.getFps();
                this.calculateFpsColor.onStop();
            }
        } else if (streamFlag == ImiDevice.ImiStreamType.DEPTH) {
            if (this.calculateFpsDepthIr != null) {
                this.mTestData.depthFps = this.calculateFpsDepthIr.getFps();
                this.calculateFpsDepthIr.onStop();
            }
        } else if (streamFlag == ImiDevice.ImiStreamType.IR) {
            if (this.calculateFpsDepthIr != null) {
                this.mTestData.irFps = this.calculateFpsDepthIr.getFps();
                this.calculateFpsDepthIr.onStop();
            }
        } else if (streamFlag == ImiDevice.ImiStreamType.DEPTH_IR && this.calculateFpsDepthIr != null) {
            this.mTestData.depthFps = this.mTestData.irFps = (long)this.calculateFpsDepthIr.getFps();
            this.calculateFpsDepthIr.onStop();
        }
        Objects.requireNonNull(ImiDevice.getInstance()).stopStream(streamFlag.toNative());
        this.testStreamFlagComplete |= streamFlag.toNative();
        if (this.testStreamFlagComplete == this.needTestStreamFlag) {
            this.mainHandler.removeMessages(8);
            if (this.bStarted) {
                this.mainHandler.sendEmptyMessage(2);
            }
        }
    }

    @SuppressLint(value={"PrivateApi"})
    private static Application getApplicationByReflection() {
        try {
            return (Application)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int getErrorCode(String errorString) {
        int ret = -1;
        if (errorString != null) {
            String regEx = "[^0-9]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(errorString);
            ret = -Integer.parseInt(m.replaceAll("").trim());
        }
        return ret;
    }

    private int getDeviceType(HashMap<String, UsbDevice> deviceList, ImiDevice imiDevice) {
        int deviceFlag = 0;
        for (UsbDevice device : deviceList.values()) {
            int vendorId = device.getVendorId();
            int productId = device.getProductId();
            if (vendorId == 11707 && productId == 4) {
                deviceFlag = 1;
                continue;
            }
            if (vendorId == 11707 && productId == 768) {
                if (imiDevice.getAttribute().getSerialNumber().contains("A200CPLV3")) {
                    deviceFlag = 0;
                    continue;
                }
                deviceFlag = 1;
                continue;
            }
            if (vendorId != 11707 || productId != 771) continue;
            deviceFlag = 1;
        }
        return deviceFlag;
    }

    public class CalculateFps
    extends Thread {
        private boolean mShouldRun = false;
        private final ImiDevice.ImiStreamType mStreamType;
        private final ImiDevice mDevice;
        private final long mCalcuTime;
        long startTime = 0L;
        long endTime = 0L;
        private int mCount = 0;

        public CalculateFps(ImiDevice device, ImiDevice.ImiStreamType streamType, long calcuTime) {
            this.mDevice = device;
            this.mStreamType = streamType;
            this.mCalcuTime = calcuTime;
        }

        public int getFps() {
            float fps = 0.0f;
            this.endTime = System.currentTimeMillis();
            float denominator = (float)((double)(this.endTime - this.startTime) / 1000.0);
            if (denominator > 0.0f) {
                fps = (float)this.mCount / denominator;
            }
            return Math.round(fps);
        }

        public boolean isRun() {
            return this.mShouldRun;
        }

        public void onStart() {
            if (!this.mShouldRun) {
                this.mShouldRun = true;
                this.start();
            }
        }

        public void onStop() {
            if (this.mShouldRun) {
                this.mShouldRun = false;
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void run() {
            super.run();
            while (this.mShouldRun) {
                ImiDevice.ImiFrame nextFrame = this.mDevice.readNextFrame(this.mStreamType, 25);
                if (nextFrame != null) {
                    ++this.mCount;
                } else {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (this.mCount != 1) continue;
                this.startTime = System.currentTimeMillis();
                ImiDeviceSelfTest.this.mainHandler.sendMessageDelayed(ImiDeviceSelfTest.this.mainHandler.obtainMessage(8, (Object)this.mStreamType), this.mCalcuTime);
                if (this.mStreamType == ImiDevice.ImiStreamType.COLOR) {
                    ((ImiDeviceSelfTest)ImiDeviceSelfTest.this).mTestData.firstColorFrameTime = System.currentTimeMillis() - ImiDeviceSelfTest.this.startColorStreamTime;
                    continue;
                }
                if (this.mStreamType == ImiDevice.ImiStreamType.DEPTH_IR) {
                    ((ImiDeviceSelfTest)ImiDeviceSelfTest.this).mTestData.firstDepthFrameTime = ((ImiDeviceSelfTest)ImiDeviceSelfTest.this).mTestData.firstIrFrameTime = System.currentTimeMillis() - ImiDeviceSelfTest.this.startDepthStreamTime;
                    continue;
                }
                if (this.mStreamType == ImiDevice.ImiStreamType.DEPTH) {
                    ((ImiDeviceSelfTest)ImiDeviceSelfTest.this).mTestData.firstDepthFrameTime = System.currentTimeMillis() - ImiDeviceSelfTest.this.startDepthStreamTime;
                    continue;
                }
                if (this.mStreamType != ImiDevice.ImiStreamType.IR) continue;
                ((ImiDeviceSelfTest)ImiDeviceSelfTest.this).mTestData.firstIrFrameTime = System.currentTimeMillis() - ImiDeviceSelfTest.this.startIrStreamTime;
            }
        }
    }

    public static class ImiDeviceTestData {
        public boolean bDisconnectedDuringTest = false;
        public boolean bOpenSucceed = false;
        public long openDeviceCostTime = -1L;
        public int openDeviceErrorCode = -1;
        public boolean bStartColorStreamSucceed = false;
        public long startColorStreamCostTime = -1L;
        public int startColorStreamErrorCode = -1;
        public boolean bStartIrStreamSucceed = false;
        public long startIrStreamCostTime = -1L;
        public int startIrStreamErrorCode = -1;
        public boolean bStartDepthStreamSucceed = false;
        public long startDepthStreamCostTime = -1L;
        public int startDepthStreamErrorCode = -1;
        public long firstColorFrameTime = -1L;
        public long firstDepthFrameTime = -1L;
        public long firstIrFrameTime = -1L;
        public long colorFps = 0L;
        public long depthFps = 0L;
        public long irFps = 0L;
        public HashMap<String, UsbDevice> deviceList = null;
    }

    class MainMsgHandler
    extends Handler {
        private final ImiDeviceSelfTest imiDeviceSelfTest;

        public MainMsgHandler(Looper looper, WeakReference<ImiDeviceSelfTest> mainActivityWeakReference) {
            super(looper);
            this.imiDeviceSelfTest = (ImiDeviceSelfTest)mainActivityWeakReference.get();
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (this.imiDeviceSelfTest != null) {
                switch (msg.what) {
                    case 3: {
                        this.imiDeviceSelfTest.startTest();
                        break;
                    }
                    case 4: {
                        this.imiDeviceSelfTest.openDevicefailed((String)msg.obj);
                        break;
                    }
                    case 5: {
                        this.imiDeviceSelfTest.startStreamTest((ImiDevice.ImiStreamType)((Object)msg.obj), ImiDeviceSelfTest.this.mUpTime * 1000L / 2L);
                        break;
                    }
                    case 7: {
                        this.imiDeviceSelfTest.disconnect();
                        break;
                    }
                    case 8: {
                        this.imiDeviceSelfTest.upToTime((ImiDevice.ImiStreamType)((Object)msg.obj));
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        this.imiDeviceSelfTest.onSelfTest(msg.what);
                        break;
                    }
                    case 6: {
                        this.imiDeviceSelfTest.stopTest();
                        break;
                    }
                }
            }
        }
    }

    public static interface ImiDeviceSelfTestCallback {
        public void onSelfTestStart();

        public void onSelfTestComplete(ImiDeviceTestData var1);

        public void onSelfTestAbort();
    }
}

