/*
 * Decompiled with CFR 0.152.
 */
package com.hjimi.api.iminect;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.util.LinkedList;

public class ImiHistoryHandler
extends Handler {
    private static final int MAX_HISTORY_SIZE = 400;
    final LinkedList<Integer> mMsgHistory = new LinkedList();

    ImiHistoryHandler(Looper looper) {
        super(looper);
        this.mMsgHistory.offerLast(-1);
    }

    Integer getCurrentMessage() {
        return this.mMsgHistory.peekLast();
    }

    String generateHistoryString(int cameraId) {
        String info = new String("HIST");
        info = info + "_ID" + cameraId;
        for (Integer msg : this.mMsgHistory) {
            info = info + '_' + msg.toString();
        }
        info = info + "_HEND";
        return info;
    }

    public void handleMessage(Message msg) {
        this.mMsgHistory.offerLast(msg.what);
        while (this.mMsgHistory.size() > 400) {
            this.mMsgHistory.pollFirst();
        }
    }
}

