/*
 * Decompiled with CFR 0.152.
 */
package com.hjimi.api.iminect;

import android.util.Log;
import java.util.NoSuchElementException;

public final class ImiLog {
    public static final String LOG_TAG = "@@@@@";
    private static boolean ENABLE_LOG = true;
    private static ImiLogLevel CURRENT_LOG_LEVEL = ImiLogLevel.LOG_LEVEL_DEBUG;
    private static LogImpl mLogImpl = null;

    public static void setLogImpl(LogImpl impl) {
        mLogImpl = impl;
    }

    public static void setLogEnable(boolean bEnable) {
        ENABLE_LOG = bEnable;
    }

    public static boolean isLogEnabled() {
        return ENABLE_LOG;
    }

    public static void setLogLevel(ImiLogLevel level) {
        CURRENT_LOG_LEVEL = level;
    }

    public static ImiLogLevel getLogLevel() {
        return CURRENT_LOG_LEVEL;
    }

    public static void v(String msg) {
        ImiLog.v(LOG_TAG, msg, null);
    }

    public static void v(String tag, String msg) {
        ImiLog.v(tag, msg, null);
    }

    public static void v(String tag, String msg, Throwable tr) {
        if (ENABLE_LOG && CURRENT_LOG_LEVEL.toNative() >= ImiLogLevel.LOG_LEVEL_VERBOSE.toNative()) {
            try {
                if (mLogImpl != null) {
                    mLogImpl.v(tag + "[" + System.currentTimeMillis() + "]", msg, tr);
                } else {
                    Log.v((String)(tag + "[" + System.currentTimeMillis() + "]"), (String)msg, (Throwable)tr);
                }
            }
            catch (Exception e) {
                Log.v((String)(tag + "[" + System.currentTimeMillis() + "]"), (String)msg, (Throwable)tr);
            }
        }
    }

    public static void d(String msg) {
        ImiLog.d(LOG_TAG, msg, null);
    }

    public static void d(String tag, String msg) {
        ImiLog.d(tag, msg, null);
    }

    public static void d(String tag, String msg, Throwable tr) {
        if (ENABLE_LOG && CURRENT_LOG_LEVEL.toNative() >= ImiLogLevel.LOG_LEVEL_DEBUG.toNative()) {
            try {
                if (mLogImpl != null) {
                    mLogImpl.d(tag + "[" + System.currentTimeMillis() + "]", msg, tr);
                } else {
                    Log.d((String)(tag + "[" + System.currentTimeMillis() + "]"), (String)msg, (Throwable)tr);
                }
            }
            catch (Exception e) {
                Log.d((String)(tag + "[" + System.currentTimeMillis() + "]"), (String)msg, (Throwable)tr);
            }
        }
    }

    public static void i(String msg) {
        ImiLog.i(LOG_TAG, msg, null);
    }

    public static void i(String tag, String msg) {
        ImiLog.i(tag, msg, null);
    }

    public static void i(String tag, String msg, Throwable tr) {
        if (ENABLE_LOG && CURRENT_LOG_LEVEL.toNative() >= ImiLogLevel.LOG_LEVEL_INFO.toNative()) {
            try {
                if (mLogImpl != null) {
                    mLogImpl.i(tag + "[" + System.currentTimeMillis() + "]", msg, tr);
                } else {
                    Log.i((String)(tag + "[" + System.currentTimeMillis() + "]"), (String)msg, (Throwable)tr);
                }
            }
            catch (Exception e) {
                Log.i((String)(tag + "[" + System.currentTimeMillis() + "]"), (String)msg, (Throwable)tr);
            }
        }
    }

    public static void w(String msg) {
        ImiLog.w(LOG_TAG, msg, null);
    }

    public static void w(String tag, String msg) {
        ImiLog.w(tag, msg, null);
    }

    public static void w(String tag, String msg, Throwable tr) {
        if (ENABLE_LOG && CURRENT_LOG_LEVEL.toNative() >= ImiLogLevel.LOG_LEVEL_WARN.toNative()) {
            try {
                if (mLogImpl != null) {
                    mLogImpl.w(tag + "[" + System.currentTimeMillis() + "]", msg, tr);
                } else {
                    Log.w((String)(tag + "[" + System.currentTimeMillis() + "]"), (String)msg, (Throwable)tr);
                }
            }
            catch (Exception e) {
                Log.w((String)(tag + "[" + System.currentTimeMillis() + "]"), (String)msg, (Throwable)tr);
            }
        }
    }

    public static void e(String msg) {
        ImiLog.e(LOG_TAG, msg, null);
    }

    public static void e(String tag, String msg) {
        ImiLog.e(tag, msg, null);
    }

    public static void e(String tag, String msg, Throwable tr) {
        if (ENABLE_LOG && CURRENT_LOG_LEVEL.toNative() >= ImiLogLevel.LOG_LEVEL_ERROR.toNative()) {
            try {
                if (mLogImpl != null) {
                    mLogImpl.e(tag + "[" + System.currentTimeMillis() + "]", msg, tr);
                } else {
                    Log.e((String)(tag + "[" + System.currentTimeMillis() + "]"), (String)msg, (Throwable)tr);
                }
            }
            catch (Exception e) {
                Log.e((String)(tag + "[" + System.currentTimeMillis() + "]"), (String)msg, (Throwable)tr);
            }
        }
    }

    public static enum ImiLogLevel {
        LOG_LEVEL_ERROR(1),
        LOG_LEVEL_WARN(2),
        LOG_LEVEL_INFO(3),
        LOG_LEVEL_DEBUG(4),
        LOG_LEVEL_VERBOSE(5);

        private final int mValue;

        public int toNative() {
            return this.mValue;
        }

        public static ImiLogLevel fromNative(int value) {
            for (ImiLogLevel type : ImiLogLevel.values()) {
                if (type.mValue != value) continue;
                return type;
            }
            throw new NoSuchElementException();
        }

        private ImiLogLevel(int value) {
            this.mValue = value;
        }
    }

    public static interface LogImpl {
        public void v(String var1, String var2, Throwable var3);

        public void d(String var1, String var2, Throwable var3);

        public void i(String var1, String var2, Throwable var3);

        public void w(String var1, String var2, Throwable var3);

        public void e(String var1, String var2, Throwable var3);
    }
}

