/*
 * Decompiled with CFR 0.152.
 */
package com.hjimi.api.iminect;

import com.hjimi.api.iminect.ImiDriverInfo;
import com.hjimi.api.iminect.ImiDriverType;
import com.hjimi.api.iminect.ImiLog;
import com.hjimi.api.iminect.NativeMethods;

public class ImiNect {
    private static boolean bLibraryLoaded = false;
    private static boolean bInitialized = false;
    private static long tmpNectTime = 0L;
    private static ImiDriverInfo m_driverInfo = null;
    private static String m_ConfigureDataPath = null;

    private ImiNect() {
    }

    public static int initialize() {
        ImiNect.loadLib();
        if (bInitialized) {
            ImiLog.d("already initialize");
            return 0;
        }
        tmpNectTime = System.currentTimeMillis();
        int ret = NativeMethods.imiInitialize();
        if (0 == ret) {
            ImiLog.d("initialize success use " + (System.currentTimeMillis() - tmpNectTime));
            bInitialized = true;
        } else {
            ImiLog.e("initialize failed(" + ret + ") use " + (System.currentTimeMillis() - tmpNectTime));
        }
        return ret;
    }

    public static int initialize(ImiDriverInfo driverInfo) {
        int ret;
        ImiNect.loadLib();
        if (bInitialized) {
            ImiLog.d("already initialize");
            return 0;
        }
        tmpNectTime = System.currentTimeMillis();
        m_driverInfo = new ImiDriverInfo(ImiDriverType.IMI_DRIVER_NONE, 0, "");
        if (driverInfo.getDriverType() != null) {
            m_driverInfo.setDriverType(driverInfo.getDriverType());
        }
        if (driverInfo.getNetListenPort() > 0) {
            m_driverInfo.setNetListenPort(driverInfo.getNetListenPort());
        }
        if (driverInfo.getRecordFilePath() != null) {
            m_driverInfo.setRecordFilePath(driverInfo.getRecordFilePath());
        }
        if (0 == (ret = NativeMethods.imiInitialize2(m_driverInfo.getDriverType().toNative(), m_driverInfo.getNetListenPort(), m_driverInfo.getRecordFilePath()))) {
            ImiLog.d("initialize2 success use " + (System.currentTimeMillis() - tmpNectTime));
            bInitialized = true;
        } else {
            ImiLog.e("initialize2 failed(" + ret + ") use " + (System.currentTimeMillis() - tmpNectTime));
        }
        return ret;
    }

    public static int setConfigureDataPath(String path) {
        if (!bInitialized) {
            ImiLog.d("not initialize");
            return -1;
        }
        int ret = NativeMethods.imiNativeSetConfigureDataPath(path);
        if (ret == 0) {
            m_ConfigureDataPath = path;
        }
        return ret;
    }

    public static String getConfigureDataPath() {
        if (!bInitialized) {
            ImiLog.d("not initialize");
            return null;
        }
        return m_ConfigureDataPath;
    }

    public static void destroy() {
        if (bInitialized) {
            tmpNectTime = System.currentTimeMillis();
            NativeMethods.imiDestroy();
            ImiLog.d("destroy use " + (System.currentTimeMillis() - tmpNectTime));
            bInitialized = false;
            m_driverInfo = null;
        }
    }

    private static void loadLib() {
        if (!bLibraryLoaded) {
            System.loadLibrary("ImiCamera.jni");
            System.loadLibrary("ImiSdk.jni");
            System.loadLibrary("ImiCamera");
            System.loadLibrary("iminect");
            bLibraryLoaded = true;
        }
    }

    public static boolean isInitialized() {
        return bInitialized;
    }

    public static ImiDriverInfo get_DriverInfo() {
        return m_driverInfo;
    }
}

