/*
 * Decompiled with CFR 0.152.
 */
package com.hjimi.api.iminect;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.text.TextUtils;
import com.hjimi.api.iminect.ImiDevice;
import com.hjimi.api.iminect.ImiDeviceFlags;
import com.hjimi.api.iminect.ImiDeviceState;
import com.hjimi.api.iminect.ImiLog;
import com.hjimi.api.iminect.ImiPermissionCallbacks;
import com.hjimi.api.iminect.NativeMethods;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class ImiUsbPermissionHelper {
    private boolean mbRegistrated = false;
    private String mUsbPermissionAct = null;
    private Context mContext = null;
    private static final int IMI_DEVICE_VID_0x2DBB = 11707;
    private static final int IMI_DEVICE_PID_0x0001 = 1;
    private static final int IMI_DEVICE_PID_0x0002 = 2;
    private static final int IMI_DEVICE_PID_0x0004 = 4;
    private static final int IMI_DEVICE_PID_0x0005 = 5;
    private static final int IMI_DEVICE_PID_0x0300 = 768;
    private static final int IMI_DEVICE_PID_0x0301 = 769;
    private static final int IMI_DEVICE_PID_0x0303 = 771;
    private static final int IMI_DEVICE_PID_0x0304 = 772;
    private static final int IMI_DEVICE_PID_0x0305 = 773;
    private static final int IMI_DEVICE_PID_0x0306 = 774;
    private static final int IMI_DEVICE_PID_0x0307 = 775;
    private static final int IMI_DEVICE_PID_0x0308 = 776;
    private static final int IMI_DEVICE_PID_0x0309 = 777;
    private static final int IMI_DEVICE_PID_0x0330 = 816;
    private static final int IMI_DEVICE_PID_0x0302 = 770;
    private static final int IMI_DEVICE_VID_0x0AC8 = 2760;
    private static final int IMI_DEVICE_PID_0x3580 = 13696;
    private static final int IMI_DEVICE_PID_0x0101 = 257;
    private static final int IMI_CAMERA_PID_0x0201 = 513;
    private static final int IMI_CAMERA_PID_0x0202 = 514;
    private static final int IMI_CAMERA_PID_0x0203 = 515;
    private static final int IMI_CAMERA_PID_0x0204 = 516;
    private static final int IMI_CAMERA_PID_0x0205 = 517;
    private static final int IMI_CAMERA_PID_0x0206 = 518;
    private static final int IMI_CAMERA_PID_0x0207 = 519;
    private static final int IMI_CAMERA_PID_0x0208 = 520;
    private static final int IMI_CAMERA_PID_0x0209 = 521;
    private static final int IMI_CAMERA_PID_0x0210 = 528;
    private static final int IMI_CAMERA_PID_0x0211 = 529;
    private static final int IMI_CAMERA_PID_0x0212 = 530;
    private HashMap<ImiDeviceFlags, PermissionWrapper> permissionWrappers;
    private List<ImiDevice.DeviceStateListener> mDeviceListener;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"NewApi"})
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (ImiUsbPermissionHelper.this.mUsbPermissionAct.equals(action)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                    if (device == null) {
                        ImiLog.e("get UsbManager.EXTRA_DEVICE error");
                        return;
                    }
                    ImiDeviceFlags currDeviceFlag = ImiUsbPermissionHelper.this.getDeviceFlag(device);
                    PermissionWrapper wrapper = (PermissionWrapper)ImiUsbPermissionHelper.this.permissionWrappers.get((Object)currDeviceFlag);
                    if (intent.getBooleanExtra("permission", false)) {
                        if (wrapper != null && wrapper.perMissionCallBack != null) {
                            UsbDeviceConnection deviceConn = ImiUsbPermissionHelper.this.openDevice(device);
                            if (deviceConn != null) {
                                ImiLog.d("open UsbDevice(" + String.format("0x%04x", device.getProductId()) + ") success");
                                wrapper.perMissionCallBack.onDevicePermissionGranted(deviceConn.getFileDescriptor(), device);
                                wrapper.deviceConn = deviceConn;
                            } else {
                                ImiLog.e("open UsbDevice(" + String.format("0x%04x", device.getProductId()) + ") failed and retry");
                                deviceConn = ImiUsbPermissionHelper.this.openDevice(device);
                                if (deviceConn != null) {
                                    ImiLog.d("open UsbDevice(" + String.format("0x%04x", device.getProductId()) + ") success");
                                    wrapper.perMissionCallBack.onDevicePermissionGranted(deviceConn.getFileDescriptor(), device);
                                    wrapper.deviceConn = deviceConn;
                                } else {
                                    ImiLog.e("open UsbDevice(" + String.format("0x%04x", device.getProductId()) + ") failed");
                                    wrapper.perMissionCallBack.onDevicePermissionDenied();
                                }
                            }
                        }
                    } else if (wrapper != null && wrapper.perMissionCallBack != null) {
                        wrapper.perMissionCallBack.onDevicePermissionDenied();
                    }
                }
            }
            if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                if (device == null) {
                    ImiLog.e("[DETACHED] get UsbManager.EXTRA_DEVICE error");
                    return;
                }
                String name = device.getDeviceName();
                String[] v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
                int busnum = 0;
                int devnum = 0;
                if (v != null) {
                    busnum = Integer.parseInt(v[v.length - 2]);
                    devnum = Integer.parseInt(v[v.length - 1]);
                }
                if (ImiUsbPermissionHelper.this.getDeviceFlag(device) == ImiDeviceFlags.IMI_DEVICE) {
                    NativeMethods.imiDeviceStatusChange(device.getVendorId(), device.getProductId(), busnum, devnum, ImiDeviceState.IMI_DEVICE_STATE_DISCONNECT.toNative());
                    ImiLog.d("[Device] pid(" + String.format("0x%04x", device.getProductId()) + ") " + device.getDeviceName() + " DISCONNECT");
                    ImiUsbPermissionHelper.this.onDeviceStateChanged("[Device] pid(" + String.format("0x%04x", device.getProductId()) + ") " + device.getDeviceName(), ImiDeviceState.IMI_DEVICE_STATE_DISCONNECT);
                } else if (ImiUsbPermissionHelper.this.getDeviceFlag(device) == ImiDeviceFlags.IMI_CAMERA) {
                    ImiLog.d("[Camera] pid(" + String.format("0x%04x", device.getProductId()) + ") " + device.getDeviceName() + " DISCONNECT");
                    ImiUsbPermissionHelper.this.onDeviceStateChanged("[Camera] pid(" + String.format("0x%04x", device.getProductId()) + ") " + device.getDeviceName(), ImiDeviceState.IMI_DEVICE_STATE_DISCONNECT);
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                if (device == null) {
                    ImiLog.e("[ATTACHED] get UsbManager.EXTRA_DEVICE error");
                    return;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (ImiUsbPermissionHelper.this.getDeviceFlag(device) == ImiDeviceFlags.IMI_DEVICE) {
                    ImiLog.d("[Device] pid(" + String.format("0x%04x", device.getProductId()) + ") " + device.getDeviceName() + " CONNECT");
                    ImiUsbPermissionHelper.this.onDeviceStateChanged("[Device] pid(" + String.format("0x%04x", device.getProductId()) + ") " + device.getDeviceName(), ImiDeviceState.IMI_DEVICE_STATE_CONNECT);
                } else if (ImiUsbPermissionHelper.this.getDeviceFlag(device) == ImiDeviceFlags.IMI_CAMERA) {
                    ImiLog.d("[Camera] pid(" + String.format("0x%04x", device.getProductId()) + ") " + device.getDeviceName() + " CONNECT");
                    ImiUsbPermissionHelper.this.onDeviceStateChanged("[Camera] pid(" + String.format("0x%04x", device.getProductId()) + ") " + device.getDeviceName(), ImiDeviceState.IMI_DEVICE_STATE_CONNECT);
                }
            }
        }
    };

    public ImiUsbPermissionHelper(Context context) {
        this.mContext = context;
        this.mUsbPermissionAct = context.getPackageName() + ".USB_PERMISSION" + this.hashCode();
        this.permissionWrappers = new HashMap();
        this.mDeviceListener = new ArrayList<ImiDevice.DeviceStateListener>();
        this.registerReceiver();
    }

    public boolean addDeviceListener(ImiDevice.DeviceStateListener deviceListener) {
        if (!this.mDeviceListener.contains(deviceListener)) {
            this.mDeviceListener.add(deviceListener);
            return true;
        }
        return false;
    }

    public boolean removeDeviceListener(ImiDevice.DeviceStateListener deviceListener) {
        if (this.mDeviceListener.contains(deviceListener)) {
            this.mDeviceListener.remove(deviceListener);
            return true;
        }
        return false;
    }

    private void onDeviceStateChanged(String info, ImiDeviceState state) {
        for (ImiDevice.DeviceStateListener deviceListener : this.mDeviceListener) {
            deviceListener.onDeviceStateChanged(info, state);
        }
    }

    @TargetApi(value=21)
    public ImiDeviceWrapper checkDevice() {
        UsbManager manager = (UsbManager)this.mContext.getSystemService("usb");
        HashMap deviceList = manager.getDeviceList();
        ArrayList<UsbDevice> devList = new ArrayList<UsbDevice>();
        ArrayList<UsbDevice> uvcList = new ArrayList<UsbDevice>();
        for (UsbDevice device : deviceList.values()) {
            int vendorId = device.getVendorId();
            int productId = device.getProductId();
            if (vendorId == 11707 && productId == 513 || vendorId == 1443 && productId == 37681 || vendorId == 11707 && productId == 514 || vendorId == 11707 && productId == 515 || vendorId == 11707 && productId == 517 || vendorId == 11707 && productId == 518 || vendorId == 11707 && productId == 516 || vendorId == 11707 && productId == 519 || vendorId == 11707 && productId == 520 || vendorId == 11707 && productId == 521 || vendorId == 11707 && productId == 528 || vendorId == 11707 && productId == 529 || vendorId == 11707 && productId == 530) {
                uvcList.add(device);
                continue;
            }
            if (vendorId != 11707 && vendorId != 2760 || productId != 1 && productId != 2 && productId != 4 && productId != 5 && productId != 768 && productId != 769 && productId != 770 && productId != 13696 && productId != 771 && productId != 772 && productId != 773 && productId != 774 && productId != 777 && productId != 775 && productId != 776 && productId != 257 && productId != 816) continue;
            devList.add(device);
        }
        ImiLog.d("@@@@@", "color device list size " + uvcList.size());
        ImiLog.d("@@@@@", "depth device list size " + devList.size());
        if (devList.size() == 0 || uvcList.size() == 0) {
            return null;
        }
        if (devList.size() != uvcList.size()) {
            ImiLog.d("@@@@@", "color and depth device number mismatched");
        } else {
            ImiLog.d("@@@@@", "device list size " + (uvcList.size() + devList.size()));
        }
        for (UsbDevice device : devList) {
            ImiLog.d("@@@@@", "depth device name " + device.getDeviceName() + " sn " + device.getSerialNumber());
        }
        for (UsbDevice device : uvcList) {
            ImiLog.d("@@@@@", "color device name " + device.getDeviceName() + " sn " + device.getSerialNumber());
        }
        for (UsbDevice u : uvcList) {
            for (UsbDevice d : devList) {
                if (!Objects.equals(u.getSerialNumber(), d.getSerialNumber())) continue;
                ImiLog.d("@@@@@", "imi device matched sn is " + u.getSerialNumber());
                return new ImiDeviceWrapper(this.getDeviceType(d), d, u);
            }
        }
        ImiLog.d("@@@@@", "imi device not found matched sn");
        return new ImiDeviceWrapper(this.getDeviceType((UsbDevice)devList.get(0)), (UsbDevice)devList.get(0), (UsbDevice)uvcList.get(0));
    }

    public ImiDeviceType getDeviceType(UsbDevice device) {
        int vendorId = device.getVendorId();
        int productId = device.getProductId();
        ImiDeviceType mDType = null;
        if (vendorId == 11707) {
            switch (productId) {
                case 257: {
                    mDType = ImiDeviceType.IMI_A100;
                    break;
                }
                case 1: {
                    mDType = ImiDeviceType.IMI_A100_3D;
                    break;
                }
                case 2: {
                    mDType = ImiDeviceType.IMI_A100M;
                    break;
                }
                case 4: {
                    mDType = ImiDeviceType.IMI_A100S_PLUS;
                    break;
                }
                case 5: {
                    mDType = ImiDeviceType.IMI_A100S;
                    break;
                }
                case 768: 
                case 769: 
                case 770: 
                case 771: 
                case 772: 
                case 773: 
                case 774: 
                case 775: 
                case 776: 
                case 777: 
                case 816: {
                    mDType = ImiDeviceType.IMI_A200;
                    break;
                }
            }
        } else if (vendorId == 2760) {
            switch (productId) {
                case 13696: {
                    mDType = ImiDeviceType.IMI_A200;
                    break;
                }
            }
        }
        return mDType;
    }

    public boolean requestDevice(ImiDeviceFlags devFlags, UsbDevice device, ImiPermissionCallbacks callbacks) {
        if (device == null) {
            return false;
        }
        if (this.permissionWrappers.get((Object)devFlags) == null) {
            PermissionWrapper wrapper = new PermissionWrapper();
            this.permissionWrappers.put(devFlags, wrapper);
        }
        this.permissionWrappers.get((Object)((Object)devFlags)).perMissionCallBack = callbacks;
        this.RequestDevicePermission(device);
        return true;
    }

    public boolean findDevice(ImiDeviceFlags deviceFlags, ImiPermissionCallbacks callbacks) {
        HashMap<String, UsbDevice> deviceList;
        ImiDeviceFlags devFlags = deviceFlags;
        if (devFlags == null) {
            devFlags = ImiDeviceFlags.IMI_DEVICE;
        }
        if ((deviceList = this.getDeviceList(devFlags)).isEmpty()) {
            ImiLog.w("no device list");
            return false;
        }
        if (this.permissionWrappers.get((Object)devFlags) == null) {
            PermissionWrapper wrapper = new PermissionWrapper();
            this.permissionWrappers.put(devFlags, wrapper);
        }
        this.permissionWrappers.get((Object)((Object)devFlags)).perMissionCallBack = callbacks;
        this.RequestDevicePermission((UsbDevice)deviceList.values().toArray()[0]);
        return true;
    }

    public HashMap<String, UsbDevice> getDeviceList(ImiDeviceFlags deviceFlag) {
        UsbManager manager = (UsbManager)this.mContext.getSystemService("usb");
        HashMap deviceList = manager.getDeviceList();
        Iterator iterator = deviceList.values().iterator();
        while (iterator.hasNext()) {
            UsbDevice device = (UsbDevice)iterator.next();
            int vendorId = device.getVendorId();
            int productId = device.getProductId();
            switch (deviceFlag) {
                case IMI_CAMERA: {
                    boolean bCamera = false;
                    if (vendorId == 11707 && productId == 513 || vendorId == 1443 && productId == 37681 || vendorId == 11707 && productId == 514 || vendorId == 11707 && productId == 515 || vendorId == 11707 && productId == 517 || vendorId == 11707 && productId == 518 || vendorId == 11707 && productId == 516 || vendorId == 11707 && productId == 519 || vendorId == 11707 && productId == 520 || vendorId == 11707 && productId == 521 || vendorId == 11707 && productId == 528 || vendorId == 11707 && productId == 529 || vendorId == 11707 && productId == 530) {
                        bCamera = true;
                    }
                    if (bCamera) break;
                    iterator.remove();
                    break;
                }
                case IMI_DEVICE: {
                    if ((vendorId == 11707 || vendorId == 2760) && (productId == 1 || productId == 2 || productId == 4 || productId == 5 || productId == 768 || productId == 769 || productId == 770 || productId == 13696 || productId == 771 || productId == 772 || productId == 773 || productId == 774 || productId == 777 || productId == 775 || productId == 776 || productId == 257 || productId == 816)) break;
                    iterator.remove();
                }
            }
        }
        return deviceList;
    }

    private void registerReceiver() {
        IntentFilter filter = new IntentFilter(this.mUsbPermissionAct);
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        this.mContext.registerReceiver(this.mUsbReceiver, filter);
        this.mbRegistrated = true;
    }

    private void RequestDevicePermission(UsbDevice device) {
        PendingIntent permissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(this.mUsbPermissionAct), (int)0);
        UsbManager manager = (UsbManager)this.mContext.getSystemService("usb");
        if (manager.hasPermission(device)) {
            ImiLog.d("UsbDevice(" + String.format("0x%04x", device.getProductId()) + ") already hasPermission");
            ImiDeviceFlags currDeviceFlag = this.getDeviceFlag(device);
            PermissionWrapper wrapper = this.permissionWrappers.get((Object)currDeviceFlag);
            if (wrapper != null && wrapper.perMissionCallBack != null) {
                UsbDeviceConnection deviceConn = this.openDevice(device);
                if (deviceConn != null) {
                    ImiLog.d("open UsbDevice(" + String.format("0x%04x", device.getProductId()) + ") success");
                    wrapper.perMissionCallBack.onDevicePermissionGranted(deviceConn.getFileDescriptor(), device);
                    wrapper.deviceConn = deviceConn;
                } else {
                    ImiLog.e("open UsbDevice(" + String.format("0x%04x", device.getProductId()) + ") failed and retry");
                    deviceConn = this.openDevice(device);
                    if (deviceConn != null) {
                        ImiLog.d("open UsbDevice(" + String.format("0x%04x", device.getProductId()) + ") success");
                        wrapper.perMissionCallBack.onDevicePermissionGranted(deviceConn.getFileDescriptor(), device);
                        wrapper.deviceConn = deviceConn;
                    } else {
                        ImiLog.e("open UsbDevice(" + String.format("0x%04x", device.getProductId()) + ") failed");
                        wrapper.perMissionCallBack.onDevicePermissionDenied();
                    }
                }
            }
        } else {
            ImiLog.d("UsbDevice(" + String.format("0x%04x", device.getProductId()) + ") requestPermission");
            manager.requestPermission(device, permissionIntent);
        }
    }

    private UsbDeviceConnection openDevice(UsbDevice device) {
        ImiLog.d("UsbDevice(" + String.format("0x%04x", device.getProductId()) + ") do openDevice");
        UsbManager manager = (UsbManager)this.mContext.getSystemService("usb");
        return manager.openDevice(device);
    }

    private ImiDeviceFlags getDeviceFlag(UsbDevice usbDevice) {
        return this.getDeviceFlag(usbDevice.getVendorId(), usbDevice.getProductId());
    }

    private ImiDeviceFlags getDeviceFlag(int vid, int pid) {
        if (vid == 11707 && (pid == 513 || pid == 514 || pid == 515 || pid == 516 || pid == 517 || pid == 518 || pid == 519 || pid == 520 || pid == 521 || pid == 528) || pid == 529 || pid == 530) {
            return ImiDeviceFlags.IMI_CAMERA;
        }
        if (vid == 11707 && (pid == 1 || pid == 2 || pid == 4 || pid == 5 || pid == 768 || pid == 769 || pid == 770 || pid == 771 || pid == 772 || pid == 773 || pid == 774 || pid == 775 || pid == 776 || pid == 777 || pid == 257 || pid == 816)) {
            return ImiDeviceFlags.IMI_DEVICE;
        }
        if (vid == 2760 && pid == 13696) {
            return ImiDeviceFlags.IMI_DEVICE;
        }
        return null;
    }

    public void close() {
        try {
            if (this.permissionWrappers == null) {
                ImiLog.e("permissionWrappers is null");
                return;
            }
            ImiLog.d("usbhelper: close");
            Collection<PermissionWrapper> wrapperCollection = this.permissionWrappers.values();
            for (PermissionWrapper wrapper : wrapperCollection) {
                if (wrapper.deviceConn == null) continue;
                wrapper.deviceConn.close();
            }
            this.permissionWrappers.clear();
            this.permissionWrappers = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        try {
            if (this.mbRegistrated) {
                this.mContext.unregisterReceiver(this.mUsbReceiver);
                this.mbRegistrated = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isRooted() {
        String[] places;
        boolean bRoot = false;
        for (String path : places = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"}) {
            if (!new File(path + "su").exists()) continue;
            bRoot = true;
            break;
        }
        return bRoot;
    }

    public int fixRootPermission() {
        UsbDevice device;
        int iRet = -1;
        if (!this.isRooted()) {
            return iRet;
        }
        HashMap<String, UsbDevice> deviceList = this.getDeviceList(ImiDeviceFlags.IMI_DEVICE);
        Iterator<UsbDevice> iterator = deviceList.values().iterator();
        while (iterator.hasNext() && (iRet = this.setRootPermission(device = iterator.next())) == 0) {
        }
        return iRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setRootPermission(UsbDevice device) {
        int iRet = -1;
        if (device == null) {
            return -1;
        }
        Runtime runtime = Runtime.getRuntime();
        OutputStreamWriter osw = null;
        Process proc = null;
        try {
            proc = runtime.exec("su");
            osw = new OutputStreamWriter(proc.getOutputStream());
            osw.write("chmod 777 " + device.getDeviceName() + "\n");
            osw.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            if (proc != null) {
                proc.waitFor();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return -1;
        }
        if (proc.exitValue() != 0) {
            ImiLog.i("ImiUsbPermissionHelper", "Root refused to give permissions.");
            iRet = -1;
        } else {
            iRet = 0;
        }
        proc.destroy();
        return iRet;
    }

    private class PermissionWrapper {
        public ImiPermissionCallbacks perMissionCallBack;
        public ImiDeviceFlags deviceFlag;
        public UsbDeviceConnection deviceConn;

        private PermissionWrapper() {
        }
    }

    public static class ImiDeviceWrapper {
        private ImiDeviceType m_DevType;
        private UsbDevice mImiDev;
        private UsbDevice mUvcDev;

        public ImiDeviceWrapper(ImiDeviceType m_DevType, UsbDevice mImiDev, UsbDevice mUvcDev) {
            this.m_DevType = m_DevType;
            this.mImiDev = mImiDev;
            this.mUvcDev = mUvcDev;
        }

        ImiDeviceType getDeviceType() {
            return this.m_DevType;
        }

        UsbDevice getImiDev() {
            return this.mImiDev;
        }

        UsbDevice getUvcDev() {
            return this.mUvcDev;
        }
    }

    public static enum ImiDeviceType {
        IMI_A100(1),
        IMI_A100_3D(2),
        IMI_A100M(3),
        IMI_A100S_PLUS(4),
        IMI_A100S(5),
        IMI_A200(6);

        private final int mValue;

        public int toNative() {
            return this.mValue;
        }

        public static ImiDeviceType fromNative(int value) {
            for (ImiDeviceType type : ImiDeviceType.values()) {
                if (type.mValue != value) continue;
                return type;
            }
            throw new NoSuchElementException();
        }

        private ImiDeviceType(int value) {
            this.mValue = value;
        }
    }
}

