/*
 * Decompiled with CFR 0.152.
 */
package com.hjimi.api.iminect;

import android.util.Log;

public class KalmanFilter {
    private static final String TAG = "KalmanFilter";
    private final float DISTANCE_MIN = 64.0f;
    private final float DISTANCE_MAX = 750.0f;
    public static final float MIN_ACCURACY = 3.0f;
    private float mNewRx;
    private float mNewRy;
    private float mVariance = -1.0f;
    private float mLastRx;
    private float mLastRy;
    private long mLastTimeStamp;
    private float mLastDuration;

    public void setInitState(float rx, float ry, long timeStamp, float accuracy) {
        this.mNewRx = this.mLastRx = rx;
        this.mNewRy = this.mLastRy = ry;
        this.mLastTimeStamp = timeStamp;
        this.mVariance = accuracy * accuracy;
        this.mLastDuration = 30.0f;
    }

    public void process(float rx, float ry, long newTimeStamp, int screenHeight) {
        if (ry < 0.0f || ry >= (float)screenHeight) {
            this.mVariance = -1.0f;
            this.mNewRx = rx;
            this.mNewRy = ry;
            return;
        }
        if (this.mVariance < 0.0f) {
            this.setInitState(rx, ry, newTimeStamp, 3.0f);
        } else {
            float distance = (float)Math.sqrt(Math.pow(rx - this.mLastRx, 2.0) + Math.pow(ry - this.mLastRy, 2.0));
            float duration = newTimeStamp - this.mLastTimeStamp;
            float newSpeed = distance / duration;
            Log.d((String)"ImiSdk", (String)("[Richard]LINE_57: duration = " + duration));
            if (duration > 0.0f) {
                this.mVariance += 2.0f * duration * newSpeed * newSpeed / (duration + this.mLastDuration);
            }
            float k = this.mVariance / (this.mVariance + 9.0f);
            this.mNewRx += k * (rx - this.mNewRx);
            this.mNewRy += k * (ry - this.mNewRy);
            this.mVariance = (1.0f - k) * this.mVariance;
            float alpha = 0.0f;
            alpha = distance < 64.0f ? 0.0f : (distance > 750.0f ? 1.0f : (float)(1.0 / (1.0 + Math.exp(-(distance - 343.0f) / 11.0f))));
            this.mNewRx = alpha * rx + (1.0f - alpha) * this.mNewRx;
            this.mNewRy = alpha * ry + (1.0f - alpha) * this.mNewRy;
            this.mLastRx = rx;
            this.mLastRy = ry;
            this.mLastTimeStamp = newTimeStamp;
            this.mLastDuration = duration;
        }
    }

    public float getNewRx() {
        return this.mNewRx;
    }

    public float getNewRy() {
        return this.mNewRy;
    }
}

