/*
 * Decompiled with CFR 0.152.
 */
package com.hjimi.api.iminect;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class LogUtil {
    private static Boolean MYLOG_SWITCH = true;
    private static Boolean MYLOG_WRITE_TO_FILE = true;
    private static char MYLOG_TYPE = (char)118;
    private static String MYLOG_PATH_SDCARD_DIR = "/sdcard/Imi/log";
    private static int SDCARD_LOG_FILE_SAVE_DAYS = 0;
    private static String MYLOGFILEName = "ImiLogF.txt";
    private static SimpleDateFormat myLogSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static SimpleDateFormat logfile = new SimpleDateFormat("yyyy-MM-dd");
    public Context context;

    public static void w(String tag, Object msg) {
        LogUtil.log(tag, msg.toString(), 'w');
    }

    public static void e(String tag, Object msg) {
        LogUtil.log(tag, msg.toString(), 'e');
    }

    public static void d(String tag, Object msg) {
        LogUtil.log(tag, msg.toString(), 'd');
    }

    public static void i(String tag, Object msg) {
        LogUtil.log(tag, msg.toString(), 'i');
    }

    public static void v(String tag, Object msg) {
        LogUtil.log(tag, msg.toString(), 'v');
    }

    public static void w(String tag, String text) {
        LogUtil.log(tag, text, 'w');
    }

    public static void e(String tag, String text) {
        LogUtil.log(tag, text, 'e');
    }

    public static void d(String tag, String text) {
        LogUtil.log(tag, text, 'd');
    }

    public static void i(String tag, String text) {
        LogUtil.log(tag, text, 'i');
    }

    public static void v(String tag, String text) {
        LogUtil.log(tag, text, 'v');
    }

    private static void log(String tag, String msg, char level) {
        if (MYLOG_SWITCH.booleanValue()) {
            if ('e' == level && ('e' == MYLOG_TYPE || 'v' == MYLOG_TYPE)) {
                Log.e((String)tag, (String)msg);
            } else if ('w' == level && ('w' == MYLOG_TYPE || 'v' == MYLOG_TYPE)) {
                Log.w((String)tag, (String)msg);
            } else if ('d' == level && ('d' == MYLOG_TYPE || 'v' == MYLOG_TYPE)) {
                Log.d((String)tag, (String)msg);
            } else if ('i' == level && ('d' == MYLOG_TYPE || 'v' == MYLOG_TYPE)) {
                Log.i((String)tag, (String)msg);
            } else {
                Log.v((String)tag, (String)msg);
            }
            if (MYLOG_WRITE_TO_FILE.booleanValue()) {
                LogUtil.writeLogtoFile(String.valueOf(level), tag, msg);
            }
        }
    }

    private static void writeLogtoFile(String mylogtype, String tag, String text) {
        File file;
        Date nowtime = new Date();
        String needWriteFiel = logfile.format(nowtime);
        String needWriteMessage = myLogSdf.format(nowtime) + " " + mylogtype + " " + tag + " " + text;
        File dirPath = Environment.getExternalStorageDirectory();
        File dirsFile = new File(MYLOG_PATH_SDCARD_DIR);
        if (!dirsFile.exists()) {
            dirsFile.mkdirs();
        }
        if (!(file = new File(dirsFile.toString(), needWriteFiel + MYLOGFILEName)).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            FileWriter filerWriter = new FileWriter(file, true);
            BufferedWriter bufWriter = new BufferedWriter(filerWriter);
            bufWriter.write(needWriteMessage);
            bufWriter.newLine();
            bufWriter.close();
            filerWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void delFile() {
        String needDelFiel = logfile.format(LogUtil.getDateBefore());
        File dirPath = Environment.getExternalStorageDirectory();
        File file = new File(dirPath, needDelFiel + MYLOGFILEName);
        if (file.exists()) {
            file.delete();
        }
    }

    private static Date getDateBefore() {
        Date nowtime = new Date();
        Calendar now = Calendar.getInstance();
        now.setTime(nowtime);
        now.set(5, now.get(5) - SDCARD_LOG_FILE_SAVE_DAYS);
        return now.getTime();
    }
}

