/*
 * Decompiled with CFR 0.152.
 */
package com.hjimi.api.iminect;

import com.hjimi.api.iminect.ImiDevice;
import com.hjimi.api.iminect.ImiErrorCode;
import com.hjimi.api.iminect.NativeMethods;
import com.hjimi.api.iminect.OutArg;
import java.nio.ByteBuffer;

public class Utils {
    public static ByteBuffer yuv422ToRGB888(ImiDevice.ImiFrame frame) {
        OutArg<ByteBuffer> outColor = new OutArg<ByteBuffer>();
        NativeMethods.yuv422ToRGB888(frame.getData(), frame.getWidth(), frame.getHeight(), frame.getSize(), outColor);
        return (ByteBuffer)outColor.mData;
    }

    public static ByteBuffer depth2RGB888(ImiDevice.ImiFrame imiImageFrame, boolean histogram, boolean extractDepth) {
        OutArg<ByteBuffer> outDepth = new OutArg<ByteBuffer>();
        NativeMethods.depth2RGB888(imiImageFrame.getData(), imiImageFrame.getWidth(), imiImageFrame.getHeight(), outDepth, histogram, extractDepth);
        return (ByteBuffer)outDepth.mData;
    }

    public static ByteBuffer depth2RGB8882(ImiDevice.ImiFrame imiImageFrame, boolean histogram, boolean extractDepth) {
        OutArg<ByteBuffer> outDepth = new OutArg<ByteBuffer>();
        NativeMethods.depth2RGB8882(imiImageFrame.getData(), imiImageFrame.getWidth(), imiImageFrame.getHeight(), outDepth, histogram, extractDepth);
        return (ByteBuffer)outDepth.mData;
    }

    public static ByteBuffer depth2RGB888(ByteBuffer depthData, int width, int height, boolean histogram, boolean extractDepth) {
        OutArg<ByteBuffer> outDepth = new OutArg<ByteBuffer>();
        NativeMethods.depth2RGB888(depthData, width, height, outDepth, histogram, extractDepth);
        return (ByteBuffer)outDepth.mData;
    }

    public static ByteBuffer depthx2RGB888(ImiDevice.ImiFrame frame) {
        OutArg<ByteBuffer> outDepth = new OutArg<ByteBuffer>();
        NativeMethods.depthx2RGB888(frame.getData(), frame.getWidth(), frame.getHeight(), outDepth);
        return (ByteBuffer)outDepth.mData;
    }

    public static ByteBuffer depthx2RGB888(ByteBuffer depthData, int width, int height) {
        OutArg<ByteBuffer> outDepth = new OutArg<ByteBuffer>();
        NativeMethods.depthx2RGB888(depthData, width, height, outDepth);
        return (ByteBuffer)outDepth.mData;
    }

    public static ByteBuffer yuv420sp2RGB(ImiDevice.ImiFrame frame) {
        OutArg<ByteBuffer> outColor = new OutArg<ByteBuffer>();
        ByteBuffer buffer = frame.getData();
        int width = frame.getWidth();
        int height = frame.getHeight();
        if (buffer != null && (double)(width * height) * 1.5 == (double)buffer.capacity()) {
            NativeMethods.yuv420sp2RGB888(buffer, width, height, outColor);
        }
        return (ByteBuffer)outColor.mData;
    }

    public static ByteBuffer ir2RGB888(ImiDevice.ImiFrame frame, boolean mirror) {
        OutArg<ByteBuffer> outColor = new OutArg<ByteBuffer>();
        NativeMethods.ir2RGB888(frame.getData(), frame.getWidth(), frame.getHeight(), mirror, outColor);
        return (ByteBuffer)outColor.mData;
    }

    public static ByteBuffer RGB888Scale(ImiDevice.ImiFrame frame, int width, int height, int filterMode) {
        OutArg<ByteBuffer> outColor = new OutArg<ByteBuffer>();
        NativeMethods.RGB888Scale(frame.getData(), frame.getWidth(), frame.getHeight(), filterMode, width, height, outColor);
        return (ByteBuffer)outColor.mData;
    }

    public static ByteBuffer ir2RGB888(ByteBuffer irData, int width, int height, boolean mirror) {
        OutArg<ByteBuffer> outColor = new OutArg<ByteBuffer>();
        NativeMethods.ir2RGB888(irData, width, height, mirror, outColor);
        return (ByteBuffer)outColor.mData;
    }

    public static ByteBuffer ir2RGB888_8bit(ImiDevice.ImiFrame frame, boolean mirror) {
        OutArg<ByteBuffer> outColor = new OutArg<ByteBuffer>();
        NativeMethods.ir8bit2RGB888(frame.getData(), frame.getWidth(), frame.getHeight(), mirror, outColor);
        return (ByteBuffer)outColor.mData;
    }

    public static ByteBuffer ir2RGB888_8bit(ByteBuffer irData, int width, int height, boolean mirror) {
        OutArg<ByteBuffer> outColor = new OutArg<ByteBuffer>();
        NativeMethods.ir8bit2RGB888(irData, width, height, mirror, outColor);
        return (ByteBuffer)outColor.mData;
    }

    public static ByteBuffer RGB8882Grey(ByteBuffer rgbData, int width, int height) {
        OutArg<ByteBuffer> outGrey = new OutArg<ByteBuffer>();
        NativeMethods.rgb8882Grey(rgbData, width, height, outGrey);
        return (ByteBuffer)outGrey.mData;
    }

    public static int frameDataCheck(ImiDevice.ImiFrame frame) {
        int frameType = -1;
        if (frame.getType() == ImiDevice.ImiStreamType.DEPTH.toNative()) {
            frameType = 0;
        } else if (frame.getType() == ImiDevice.ImiStreamType.IR.toNative()) {
            frameType = 1;
        } else if (frame.getType() == ImiDevice.ImiStreamType.COLOR.toNative()) {
            frameType = 2;
        } else if (frame.getType() == ImiDevice.ImiStreamType.USER_INDEX_SKELETON.toNative()) {
            frameType = 3;
        } else if (frame.getType() == ImiDevice.ImiStreamType.DEPTH_IR.toNative()) {
            frameType = 4;
        } else {
            return ImiErrorCode.IMI_NOT_SUPPORTED.toNative();
        }
        return NativeMethods.frameDataCheck(frameType, frame.getData(), frame.getWidth(), frame.getHeight());
    }

    public static void overlay(ByteBuffer colorBuffer, ByteBuffer depthBuffer, int width, int height) {
        NativeMethods.overlay(colorBuffer, depthBuffer, width, height);
    }

    public static void overlayIR(ByteBuffer colorBuffer, ByteBuffer irBuffer, int width, int height, int lightValue) {
        NativeMethods.overlayIR(colorBuffer, irBuffer, width, height, lightValue);
    }
}

