/*
 * Decompiled with CFR 0.152.
 */
package com.deptrum.usblite.param;

import java.util.Arrays;

public class DTFrameStreamBean {
    private byte[] data;
    private byte[] sign;
    private byte[] jpeg;
    private int imageType;
    private int width;
    private int height;
    private int fps;
    private int bitPerPixel;
    private int rotation;
    private int mirror;
    private long frameStamp;
    private long frameIndex;
    private int faceAeAreaSX;
    private int faceAeAreaSY;
    private int faceAeAreaW;
    private int faceAeAreaH;
    private int currentMode;
    private int signStatus;

    public byte[] getData() {
        return this.data;
    }

    public byte[] getSign() {
        return this.sign;
    }

    public byte[] getJpeg() {
        return this.jpeg;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long getFrameStamp() {
        return this.frameStamp;
    }

    public long getFrameIndex() {
        return this.frameIndex;
    }

    public int getFaceAeAreaSX() {
        return this.faceAeAreaSX;
    }

    public int getFaceAeAreaSY() {
        return this.faceAeAreaSY;
    }

    public int getFaceAeAreaW() {
        return this.faceAeAreaW;
    }

    public int getFaceAeAreaH() {
        return this.faceAeAreaH;
    }

    public int getSignStatus() {
        return this.signStatus;
    }

    public IMAGE_TYPE getImageType() {
        switch (this.imageType) {
            case 1: {
                return IMAGE_TYPE.IR;
            }
            case 2: {
                return IMAGE_TYPE.DEPTH;
            }
        }
        return IMAGE_TYPE.RGB;
    }

    public IMAGE_FPS getFps() {
        switch (this.fps) {
            case 25: {
                return IMAGE_FPS.FPS_25;
            }
        }
        return IMAGE_FPS.FPS_13;
    }

    public IMAGE_BIT_PIXEL getBitPerPixel() {
        switch (this.bitPerPixel) {
            case 8: {
                return IMAGE_BIT_PIXEL.BIT_8;
            }
            case 16: {
                return IMAGE_BIT_PIXEL.BIT_16;
            }
        }
        return IMAGE_BIT_PIXEL.BIT_24;
    }

    public IMAGE_ROTATION getRotation() {
        switch (this.rotation) {
            case 1: {
                return IMAGE_ROTATION.ROTATE_90;
            }
            case 2: {
                return IMAGE_ROTATION.ROTATE_180;
            }
            case 3: {
                return IMAGE_ROTATION.ROTATE_270;
            }
        }
        return IMAGE_ROTATION.ROTATE_0;
    }

    public IMAGE_MIRROR getMirror() {
        if (this.mirror >= 1) {
            return IMAGE_MIRROR.MIRROR_HOR;
        }
        return IMAGE_MIRROR.MIRROR_NONE;
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(int currentMode) {
        this.currentMode = currentMode;
    }

    public String toString() {
        return "DTFrameStreamBean{data=" + Arrays.toString(this.data) + "sign=" + Arrays.toString(this.sign) + "jpeg=" + Arrays.toString(this.jpeg) + ", imageType=" + this.imageType + ", width=" + this.width + ", height=" + this.height + ", fps=" + this.fps + ", bitPerPixel=" + this.bitPerPixel + ", rotation=" + this.rotation + ", mirror=" + this.mirror + ", frameStamp=" + this.frameStamp + ", frameIndex=" + this.frameIndex + ", faceAeAreaSX=" + this.faceAeAreaSX + ", faceAeAreaSY=" + this.faceAeAreaSY + ", faceAeAreaW=" + this.faceAeAreaW + ", faceAeAreaH=" + this.faceAeAreaH + ", currentMode=" + this.currentMode + '}';
    }

    public static enum IMAGE_BIT_PIXEL {
        BIT_8,
        BIT_16,
        BIT_24;

    }

    public static enum IMAGE_FPS {
        FPS_13,
        FPS_25;

    }

    public static enum IMAGE_MIRROR {
        MIRROR_HOR,
        MIRROR_NONE;

    }

    public static enum IMAGE_ROTATION {
        ROTATE_0,
        ROTATE_90,
        ROTATE_180,
        ROTATE_270;

    }

    public static enum IMAGE_TYPE {
        RGB,
        IR,
        DEPTH;

    }
}

