/*
 * Decompiled with CFR 0.152.
 */
package com.deptrum.usblite.sdk;

import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.core.content.ContextCompat;
import com.deptrum.usblite.callback.IDelay;
import com.deptrum.usblite.callback.IDeviceListener;
import com.deptrum.usblite.callback.ILoggerListener;
import com.deptrum.usblite.callback.ILoggerLongListener;
import com.deptrum.usblite.callback.INativeUpdateListener;
import com.deptrum.usblite.callback.IPsensorListener;
import com.deptrum.usblite.callback.IRollBackListener;
import com.deptrum.usblite.callback.IStreamListener;
import com.deptrum.usblite.callback.IUpdateListener;
import com.deptrum.usblite.constant.AEMode;
import com.deptrum.usblite.param.DeptrumCameraInfo;
import com.deptrum.usblite.param.DeviceLoggerInfo;
import com.deptrum.usblite.param.FaceArea;
import com.deptrum.usblite.param.StreamParam;
import com.deptrum.usblite.param.se.AuthSignResult;
import com.deptrum.usblite.param.se.ConfigSm3HashValueResult;
import com.deptrum.usblite.param.se.CosTypeResult;
import com.deptrum.usblite.param.se.DisassemblyStatusResult;
import com.deptrum.usblite.param.se.FwRunModeResult;
import com.deptrum.usblite.param.se.FwVersionResult;
import com.deptrum.usblite.param.se.InspectRequestParamResult;
import com.deptrum.usblite.param.se.SNResult;
import com.deptrum.usblite.param.se.SdkVersionResult;
import com.deptrum.usblite.param.se.TimeStampResult;
import com.deptrum.usblite.param.se.UnlockCommandResult;
import com.deptrum.usblite.sdk.NativeDeptrumSdk;
import com.deptrum.usblite.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DeptrumSdkApi {
    private static final String TAG = "deptrum_usblite_sdk_java";
    private static final int PERMISSION_PASS_CODE = 10;
    private final String ACTION_ANDROID_USB_PERMISSION = "com.android.usb.USB_PERMISSION";
    private static final int AURORA_900_PID = 6400;
    private static final int AURORA_900_VID = 12881;
    private static final int FRAME_NONE = 0;
    private static final int FRAME_RAW = 1;
    private static final int FRAME_RGB = 2;
    private boolean mIsNowStreaming;
    private volatile boolean mIsNowOpen = false;
    private volatile boolean mIsNowUpgrade;
    private volatile boolean mIsNowRollBack;
    private String[] mVersionArray;
    private IStreamListener mStreamListener;
    private WeakReference<Context> mWeakRef;
    private PendingIntent mPendingIntent;
    private UpgradeThread mUpThread;
    private RollBackThread mRollThread;
    private UsbManager mUsbManager;
    private boolean mHasRegister;
    private String[] mActionArray = new String[]{"android.hardware.usb.action.USB_DEVICE_ATTACHED", "android.hardware.usb.action.USB_DEVICE_DETACHED", "android.hardware.usb.action.USB_ACCESSORY_ATTACHED", "android.hardware.usb.action.USB_ACCESSORY_DETACHED", "android.intent.action.BATTERY_CHANGED", "com.android.usb.USB_PERMISSION"};
    private static volatile boolean mHardResetFlag = false;
    private Context mContext = null;
    private IDeviceListener mIDeviceListener;
    private UsbDeviceConnection mConnection;
    private BroadcastReceiver usbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "com.android.usb.USB_PERMISSION": {
                    LogUtil.d(DeptrumSdkApi.TAG, "------ACTION_ANDROID_USB_PERMISSION------" + intent.getBooleanExtra("permission", false));
                    boolean isGrant = intent.getBooleanExtra("permission", false);
                    if (!isGrant || DeptrumSdkApi.this.countDownLatch == null) break;
                    DeptrumSdkApi.this.countDownLatch.countDown();
                    break;
                }
                case "android.hardware.usb.action.USB_DEVICE_ATTACHED": {
                    break;
                }
                case "android.hardware.usb.action.USB_DEVICE_DETACHED": {
                    if (!DeptrumSdkApi.this.isAurora900Device() && DeptrumSdkApi.this.mIsNowOpen) {
                        LogUtil.d(DeptrumSdkApi.TAG, "deptrum camera is detached!");
                        DeptrumSdkApi.this.close();
                        mHardResetFlag = false;
                    }
                    LogUtil.d(DeptrumSdkApi.TAG, "-------recv broadcast DETACHED-------");
                }
            }
        }
    };
    private static final DeptrumSdkApi api = new DeptrumSdkApi();
    private CountDownLatch countDownLatch;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    public static volatile boolean transfering = false;
    private ILoggerLongListener mILoggerListener = new ILoggerLongListener(){

        @Override
        public void onLogger(String event, long resultCode) {
            if (TextUtils.isEmpty((CharSequence)event)) {
                return;
            }
            LogUtil.d(DeptrumSdkApi.TAG, " event " + event + " resultCode " + resultCode);
        }
    };
    private ILoggerListener mITOListener = new ILoggerListener(){

        @Override
        public void onLogger(String event, int resultCode) {
            if (null != DeptrumSdkApi.this.mIDeviceListener) {
                DeptrumSdkApi.this.mIDeviceListener.onErrorEvent(event, resultCode);
            }
            if (TextUtils.isEmpty((CharSequence)event)) {
                return;
            }
            LogUtil.d(DeptrumSdkApi.TAG, " event " + event + " resultCode " + resultCode);
        }
    };

    private DeptrumSdkApi() {
        System.loadLibrary("deptrum_lite.jni");
    }

    public static DeptrumSdkApi getApi() {
        return api;
    }

    public void open(Context context, final IDeviceListener listener) {
        if (!this.checkContextType(context)) {
            LogUtil.e(TAG, "this context is not instance of activity or application context !");
            return;
        }
        this.mIDeviceListener = listener;
        if (null == this.mContext && null != context) {
            this.mContext = context.getApplicationContext();
        }
        this.mWeakRef = new WeakReference<Context>(context);
        if (this.mIsNowOpen) {
            if (null != listener) {
                listener.onOpenResult(0);
            }
            return;
        }
        if (0 != ContextCompat.checkSelfPermission((Context)((Context)this.mWeakRef.get()), (String)"android.permission.WRITE_EXTERNAL_STORAGE") || 0 != ContextCompat.checkSelfPermission((Context)((Context)this.mWeakRef.get()), (String)"android.permission.READ_EXTERNAL_STORAGE") || 0 != ContextCompat.checkSelfPermission((Context)((Context)this.mWeakRef.get()), (String)"android.permission.CAMERA")) {
            LogUtil.e(TAG, "------nativeOpenDevice: ------no permission");
        }
        if (null == this.mPendingIntent && null == this.mUsbManager) {
            this.mPendingIntent = PendingIntent.getBroadcast((Context)((Context)this.mWeakRef.get()), (int)0, (Intent)new Intent("com.android.usb.USB_PERMISSION"), (int)0);
            this.mUsbManager = (UsbManager)((Context)this.mWeakRef.get()).getSystemService("usb");
        }
        this.registerUsbReceiver((Context)this.mWeakRef.get(), this.mActionArray);
        if (!this.isAurora900Device()) {
            LogUtil.e(TAG, "------nativeOpenDevice: ------device detached");
            if (null != listener) {
                listener.onDetach();
            }
            this.mIsNowOpen = false;
            return;
        }
        this.enumDeviceDelay(new IDelay<DeptrumCameraInfo>(){

            @Override
            public void call(DeptrumCameraInfo cameraInfo) {
                DeptrumSdkApi.this.processOpen(listener, cameraInfo);
            }
        });
    }

    private void processOpen(IDeviceListener listener, DeptrumCameraInfo cameraInfo) {
        if (null == cameraInfo) {
            LogUtil.e(TAG, "------nativeOpenDevice: ------device detached");
            if (null != listener) {
                listener.onDetach();
            }
            this.mIsNowOpen = false;
            return;
        }
        if (null != listener) {
            listener.onAttach();
        }
        LogUtil.e(TAG, "------nativeOpenDevice: ------start");
        int ret = NativeDeptrumSdk.nativeOpenDevice(cameraInfo);
        NativeDeptrumSdk.nativeOpenYT(1);
        NativeDeptrumSdk.nativeOpenLog(true);
        LogUtil.e(TAG, "------nativeOpenDevice: " + Integer.toHexString(ret) + "------");
        if (0 != ret) {
            if (null != listener) {
                listener.onOpenResult(ret);
            }
            return;
        }
        LogUtil.e(TAG, "----------nativeGetCameraParameter: -------start");
        int retParameter = NativeDeptrumSdk.nativeGetCameraParameter("");
        if (0 != retParameter) {
            if (null != listener) {
                listener.onOpenResult(retParameter);
            }
            this.mIsNowOpen = true;
            this.close();
            return;
        }
        this.mIsNowOpen = true;
        if (null != listener) {
            listener.onOpenResult(retParameter);
        }
        LogUtil.e(TAG, "----------nativeGetCameraParameter: " + Integer.toHexString(retParameter));
        this.getDeviceDebugInfo(new DeviceLoggerInfo());
        this.setItoListener();
    }

    public synchronized int setStreamParam(StreamParam param) {
        LogUtil.e(TAG, "----------setStreamParam: -------start");
        int ret = NativeDeptrumSdk.nativeSetStreamParam(param);
        LogUtil.e(TAG, "----------setStreamParam: " + ret);
        return ret;
    }

    public synchronized int startStream(int mask) {
        LogUtil.e(TAG, "----------nativeStartStream: -------start");
        int retCap = NativeDeptrumSdk.nativeStartStream(mask);
        LogUtil.e(TAG, "----------nativeStartStream: " + retCap);
        this.mIsNowStreaming = true;
        return 0;
    }

    public synchronized int stopStream(int mask) {
        LogUtil.e(TAG, "----------stopStream: -------start");
        int ret = NativeDeptrumSdk.nativeCaptureStop(mask);
        LogUtil.e(TAG, "----------stopStream: " + ret);
        return ret;
    }

    public synchronized int setStreamListener(IStreamListener listener) {
        if (null != listener) {
            this.setLoggerListener();
        }
        this.mStreamListener = listener;
        NativeDeptrumSdk.nativeSetCallback(listener);
        if (null != this.mStreamListener) {
            int n = NativeDeptrumSdk.nativeRegisterRawCapture();
        }
        return 0;
    }

    public synchronized int close() {
        LogUtil.e(TAG, "----------nativeCloseDevice: -----------start");
        int ret = 0;
        if (!this.mIsNowOpen) {
            LogUtil.e(TAG, "----------nativeCloseDevice \u8bbe\u5907\u5df2\u7ecf\u5173\u95ed\u8fc7 : " + Integer.toHexString(ret));
            return 0;
        }
        if (this.mIsNowStreaming) {
            this.stopStream(7);
            this.mIsNowStreaming = false;
        }
        if (null != this.mVersionArray && this.mVersionArray.length > 0) {
            this.mVersionArray = null;
        }
        this.setStreamListener(null);
        ret = NativeDeptrumSdk.nativeCloseDevice();
        this.unRegisterUsbReceiver((Context)this.mWeakRef.get());
        if (null != this.mConnection) {
            this.mConnection.close();
        }
        this.mIsNowOpen = false;
        LogUtil.e(TAG, "----------nativeCloseDevice: " + Integer.toHexString(ret));
        return ret;
    }

    public synchronized int softResetDevice() {
        LogUtil.e(TAG, "----------nativeSoftResetDevice: -----------start");
        int ret = NativeDeptrumSdk.nativeSoftResetDevice();
        LogUtil.e(TAG, "----------nativeSoftResetDevice: " + ret);
        return ret;
    }

    public int hardResetDevice() {
        LogUtil.e(TAG, "-------hardResetDevice\uff1a-------start");
        if (!this.mIsNowOpen) {
            LogUtil.e(TAG, "-------hardResetDevice\uff1a" + Integer.toHexString(135180));
            return 135180;
        }
        this.setStreamListener(null);
        mHardResetFlag = true;
        int ret = NativeDeptrumSdk.nativeRebootDevice();
        long curTime = System.currentTimeMillis();
        while (mHardResetFlag && System.currentTimeMillis() - curTime <= 6000L) {
        }
        LogUtil.e(TAG, "-------hardResetDevice\uff1a" + Integer.toHexString(ret));
        return ret;
    }

    public synchronized int setFaceAEMode(AEMode mode) {
        LogUtil.e(TAG, "-------nativeSetAeMode\uff1a-------start");
        int ret = NativeDeptrumSdk.nativeSetAeMode(mode.ordinal());
        LogUtil.e(TAG, "-------nativeSetAeMode\uff1a" + ret);
        return ret;
    }

    public synchronized int setFaceArea(FaceArea area) {
        LogUtil.e(TAG, "-------nativeSetFaceArea\uff1a-------start");
        int ret = NativeDeptrumSdk.nativeSetFaceArea(area);
        LogUtil.e(TAG, "-------nativeSetFaceArea\uff1a" + ret);
        return ret;
    }

    public synchronized String getSupportInfo() {
        if (!this.mIsNowOpen) {
            this.mVersionArray = null;
            return "\u76f8\u673a\u672aopen\uff0c\u65e0\u6cd5\u83b7\u77e5\u76f8\u673a\u652f\u6301\u4fe1\u606f!";
        }
        LogUtil.e(TAG, "-------getSupportInfo\uff1a-------start");
        LogUtil.e(TAG, "-------getSupportInfo\uff1a" + this.mVersionArray == null ? "false" : "true");
        return "\u662f\u5426\u652f\u6301\u4e09\u56fe\u540c\u51fa\uff1atrue\n\u662f\u5426\u652f\u6301\u626b\u7801\u6a21\u5f0f\uff1atrue\n\u662f\u5426\u652f\u6301\u8bbe\u5907\u5e38\u5f00(7x24\u5c0f\u65f6): true\n\u6df1\u5ea6\u56fe\u6709\u6548\u8303\u56f4\uff1a0.3m\u2014\u20141.0m";
    }

    public synchronized String getSerialNumber() {
        if (!this.mIsNowOpen) {
            this.mVersionArray = null;
            return "\u76f8\u673a\u672aopen\uff0c\u65e0\u6cd5\u83b7\u77e5\u5e8f\u5217\u53f7!";
        }
        LogUtil.e(TAG, "-------getSerialNumber\uff1a-------start");
        if (null == this.mVersionArray || this.mVersionArray.length <= 0) {
            this.mVersionArray = NativeDeptrumSdk.nativeGetVersionInfo().split("\n");
        }
        LogUtil.e(TAG, "-------getSerialNumber\uff1a" + this.mVersionArray == null ? "false" : "true");
        if (this.mVersionArray.length < 5) {
            return "\u65e0\u6cd5\u83b7\u77e5\u5e8f\u5217\u53f7!";
        }
        return this.mVersionArray[0];
    }

    public synchronized String getCameraSDKVersion() {
        return "1.0.8";
    }

    public synchronized String getCameraFwVersion() {
        if (!this.mIsNowOpen) {
            this.mVersionArray = null;
            return "\u76f8\u673a\u672aopen\uff0c\u65e0\u6cd5\u83b7\u77e5\u56fa\u4ef6\u7248\u672c\u53f7!";
        }
        LogUtil.e(TAG, "-------getCameraFwVersion\uff1a-------start");
        if (null == this.mVersionArray || this.mVersionArray.length <= 0) {
            this.mVersionArray = NativeDeptrumSdk.nativeGetVersionInfo().split("\n");
        }
        LogUtil.e(TAG, "-------getCameraFwVersion\uff1a" + this.mVersionArray == null ? "false" : "true");
        if (this.mVersionArray.length < 5) {
            return "\u65e0\u6cd5\u83b7\u77e5\u56fa\u4ef6\u7248\u672c\u53f7!";
        }
        return this.mVersionArray[1];
    }

    public synchronized String getCameraName() {
        if (!this.mIsNowOpen) {
            this.mVersionArray = null;
            return "\u76f8\u673a\u672aopen\uff0c\u65e0\u6cd5\u83b7\u77e5\u76f8\u673a\u540d\u79f0!";
        }
        LogUtil.e(TAG, "-------getCameraName\uff1a-------start");
        if (null == this.mVersionArray || this.mVersionArray.length <= 0) {
            this.mVersionArray = NativeDeptrumSdk.nativeGetVersionInfo().split("\n");
        }
        LogUtil.e(TAG, "-------getCameraName\uff1a" + this.mVersionArray == null ? "false" : "true");
        if (this.mVersionArray.length < 5) {
            return "\u65e0\u6cd5\u83b7\u77e5\u76f8\u673a\u540d\u79f0!";
        }
        int index = 9;
        if (this.mVersionArray.length > index) {
            return this.mVersionArray[index];
        }
        return "\u65e0\u6cd5\u83b7\u77e5\u76f8\u673a\u540d\u79f0!";
    }

    public synchronized String getHimaxFwVersion() {
        if (!this.mIsNowOpen) {
            this.mVersionArray = null;
            return "\u76f8\u673a\u672aopen\uff0c\u65e0\u6cd5\u83b7\u77e5\u56fa\u4ef6\u7248\u672c\u53f7!";
        }
        LogUtil.e(TAG, "-------getHimaxFwVersion\uff1a-------start");
        if (null == this.mVersionArray || this.mVersionArray.length <= 0) {
            this.mVersionArray = NativeDeptrumSdk.nativeGetVersionInfo().split("\n");
        }
        LogUtil.e(TAG, "-------getHimaxFwVersion\uff1a" + this.mVersionArray == null ? "false" : "true");
        int index = 10;
        if (this.mVersionArray.length > index) {
            return this.mVersionArray[index];
        }
        return "\u65e0\u6cd5\u83b7\u77e5\u76f8\u673a\u540d\u79f0!";
    }

    public synchronized int setScanFaceMode() {
        this.mIsNowStreaming = true;
        LogUtil.e(TAG, "-------nativeScanFaceMode\uff1a-------start");
        int ret = NativeDeptrumSdk.nativeScanFaceMode();
        LogUtil.e(TAG, "-------nativeScanFaceMode\uff1a" + ret);
        return ret;
    }

    public synchronized int setScanCodeMode() {
        this.mIsNowStreaming = true;
        LogUtil.e(TAG, "-------nativeScanCodeMode\uff1a-------start");
        int ret = NativeDeptrumSdk.nativeScanCodeMode();
        LogUtil.e(TAG, "-------nativeScanCodeMode\uff1a" + ret);
        return ret;
    }

    public synchronized int setScanPalmMode() {
        this.mIsNowStreaming = true;
        LogUtil.e(TAG, "-------nativeScanPalmMode\uff1a-------start");
        int ret = NativeDeptrumSdk.nativeScanPalmMode();
        LogUtil.e(TAG, "-------nativeScanPalmMode\uff1a" + ret);
        return ret;
    }

    public synchronized int startUpgrade(String updatePath, IUpdateListener listener) {
        if (!this.mIsNowUpgrade) {
            this.mUpThread = new UpgradeThread(updatePath, listener);
            this.mUpThread.start();
        }
        return 0;
    }

    public synchronized int rollBack(IRollBackListener listener) {
        if (!this.mIsNowRollBack) {
            this.mRollThread = new RollBackThread(listener);
            this.mRollThread.start();
        }
        return 0;
    }

    public synchronized void openYt(int type) {
        NativeDeptrumSdk.nativeOpenYT(type);
    }

    public synchronized int configSet(String key, String value) {
        return NativeDeptrumSdk.nativeConfigSet(key, value);
    }

    public synchronized void saveDepth(String filePath, int width, int heigth, byte[] data) {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            outputStream.write(data);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            LogUtil.e(TAG, e.toString());
        }
    }

    public synchronized byte[] readDepth(String filePath, int width, int height) {
        File file = new File(filePath);
        byte[] depthData = null;
        if (!file.exists()) {
            return depthData;
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            depthData = new byte[width * height * 2];
            int readN = 0;
            while ((readN = inputStream.read(depthData)) != -1) {
                byteStream.write(depthData, 0, readN);
            }
        }
        catch (Exception e) {
            LogUtil.e(TAG, e.toString());
        }
        return depthData;
    }

    public int openPSensor() {
        LogUtil.e(TAG, "------openPSensor: ------start");
        int ret = 4;
        LogUtil.e(TAG, "-------openPSensor\uff1a" + ret);
        return ret;
    }

    public int closePSensor() {
        LogUtil.e(TAG, "------closePSensor: ------start");
        int ret = 4;
        LogUtil.e(TAG, "-------closePSensor\uff1a" + ret);
        return ret;
    }

    public boolean isPSensorHWSupport() {
        LogUtil.e(TAG, "------isPSensorHWSupport: ------start");
        boolean ret = false;
        LogUtil.e(TAG, "-------isPSensorHWSupport\uff1a" + ret);
        return ret;
    }

    public boolean isPSensorFactoryCali() {
        LogUtil.e(TAG, "------isPSensorFactoryCali: ------start");
        boolean ret = false;
        LogUtil.e(TAG, "-------isPSensorFactoryCali\uff1a" + ret);
        return ret;
    }

    public boolean isPSensorDefenseProtectTriggered() {
        LogUtil.e(TAG, "------isPSensorDefenseProtectTriggered: ------start");
        boolean ret = false;
        LogUtil.e(TAG, "-------isPSensorDefenseProtectTriggered\uff1a" + ret);
        return ret;
    }

    public int disablePSensorDefenseProtect() {
        LogUtil.e(TAG, "------disablePSensorDefenseProtect: ------start");
        int ret = 4;
        LogUtil.e(TAG, "-------disablePSensorDefenseProtect\uff1a" + ret);
        return ret;
    }

    public int setDFPTSTime(int times) {
        LogUtil.e(TAG, "------setDFPTSTime: ------start");
        int ret = 4;
        LogUtil.e(TAG, "-------setDFPTSTime\uff1a" + ret);
        return ret;
    }

    public void setPSensorListener(IPsensorListener listener) {
    }

    public int getCameraTemp(int type) {
        LogUtil.e(TAG, "------getCameraTemp: ------start");
        int ret = NativeDeptrumSdk.nativeGetCameraTemp(type);
        LogUtil.e(TAG, "-------getCameraTemp\uff1a" + ret);
        return ret;
    }

    public SNResult getSeSeriaNumber() {
        SNResult result = new SNResult();
        LogUtil.e(TAG, "------getSeSeriaNumber: ------start");
        int retCode = NativeDeptrumSdk.nativeGetSeSerialNumber(result);
        result.setRetCode(retCode);
        LogUtil.e(TAG, "-------getSeSeriaNumber retCode\uff1a " + retCode);
        return result;
    }

    public SdkVersionResult getSeSDKVersion() {
        SdkVersionResult result = new SdkVersionResult();
        LogUtil.e(TAG, "------getSeSDKVersion: ------start");
        int retCode = NativeDeptrumSdk.nativeGetSeSdkVersion(result);
        result.setRetCode(retCode);
        LogUtil.e(TAG, "-------getSeSDKVersion retCode\uff1a " + retCode);
        return result;
    }

    public CosTypeResult getSeCosType() {
        CosTypeResult result = new CosTypeResult();
        LogUtil.e(TAG, "------getSeCosType: ------start");
        int retCode = NativeDeptrumSdk.nativeGetSeCosType(result);
        result.setRetCode(retCode);
        LogUtil.e(TAG, "-------getSeCosType retCode \uff1a " + retCode);
        return result;
    }

    public FwVersionResult getSeFwVersion() {
        FwVersionResult result = new FwVersionResult();
        LogUtil.e(TAG, "------getSeFwVersion: ------start");
        int retCode = NativeDeptrumSdk.nativeGetSeFwVersion(result);
        result.setRetCode(retCode);
        LogUtil.e(TAG, "-------getSeFwVersion retCode\uff1a " + retCode);
        return result;
    }

    public FwRunModeResult getSeFwRunMode() {
        FwRunModeResult result = new FwRunModeResult();
        LogUtil.e(TAG, "------getSeFwRunMode: ------start");
        int retCode = NativeDeptrumSdk.nativeGetSeFwRunMode(result);
        result.setRetCode(retCode);
        LogUtil.e(TAG, "-------getSeFwRunMode retCode\uff1a " + retCode);
        return result;
    }

    public DisassemblyStatusResult getDisassemblyStatus() {
        DisassemblyStatusResult result = new DisassemblyStatusResult();
        LogUtil.e(TAG, "------getDisassemblyStatus: ------start");
        int retCode = NativeDeptrumSdk.nativeGetDisassemblyStatus(result);
        result.setRetCode(retCode);
        LogUtil.e(TAG, "-------getDisassemblyStatus retCode\uff1a " + retCode);
        return result;
    }

    public TimeStampResult getSeCurrentTimeStamp() {
        TimeStampResult result = new TimeStampResult();
        LogUtil.e(TAG, "------getSeCurrentTimeStamp: ------start");
        int retCode = NativeDeptrumSdk.nativeGetSeCurrentTimeStamp(result);
        result.setRetCode(retCode);
        LogUtil.e(TAG, "-------getSeCurrentTimeStamp retCode\uff1a " + retCode);
        return result;
    }

    public int setSeTimeStamp(long timeStamp) {
        LogUtil.e(TAG, "------setSeTimeStamp: ------start");
        int retCode = NativeDeptrumSdk.nativeSetSeTimeStamp(timeStamp);
        LogUtil.e(TAG, "-------setSeTimeStamp retCode\uff1a " + retCode);
        return retCode;
    }

    public UnlockCommandResult getUnlockCommand() {
        UnlockCommandResult result = new UnlockCommandResult();
        LogUtil.e(TAG, "------getUnlockCommand: ------start");
        int retCode = NativeDeptrumSdk.nativeGetUnlockCommand(result);
        result.setRetCode(retCode);
        LogUtil.e(TAG, "-------getUnlockCommand retCode\uff1a " + retCode);
        return result;
    }

    public int unlockSe(byte[] unlockCommand, int unlockCommandLen) {
        if (null == unlockCommand || unlockCommandLen != unlockCommand.length) {
            return 3;
        }
        LogUtil.e(TAG, "------unlockSe: ------start");
        int retCode = NativeDeptrumSdk.nativeUnlockSe(unlockCommand, unlockCommandLen);
        LogUtil.e(TAG, "-------unlockSe retCode\uff1a " + retCode);
        return retCode;
    }

    public int writeSeConfig(byte[] seConfigCommand, int seConfigCommandLen) {
        if (null == seConfigCommand || seConfigCommandLen != seConfigCommand.length) {
            return 3;
        }
        LogUtil.e(TAG, "------writeSeConfig: ------start");
        int retCode = NativeDeptrumSdk.nativeWriteSeConfig(seConfigCommand, seConfigCommandLen);
        LogUtil.e(TAG, "-------writeSeConfig retCode\uff1a " + retCode);
        return retCode;
    }

    public ConfigSm3HashValueResult getConfigSm3HashValue() {
        ConfigSm3HashValueResult result = new ConfigSm3HashValueResult();
        LogUtil.e(TAG, "------getConfigSm3HashValue: ------start");
        int retCode = NativeDeptrumSdk.nativeGetConfigSm3HashValue(result);
        result.setRetCode(retCode);
        LogUtil.e(TAG, "-------getConfigSm3HashValue retCode\uff1a " + retCode);
        return result;
    }

    public InspectRequestParamResult getInspectRequestParam() {
        InspectRequestParamResult result = new InspectRequestParamResult();
        LogUtil.e(TAG, "------getInspectRequestParam: ------start");
        int retCode = NativeDeptrumSdk.nativeGetInspectRequestParam(result);
        result.setRetCode(retCode);
        LogUtil.e(TAG, "-------getInspectRequestParam retCode\uff1a " + retCode);
        return result;
    }

    public AuthSignResult computePartAuthSign(byte[] payLoad, int payLoadLen) {
        AuthSignResult result = new AuthSignResult();
        if (null == payLoad || payLoadLen != payLoad.length) {
            result.setRetCode(3);
            return result;
        }
        LogUtil.e(TAG, "------computePartAuthSign: ------start");
        int retCode = NativeDeptrumSdk.nativeComputePartAuthSign(payLoad, payLoadLen, result);
        result.setRetCode(retCode);
        LogUtil.e(TAG, "-------computePartAuthSign retCode\uff1a " + retCode);
        return result;
    }

    public synchronized byte[] drawDepthMapInColor(int rows, int cols, int range_min, int range_mid, int range_max, byte[] depth_map) {
        return NativeDeptrumSdk.nativeDrawDepthMapInColor(rows, cols, range_min, range_mid, range_max, depth_map);
    }

    private DeptrumCameraInfo enumDevice() {
        if (null == this.mWeakRef || null == this.mUsbManager) {
            return null;
        }
        DeptrumCameraInfo cameraInfo = null;
        HashMap deviceList = this.mUsbManager.getDeviceList();
        for (UsbDevice device : deviceList.values()) {
            if (device.getProductId() != 6400) continue;
            this.mUsbManager.requestPermission(device, this.mPendingIntent);
            cameraInfo = this.createCameraInfo(device);
        }
        return cameraInfo;
    }

    private void enumDeviceDelay(final IDelay<DeptrumCameraInfo> iDelay) {
        final DeptrumCameraInfo[] cameraInfo = new DeptrumCameraInfo[]{null};
        HashMap deviceList = this.mUsbManager.getDeviceList();
        for (final UsbDevice device : deviceList.values()) {
            if (device.getProductId() != 6400) continue;
            if (Looper.myLooper() == Looper.getMainLooper()) {
                LogUtil.e(TAG, "Caller is Main Thread");
                if (!this.mUsbManager.hasPermission(device)) {
                    LogUtil.e(TAG, "usbManager requestPermission");
                    this.mUsbManager.requestPermission(device, this.mPendingIntent);
                    this.mainHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (iDelay != null) {
                                cameraInfo[0] = DeptrumSdkApi.this.createCameraInfo(device);
                                iDelay.call(cameraInfo[0]);
                            }
                        }
                    }, 400L);
                    continue;
                }
                LogUtil.e(TAG, "device has Permission");
                cameraInfo[0] = this.createCameraInfo(device);
                iDelay.call(cameraInfo[0]);
                continue;
            }
            LogUtil.e(TAG, "Caller is Child Thread");
            if (!this.mUsbManager.hasPermission(device)) {
                LogUtil.e(TAG, "usbManager requestPermission");
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        DeptrumSdkApi.this.mUsbManager.requestPermission(device, DeptrumSdkApi.this.mPendingIntent);
                    }
                });
                this.countDownLatch = new CountDownLatch(1);
                try {
                    this.countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.countDownLatch = null;
                if (iDelay == null) continue;
                cameraInfo[0] = this.createCameraInfo(device);
                iDelay.call(cameraInfo[0]);
                continue;
            }
            LogUtil.e(TAG, "device has Permission");
            cameraInfo[0] = this.createCameraInfo(device);
            iDelay.call(cameraInfo[0]);
        }
    }

    private boolean isAurora900Device() {
        if (null == this.mWeakRef || null == this.mUsbManager) {
            return false;
        }
        HashMap deviceList = this.mUsbManager.getDeviceList();
        for (UsbDevice device : deviceList.values()) {
            if (device.getProductId() != 6400) continue;
            return true;
        }
        return false;
    }

    private DeptrumCameraInfo createCameraInfo(UsbDevice device) {
        String[] v;
        DeptrumCameraInfo cameraInfo = new DeptrumCameraInfo();
        cameraInfo.setPid(device.getProductId());
        cameraInfo.setVid(device.getVendorId());
        cameraInfo.setName(device.getDeviceName());
        cameraInfo.setDeviceAddr(device.getDeviceId());
        cameraInfo.setSerialNumber(device.getSerialNumber());
        String name = device.getDeviceName();
        String usbfs = "/dev/bus/usb";
        cameraInfo.setUsbFs(usbfs);
        String[] stringArray = v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
        if (v != null) {
            cameraInfo.setBusNum(Integer.parseInt(v[v.length - 2]));
            cameraInfo.setDeviceAddr(Integer.parseInt(v[v.length - 1]));
        }
        try {
            UsbDeviceConnection connection;
            cameraInfo.setFd(-1);
            if (null != this.mWeakRef && null != (connection = this.mUsbManager.openDevice(device))) {
                cameraInfo.setFd(connection.getFileDescriptor());
                this.mConnection = connection;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cameraInfo;
    }

    public boolean checkContextType(Context context) {
        return context instanceof Activity || context instanceof Application;
    }

    public void registerUsbReceiver(Context context, String[] actions) {
        if (this.mHasRegister) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        for (String action : actions) {
            filter.addAction(action);
        }
        if (null != this.usbReceiver && null != this.mContext) {
            this.mContext.registerReceiver(this.usbReceiver, filter);
            this.mHasRegister = true;
        }
    }

    public void unRegisterUsbReceiver(Context context) {
        if (this.mHasRegister && null != this.usbReceiver && null != this.mContext) {
            this.mContext.unregisterReceiver(this.usbReceiver);
            this.mHasRegister = false;
        }
    }

    public int openIrAeCheck() {
        LogUtil.e(TAG, "------openIrAeCheck: ------start");
        int ret = NativeDeptrumSdk.nativeOpenIrAeCheck();
        LogUtil.e(TAG, "-------openIrAeCheck\uff1a" + ret);
        return ret;
    }

    public int closeIrAeCheck() {
        LogUtil.e(TAG, "------closeIrAeCheck: ------start");
        int ret = NativeDeptrumSdk.nativeCloseIrAeCheck();
        LogUtil.e(TAG, "-------closeIrAeCheck\uff1a" + ret);
        return ret;
    }

    public int openColorSign() {
        LogUtil.e(TAG, "------openColorSign: ------start");
        int ret = NativeDeptrumSdk.nativeOpenColorSign();
        LogUtil.e(TAG, "-------openColorSign\uff1a" + ret);
        return ret;
    }

    public int closeColorSign() {
        LogUtil.e(TAG, "------closeColorSign: ------start");
        int ret = NativeDeptrumSdk.nativeCloseColorSign();
        LogUtil.e(TAG, "-------closeColorSign\uff1a" + ret);
        return ret;
    }

    public void getDeviceDebugInfo(DeviceLoggerInfo info) {
        LogUtil.e(TAG, "------getDeviceDebugInfo: ------start");
        if (null == info) {
            return;
        }
        NativeDeptrumSdk.nativeGetDeviceDebugInfo(info);
        info.setDoeStatus(NativeDeptrumSdk.nativeGetDoeStatus());
        LogUtil.d(TAG, info.toString());
        LogUtil.e(TAG, "------getDeviceDebugInfo: ------end");
    }

    public synchronized int setLaserDriver(int mode) {
        LogUtil.e(TAG, "-------setLaserDriver\uff1a-------start");
        int ret = NativeDeptrumSdk.nativeSetLaserDriver(mode);
        LogUtil.e(TAG, "-------setLaserDriver\uff1a" + ret);
        return ret;
    }

    private void setLoggerListener() {
        LogUtil.e(TAG, "-------setLoggerListener");
        NativeDeptrumSdk.nativeSetLoggerListener(this.mILoggerListener);
    }

    private void setItoListener() {
        LogUtil.e(TAG, "-------setItoListener");
        NativeDeptrumSdk.nativeSetItoListener(this.mITOListener);
    }

    private class RollBackThread
    extends Thread {
        IRollBackListener rollBackListener;

        RollBackThread(IRollBackListener listener) {
            this.rollBackListener = listener;
        }

        @Override
        public void run() {
            DeptrumSdkApi.this.mIsNowRollBack = true;
            if (!DeptrumSdkApi.this.mIsNowOpen) {
                DeptrumCameraInfo cameraInfo = DeptrumSdkApi.this.enumDevice();
                if (null == cameraInfo && null != this.rollBackListener) {
                    this.rollBackListener.onRollBackFail("\u76f8\u673a\u672a\u8fde\u63a5!");
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int ret = NativeDeptrumSdk.nativeOpenDevice(cameraInfo);
                if (ret > 0) {
                    if (null != this.rollBackListener) {
                        this.rollBackListener.onRollBackFail("\u76f8\u673aopen\u5931\u8d25\uff0c\u9519\u8bef\u7801:" + ret);
                    }
                    DeptrumSdkApi.this.mIsNowRollBack = false;
                    NativeDeptrumSdk.nativeCloseDevice();
                    return;
                }
            }
            long time = System.currentTimeMillis();
            int ret = NativeDeptrumSdk.nativeVersionRollback();
            if (null != this.rollBackListener) {
                if (ret > 0) {
                    this.rollBackListener.onRollBackFail("Rollback\u56de\u6eda\u5931\u8d25\uff0c\u9519\u8bef\u7801:" + ret);
                    DeptrumSdkApi.this.mIsNowRollBack = false;
                    NativeDeptrumSdk.nativeCloseDevice();
                    return;
                }
                this.rollBackListener.onRollBackStart();
            }
            long timeThres = 0L;
            while (timeThres <= 30000L) {
                timeThres = System.currentTimeMillis() - time;
                long thresTemp = timeThres;
                if (thresTemp % 300L != 0L || null == this.rollBackListener) continue;
                this.rollBackListener.onRollBackProgress((int)(thresTemp / 300L));
            }
            NativeDeptrumSdk.nativeCloseDevice();
            int openCount = 0;
            int openRet = 0;
            while (openCount <= 30) {
                DeptrumCameraInfo cameraInfo;
                ++openCount;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (null == (cameraInfo = DeptrumSdkApi.this.enumDevice()) || (openRet = NativeDeptrumSdk.nativeOpenDevice(cameraInfo)) != 0) continue;
                break;
            }
            NativeDeptrumSdk.nativeCloseDevice();
            if (openRet > 0) {
                if (null != this.rollBackListener) {
                    this.rollBackListener.onRollBackTimeout();
                }
                DeptrumSdkApi.this.mIsNowRollBack = false;
                return;
            }
            if (null != this.rollBackListener) {
                this.rollBackListener.onRollBackSuccess();
            }
            DeptrumSdkApi.this.mIsNowRollBack = false;
            DeptrumSdkApi.this.mIsNowOpen = false;
        }
    }

    private class UpgradeThread
    extends Thread {
        String updatePath;
        IUpdateListener updateListener;
        int transferResult = 0;

        UpgradeThread(String path, IUpdateListener listener) {
            this.updatePath = path;
            this.updateListener = listener;
        }

        @Override
        public void run() {
            DeptrumSdkApi.this.mIsNowUpgrade = true;
            File updateFile = new File(this.updatePath);
            if (!updateFile.exists()) {
                if (null != this.updateListener) {
                    this.updateListener.onUpdateFail("\u6307\u5b9a\u66f4\u65b0\u6587\u4ef6\u4e0d\u5b58\u5728!");
                }
                DeptrumSdkApi.this.mIsNowUpgrade = false;
                return;
            }
            if (!DeptrumSdkApi.this.mIsNowOpen) {
                DeptrumCameraInfo cameraInfo = DeptrumSdkApi.this.enumDevice();
                if (null == cameraInfo && null != this.updateListener) {
                    this.updateListener.onUpdateFail("\u76f8\u673a\u672a\u8fde\u63a5!");
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int ret = NativeDeptrumSdk.nativeOpenDevice(cameraInfo);
                if (ret > 0) {
                    if (null != this.updateListener) {
                        this.updateListener.onUpdateFail("\u76f8\u673aopen\u5931\u8d25\uff0c\u9519\u8bef\u7801:" + ret);
                    }
                    DeptrumSdkApi.this.mIsNowUpgrade = false;
                    return;
                }
            }
            long time = System.currentTimeMillis();
            int ret = NativeDeptrumSdk.nativeUpgrade(this.updatePath, "update.tar.gz", this.updateListener);
            if (null != this.updateListener) {
                if (ret > 0) {
                    this.updateListener.onUpdateFail("startUpgrade\u5347\u7ea7\u5931\u8d25\uff0c\u9519\u8bef\u7801:" + ret);
                    DeptrumSdkApi.this.mIsNowUpgrade = false;
                    return;
                }
                this.updateListener.onUpdateStart();
            }
            transfering = true;
            this.transferResult = 0;
            NativeDeptrumSdk.nativeSetUpdateListener(new INativeUpdateListener(){

                @Override
                public void onUpdateResult(int event) {
                    LogUtil.e(DeptrumSdkApi.TAG, "onUpdateResult event " + event);
                    transfering = false;
                    UpgradeThread.this.transferResult = event;
                }
            });
            long timeThres = 0L;
            while (timeThres <= 120000L) {
                timeThres = System.currentTimeMillis() - time;
                long thresTemp = timeThres;
                if (thresTemp % 1200L != 0L) continue;
                if (null != this.updateListener) {
                    this.updateListener.onUpdateProgress((int)(thresTemp / 1200L));
                }
                if (transfering) continue;
                LogUtil.e(DeptrumSdkApi.TAG, "UpgradeThread break");
                if (null == this.updateListener) break;
                this.updateListener.onUpdateProgress(100);
                break;
            }
            if (transfering) {
                LogUtil.e(DeptrumSdkApi.TAG, "UpgradeThread transfering  timeout");
                NativeDeptrumSdk.nativeCloseDevice();
                if (null != this.updateListener) {
                    this.updateListener.onUpdateFail("startUpgrade\u5347\u7ea7\u5931\u8d25\uff0c\u9519\u8bef\u7801:139280");
                    DeptrumSdkApi.this.mIsNowUpgrade = false;
                }
                return;
            }
            if (0 != this.transferResult) {
                LogUtil.e(DeptrumSdkApi.TAG, "UpgradeThread transferResult " + this.transferResult);
                NativeDeptrumSdk.nativeCloseDevice();
                if (null != this.updateListener) {
                    this.updateListener.onUpdateFail("startUpgrade\u5347\u7ea7\u5931\u8d25\uff0c\u9519\u8bef\u7801:" + this.transferResult);
                    DeptrumSdkApi.this.mIsNowUpgrade = false;
                }
                return;
            }
            LogUtil.e(DeptrumSdkApi.TAG, "UpgradeThread sleep 15 s");
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            NativeDeptrumSdk.nativeCloseDevice();
            int openCount = 0;
            int openRet = 0;
            while (openCount <= 30) {
                DeptrumCameraInfo cameraInfo;
                ++openCount;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (null == (cameraInfo = DeptrumSdkApi.this.enumDevice()) || (openRet = NativeDeptrumSdk.nativeOpenDevice(cameraInfo)) != 0) continue;
                break;
            }
            if (openRet > 0) {
                if (null != this.updateListener) {
                    this.updateListener.onUpdateTimeout();
                }
                DeptrumSdkApi.this.mIsNowUpgrade = false;
                return;
            }
            NativeDeptrumSdk.nativeCloseDevice();
            DeptrumSdkApi.this.mIsNowUpgrade = false;
            DeptrumSdkApi.this.mIsNowOpen = false;
            if (null != this.updateListener) {
                this.updateListener.onUpdateSuccess();
            }
        }
    }
}

