/*
 * Decompiled with CFR 0.152.
 */
package android_serialport_api;

import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class SerialPort {
    private static final String TAG = "SerialPort";
    private FileDescriptor mFd;
    private FileInputStream mFileInputStream;
    private FileOutputStream mFileOutputStream;

    static {
        System.loadLibrary("serial_port");
    }

    public SerialPort(File device, int baudrate, int flags) throws SecurityException, IOException {
        if (!device.canRead() || !device.canWrite()) {
            try {
                Log.e((String)TAG, (String)"1============================");
                Process su = Runtime.getRuntime().exec("/system/xbin/su");
                String cmd = "chmod 666 " + device.getAbsolutePath();
                Log.e((String)TAG, (String)("cmd=====================" + cmd));
                Runtime.getRuntime().exec(cmd);
                if (!device.canRead() || !device.canWrite()) {
                    Log.e((String)TAG, (String)"2=====================");
                    throw new SecurityException();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"3=================");
                e.printStackTrace();
                throw new SecurityException();
            }
        }
        this.mFd = SerialPort.open(device.getAbsolutePath(), baudrate, flags);
        if (this.mFd == null) {
            Log.e((String)TAG, (String)"native open returns null");
            throw new IOException();
        }
        this.mFileInputStream = new FileInputStream(this.mFd);
        this.mFileOutputStream = new FileOutputStream(this.mFd);
    }

    public InputStream getInputStream() {
        return this.mFileInputStream;
    }

    public OutputStream getOutputStream() {
        return this.mFileOutputStream;
    }

    String do_exec(String cmd) {
        String s = "/n";
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null) {
                s = String.valueOf(s) + line + "/n";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cmd;
    }

    private static native FileDescriptor open(String var0, int var1, int var2);

    public native void close();
}

