/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.decode;

public class Decode {
    static {
        System.loadLibrary("decode");
    }

    public static synchronized void open() throws Exception {
        int ret = Decode.decode_open();
        if (ret != 0) {
            if (ret == -1) {
                throw new Exception("unknown device");
            }
            if (ret == -2) {
                throw new Exception("invalid baudrate");
            }
            if (ret == -3) {
                throw new Exception("cannot open port");
            }
            if (ret == -4) {
                throw new Exception("tcgetattr() failed");
            }
            if (ret == -5) {
                throw new Exception("tcsetattr() failed");
            }
            if (ret == -6) {
                throw new Exception("externcard already opened");
            }
            if (ret == -7) {
                throw new Exception("cannot open externcard");
            }
            if (ret == -8) {
                throw new Exception("switch to qrcode error");
            }
        }
    }

    public static synchronized void close() {
        Decode.decode_close();
    }

    public static synchronized byte[] readWithFormat(int timeout) throws Exception {
        byte[] array = new byte[2048];
        byte[] array1 = new byte[2048];
        int ret = Decode.decode_read(timeout, array);
        if (ret < 0) {
            if (ret == -2) {
                throw new Exception("Read Timeout");
            }
            throw new Exception("Read Error");
        }
        if (array[0] != 3) {
            throw new Exception("Invalid Format");
        }
        System.arraycopy(array, 5, array1, 0, array[6] * 256 + array[7] + 3);
        return array1;
    }

    public static synchronized String read(int timeout) throws Exception {
        byte[] array = new byte[2048];
        int ret = Decode.decode_read(timeout, array);
        if (ret < 0) {
            if (ret == -2) {
                throw new Exception("Read Timeout");
            }
            throw new Exception("Read Error");
        }
        String data = new String(array, 0, ret, "UTF-8");
        return data;
    }

    private static native int decode_open();

    private static native void decode_close();

    private static native int decode_read(int var0, byte[] var1);
}

