/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.iccard;

import android.content.Context;
import android.content.Intent;
import com.telpo.tps550.api.DeviceNotOpenException;
import com.telpo.tps550.api.InternalErrorException;
import com.telpo.tps550.api.NotSupportYetException;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.TimeoutException;
import com.telpo.tps550.api.iccard.AuthorityFailException;
import com.telpo.tps550.api.iccard.CommunicationErrorException;
import com.telpo.tps550.api.iccard.NoAuthorityCardException;
import com.telpo.tps550.api.iccard.RemovedCardException;

public class Picc {
    public static final int PICC_M1_TYPE_A = 0;
    public static final int PICC_M1_TYPE_B = 1;
    public static final int PICC_CARD_TYPE_ERROER = -1;
    public static final int PICC_CARD_TYPE_CPU = 1;
    public static final int PICC_CARD_TYPE_M1 = 2;
    public static final int PICC_CARD_TYPE_UL = 3;

    static {
        System.loadLibrary("picc");
    }

    private static native int open(int var0);

    private static native int close();

    private static native int check_card(byte[] var0, int[] var1);

    private static native int check_card_sak(byte[] var0, int[] var1, byte[] var2, byte[] var3);

    private static native int halt_card();

    private static native int reset_card();

    private static native int transmit(byte[] var0, int var1, byte[] var2, int[] var3);

    private static native int m1_authority(int var0, int var1, byte[] var2);

    private static native int m1_read(int var0, byte[] var1);

    private static native int m1_write(int var0, byte[] var1);

    private static native int m1_add_sub(int var0, int var1, byte[] var2);

    private static native int ultralight_read(int var0, byte[] var1);

    private static native int ultralight_write(int var0, byte[] var1);

    private static native int get_last_error();

    private static native int get_reader_info(byte[] var0);

    private static native int set_baudrate(int var0);

    private static native int enter_cpu_model();

    private static TelpoException getException(int ret) {
        switch (Picc.get_last_error()) {
            case 0: {
                switch (ret) {
                    case -1: {
                        return new DeviceNotOpenException();
                    }
                    case -10: {
                        return new NotSupportYetException();
                    }
                }
                return new InternalErrorException();
            }
            case 1: {
                return new RemovedCardException("There is no valid card found!");
            }
            case 4: 
            case 9: {
                return new AuthorityFailException();
            }
            case 10: {
                return new NoAuthorityCardException();
            }
            case 27: {
                return new TimeoutException();
            }
        }
        return new CommunicationErrorException();
    }

    public static void openReader() throws TelpoException {
        int ret = Picc.open(9600);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static void openReader(int baudrate) throws TelpoException {
        if (baudrate != 4800 && baudrate != 9600 && baudrate != 19200 && baudrate != 38400 && baudrate != 57600 && baudrate != 115200) {
            throw new IllegalArgumentException();
        }
        int ret = Picc.open(baudrate);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static void openReader(Context context) throws TelpoException {
        int ret = Picc.open(9600);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
        context.sendBroadcast(new Intent("com.telpo.rfid.picc.start"));
    }

    public static void closeReader() {
        Picc.close();
    }

    public static void closeReader(Context context) {
        Picc.close();
        context.sendBroadcast(new Intent("com.telpo.rfid.picc.stop"));
    }

    public static int selectCard(byte[] sn, byte[] sak, byte[] tag) throws TelpoException {
        int[] recLen = new int[2];
        if (sn == null) {
            throw new IllegalArgumentException();
        }
        int ret = Picc.check_card_sak(sn, recLen, sak, tag);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
        return recLen[0];
    }

    public static void haltCard() throws TelpoException {
        int ret = Picc.halt_card();
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static void resetReader() throws TelpoException {
        int ret = Picc.reset_card();
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static int command(byte[] snd, int sndLen, byte[] rcv) throws TelpoException {
        int[] recLen = new int[2];
        if (snd == null || rcv == null) {
            throw new IllegalArgumentException();
        }
        int ret = Picc.transmit(snd, sndLen, rcv, recLen);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
        return recLen[0];
    }

    public static void m1Authority(int type, int sectorNo, byte[] password) throws TelpoException {
        if (type != 0 && type != 1 || password == null) {
            throw new IllegalArgumentException();
        }
        int ret = Picc.m1_authority(type, sectorNo, password);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static void m1Read(int blockNo, byte[] buffer) throws TelpoException {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int ret = Picc.m1_read(blockNo, buffer);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static void m1Write(int blockNo, byte[] buffer) throws TelpoException {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int ret = Picc.m1_write(blockNo, buffer);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static void m1Add(int blockNo, byte[] value) throws TelpoException {
        int ret = Picc.m1_add_sub(0, blockNo, value);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static void m1Sub(int blockNo, byte[] value) throws TelpoException {
        int ret = Picc.m1_add_sub(1, blockNo, value);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static void getReaderInfo(byte[] result) throws TelpoException {
        if (result == null) {
            throw new IllegalArgumentException();
        }
        int ret = Picc.get_reader_info(result);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static void ultralightRead(int blockNo, byte[] buffer) throws TelpoException {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int ret = Picc.ultralight_read(blockNo, buffer);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static void ultralightWrite(int blockNo, byte[] buffer) throws TelpoException {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int ret = Picc.ultralight_write(blockNo, buffer);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static void setReaderBaudrate(int cnt) throws TelpoException {
        if (cnt != 0 && cnt != 1 && cnt != 2 && cnt != 3 && cnt != 4 && cnt != 5) {
            throw new IllegalArgumentException();
        }
        int ret = Picc.set_baudrate(cnt);
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }

    public static void enterCpuModel() throws TelpoException {
        int ret = Picc.enter_cpu_model();
        if (ret != 0) {
            throw Picc.getException(ret);
        }
    }
}

