/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.idcard;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.idcard.IdCardNotCheckException;
import com.telpo.tps550.api.idcard.IdentityMsg;
import com.telpo.tps550.api.idcard.ImageDecodeException;
import com.telpo.tps550.api.util.ReaderUtils;
import com.zkteco.android.IDReader.IDPhotoHelper;
import com.zkteco.android.IDReader.WLTService;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

@SuppressLint(value={"NewApi"})
public class BlueToothIdCard {
    private static final String TAG = "TELPO_SDK";
    static String[] nation_list = new String[]{"\u6c49", "\u8499\u53e4", "\u56de", "\u85cf", "\u7ef4\u543e\u5c14", "\u82d7", "\u5f5d", "\u58ee", "\u5e03\u4f9d", "\u671d\u9c9c", "\u6ee1", "\u4f97", "\u7476", "\u767d", "\u571f\u5bb6", "\u54c8\u5c3c", "\u54c8\u8428\u514b", "\u50a3", "\u9ece", "\u5088\u50f3", "\u4f64", "\u7572", "\u9ad8\u5c71", "\u62c9\u795c", "\u6c34", "\u4e1c\u4e61", "\u7eb3\u897f", "\u666f\u9887", "\u67ef\u5c14\u514b\u5b5c", "\u571f", "\u8fbe\u65a1\u5c14", "\u4eeb\u4f6c", "\u7f8c", "\u5e03\u6717", "\u6492\u62c9", "\u6bdb\u5357", "\u4ee1\u4f6c", "\u9521\u4f2f", "\u963f\u660c", "\u666e\u7c73", "\u5854\u5409\u514b", "\u6012", "\u4e4c\u5b5c\u522b\u514b", "\u4fc4\u7f57\u65af", "\u9102\u6e29\u514b", "\u5fb7\u6602", "\u4fdd\u5b89", "\u88d5\u56fa", "\u4eac", "\u5854\u5854\u5c14", "\u72ec\u9f99", "\u9102\u4f26\u6625", "\u8d6b\u54f2", "\u95e8\u5df4", "\u73de\u5df4", "\u57fa\u8bfa", "\u5176\u4ed6", "\u5916\u56fd\u8840\u7edf\u4e2d\u56fd\u7c4d\u4eba\u58eb"};
    private int contentLength;
    private int imageDatalength;
    private int fplength;
    private static final UUID SERVICE_WRITE_UUID = UUID.fromString("0000ffe5-0000-1000-8000-00805f9b34fb");
    private static final UUID SERVICE_NOTIFY_UUID = UUID.fromString("0000ffe0-0000-1000-8000-00805f9b34fb");
    private static final UUID CHARACTERISTIC_OUTPUT_UUID = UUID.fromString("0000ffe9-0000-1000-8000-00805f9b34fb");
    private static final UUID CHARACTERISTIC_NOTIFY_UUID = UUID.fromString("0000ffe4-0000-1000-8000-00805f9b34fb");
    private BluetoothGatt gatt = null;
    private Context mContext = null;
    private static byte[] receiveData = null;
    private static byte[] sendData = null;
    public int charSendBufferPos = 0;
    private static BluetoothGattCharacteristic writeCharacteristic;
    private static BluetoothGattCharacteristic notifyCharacteristic;
    private int currentStep = 0;
    private static final int STEP_CHECK = 0;
    private static final int STEP_SELECT = 1;
    private static final int STEP_READ = 2;
    public boolean isConnect = false;
    private static final byte[] SAM_HEADER;
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            if (newState == 2) {
                gatt.discoverServices();
                Log.i((String)BlueToothIdCard.TAG, (String)"Connected to GATT server.");
            } else if (newState == 0) {
                Log.i((String)BlueToothIdCard.TAG, (String)"Disconnected from GATT server.");
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            if (status == 0) {
                BluetoothGattCharacteristic c;
                Log.i((String)BlueToothIdCard.TAG, (String)"onServicesDiscovered");
                List services = gatt.getServices();
                BluetoothGattService wirte_service = null;
                BluetoothGattService notify_service = null;
                int i = 0;
                while (i < services.size()) {
                    BluetoothGattService s = (BluetoothGattService)services.get(i);
                    Log.d((String)BlueToothIdCard.TAG, (String)("service " + i + ":" + s.getUuid().toString()));
                    if (SERVICE_WRITE_UUID.toString().equals(s.getUuid().toString())) {
                        wirte_service = s;
                    }
                    if (SERVICE_NOTIFY_UUID.toString().equals(s.getUuid().toString())) {
                        notify_service = s;
                    }
                    ++i;
                }
                List characteristics = wirte_service.getCharacteristics();
                int i2 = 0;
                while (i2 < characteristics.size()) {
                    c = (BluetoothGattCharacteristic)characteristics.get(i2);
                    Log.d((String)BlueToothIdCard.TAG, (String)("characteristic " + i2 + ":" + c.getUuid().toString()));
                    if (CHARACTERISTIC_OUTPUT_UUID.toString().equals(c.getUuid().toString())) {
                        writeCharacteristic = c;
                    }
                    ++i2;
                }
                characteristics = notify_service.getCharacteristics();
                i2 = 0;
                while (i2 < characteristics.size()) {
                    c = (BluetoothGattCharacteristic)characteristics.get(i2);
                    Log.d((String)BlueToothIdCard.TAG, (String)("characteristic " + i2 + ":" + c.getUuid().toString()));
                    if (CHARACTERISTIC_NOTIFY_UUID.toString().equals(c.getUuid().toString())) {
                        notifyCharacteristic = c;
                    }
                    ++i2;
                }
                if (writeCharacteristic != null && notifyCharacteristic != null && BlueToothIdCard.this.isCharacteristicWritable(writeCharacteristic) && BlueToothIdCard.this.isCharacteristicNotifiable(notifyCharacteristic)) {
                    boolean success = gatt.setCharacteristicNotification(notifyCharacteristic, true);
                    if (success) {
                        Log.d((String)BlueToothIdCard.TAG, (String)"\u8fde\u63a5\u6210\u529f");
                        BlueToothIdCard.this.isConnect = true;
                    } else {
                        Log.d((String)BlueToothIdCard.TAG, (String)"\u8fde\u63a5\u5931\u8d25");
                        BlueToothIdCard.this.isConnect = false;
                    }
                } else {
                    Log.d((String)BlueToothIdCard.TAG, (String)"\u672a\u77e5\u8bbe\u5907");
                    BlueToothIdCard.this.isConnect = false;
                }
            } else {
                Log.d((String)BlueToothIdCard.TAG, (String)"\u8fde\u63a5\u5931\u8d25");
                BlueToothIdCard.this.isConnect = false;
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            Log.d((String)BlueToothIdCard.TAG, (String)("characteristic uuid = " + characteristic.getUuid().toString()));
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            byte[] receive = characteristic.getValue();
            Log.d((String)BlueToothIdCard.TAG, (String)("onCharacteristicChanged------>" + ReaderUtils.byte2HexString(receive)));
            if (receive != null && receive.length > 0) {
                receiveData = ReaderUtils.merge(receiveData, receive);
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            Log.d((String)BlueToothIdCard.TAG, (String)("onCharacteristicWrite------>" + ReaderUtils.byte2HexString(characteristic.getValue())));
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.d((String)BlueToothIdCard.TAG, (String)("onDescriptorRead------>" + ReaderUtils.byte2HexString(descriptor.getValue())));
            Log.d((String)BlueToothIdCard.TAG, (String)("descriptor uuid = " + descriptor.getUuid().toString()));
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.d((String)BlueToothIdCard.TAG, (String)("onDescriptorWrite------>" + ReaderUtils.byte2HexString(descriptor.getValue())));
            Log.d((String)BlueToothIdCard.TAG, (String)("descriptor uuid = " + descriptor.getUuid().toString()));
        }

        public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
            Log.d((String)BlueToothIdCard.TAG, (String)("onReliableWriteCompleted------>" + status));
        }
    };

    static {
        SAM_HEADER = new byte[]{-86, -86, -86, -106, 105};
    }

    public BlueToothIdCard(Context context) {
        this.mContext = context;
    }

    public void connectDevice(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice != null) {
            this.gatt = bluetoothDevice.connectGatt(this.mContext, false, this.mGattCallback);
        }
    }

    private boolean isCharacteristicReadable(BluetoothGattCharacteristic characteristic) {
        return (characteristic.getProperties() & 2) > 0;
    }

    private boolean isCharacteristicWritable(BluetoothGattCharacteristic characteristic) {
        return (characteristic.getProperties() & 8) > 0 || (characteristic.getProperties() & 4) > 0;
    }

    private boolean isCharacteristicNotifiable(BluetoothGattCharacteristic characteristic) {
        return (characteristic.getProperties() & 0x10) > 0 || (characteristic.getProperties() & 0x20) > 0;
    }

    private byte[] packageCommand(byte[] data2send) {
        if (data2send != null && data2send.length > 0) {
            int len = data2send.length;
            int pos = 0;
            byte crc = 0;
            byte[] result = new byte[4 + len + 2];
            result[pos++] = 104;
            result[pos++] = (byte)(len % 255);
            result[pos++] = (byte)(len / 255);
            result[pos++] = 104;
            byte[] byArray = data2send;
            int n = data2send.length;
            int n2 = 0;
            while (n2 < n) {
                byte d = byArray[n2];
                result[pos++] = d;
                crc = (byte)(crc ^ d);
                ++n2;
            }
            result[pos++] = crc;
            result[pos++] = 22;
            return result;
        }
        return null;
    }

    private void sendCommand() {
        int Len = 20;
        if (this.charSendBufferPos + 20 > sendData.length) {
            Len = (byte)(sendData.length - this.charSendBufferPos);
        }
        byte[] value1 = new byte[Len];
        int i = 0;
        while (i < Len) {
            value1[i] = sendData[i + this.charSendBufferPos];
            i = (byte)(i + 1);
        }
        writeCharacteristic.setValue(value1);
        Log.d((String)"TAG", (String)"before write");
        this.gatt.writeCharacteristic(writeCharacteristic);
        Log.d((String)"TAG", (String)"after write");
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.charSendBufferPos += Len;
        if (this.charSendBufferPos == sendData.length) {
            this.charSendBufferPos = 0;
        }
        this.charSendBufferPos %= sendData.length;
    }

    public IdentityMsg checkIdCard() {
        byte[] data2send = null;
        byte[] stepReceiveData = null;
        receiveData = null;
        byte[] byArray = new byte[10];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 3;
        byArray[7] = 32;
        byArray[8] = 1;
        byArray[9] = 34;
        data2send = byArray;
        if (data2send != null && data2send.length > 0 && (sendData = this.packageCommand(data2send)) != null) {
            this.sendCommand();
            this.currentStep = 0;
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        stepReceiveData = this.checkReceivedData();
        receiveData = null;
        byte[] byArray2 = new byte[10];
        byArray2[0] = -86;
        byArray2[1] = -86;
        byArray2[2] = -86;
        byArray2[3] = -106;
        byArray2[4] = 105;
        byArray2[6] = 3;
        byArray2[7] = 32;
        byArray2[8] = 2;
        byArray2[9] = 33;
        data2send = byArray2;
        if (data2send != null && data2send.length > 0 && (sendData = this.packageCommand(data2send)) != null) {
            this.sendCommand();
            this.currentStep = 1;
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        stepReceiveData = this.checkReceivedData();
        receiveData = null;
        byte[] byArray3 = new byte[10];
        byArray3[0] = -86;
        byArray3[1] = -86;
        byArray3[2] = -86;
        byArray3[3] = -106;
        byArray3[4] = 105;
        byArray3[6] = 3;
        byArray3[7] = 48;
        byArray3[8] = 16;
        byArray3[9] = 35;
        data2send = byArray3;
        if (data2send != null && data2send.length > 0 && (sendData = this.packageCommand(data2send)) != null) {
            this.sendCommand();
            this.currentStep = 2;
        }
        stepReceiveData = this.checkReceivedData();
        receiveData = null;
        if (stepReceiveData != null) {
            Log.e((String)"TAG", (String)("stepReceiveData.length is" + stepReceiveData.length));
        }
        return this.decodeIdCardBaseInfo(stepReceiveData);
    }

    public static synchronized byte[] getIdCardImage(IdentityMsg info) throws TelpoException {
        byte[] image = info.getHead_photo();
        if (image == null) {
            throw new IdCardNotCheckException();
        }
        return image;
    }

    public static synchronized byte[] getFringerPrint(IdentityMsg info) throws TelpoException {
        byte[] image = BlueToothIdCard.getIdCardImage(info);
        byte[] fringerprint = null;
        if (image == null) {
            throw new IdCardNotCheckException();
        }
        try {
            fringerprint = Arrays.copyOfRange(image, 1024, image.length);
        }
        catch (Exception e) {
            throw new IdCardNotCheckException();
        }
        if (fringerprint == null) {
            throw new IdCardNotCheckException();
        }
        return fringerprint;
    }

    public static Bitmap decodeIdCardImage(byte[] image) throws TelpoException {
        if (image == null) {
            throw new ImageDecodeException();
        }
        byte[] buf = new byte[WLTService.imgLength];
        if (1 == WLTService.wlt2Bmp(image, buf)) {
            return IDPhotoHelper.Bgr2Bitmap(buf);
        }
        throw new ImageDecodeException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] checkReceivedData() {
        try {
            if (this.currentStep == 2) {
                Thread.sleep(2500L);
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (receiveData == null) {
            return null;
        }
        if (this.currentStep == 2 && receiveData.length < 1024) {
            return null;
        }
        byte[] answer_code = null;
        switch (this.currentStep) {
            case 0: {
                byte[] byArray = new byte[3];
                byArray[2] = -97;
                answer_code = byArray;
                break;
            }
            case 1: {
                byte[] byArray = new byte[3];
                byArray[2] = -112;
                answer_code = byArray;
                break;
            }
            case 2: {
                byte[] byArray = new byte[3];
                byArray[2] = -112;
                answer_code = byArray;
                break;
            }
        }
        if (answer_code == null) {
            return null;
        }
        try {
            int pos = 0;
            int i = 0;
            while (i < SAM_HEADER.length) {
                if (receiveData[pos++] != SAM_HEADER[i]) {
                    return null;
                }
                ++i;
            }
            pos += 2;
            i = 0;
            while (i < answer_code.length) {
                if (receiveData[pos++] != answer_code[i]) {
                    return null;
                }
                ++i;
            }
            return receiveData;
        }
        catch (Exception e) {
            return null;
        }
    }

    public IdentityMsg decodeIdCardBaseInfo(byte[] ret) {
        if (ret == null) {
            return null;
        }
        ret = Arrays.copyOfRange(ret, 16, ret.length - 1);
        int len = ret.length;
        Log.d((String)TAG, (String)("info len = " + len));
        if (len == 1280 || len == 1792 || len == 2304) {
            this.imageDatalength = (char)ret[2] * 256 + (char)ret[3];
            this.contentLength = ret[0] << 8 & 0xFF00;
            this.contentLength += ret[1];
            this.imageDatalength = ret[2] << 8 & 0xFF00;
            this.imageDatalength += ret[3];
            this.fplength = ret[4] << 8 & 0xFF00;
            this.fplength += ret[5];
            IdentityMsg info = new IdentityMsg();
            String stringBuffer = null;
            try {
                stringBuffer = new String(ret, "UTF16-LE");
                stringBuffer = new String(stringBuffer.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            info.setName(stringBuffer.substring(0, 60));
            info.setSex(stringBuffer.substring(60, 61));
            info.setNo(stringBuffer.substring(61, 76));
            info.setCountry(stringBuffer.substring(76, 79));
            info.setCn_name(stringBuffer.substring(79, 94));
            info.setPeriod(stringBuffer.substring(94, 110));
            info.setBorn(stringBuffer.substring(110, 118));
            info.setIdcard_version(stringBuffer.substring(118, 120));
            info.setApartment(stringBuffer.substring(120, 124));
            info.setCard_type(stringBuffer.substring(124, 125));
            info.setReserve(stringBuffer.substring(125, 128));
            info.setHead_photo(Arrays.copyOfRange(ret, 256, ret.length));
            if (!"I".equals(info.getCard_type())) {
                info.setName(stringBuffer.substring(0, 15));
                info.setSex(stringBuffer.substring(15, 16));
                if (!stringBuffer.substring(16, 18).equals("  ")) {
                    info.setNation(stringBuffer.substring(16, 18));
                }
                info.setBorn(stringBuffer.substring(18, 26));
                info.setAddress(stringBuffer.substring(26, 61).trim());
                info.setNo(stringBuffer.substring(61, 79).trim());
                info.setApartment(stringBuffer.substring(79, 94).trim());
                info.setPeriod(stringBuffer.substring(94, 110));
                if (!stringBuffer.substring(110, 119).equals("         ")) {
                    info.setPassNum(stringBuffer.substring(110, 119));
                }
                if (!stringBuffer.substring(119, 121).equals("  ")) {
                    info.setIssuesNum(stringBuffer.substring(119, 121));
                }
                if (!stringBuffer.substring(124, 125).equals(" ")) {
                    info.setCardSignal(stringBuffer.substring(124, 125));
                }
                info.setHead_photo(Arrays.copyOfRange(ret, 256, ret.length));
            }
            StringBuilder builder = new StringBuilder();
            String temp = info.getName().trim();
            if (ReaderUtils.count_chinese(temp) != 0) {
                if (temp.length() <= 4) {
                    char[] cArray = temp.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        builder.append(c);
                        builder.append(" ");
                        ++n2;
                    }
                } else if (temp.length() > 14) {
                    builder.append(temp.substring(0, 14));
                    builder.append("\n\t\t\t");
                    builder.append(temp.substring(14));
                }
                info.setName(builder.toString());
            } else {
                int splitIndex = 26;
                if (temp.length() > 26) {
                    String t = temp.substring(0, 26);
                    int d1 = t.lastIndexOf(" ");
                    int d2 = t.lastIndexOf(",");
                    if (d1 != -1 || d2 != -1) {
                        splitIndex = d1 > d2 ? d1 : d2;
                    }
                    builder.append(temp.substring(0, splitIndex + 1));
                    builder.append("\n\t\t\t");
                    builder.append(temp.substring(splitIndex + 1));
                    info.setName(builder.toString());
                }
            }
            temp = info.getNation();
            try {
                info.setNation(nation_list[Integer.parseInt(temp) - 1]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            temp = info.getSex();
            if ("1".equals(temp)) {
                info.setSex("\u7537 / M");
            } else if ("2".equals(temp)) {
                info.setSex("\u5973 / F");
            }
            temp = info.getBorn().trim();
            if (temp.length() >= 8) {
                info.setBorn(BlueToothIdCard.formatDate(temp));
            }
            if ((temp = info.getPeriod().trim()).length() >= 16) {
                info.setPeriod(String.valueOf(BlueToothIdCard.formatDate(temp.substring(0, 8))) + " - " + BlueToothIdCard.formatDate(temp.substring(8)));
            }
            if ("I".equals(info.getCard_type())) {
                info.setApartment("\u516c\u5b89\u90e8/Ministry of Public Security");
            }
            Log.d((String)TAG, (String)"handle data success");
            return info;
        }
        return null;
    }

    private static String formatDate(String date) {
        StringBuilder formatedDate = new StringBuilder();
        formatedDate.append(date.substring(0, 4));
        formatedDate.append(".");
        formatedDate.append(date.substring(4, 6));
        formatedDate.append(".");
        formatedDate.append(date.substring(6, 8));
        return formatedDate.toString();
    }

    public boolean checkConnect() {
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.isConnect;
    }

    public String getVersion() throws TelpoException {
        byte[] data2send = new byte[]{102, 1, 2, 3, -1, 107, 22};
        sendData = this.packageCommand(data2send);
        this.sendCommand();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (receiveData != null) {
            receiveData = Arrays.copyOfRange(receiveData, 5, 7);
            byte left = receiveData[1];
            byte right = receiveData[0];
            Log.d((String)"!@#", (String)(String.valueOf(left) + "." + right));
            return String.valueOf(left) + "." + right;
        }
        return null;
    }
}

