/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.idcard;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.util.Log;
import android.widget.ImageView;
import com.zkteco.android.biometric.core.device.BiometricDevice;
import com.zkteco.android.biometric.core.device.TransportType;
import com.zkteco.android.biometric.core.utils.ToolUtils;
import com.zkteco.android.biometric.nidfpsensor.NIDFPFactory;
import com.zkteco.android.biometric.nidfpsensor.NIDFPSensor;
import com.zkteco.android.biometric.nidfpsensor.exception.NIDFPException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class FingerReader {
    private static final String TAG = "TELPO_SDK";
    private boolean mbStart = false;
    private boolean mbStop = true;
    private NIDFPSensor mNIDFPSensor = null;
    private Context context;
    private byte[] mBufImage;
    private byte[] returnByte;
    private byte returnScore;
    private ZKWorkThread mWorkThread = null;
    private UsbManager musbManager = null;
    private UsbDevice usbDevice = null;
    private byte[] fringerprint;
    private float matchingvalue_one;
    private float matchingvalue_two;
    private byte[] fringerprint_one;
    private byte[] fringerprint_two;
    private Bitmap fingerBitmap = null;
    private boolean verifyFinger = false;
    public static final int VID = 6997;
    public static final int PID = 770;
    public static final int PID_110 = 772;
    private int now_PID = 0;
    private CountDownLatch countdownLatch = new CountDownLatch(1);
    private final String ACTION_USB_PERMISSION = "com.zkteco.idfprdemo.USB_PERMISSION";
    private int isMatchSuccess = 0;
    private static volatile FingerReader instance;

    private FingerReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FingerReader getInstance(Context context) {
        if (instance != null) return instance;
        Class<FingerReader> clazz = FingerReader.class;
        synchronized (FingerReader.class) {
            if (instance != null) return instance;
            instance = new FingerReader(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private FingerReader(Context context) {
        this.context = context;
    }

    public int isMatchSuccess() {
        return this.isMatchSuccess;
    }

    public boolean openFingerReader() {
        return this.initFingerReader(new byte[1024]);
    }

    public boolean openFingerReader(byte[] fringerprint) {
        return this.initFingerReader(fringerprint);
    }

    public void getFingerDetect() {
        this.getFingerDetect(null);
    }

    public void getFingerDetect(ImageView imageView) {
        if (this.mbStart) {
            return;
        }
        try {
            if (this.mNIDFPSensor == null) {
                Log.d((String)TAG, (String)"FingerReader open failed");
                return;
            }
            this.mNIDFPSensor.open(0);
            this.mBufImage = new byte[this.mNIDFPSensor.getFpImgWidth() * this.mNIDFPSensor.getFpImgHeight()];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mWorkThread = new ZKWorkThread(imageView);
        this.mWorkThread.start();
        this.mbStart = true;
    }

    public Bitmap getFingerBitmap() {
        return this.fingerBitmap;
    }

    public void verifyFinger(boolean status) {
        this.verifyFinger = status;
    }

    public void closeFingerReader() {
        if (this.mNIDFPSensor != null) {
            if (this.mbStart) {
                this.mbStop = true;
                try {
                    this.countdownLatch.await(10000L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    this.mNIDFPSensor.close(0);
                    NIDFPFactory.destroy((BiometricDevice)this.mNIDFPSensor);
                }
                catch (NIDFPException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.mNIDFPSensor.close(0);
                    NIDFPFactory.destroy((BiometricDevice)this.mNIDFPSensor);
                }
                catch (NIDFPException e) {
                    e.printStackTrace();
                }
            }
            this.mbStart = false;
        }
    }

    private void setReaderFingerByte(byte[] readerFinger) {
        this.returnByte = readerFinger;
    }

    public byte[] getReaderFingerByte() {
        return this.returnByte;
    }

    public byte getQualityScore() {
        return this.returnScore;
    }

    public int fingerprintCompare(byte[] srcFingerPrint, byte[] scanFinger, byte score) {
        if (!this.decodeSrcFingerPrint(srcFingerPrint)) {
            return -1;
        }
        if (this.returnScore > score) {
            Log.d((String)"TAG", (String)"returnScore > score");
            float ret_one = this.mNIDFPSensor.ImageMatch(0, scanFinger, this.fringerprint_one);
            float ret_two = this.mNIDFPSensor.ImageMatch(0, scanFinger, this.fringerprint_two);
            Log.d((String)"TAG", (String)("ret 1:" + ret_one));
            Log.d((String)"TAG", (String)("ret 2:" + ret_two));
            if ((double)ret_one == 1.0 || (double)ret_two == 1.0) {
                this.isMatchSuccess = 1;
                return 1;
            }
            this.isMatchSuccess = 2;
            return 2;
        }
        return -1;
    }

    private boolean initFingerReader(byte[] fringerprint) {
        if (this.mbStart) {
            Log.d((String)TAG, (String)"\u8bbe\u5907\u5df2\u8fde\u63a5\uff0c\u8bf7\u5148\u65ad\u5f00\u8fde\u63a5");
            return false;
        }
        this.musbManager = (UsbManager)this.context.getSystemService("usb");
        if (fringerprint == null) {
            return false;
        }
        this.fringerprint = fringerprint;
        if (this.fringerprint.length == 1024) {
            this.fringerprint_one = Arrays.copyOfRange(fringerprint, 0, 512);
            this.fringerprint_two = Arrays.copyOfRange(fringerprint, 512, fringerprint.length);
        }
        if (this.checkFingerReader()) {
            Intent intent = new Intent("com.zkteco.idfprdemo.USB_PERMISSION");
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0);
            this.musbManager.requestPermission(this.usbDevice, pendingIntent);
            this.StartFingerSensor();
            return true;
        }
        Log.d((String)TAG, (String)"FingerReader is not connected");
        return false;
    }

    private boolean decodeSrcFingerPrint(byte[] srcFingerPrint) {
        if (srcFingerPrint == null) {
            return false;
        }
        this.fringerprint = srcFingerPrint;
        if (this.fringerprint.length == 1024) {
            this.fringerprint_one = Arrays.copyOfRange(this.fringerprint, 0, 512);
            this.fringerprint_two = Arrays.copyOfRange(this.fringerprint, 512, this.fringerprint.length);
            return true;
        }
        return false;
    }

    private void StartFingerSensor() {
        HashMap<String, Integer> fingerprintParams = new HashMap<String, Integer>();
        fingerprintParams.put("param.key.vid", 6997);
        fingerprintParams.put("param.key.pid", this.now_PID);
        this.mNIDFPSensor = NIDFPFactory.createNIDFPSensor((Context)this.context, (TransportType)TransportType.USBSCSI, fingerprintParams);
    }

    private boolean checkFingerReader() {
        UsbManager zk_musbManager = (UsbManager)this.context.getSystemService("usb");
        for (UsbDevice device : zk_musbManager.getDeviceList().values()) {
            if ((device.getVendorId() != 6997 || device.getProductId() != 770) && (device.getVendorId() != 6997 || device.getProductId() != 772)) continue;
            if (device.getProductId() == 770) {
                this.now_PID = 770;
            } else if (device.getProductId() == 772) {
                this.now_PID = 772;
            }
            this.usbDevice = device;
            return true;
        }
        return false;
    }

    private class ZKWorkThread
    extends Thread {
        private ImageView imageView = null;

        public ZKWorkThread(ImageView imageView) {
            this.imageView = imageView;
            FingerReader.this.isMatchSuccess = 0;
        }

        @Override
        public void run() {
            super.run();
            FingerReader.this.mbStop = false;
            while (!FingerReader.this.mbStop) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    FingerReader.this.mNIDFPSensor.GetFPRawData(0, FingerReader.this.mBufImage);
                    FingerReader.this.setReaderFingerByte(FingerReader.this.mBufImage);
                }
                catch (NIDFPException e) {
                    e.printStackTrace();
                    continue;
                }
                if (FingerReader.this.fringerprint != null) {
                    byte[] retQualityScore = new byte[1];
                    FingerReader.this.mNIDFPSensor.getQualityScore(FingerReader.this.mBufImage, retQualityScore);
                    byte qualityScore = retQualityScore[0];
                    FingerReader.this.returnScore = qualityScore;
                    try {
                        FingerReader.this.fingerBitmap = ToolUtils.renderCroppedGreyScaleBitmap((byte[])FingerReader.this.mBufImage, (int)FingerReader.this.mNIDFPSensor.getFpImgWidth(), (int)FingerReader.this.mNIDFPSensor.getFpImgHeight());
                        if (this.imageView != null) {
                            this.imageView.post(new Runnable(){

                                @Override
                                public void run() {
                                    ZKWorkThread.this.imageView.setImageBitmap(FingerReader.this.fingerBitmap);
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (FingerReader.this.verifyFinger && qualityScore > 80) {
                        float ret_one = FingerReader.this.mNIDFPSensor.ImageMatch(0, FingerReader.this.mBufImage, FingerReader.this.fringerprint_one);
                        float ret_two = FingerReader.this.mNIDFPSensor.ImageMatch(0, FingerReader.this.mBufImage, FingerReader.this.fringerprint_two);
                        float ret_three = FingerReader.this.mNIDFPSensor.ImageMatch(0, FingerReader.this.mBufImage, FingerReader.this.fringerprint);
                        FingerReader.this.matchingvalue_one = ret_one;
                        FingerReader.this.matchingvalue_two = ret_two;
                        if ((double)FingerReader.this.matchingvalue_one == 1.0 || (double)FingerReader.this.matchingvalue_two == 1.0) {
                            FingerReader.this.isMatchSuccess = 1;
                            if (FingerReader.this.mNIDFPSensor != null) {
                                FingerReader.this.closeFingerReader();
                                NIDFPFactory.destroy((BiometricDevice)FingerReader.this.mNIDFPSensor);
                            }
                        } else {
                            FingerReader.this.isMatchSuccess = 2;
                            if (FingerReader.this.mNIDFPSensor != null) {
                                FingerReader.this.closeFingerReader();
                                NIDFPFactory.destroy((BiometricDevice)FingerReader.this.mNIDFPSensor);
                            }
                        }
                    }
                }
                FingerReader.this.countdownLatch.countDown();
            }
        }
    }
}

