/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.idcard;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Environment;
import android.util.Log;
import android_serialport_api.SerialPort;
import com.telpo.tps550.api.DeviceNotFoundException;
import com.telpo.tps550.api.DeviceNotOpenException;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.TimeoutException;
import com.telpo.tps550.api.idcard.IdCardInitFailException;
import com.telpo.tps550.api.idcard.IdCardNotCheckException;
import com.telpo.tps550.api.idcard.IdCardNotReadSnException;
import com.telpo.tps550.api.idcard.IdentityMsg;
import com.telpo.tps550.api.idcard.ImageDecodeException;
import com.telpo.tps550.api.idcard.TPS900IDCard;
import com.telpo.tps550.api.idcard.UsbIdCard;
import com.telpo.tps550.api.util.ReaderUtils;
import com.telpo.tps550.api.util.ShellUtils;
import com.telpo.tps550.api.util.StringUtil;
import com.telpo.tps550.api.util.SystemUtil;
import com.zkteco.android.IDReader.IDPhotoHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdCard {
    private static final byte[] byLicData;
    private static final int DEFAULT_BARTRATE = 115200;
    public static final int IDREADER_TYPE_UART = 0;
    public static final int IDREADER_TYPE_USB = 1;
    public static final int READER_PID_SMALL = 22352;
    public static final int READER_VID_SMALL = 1155;
    public static final int READER_PID_BIG = 50010;
    public static final int READER_VID_BIG = 1024;
    public static final int READER_PID_WINDOWS = 650;
    public static final int READER_VID_WINDOWS = 10473;
    private static final int VID = 6997;
    private static final int PID = 770;
    private static final int PID_110 = 772;
    private static int now_PID;
    private static UsbManager mUsbManager;
    private static UsbDevice idcard_reader;
    private static UsbIdCard mUsbIdCard;
    private static IdentityMsg info;
    private InputStream mInputStream = null;
    private OutputStream mOutputStream = null;
    private SerialPort serial = null;
    private ReadThread mReadThread;
    private byte[] idData = null;
    private static byte[] idData_find;
    private static byte[] idData_select;
    private static byte[] idData_read;
    private static final int STEP_CHECK = 1;
    private static final int STEP_SELECT = 2;
    private static final int STEP_READ = 3;
    private static final int CHECK_ADDR = 4;
    private static final int STEP_ALL = 5;
    private int step = -1;
    private static int contentLength;
    private static int imageDatalength;
    private static int fplength;
    private static String[] nation_list;

    static {
        byte[] byArray = new byte[12];
        byArray[0] = 5;
        byArray[2] = 1;
        byArray[4] = 91;
        byArray[5] = 3;
        byArray[6] = 51;
        byArray[7] = 1;
        byArray[8] = 90;
        byArray[9] = -77;
        byArray[10] = 30;
        byLicData = byArray;
        now_PID = 0;
        mUsbIdCard = null;
        info = null;
        idData_find = null;
        idData_select = null;
        idData_read = null;
        nation_list = new String[]{"\u6c49", "\u8499\u53e4", "\u56de", "\u85cf", "\u7ef4\u543e\u5c14", "\u82d7", "\u5f5d", "\u58ee", "\u5e03\u4f9d", "\u671d\u9c9c", "\u6ee1", "\u4f97", "\u7476", "\u767d", "\u571f\u5bb6", "\u54c8\u5c3c", "\u54c8\u8428\u514b", "\u50a3", "\u9ece", "\u5088\u50f3", "\u4f64", "\u7572", "\u9ad8\u5c71", "\u62c9\u795c", "\u6c34", "\u4e1c\u4e61", "\u7eb3\u897f", "\u666f\u9887", "\u67ef\u5c14\u514b\u5b5c", "\u571f", "\u8fbe\u65a1\u5c14", "\u4eeb\u4f6c", "\u7f8c", "\u5e03\u6717", "\u6492\u62c9", "\u6bdb\u5357", "\u4ee1\u4f6c", "\u9521\u4f2f", "\u963f\u660c", "\u666e\u7c73", "\u5854\u5409\u514b", "\u6012", "\u4e4c\u5b5c\u522b\u514b", "\u4fc4\u7f57\u65af", "\u9102\u6e29\u514b", "\u5fb7\u6602", "\u4fdd\u5b89", "\u88d5\u56fa", "\u4eac", "\u5854\u5854\u5c14", "\u72ec\u9f99", "\u9102\u4f26\u6625", "\u8d6b\u54f2", "\u95e8\u5df4", "\u73de\u5df4", "\u57fa\u8bfa", "\u5176\u4ed6", "\u5916\u56fd\u8840\u7edf\u4e2d\u56fd\u7c4d\u4eba\u58eb"};
        if (SystemUtil.getDeviceType() != StringUtil.DeviceModelEnum.TPS900.ordinal() && SystemUtil.getDeviceType() != StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            System.loadLibrary("idcard");
        }
    }

    public IdCard() {
    }

    public IdCard(Context context) {
        try {
            mUsbIdCard = new UsbIdCard(context);
        }
        catch (TelpoException e) {
            if (mUsbIdCard == null) {
                Log.d((String)"idcard demo", (String)"IdCard(Context context) mUsbIdCard is null");
            }
            e.printStackTrace();
        }
    }

    public IdCard(int type, Context context) throws TelpoException {
        if (type == 1) {
            try {
                mUsbIdCard = new UsbIdCard(context);
            }
            catch (TelpoException e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized void open() throws TelpoException {
        File destDir = new File(Environment.getExternalStorageDirectory() + "/wltlib");
        if (!destDir.exists() && !destDir.mkdir()) {
            throw new IdCardInitFailException("Failed to find idcard library directory!");
        }
        if (!IdCard.isFileExists(Environment.getExternalStorageDirectory() + "/wltlib/base.dat") && !IdCard.copyFile("/system/usr/base.dat", Environment.getExternalStorageDirectory() + "/wltlib/base.dat")) {
            throw new IdCardInitFailException("Failed to find idcard library data file!");
        }
        if (!IdCard.isFileExists(Environment.getExternalStorageDirectory() + "/wltlib/license.lic") && !IdCard.copyFile("/system/usr/license.lic", Environment.getExternalStorageDirectory() + "/wltlib/license.lic")) {
            throw new IdCardInitFailException("Failed to find idcard library license file!");
        }
        if (!IdCard.connect_idcard(0, 115200)) {
            throw new DeviceNotFoundException();
        }
    }

    public static synchronized void open(Context context) throws TelpoException {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            TPS900IDCard.open(context);
            return;
        }
        File destDir = new File(Environment.getExternalStorageDirectory() + "/wltlib");
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        if (!IdCard.isFileExists(Environment.getExternalStorageDirectory() + "/wltlib/base.dat")) {
            IdCard.copyFile("/system/usr/base.dat", Environment.getExternalStorageDirectory() + "/wltlib/base.dat");
        }
        if (!IdCard.isFileExists(Environment.getExternalStorageDirectory() + "/wltlib/license.lic")) {
            IdCard.copyFile("/system/usr/license.lic", Environment.getExternalStorageDirectory() + "/wltlib/license.lic");
        }
        if (!IdCard.connect_idcard(0, 115200)) {
            throw new DeviceNotFoundException();
        }
    }

    public static synchronized void open(int type, int pautRate) throws TelpoException {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Idcard reader type is invalid!");
        }
        File destDir = new File(Environment.getExternalStorageDirectory() + "/wltlib");
        if (!destDir.exists() && !destDir.mkdir()) {
            throw new IdCardInitFailException("Failed to find idcard library directory!");
        }
        if (!IdCard.isFileExists(Environment.getExternalStorageDirectory() + "/wltlib/base.dat") && !IdCard.copyFile("/system/usr/base.dat", Environment.getExternalStorageDirectory() + "/wltlib/base.dat")) {
            throw new IdCardInitFailException("Failed to find idcard library data file!");
        }
        if (!IdCard.isFileExists(Environment.getExternalStorageDirectory() + "/wltlib/license.lic") && !IdCard.copyFile("/system/usr/license.lic", Environment.getExternalStorageDirectory() + "/wltlib/license.lic")) {
            throw new IdCardInitFailException("Failed to find idcard library license file!");
        }
        if (!IdCard.connect_idcard(type, pautRate)) {
            throw new DeviceNotFoundException();
        }
    }

    public static synchronized void open(int pautRate, String uart) throws TelpoException {
        File destDir = new File(Environment.getExternalStorageDirectory() + "/wltlib");
        if (!destDir.exists() && !destDir.mkdir()) {
            throw new IdCardInitFailException("Failed to find idcard library directory!");
        }
        IdCard.connected_idcard(0, pautRate, uart);
    }

    public static synchronized void open(int type) throws TelpoException {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Idcard reader type is invalid!");
        }
        File destDir = new File(Environment.getExternalStorageDirectory() + "/wltlib");
        if (!destDir.exists() && !destDir.mkdir()) {
            throw new IdCardInitFailException("Failed to find idcard library directory!");
        }
        if (!IdCard.isFileExists(Environment.getExternalStorageDirectory() + "/wltlib/base.dat") && !IdCard.copyFile("/system/usr/base.dat", Environment.getExternalStorageDirectory() + "/wltlib/base.dat")) {
            throw new IdCardInitFailException("Failed to find idcard library data file!");
        }
        if (!IdCard.isFileExists(Environment.getExternalStorageDirectory() + "/wltlib/license.lic") && !IdCard.copyFile("/system/usr/license.lic", Environment.getExternalStorageDirectory() + "/wltlib/license.lic")) {
            throw new IdCardInitFailException("Failed to find idcard library license file!");
        }
        if (type == 1) {
            ShellUtils.CommandResult result = ShellUtils.execCommand("chmod -R 777 /dev/bus/usb/", true);
            Log.w((String)"result", (String)(String.valueOf(result.result) + result.errorMsg));
        }
        if (!IdCard.connect_idcard(type, 115200)) {
            throw new DeviceNotFoundException();
        }
    }

    public static synchronized int open(int type, Context context) {
        if (type == 1) {
            try {
                mUsbIdCard = new UsbIdCard(context);
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return 1;
            }
            return 0;
        }
        return -99;
    }

    public static synchronized IdentityMsg checkIdCard(int timeoutInMs) throws TelpoException {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            return TPS900IDCard.checkIdCard(timeoutInMs);
        }
        int[] result = new int[2];
        IdentityMsg info = (IdentityMsg)IdCard.check_idcard(timeoutInMs, result);
        if (info == null) {
            if (result[0] == -5) {
                IdCard.close();
                throw new DeviceNotFoundException();
            }
            throw new TimeoutException();
        }
        StringBuilder builder = new StringBuilder();
        String temp = info.getName().trim();
        if (IdCard.countChinese(temp) != 0) {
            if (temp.length() <= 4) {
                char[] cArray = temp.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    builder.append(c);
                    builder.append(" ");
                    ++n2;
                }
            } else if (temp.length() > 14) {
                builder.append(temp.substring(0, 14));
                builder.append("\n\t\t\t");
                builder.append(temp.substring(14));
            }
            if (!builder.toString().equals("")) {
                info.setName(builder.toString());
            }
        } else {
            int splitIndex = 26;
            if (temp.length() > 26) {
                String t = temp.substring(0, 26);
                int d1 = t.lastIndexOf(" ");
                int d2 = t.lastIndexOf(",");
                if (d1 != -1 || d2 != -1) {
                    splitIndex = d1 > d2 ? d1 : d2;
                }
                builder.append(temp.substring(0, splitIndex + 1));
                builder.append("\n\t\t\t");
                builder.append(temp.substring(splitIndex + 1));
                info.setName(builder.toString());
            }
        }
        if ("\u7537".equals(temp = info.getSex())) {
            info.setSex(String.valueOf(temp) + " / M");
        } else if ("\u5973".equals(temp)) {
            info.setSex(String.valueOf(temp) + " / F");
        }
        temp = info.getBorn().trim();
        if (temp.length() >= 8) {
            info.setBorn(IdCard.formatDate(temp));
        }
        if ((temp = info.getPeriod().trim()).length() >= 17) {
            info.setPeriod(String.valueOf(IdCard.formatDate(temp.substring(0, 8))) + " - " + IdCard.formatDate(temp.substring(9)));
        }
        if ("I".equals(info.getCard_type())) {
            info.setApartment("\u516c\u5b89\u90e8/Ministry of Public Security");
        }
        return info;
    }

    public IdentityMsg checkIdCardOverseas(int timeoutInMs) throws TelpoException {
        return this.checkIdCardOverseas(null, 115200, timeoutInMs);
    }

    public IdentityMsg checkIdCardOverseas(String uart, int pautRate, int timeoutInMs) throws TelpoException {
        if (mUsbIdCard != null) {
            info = mUsbIdCard.checkIdCard();
            return info;
        }
        Log.d((String)"idcard demo", (String)"checkIdCardOverseas mUsbIdCard == null");
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        this.checkId(uart, pautRate);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        while (endTime - startTime < (long)timeoutInMs) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.idData != null && this.idData.length == 1297 && endTime - startTime > 50L) {
                Log.d((String)"idcard demo", (String)"return idData 1297");
                this.closeStream();
                return this.decodeIdCardBaseInfo(this.idData);
            }
            if (this.idData != null && this.idData.length == 2321) {
                Log.d((String)"idcard demo", (String)"return idData 2321");
                this.closeStream();
                return this.decodeIdCardBaseInfo(this.idData);
            }
            endTime = System.currentTimeMillis();
        }
        this.closeStream();
        throw new TimeoutException();
    }

    public static synchronized byte[] getIdCardImage() throws TelpoException {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            return TPS900IDCard.getIdCardImage();
        }
        byte[] image = IdCard.get_image();
        if (image == null) {
            throw new IdCardNotCheckException();
        }
        return image;
    }

    public static int saveIdCardImage(byte[] imageData, String path) {
        int ret = IdCard.get_imageusb(imageData, path);
        return ret;
    }

    public byte[] getIdCardImageOverseas(IdentityMsg info) throws TelpoException {
        if (mUsbIdCard != null && info != null) {
            return UsbIdCard.getIdCardImage(info);
        }
        byte[] image = info.getHead_photo();
        if (image == null) {
            throw new IdCardNotCheckException();
        }
        return image;
    }

    public static synchronized byte[] getFringerPrint() throws TelpoException {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            return null;
        }
        byte[] fringerprint = IdCard.get_fringerprint();
        if (fringerprint == null) {
            throw new IdCardNotCheckException();
        }
        return fringerprint;
    }

    public byte[] getFringerPrintOverseas(IdentityMsg info) throws TelpoException {
        if (mUsbIdCard != null && info != null) {
            return UsbIdCard.getFringerPrint(info);
        }
        byte[] image = this.getIdCardImageOverseas(info);
        byte[] fringerprint = null;
        if (image == null) {
            throw new IdCardNotCheckException();
        }
        try {
            fringerprint = Arrays.copyOfRange(image, imageDatalength, image.length);
        }
        catch (Exception e) {
            throw new IdCardNotCheckException();
        }
        if (fringerprint == null) {
            throw new IdCardNotCheckException();
        }
        return fringerprint;
    }

    public static Bitmap decodeIdCardImage(byte[] image) throws TelpoException {
        if (image == null) {
            throw new ImageDecodeException();
        }
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            return TPS900IDCard.decodeIdCardImage(image);
        }
        String path = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + "/wltlib/zp.bmp";
        Bitmap bmp = null;
        try {
            bmp = BitmapFactory.decodeFile((String)path);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ImageDecodeException();
        }
        return bmp;
    }

    public Bitmap decodeIdCardImageOverseas(byte[] image) throws TelpoException {
        if (image == null) {
            throw new ImageDecodeException();
        }
        if (mUsbIdCard != null) {
            return UsbIdCard.decodeIdCardImage(image);
        }
        byte[] buf = new byte[38556];
        if (1 == IdCard.getimage(image, buf)) {
            return IDPhotoHelper.Bgr2Bitmap(buf);
        }
        throw new ImageDecodeException();
    }

    public static synchronized String getSAM() throws TelpoException {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            return null;
        }
        if (mUsbIdCard != null) {
            return mUsbIdCard.getSAM();
        }
        byte[] sam_info = IdCard.get_sam();
        if (sam_info == null) {
            throw new IdCardNotReadSnException();
        }
        if (sam_info.length == 16) {
            StringBuilder sam = new StringBuilder();
            sam.append(IdCard.bytearray2Str(sam_info, 0, 2, 2));
            sam.append(IdCard.bytearray2Str(sam_info, 2, 2, 2));
            sam.append(IdCard.bytearray2Str(sam_info, 4, 4, 8));
            sam.append(IdCard.bytearray2Str(sam_info, 8, 4, 10));
            sam.append(IdCard.bytearray2Str(sam_info, 12, 4, 10));
            return sam.toString();
        }
        return null;
    }

    public static synchronized String getVersion() throws TelpoException {
        if (mUsbIdCard != null) {
            return mUsbIdCard.getVersion();
        }
        return null;
    }

    private void loadSo(Context context, String originPath, String fileName) {
        File dir = context.getDir("libs", 0);
        File destFile = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + fileName);
        if (IdCard.copyLibraryFile(context, originPath, destFile.getAbsolutePath())) {
            System.load(destFile.getAbsolutePath());
        }
    }

    private static boolean copyLibraryFile(Context context, String origPath, String destPath) {
        File file;
        FileInputStream is;
        boolean copyIsFinish;
        block5: {
            copyIsFinish = false;
            File dirFile = new File(destPath.substring(0, destPath.lastIndexOf("/")));
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            is = new FileInputStream(new File(origPath));
            file = new File(destPath);
            if (!file.exists()) break block5;
            Log.d((String)"tagg", (String)("src file size=" + is.available()));
            Log.d((String)"tagg", (String)("dest file size=" + file.length()));
            if (file.length() != (long)is.available()) break block5;
            return true;
        }
        try {
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            byte[] temp = new byte[1024];
            int i = 0;
            while ((i = is.read(temp)) > 0) {
                fos.write(temp, 0, i);
            }
            fos.close();
            is.close();
            copyIsFinish = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return copyIsFinish;
    }

    public static synchronized byte[] getPhyAddr() throws TelpoException {
        if (mUsbIdCard != null) {
            return mUsbIdCard.getPhyAddr();
        }
        return null;
    }

    public static int close() {
        try {
            if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
                TPS900IDCard.close();
            } else {
                IdCard.disconnect_idcard();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public void usbClose() {
        if (mUsbIdCard != null) {
            mUsbIdCard = null;
        }
    }

    private static String formatDate(String date) {
        StringBuilder formatedDate = new StringBuilder();
        formatedDate.append(date.substring(0, 4));
        formatedDate.append(".");
        formatedDate.append(date.substring(4, 6));
        formatedDate.append(".");
        formatedDate.append(date.substring(6, 8));
        return formatedDate.toString();
    }

    private static String bytearray2Str(byte[] data, int start, int length, int targetLength) {
        long number = 0L;
        if (data.length < start + length) {
            return "";
        }
        int i = 1;
        while (i <= length) {
            number *= 256L;
            number += (long)(data[start + length - i] & 0xFF);
            ++i;
        }
        return String.format("%0" + targetLength + "d", number);
    }

    private static int countChinese(String str) {
        int count = 0;
        Pattern p = Pattern.compile("[\\u4e00-\\u9fa5]");
        Matcher m = p.matcher(str);
        while (m.find()) {
            ++count;
        }
        return count;
    }

    private static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(IdCard.charToByte(hexChars[pos]) << 4 | IdCard.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    private static boolean copyFile(String fileName, String path) {
        File oFile;
        boolean copyIsFinish;
        block4: {
            copyIsFinish = false;
            oFile = new File(fileName);
            if (oFile.exists() && oFile.canRead()) break block4;
            return false;
        }
        try {
            FileInputStream is = new FileInputStream(oFile);
            File file = new File(path);
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            byte[] temp = new byte[1024];
            int i = 0;
            while ((i = ((InputStream)is).read(temp)) > 0) {
                fos.write(temp, 0, i);
            }
            fos.close();
            ((InputStream)is).close();
            copyIsFinish = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return copyIsFinish;
    }

    private static boolean isFileExists(String filePath) {
        try {
            File f = new File(filePath);
            return f.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public IdentityMsg decodeIdCardBaseInfo(byte[] ret) {
        if (ret == null) {
            return null;
        }
        ret = Arrays.copyOfRange(ret, 10, ret.length - 1);
        byte[] dataByte = Arrays.copyOfRange(ret, 6, ret.length);
        imageDatalength = (char)ret[2] * 256 + (char)ret[3];
        contentLength = ret[0] << 8 & 0xFF00;
        contentLength += ret[1];
        imageDatalength = ret[2] << 8 & 0xFF00;
        imageDatalength += ret[3];
        fplength = ret[4] << 8 & 0xFF00;
        fplength += ret[5];
        IdentityMsg info = new IdentityMsg();
        String stringBuffer = null;
        try {
            stringBuffer = new String(dataByte, "UTF16-LE");
            stringBuffer = new String(stringBuffer.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        info.setName(stringBuffer.substring(0, 60));
        info.setSex(stringBuffer.substring(60, 61));
        info.setNo(stringBuffer.substring(61, 76));
        info.setCountry(stringBuffer.substring(76, 79));
        info.setCn_name(stringBuffer.substring(79, 94));
        info.setPeriod(stringBuffer.substring(94, 110));
        info.setBorn(stringBuffer.substring(110, 118));
        info.setIdcard_version(stringBuffer.substring(118, 120));
        info.setApartment(stringBuffer.substring(120, 124));
        info.setCard_type(stringBuffer.substring(124, 125));
        info.setReserve(stringBuffer.substring(125, 128));
        info.setHead_photo(Arrays.copyOfRange(dataByte, 256, dataByte.length));
        if (!"I".equals(info.getCard_type())) {
            info.setName(stringBuffer.substring(0, 15));
            info.setSex(stringBuffer.substring(15, 16));
            if (!stringBuffer.substring(16, 18).equals("  ")) {
                info.setNation(stringBuffer.substring(16, 18));
            }
            info.setBorn(stringBuffer.substring(18, 26));
            info.setAddress(stringBuffer.substring(26, 61).trim());
            info.setNo(stringBuffer.substring(61, 79).trim());
            info.setApartment(stringBuffer.substring(79, 94).trim());
            info.setPeriod(stringBuffer.substring(94, 110));
            if (!stringBuffer.substring(110, 119).equals("         ")) {
                info.setPassNum(stringBuffer.substring(110, 119));
            }
            if (!stringBuffer.substring(119, 121).equals("  ")) {
                info.setIssuesNum(stringBuffer.substring(119, 121));
            }
            if (!stringBuffer.substring(124, 125).equals(" ")) {
                info.setCardSignal(stringBuffer.substring(124, 125));
            }
            info.setHead_photo(Arrays.copyOfRange(dataByte, 256, dataByte.length));
        }
        StringBuilder builder = new StringBuilder();
        String temp = info.getName().trim();
        info.setName(temp);
        temp = info.getNation();
        try {
            info.setNation(nation_list[Integer.parseInt(temp) - 1]);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        temp = info.getSex();
        if ("1".equals(temp)) {
            info.setSex("\u7537 / M");
        } else if ("2".equals(temp)) {
            info.setSex("\u5973 / F");
        }
        temp = info.getBorn().trim();
        if (temp.length() >= 8) {
            info.setBorn(IdCard.formatDate(temp));
        }
        if ((temp = info.getPeriod().trim()).length() >= 16) {
            info.setPeriod(String.valueOf(IdCard.formatDate(temp.substring(0, 8))) + " - " + IdCard.formatDate(temp.substring(8)));
        }
        if ("I".equals(info.getCard_type())) {
            info.setApartment("\u516c\u5b89\u90e8/Ministry of Public Security");
        }
        return info;
    }

    private void closeStream() {
        try {
            if (this.mReadThread != null) {
                this.mReadThread.interrupt();
            }
            if (this.mOutputStream != null) {
                this.mOutputStream.close();
            }
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.serial != null) {
            this.serial.close();
            this.serial = null;
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void checkId(String uart, int pautRate) throws TelpoException {
        this.checkId(uart, pautRate, 5);
    }

    private void checkId(String uart, int pautRate, int stepType) throws TelpoException {
        try {
            if (uart == null) {
                if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS550.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS550A.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS510.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS580A.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS510A.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS510A_NHW.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS980P.ordinal()) {
                    this.serial = new SerialPort(new File("/dev/ttyS0"), 115200, 0);
                } else if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS580.ordinal()) {
                    this.serial = new SerialPort(new File("/dev/ttyS2"), 115200, 0);
                } else if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS550MTK.ordinal()) {
                    this.serial = new SerialPort(new File("/dev/ttyMT3"), 115200, 0);
                } else if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS462.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS468.ordinal()) {
                    this.serial = new SerialPort(new File("/dev/ttyS3"), 115200, 0);
                }
            } else {
                this.serial = new SerialPort(new File(uart), pautRate, 0);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.serial == null) {
            throw new DeviceNotOpenException();
        }
        this.mOutputStream = this.serial.getOutputStream();
        this.mInputStream = this.serial.getInputStream();
        this.mReadThread = new ReadThread();
        this.mReadThread.start();
        if (stepType == 1 || stepType == 5) {
            byte[] byArray = new byte[10];
            byArray[0] = -86;
            byArray[1] = -86;
            byArray[2] = -86;
            byArray[3] = -106;
            byArray[4] = 105;
            byArray[6] = 3;
            byArray[7] = 32;
            byArray[8] = 1;
            byArray[9] = 34;
            this.sendCommand(byArray, 1);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (stepType == 2 || stepType == 5) {
            byte[] byArray = new byte[10];
            byArray[0] = -86;
            byArray[1] = -86;
            byArray[2] = -86;
            byArray[3] = -106;
            byArray[4] = 105;
            byArray[6] = 3;
            byArray[7] = 32;
            byArray[8] = 2;
            byArray[9] = 33;
            this.sendCommand(byArray, 2);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (stepType == 3 || stepType == 5) {
            byte[] byArray = new byte[10];
            byArray[0] = -86;
            byArray[1] = -86;
            byArray[2] = -86;
            byArray[3] = -106;
            byArray[4] = 105;
            byArray[6] = 3;
            byArray[7] = 48;
            byArray[8] = 16;
            byArray[9] = 35;
            this.sendCommand(byArray, 3);
        }
    }

    private void sendCommand(byte[] cmdStr, int step) {
        this.step = step;
        if (step == 3) {
            this.idData = null;
        }
        try {
            int i = 0;
            while (i < cmdStr.length) {
                this.mOutputStream.write(cmdStr[i]);
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized int serial_idcard_find(String uart, int pautRate) {
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        try {
            this.checkId(uart, pautRate, 1);
        }
        catch (TelpoException e1) {
            e1.printStackTrace();
        }
        while (endTime - startTime < 200L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (idData_find != null && idData_find.length > 1 && StringUtil.toHexString(idData_find).substring((idData_find.length - 2) * 2 + 2, idData_find.length * 2).equals("97")) {
                idData_find = null;
                this.closeStream();
                return 0;
            }
            endTime = System.currentTimeMillis();
        }
        this.closeStream();
        idData_find = null;
        Log.d((String)"TELPO_SDK", (String)"check idcard timeout or receive wrong data");
        return -99;
    }

    public synchronized int serial_idcard_select(String uart, int pautRate) {
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        try {
            this.checkId(uart, pautRate, 2);
        }
        catch (TelpoException e1) {
            e1.printStackTrace();
        }
        while (endTime - startTime < 200L) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (idData_select != null && idData_select.length > 1 && StringUtil.toHexString(idData_select).substring((idData_select.length - 2) * 2 + 2, idData_select.length * 2).equals("9C")) {
                idData_select = null;
                this.closeStream();
                return 0;
            }
            endTime = System.currentTimeMillis();
        }
        this.closeStream();
        idData_select = null;
        Log.d((String)"TELPO_SDK", (String)"select idcard timeout or receive wrong data");
        return -99;
    }

    public synchronized byte[] serial_idcard_read(String uart, int pautRate) throws TelpoException {
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        this.checkId(uart, pautRate);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        while (endTime - startTime < 3000L) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.idData != null && this.idData.length == 1297 && endTime - startTime > 50L) {
                Log.d((String)"idcard demo", (String)"return idData 1297");
                this.closeStream();
                return this.idData;
            }
            if (this.idData != null && this.idData.length == 2321) {
                Log.d((String)"idcard demo", (String)"return idData 2321");
                this.closeStream();
                return this.idData;
            }
            endTime = System.currentTimeMillis();
        }
        this.closeStream();
        throw new TimeoutException();
    }

    public static synchronized int usb_idcard_find() {
        if (mUsbIdCard != null) {
            byte[] findByte;
            byte[] findCurrect;
            block5: {
                try {
                    byte[] byArray = new byte[15];
                    byArray[0] = -86;
                    byArray[1] = -86;
                    byArray[2] = -86;
                    byArray[3] = -106;
                    byArray[4] = 105;
                    byArray[6] = 8;
                    byArray[9] = -97;
                    byArray[14] = -105;
                    findCurrect = byArray;
                    findByte = mUsbIdCard.findCard();
                    if (findByte != null) break block5;
                    return 1;
                }
                catch (TelpoException e) {
                    e.printStackTrace();
                    return -99;
                }
            }
            if (!StringUtil.toHexString(findByte).equals(StringUtil.toHexString(findCurrect))) {
                return 1;
            }
            return 0;
        }
        return -99;
    }

    public static synchronized int usb_idcard_select() {
        if (mUsbIdCard != null) {
            byte[] selectByte;
            byte[] selectCurrect;
            block5: {
                try {
                    byte[] byArray = new byte[19];
                    byArray[0] = -86;
                    byArray[1] = -86;
                    byArray[2] = -86;
                    byArray[3] = -106;
                    byArray[4] = 105;
                    byArray[6] = 12;
                    byArray[9] = -112;
                    byArray[18] = -100;
                    selectCurrect = byArray;
                    selectByte = mUsbIdCard.selectCard();
                    if (selectByte != null) break block5;
                    return 1;
                }
                catch (TelpoException e) {
                    e.printStackTrace();
                    return -99;
                }
            }
            if (!StringUtil.toHexString(selectByte).equals(StringUtil.toHexString(selectCurrect))) {
                return 1;
            }
            return 0;
        }
        return -99;
    }

    public static synchronized byte[] usb_idcard_read() {
        if (mUsbIdCard != null) {
            try {
                return mUsbIdCard.readCard();
            }
            catch (TelpoException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static native boolean connect_idcard(int var0, int var1);

    private static native boolean connected_idcard(int var0, int var1, String var2);

    private static native boolean disconnect_idcard();

    private static native Object check_idcard(int var0, int[] var1);

    private static native int check_find(int var0);

    private static native int check_select(int var0);

    private static native int check_read(int var0);

    private static native byte[] get_image();

    private static native int get_imageusb(byte[] var0, String var1);

    public static native int getimage(byte[] var0, byte[] var1);

    private static native byte[] get_fringerprint();

    private static native byte[] get_sam();

    private class ReadThread
    extends Thread {
        @Override
        public void run() {
            super.run();
            while (!this.isInterrupted()) {
                try {
                    byte[] buffer = new byte[1024];
                    int size = IdCard.this.mInputStream.read(buffer);
                    buffer = Arrays.copyOfRange(buffer, 0, size);
                    if (IdCard.this.step == 1) {
                        idData_find = ReaderUtils.merge(idData_find, buffer);
                        buffer = null;
                    }
                    if (IdCard.this.step == 2) {
                        idData_select = ReaderUtils.merge(idData_select, buffer);
                        buffer = null;
                    }
                    if (IdCard.this.step == 3) {
                        IdCard.this.idData = ReaderUtils.merge(IdCard.this.idData, buffer);
                        idData_read = IdCard.this.idData;
                    }
                    if (IdCard.this.step != 4) continue;
                    Log.d((String)"idcard demo", (String)("addr:" + StringUtil.toHexString(buffer)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }
}

