/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.idcard;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.util.Log;
import com.telpo.tps550.api.DeviceNotFoundException;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.TimeoutException;
import com.telpo.tps550.api.idcard.IdentityMsg;
import com.telpo.tps550.api.idcard.ImageDecodeException;

public class TPS900IDCard {
    private static Context mContext = null;
    static IdentityMsg identityinfo = new IdentityMsg();
    static IdentityMsg idcardinfo = null;
    static byte[] imgae = new byte[1024];
    public static String name = null;
    public static String sex = null;
    public static String nation = null;
    public static String born = null;
    public static String address = null;
    public static String number = null;
    public static String office = null;
    public static String term = null;

    static {
        System.loadLibrary("idcard900");
    }

    public static synchronized void open(Context context) throws DeviceNotFoundException {
        if (!TPS900IDCard.connect_idcard()) {
            throw new DeviceNotFoundException();
        }
    }

    public static synchronized IdentityMsg checkIdCard(int timeout) throws TelpoException {
        int[] result = new int[2];
        IdentityMsg info = (IdentityMsg)TPS900IDCard.check_idcard(timeout, result);
        Log.d((String)"serial test", (String)"after check_idcard");
        if (info == null) {
            if (result[0] == -5) {
                TPS900IDCard.disconnect_idcard();
                throw new DeviceNotFoundException();
            }
            throw new TimeoutException();
        }
        return info;
    }

    public static synchronized byte[] getIdCardImage() throws TelpoException {
        return TPS900IDCard.get_image();
    }

    public static synchronized Bitmap decodeIdCardImage(byte[] image) throws TelpoException {
        if (image == null) {
            throw new ImageDecodeException();
        }
        if (TPS900IDCard.decode_image(image)) {
            String path = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + "/tps900/zp.bmp";
            try {
                return BitmapFactory.decodeFile((String)path);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ImageDecodeException();
            }
        }
        throw new ImageDecodeException();
    }

    public static synchronized void close() {
        TPS900IDCard.disconnect_idcard();
    }

    private static native boolean connect_idcard();

    private static native Object check_idcard(int var0, int[] var1);

    private static native byte[] get_image();

    private static native boolean decode_image(byte[] var0);

    private static native boolean disconnect_idcard();
}

