/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.idcard;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Environment;
import android.util.Log;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.idcard.IdCard;
import com.telpo.tps550.api.idcard.IdCardInitFailException;
import com.telpo.tps550.api.idcard.IdCardNotCheckException;
import com.telpo.tps550.api.idcard.IdentityMsg;
import com.telpo.tps550.api.idcard.ImageDecodeException;
import com.telpo.tps550.api.util.StringUtil;
import com.zkteco.android.IDReader.IDPhotoHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UsbIdCard {
    private static final byte[] SAM_HEADER = new byte[]{-86, -86, -86, -106, 105};
    static String[] nation_list = new String[]{"\u6c49", "\u8499\u53e4", "\u56de", "\u85cf", "\u7ef4\u543e\u5c14", "\u82d7", "\u5f5d", "\u58ee", "\u5e03\u4f9d", "\u671d\u9c9c", "\u6ee1", "\u4f97", "\u7476", "\u767d", "\u571f\u5bb6", "\u54c8\u5c3c", "\u54c8\u8428\u514b", "\u50a3", "\u9ece", "\u5088\u50f3", "\u4f64", "\u7572", "\u9ad8\u5c71", "\u62c9\u795c", "\u6c34", "\u4e1c\u4e61", "\u7eb3\u897f", "\u666f\u9887", "\u67ef\u5c14\u514b\u5b5c", "\u571f", "\u8fbe\u65a1\u5c14", "\u4eeb\u4f6c", "\u7f8c", "\u5e03\u6717", "\u6492\u62c9", "\u6bdb\u5357", "\u4ee1\u4f6c", "\u9521\u4f2f", "\u963f\u660c", "\u666e\u7c73", "\u5854\u5409\u514b", "\u6012", "\u4e4c\u5b5c\u522b\u514b", "\u4fc4\u7f57\u65af", "\u9102\u6e29\u514b", "\u5fb7\u6602", "\u4fdd\u5b89", "\u88d5\u56fa", "\u4eac", "\u5854\u5854\u5c14", "\u72ec\u9f99", "\u9102\u4f26\u6625", "\u8d6b\u54f2", "\u95e8\u5df4", "\u73de\u5df4", "\u57fa\u8bfa", "\u5176\u4ed6", "\u5916\u56fd\u8840\u7edf\u4e2d\u56fd\u7c4d\u4eba\u58eb"};
    private static UsbDevice idcard_reader = null;
    private static UsbManager mUsbManager = null;
    private static UsbDevice updater = null;
    private PendingIntent mPermissionIntent = null;
    private Context mContext;
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    private static int contentLength;
    private static int imageDatalength;
    private static int fplength;
    private byte[] resultCommand = null;
    private final int REQUEST = 0;
    private final int CHECK = 1;
    private final int DOWNLOAD_1 = 2;
    private final int DOWNLOAD_FINISH = 3;
    private final int NEW_PID = 649;
    private final int NEW_VID = 10473;
    private int checkCount = 0;
    private boolean finalRet = false;
    private long[] crc_16tab;

    public UsbIdCard(Context context) throws TelpoException {
        long[] lArray = new long[256];
        lArray[1] = 4129L;
        lArray[2] = 8258L;
        lArray[3] = 12387L;
        lArray[4] = 16516L;
        lArray[5] = 20645L;
        lArray[6] = 24774L;
        lArray[7] = 28903L;
        lArray[8] = 33032L;
        lArray[9] = 37161L;
        lArray[10] = 41290L;
        lArray[11] = 45419L;
        lArray[12] = 49548L;
        lArray[13] = 53677L;
        lArray[14] = 57806L;
        lArray[15] = 61935L;
        lArray[16] = 4657L;
        lArray[17] = 528L;
        lArray[18] = 12915L;
        lArray[19] = 8786L;
        lArray[20] = 21173L;
        lArray[21] = 17044L;
        lArray[22] = 29431L;
        lArray[23] = 25302L;
        lArray[24] = 37689L;
        lArray[25] = 33560L;
        lArray[26] = 45947L;
        lArray[27] = 41818L;
        lArray[28] = 54205L;
        lArray[29] = 50076L;
        lArray[30] = 62463L;
        lArray[31] = 58334L;
        lArray[32] = 9314L;
        lArray[33] = 13379L;
        lArray[34] = 1056L;
        lArray[35] = 5121L;
        lArray[36] = 25830L;
        lArray[37] = 29895L;
        lArray[38] = 17572L;
        lArray[39] = 21637L;
        lArray[40] = 42346L;
        lArray[41] = 46411L;
        lArray[42] = 34088L;
        lArray[43] = 38153L;
        lArray[44] = 58862L;
        lArray[45] = 62927L;
        lArray[46] = 50604L;
        lArray[47] = 54669L;
        lArray[48] = 13907L;
        lArray[49] = 9842L;
        lArray[50] = 5649L;
        lArray[51] = 1584L;
        lArray[52] = 30423L;
        lArray[53] = 26358L;
        lArray[54] = 22165L;
        lArray[55] = 18100L;
        lArray[56] = 46939L;
        lArray[57] = 42874L;
        lArray[58] = 38681L;
        lArray[59] = 34616L;
        lArray[60] = 63455L;
        lArray[61] = 59390L;
        lArray[62] = 55197L;
        lArray[63] = 51132L;
        lArray[64] = 18628L;
        lArray[65] = 22757L;
        lArray[66] = 26758L;
        lArray[67] = 30887L;
        lArray[68] = 2112L;
        lArray[69] = 6241L;
        lArray[70] = 10242L;
        lArray[71] = 14371L;
        lArray[72] = 51660L;
        lArray[73] = 55789L;
        lArray[74] = 59790L;
        lArray[75] = 63919L;
        lArray[76] = 35144L;
        lArray[77] = 39273L;
        lArray[78] = 43274L;
        lArray[79] = 47403L;
        lArray[80] = 23285L;
        lArray[81] = 19156L;
        lArray[82] = 31415L;
        lArray[83] = 27286L;
        lArray[84] = 6769L;
        lArray[85] = 2640L;
        lArray[86] = 14899L;
        lArray[87] = 10770L;
        lArray[88] = 56317L;
        lArray[89] = 52188L;
        lArray[90] = 64447L;
        lArray[91] = 60318L;
        lArray[92] = 39801L;
        lArray[93] = 35672L;
        lArray[94] = 47931L;
        lArray[95] = 43802L;
        lArray[96] = 27814L;
        lArray[97] = 31879L;
        lArray[98] = 19684L;
        lArray[99] = 23749L;
        lArray[100] = 11298L;
        lArray[101] = 15363L;
        lArray[102] = 3168L;
        lArray[103] = 7233L;
        lArray[104] = 60846L;
        lArray[105] = 64911L;
        lArray[106] = 52716L;
        lArray[107] = 56781L;
        lArray[108] = 44330L;
        lArray[109] = 48395L;
        lArray[110] = 36200L;
        lArray[111] = 40265L;
        lArray[112] = 32407L;
        lArray[113] = 28342L;
        lArray[114] = 24277L;
        lArray[115] = 20212L;
        lArray[116] = 15891L;
        lArray[117] = 11826L;
        lArray[118] = 7761L;
        lArray[119] = 3696L;
        lArray[120] = 65439L;
        lArray[121] = 61374L;
        lArray[122] = 57309L;
        lArray[123] = 53244L;
        lArray[124] = 48923L;
        lArray[125] = 44858L;
        lArray[126] = 40793L;
        lArray[127] = 36728L;
        lArray[128] = 37256L;
        lArray[129] = 33193L;
        lArray[130] = 45514L;
        lArray[131] = 41451L;
        lArray[132] = 53516L;
        lArray[133] = 49453L;
        lArray[134] = 61774L;
        lArray[135] = 57711L;
        lArray[136] = 4224L;
        lArray[137] = 161L;
        lArray[138] = 12482L;
        lArray[139] = 8419L;
        lArray[140] = 20484L;
        lArray[141] = 16421L;
        lArray[142] = 28742L;
        lArray[143] = 24679L;
        lArray[144] = 33721L;
        lArray[145] = 37784L;
        lArray[146] = 41979L;
        lArray[147] = 46042L;
        lArray[148] = 49981L;
        lArray[149] = 54044L;
        lArray[150] = 58239L;
        lArray[151] = 62302L;
        lArray[152] = 689L;
        lArray[153] = 4752L;
        lArray[154] = 8947L;
        lArray[155] = 13010L;
        lArray[156] = 16949L;
        lArray[157] = 21012L;
        lArray[158] = 25207L;
        lArray[159] = 29270L;
        lArray[160] = 46570L;
        lArray[161] = 42443L;
        lArray[162] = 38312L;
        lArray[163] = 34185L;
        lArray[164] = 62830L;
        lArray[165] = 58703L;
        lArray[166] = 54572L;
        lArray[167] = 50445L;
        lArray[168] = 13538L;
        lArray[169] = 9411L;
        lArray[170] = 5280L;
        lArray[171] = 1153L;
        lArray[172] = 29798L;
        lArray[173] = 25671L;
        lArray[174] = 21540L;
        lArray[175] = 17413L;
        lArray[176] = 42971L;
        lArray[177] = 47098L;
        lArray[178] = 34713L;
        lArray[179] = 38840L;
        lArray[180] = 59231L;
        lArray[181] = 63358L;
        lArray[182] = 50973L;
        lArray[183] = 55100L;
        lArray[184] = 9939L;
        lArray[185] = 14066L;
        lArray[186] = 1681L;
        lArray[187] = 5808L;
        lArray[188] = 26199L;
        lArray[189] = 30326L;
        lArray[190] = 17941L;
        lArray[191] = 22068L;
        lArray[192] = 55628L;
        lArray[193] = 51565L;
        lArray[194] = 63758L;
        lArray[195] = 59695L;
        lArray[196] = 39368L;
        lArray[197] = 35305L;
        lArray[198] = 47498L;
        lArray[199] = 43435L;
        lArray[200] = 22596L;
        lArray[201] = 18533L;
        lArray[202] = 30726L;
        lArray[203] = 26663L;
        lArray[204] = 6336L;
        lArray[205] = 2273L;
        lArray[206] = 14466L;
        lArray[207] = 10403L;
        lArray[208] = 52093L;
        lArray[209] = 56156L;
        lArray[210] = 60223L;
        lArray[211] = 64286L;
        lArray[212] = 35833L;
        lArray[213] = 39896L;
        lArray[214] = 43963L;
        lArray[215] = 48026L;
        lArray[216] = 19061L;
        lArray[217] = 23124L;
        lArray[218] = 27191L;
        lArray[219] = 31254L;
        lArray[220] = 2801L;
        lArray[221] = 6864L;
        lArray[222] = 10931L;
        lArray[223] = 14994L;
        lArray[224] = 64814L;
        lArray[225] = 60687L;
        lArray[226] = 56684L;
        lArray[227] = 52557L;
        lArray[228] = 48554L;
        lArray[229] = 44427L;
        lArray[230] = 40424L;
        lArray[231] = 36297L;
        lArray[232] = 31782L;
        lArray[233] = 27655L;
        lArray[234] = 23652L;
        lArray[235] = 19525L;
        lArray[236] = 15522L;
        lArray[237] = 11395L;
        lArray[238] = 7392L;
        lArray[239] = 3265L;
        lArray[240] = 61215L;
        lArray[241] = 65342L;
        lArray[242] = 53085L;
        lArray[243] = 57212L;
        lArray[244] = 44955L;
        lArray[245] = 49082L;
        lArray[246] = 36825L;
        lArray[247] = 40952L;
        lArray[248] = 28183L;
        lArray[249] = 32310L;
        lArray[250] = 20053L;
        lArray[251] = 24180L;
        lArray[252] = 11923L;
        lArray[253] = 16050L;
        lArray[254] = 3793L;
        lArray[255] = 7920L;
        this.crc_16tab = lArray;
        this.mContext = context;
        this.mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        mUsbManager = (UsbManager)context.getSystemService("usb");
        HashMap deviceHashMap = mUsbManager.getDeviceList();
        for (UsbDevice usbDevice : deviceHashMap.values()) {
            int pid = usbDevice.getProductId();
            int vid = usbDevice.getVendorId();
            Log.d((String)"idcard demo", (String)("pid:" + pid + ";vid:" + vid));
            if (!(pid == 50010 && vid == 1024 || pid == 22352 && vid == 1155) && (pid != 650 || vid != 10473)) continue;
            idcard_reader = usbDevice;
            if (mUsbManager.hasPermission(usbDevice)) break;
            mUsbManager.requestPermission(usbDevice, this.mPermissionIntent);
        }
        if (mUsbManager == null || idcard_reader == null) {
            throw new IdCardInitFailException("Failed to open usb device");
        }
    }

    public synchronized IdentityMsg checkIdCard() throws TelpoException {
        byte[] byArray = new byte[10];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 3;
        byArray[7] = 32;
        byArray[8] = 1;
        byArray[9] = 34;
        byte[] cmd_find_card = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[2] = -97;
        byte[] ret = this.requestUSBDataBtn(cmd_find_card, byArray2);
        byte[] byArray3 = new byte[10];
        byArray3[0] = -86;
        byArray3[1] = -86;
        byArray3[2] = -86;
        byArray3[3] = -106;
        byArray3[4] = 105;
        byArray3[6] = 3;
        byArray3[7] = 32;
        byArray3[8] = 2;
        byArray3[9] = 33;
        byte[] cmd_select_card = byArray3;
        byte[] byArray4 = new byte[3];
        byArray4[2] = -112;
        ret = this.requestUSBDataBtn(cmd_select_card, byArray4);
        byte[] byArray5 = new byte[10];
        byArray5[0] = -86;
        byArray5[1] = -86;
        byArray5[2] = -86;
        byArray5[3] = -106;
        byArray5[4] = 105;
        byArray5[6] = 3;
        byArray5[7] = 48;
        byArray5[8] = 16;
        byArray5[9] = 35;
        byte[] cmd_read_card = byArray5;
        byte[] byArray6 = new byte[3];
        byArray6[2] = -112;
        ret = this.requestUSBDataBtn(cmd_read_card, byArray6);
        return this.decodeIdCardBaseInfo(ret);
    }

    public synchronized byte[] findCard() throws TelpoException {
        byte[] ret = null;
        byte[] byArray = new byte[10];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 3;
        byArray[7] = 32;
        byArray[8] = 1;
        byArray[9] = 34;
        byte[] cmd_find_card = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[2] = -97;
        ret = this.requestUSBDataBtn(cmd_find_card, byArray2, 1);
        if (ret == null) {
            return null;
        }
        return ret;
    }

    public synchronized byte[] selectCard() throws TelpoException {
        byte[] ret = null;
        byte[] byArray = new byte[10];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 3;
        byArray[7] = 32;
        byArray[8] = 2;
        byArray[9] = 33;
        byte[] cmd_select_card = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[2] = -112;
        ret = this.requestUSBDataBtn(cmd_select_card, byArray2, 1);
        if (ret == null) {
            return null;
        }
        return ret;
    }

    public synchronized byte[] readCard() throws TelpoException {
        byte[] ret = null;
        byte[] byArray = new byte[10];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 3;
        byArray[7] = 48;
        byArray[8] = 16;
        byArray[9] = 35;
        byte[] cmd_read_card2 = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[2] = -112;
        ret = this.requestUSBDataBtn(cmd_read_card2, byArray2);
        if (ret == null) {
            return null;
        }
        return ret;
    }

    public static synchronized byte[] getIdCardImage(IdentityMsg info) throws TelpoException {
        byte[] image = info.getHead_photo();
        if (image == null) {
            throw new IdCardNotCheckException();
        }
        return image;
    }

    public static synchronized byte[] getFringerPrint(IdentityMsg info) throws TelpoException {
        byte[] image = UsbIdCard.getIdCardImage(info);
        byte[] fringerprint = null;
        if (image == null) {
            throw new IdCardNotCheckException();
        }
        try {
            fringerprint = Arrays.copyOfRange(image, imageDatalength, image.length);
        }
        catch (Exception e) {
            throw new IdCardNotCheckException();
        }
        if (fringerprint == null) {
            throw new IdCardNotCheckException();
        }
        return fringerprint;
    }

    public static Bitmap decodeIdCardImage(byte[] image) throws TelpoException {
        if (image == null) {
            throw new ImageDecodeException();
        }
        byte[] buf = new byte[38556];
        if (1 == IdCard.getimage(image, buf)) {
            return IDPhotoHelper.Bgr2Bitmap(buf);
        }
        throw new ImageDecodeException();
    }

    public synchronized String getSAM() throws TelpoException {
        byte[] byArray = new byte[10];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 3;
        byArray[7] = 18;
        byArray[8] = -1;
        byArray[9] = -18;
        byte[] cmd = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[2] = -112;
        byte[] sam_info = this.requestUSBDataBtn(cmd, byArray2);
        if (sam_info == null) {
            return null;
        }
        if (sam_info.length == 16) {
            StringBuilder sam = new StringBuilder();
            sam.append(UsbIdCard.bytearray2Str(sam_info, 0, 2, 2));
            sam.append(UsbIdCard.bytearray2Str(sam_info, 2, 2, 2));
            sam.append(UsbIdCard.bytearray2Str(sam_info, 4, 4, 8));
            sam.append(UsbIdCard.bytearray2Str(sam_info, 8, 4, 10));
            sam.append(UsbIdCard.bytearray2Str(sam_info, 12, 4, 10));
            return sam.toString();
        }
        return null;
    }

    public synchronized byte[] getPhyAddr() throws TelpoException {
        byte[] byArray = new byte[5];
        byArray[1] = 54;
        byArray[4] = 8;
        byte[] cmd = byArray;
        byte[] addr = this.requestAddr(cmd);
        if (addr == null) {
            return null;
        }
        return addr;
    }

    public String getVersion() {
        byte[] cmd = new byte[]{102, 1, 2, 3, -1, 107, 22};
        byte[] version = this.requestVersion(cmd);
        Log.d((String)"tagg2", (String)("version:" + StringUtil.toHexString(version)));
        byte left = 0;
        byte right = 0;
        if (version != null) {
            left = version[1];
            right = version[0];
        }
        return String.valueOf(left) + "." + right;
    }

    public byte[] requestVersion(byte[] cmd) {
        if (idcard_reader != null) {
            UsbInterface usbInterface = idcard_reader.getInterface(0);
            UsbEndpoint inEndpoint = usbInterface.getEndpoint(0);
            UsbEndpoint outEndpoint = usbInterface.getEndpoint(1);
            UsbDeviceConnection connection = null;
            connection = mUsbManager.openDevice(idcard_reader);
            if (connection == null) {
                return null;
            }
            connection.claimInterface(usbInterface, true);
            int out = connection.bulkTransfer(outEndpoint, cmd, cmd.length, 3000);
            byte[] byte2 = new byte[9];
            int ret = connection.bulkTransfer(inEndpoint, byte2, byte2.length, 3000);
            return Arrays.copyOfRange(byte2, 5, 7);
        }
        return null;
    }

    public byte[] requestAddr(byte[] cmd) {
        if (idcard_reader != null) {
            UsbInterface usbInterface = idcard_reader.getInterface(0);
            UsbEndpoint inEndpoint = usbInterface.getEndpoint(0);
            UsbEndpoint outEndpoint = usbInterface.getEndpoint(1);
            UsbDeviceConnection connection = null;
            connection = mUsbManager.openDevice(idcard_reader);
            if (connection == null) {
                return null;
            }
            connection.claimInterface(usbInterface, true);
            int out = connection.bulkTransfer(outEndpoint, cmd, cmd.length, 3000);
            byte[] byte2 = new byte[128];
            int ret = connection.bulkTransfer(inEndpoint, byte2, byte2.length, 3000);
            if (ret != -1) {
                return Arrays.copyOfRange(byte2, 0, ret);
            }
        }
        return null;
    }

    public byte[] requestUSBDataBtn(byte[] cmd, byte[] resp) {
        if (idcard_reader != null && resp.length == 3) {
            UsbInterface usbInterface = idcard_reader.getInterface(0);
            UsbEndpoint inEndpoint = usbInterface.getEndpoint(0);
            UsbEndpoint outEndpoint = usbInterface.getEndpoint(1);
            UsbDeviceConnection connection = null;
            try {
                connection = mUsbManager.openDevice(idcard_reader);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (connection == null) {
                return null;
            }
            connection.claimInterface(usbInterface, true);
            int out = connection.bulkTransfer(outEndpoint, cmd, cmd.length, 3000);
            byte[] byte2 = new byte[5120];
            int ret = connection.bulkTransfer(inEndpoint, byte2, byte2.length, 3000);
            int i = 0;
            while (i < SAM_HEADER.length) {
                if (byte2[i] != SAM_HEADER[i]) {
                    connection.close();
                    return null;
                }
                ++i;
            }
            i = 0;
            while (i < resp.length) {
                if (byte2[SAM_HEADER.length + 2 + i] != resp[i]) {
                    connection.close();
                    return null;
                }
                ++i;
            }
            connection.close();
            return Arrays.copyOfRange(byte2, SAM_HEADER.length + 5, ret - 1);
        }
        return null;
    }

    public byte[] requestUSBDataBtn(byte[] cmd, byte[] resp, int single) {
        if (idcard_reader != null && resp.length == 3) {
            UsbInterface usbInterface = idcard_reader.getInterface(0);
            UsbEndpoint inEndpoint = usbInterface.getEndpoint(0);
            UsbEndpoint outEndpoint = usbInterface.getEndpoint(1);
            UsbDeviceConnection connection = null;
            try {
                connection = mUsbManager.openDevice(idcard_reader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (connection == null) {
                return null;
            }
            connection.claimInterface(usbInterface, true);
            int out = connection.bulkTransfer(outEndpoint, cmd, cmd.length, 3000);
            byte[] byte2 = new byte[5120];
            int ret = connection.bulkTransfer(inEndpoint, byte2, byte2.length, 3000);
            int i = 0;
            while (i < SAM_HEADER.length) {
                if (byte2[i] != SAM_HEADER[i]) {
                    connection.close();
                    return null;
                }
                ++i;
            }
            i = 0;
            while (i < resp.length) {
                if (byte2[SAM_HEADER.length + 2 + i] != resp[i]) {
                    connection.close();
                    return null;
                }
                ++i;
            }
            connection.close();
            return Arrays.copyOfRange(byte2, 0, ret);
        }
        return null;
    }

    public static String toHexString1(byte b) {
        String s = Integer.toHexString(b & 0xFF);
        if (s.length() == 1) {
            return "0" + s;
        }
        return s;
    }

    private static String formatDate(String date) {
        StringBuilder formatedDate = new StringBuilder();
        formatedDate.append(date.substring(0, 4));
        formatedDate.append(".");
        formatedDate.append(date.substring(4, 6));
        formatedDate.append(".");
        formatedDate.append(date.substring(6, 8));
        return formatedDate.toString();
    }

    private static String bytearray2Str(byte[] data, int start, int length, int targetLength) {
        long number = 0L;
        if (data.length < start + length) {
            return "";
        }
        int i = 1;
        while (i <= length) {
            number *= 256L;
            number += (long)(data[start + length - i] & 0xFF);
            ++i;
        }
        return String.format("%0" + targetLength + "d", number);
    }

    private static int countChinese(String str) {
        int count = 0;
        Pattern p = Pattern.compile("[\\u4e00-\\u9fa5]");
        Matcher m = p.matcher(str);
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public IdentityMsg decodeIdCardBaseInfo(byte[] ret) {
        if (ret == null) {
            return null;
        }
        byte[] dataByte = Arrays.copyOfRange(ret, 6, ret.length);
        imageDatalength = (char)ret[2] * 256 + (char)ret[3];
        contentLength = ret[0] << 8 & 0xFF00;
        contentLength += ret[1];
        imageDatalength = ret[2] << 8 & 0xFF00;
        imageDatalength += ret[3];
        fplength = ret[4] << 8 & 0xFF00;
        fplength += ret[5];
        IdentityMsg info = new IdentityMsg();
        String stringBuffer = null;
        try {
            stringBuffer = new String(dataByte, "UTF16-LE");
            stringBuffer = new String(stringBuffer.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        info.setName(stringBuffer.substring(0, 60));
        info.setSex(stringBuffer.substring(60, 61));
        info.setNo(stringBuffer.substring(61, 76));
        info.setCountry(stringBuffer.substring(76, 79));
        info.setCn_name(stringBuffer.substring(79, 94));
        info.setPeriod(stringBuffer.substring(94, 110));
        info.setBorn(stringBuffer.substring(110, 118));
        info.setIdcard_version(stringBuffer.substring(118, 120));
        info.setApartment(stringBuffer.substring(120, 124));
        info.setCard_type(stringBuffer.substring(124, 125));
        info.setReserve(stringBuffer.substring(125, 128));
        info.setHead_photo(Arrays.copyOfRange(dataByte, 256, dataByte.length));
        if (!"I".equals(info.getCard_type())) {
            info.setName(stringBuffer.substring(0, 15));
            info.setSex(stringBuffer.substring(15, 16));
            if (!stringBuffer.substring(16, 18).equals("  ")) {
                info.setNation(stringBuffer.substring(16, 18));
            }
            info.setBorn(stringBuffer.substring(18, 26));
            info.setAddress(stringBuffer.substring(26, 61).trim());
            info.setNo(stringBuffer.substring(61, 79).trim());
            info.setApartment(stringBuffer.substring(79, 94).trim());
            info.setPeriod(stringBuffer.substring(94, 110));
            if (!stringBuffer.substring(110, 119).equals("         ")) {
                info.setPassNum(stringBuffer.substring(110, 119));
            }
            if (!stringBuffer.substring(119, 121).equals("  ")) {
                info.setIssuesNum(stringBuffer.substring(119, 121));
            }
            if (!stringBuffer.substring(124, 125).equals(" ")) {
                info.setCardSignal(stringBuffer.substring(124, 125));
            }
            info.setHead_photo(Arrays.copyOfRange(dataByte, 256, dataByte.length));
        }
        StringBuilder builder = new StringBuilder();
        String temp = info.getName().trim();
        info.setName(temp);
        temp = info.getNation();
        try {
            info.setNation(nation_list[Integer.parseInt(temp) - 1]);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        temp = info.getSex();
        if ("1".equals(temp)) {
            info.setSex("\u7537 / M");
        } else if ("2".equals(temp)) {
            info.setSex("\u5973 / F");
        }
        temp = info.getBorn().trim();
        if (temp.length() >= 8) {
            info.setBorn(UsbIdCard.formatDate(temp));
        }
        if ((temp = info.getPeriod().trim()).length() >= 16) {
            info.setPeriod(String.valueOf(UsbIdCard.formatDate(temp.substring(0, 8))) + " - " + UsbIdCard.formatDate(temp.substring(8)));
        }
        if ("I".equals(info.getCard_type())) {
            info.setApartment("\u516c\u5b89\u90e8/Ministry of Public Security");
        }
        return info;
    }

    public boolean moduleUpdate() {
        if (this.connectUsb()) {
            if (this.getUpdate()) {
                Log.d((String)"tagg2", (String)"update success");
                return true;
            }
            Log.d((String)"tagg2", (String)"update failed");
        }
        return false;
    }

    private static void replaceIndex(int index, String res, String str) {
        res = String.valueOf(res.substring(0, index)) + str + res.substring(index + 1);
    }

    private static boolean isFileExists(String filePath) {
        try {
            File f = new File(filePath);
            return f.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean copyFile(String fileName, String path) {
        File oFile;
        boolean copyIsFinish;
        block4: {
            copyIsFinish = false;
            oFile = new File(fileName);
            if (oFile.exists() && oFile.canRead()) break block4;
            return false;
        }
        try {
            FileInputStream is = new FileInputStream(oFile);
            File file = new File(path);
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            byte[] temp = new byte[1024];
            int i = 0;
            while ((i = ((InputStream)is).read(temp)) > 0) {
                fos.write(temp, 0, i);
            }
            fos.close();
            ((InputStream)is).close();
            copyIsFinish = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return copyIsFinish;
    }

    private boolean getUpdate() {
        this.requestOrCheck(0);
        this.sleep();
        while (this.checkCount < 5 && !this.downloadFile()) {
            this.sleep();
            this.requestOrCheck(1);
            ++this.checkCount;
            this.sleep();
        }
        return this.finalRet;
    }

    private void sleep() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private boolean connectUsb() {
        return this.connectUsb(-1, -1);
    }

    private boolean connectUsb(int newPID, int newVID) {
        Log.d((String)"tagg2", (String)"update-connectUSB");
        boolean connectedUsb = false;
        this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        mUsbManager = (UsbManager)this.mContext.getSystemService("usb");
        HashMap deviceHashMap = mUsbManager.getDeviceList();
        for (UsbDevice usbDevice : deviceHashMap.values()) {
            int pid = usbDevice.getProductId();
            int vid = usbDevice.getVendorId();
            if (!(pid == 50010 && vid == 1024 || pid == 22352 && vid == 1155 || pid == 650 && vid == 10473) && (pid != newPID || vid != newVID)) continue;
            Log.d((String)"tagg2", (String)("pid:" + pid + ";vid:" + vid));
            updater = usbDevice;
            if (mUsbManager.hasPermission(usbDevice)) {
                connectedUsb = true;
                break;
            }
            mUsbManager.requestPermission(usbDevice, this.mPermissionIntent);
            connectedUsb = true;
        }
        return connectedUsb;
    }

    private boolean requestUpdateDataBtn(byte[] cmd, int download) {
        if (updater != null) {
            UsbInterface usbInterface = updater.getInterface(0);
            UsbEndpoint inEndpoint = usbInterface.getEndpoint(0);
            UsbEndpoint outEndpoint = usbInterface.getEndpoint(1);
            UsbDeviceConnection connection = null;
            try {
                connection = mUsbManager.openDevice(updater);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (connection == null) {
                return false;
            }
            connection.claimInterface(usbInterface, true);
            int out = connection.bulkTransfer(outEndpoint, cmd, cmd.length, 3000);
            Log.d((String)"tagg2", (String)("output--->" + StringUtil.toHexString(cmd)));
            byte[] byte2 = new byte[5120];
            int ret = connection.bulkTransfer(inEndpoint, byte2, byte2.length, 3000);
            connection.close();
            this.resultCommand = null;
            if (ret != -1) {
                this.resultCommand = Arrays.copyOfRange(byte2, 0, ret);
                Log.d((String)"idcard demo", (String)("input data--->" + StringUtil.toHexString(this.resultCommand)));
            }
            if (download == 0) {
                return true;
            }
            if (download == 1) {
                if (ret != -1 && this.resultCommand[9] == 1) {
                    return true;
                }
            } else if (download == 3 && ret != -1 && this.resultCommand[9] == 0) {
                this.finalRet = true;
                return true;
            }
        }
        return false;
    }

    private boolean requestOrCheck(int status) {
        if (status == 0) {
            this.connectUsb();
        } else if (status == 1) {
            this.connectUsb(649, 10473);
        }
        byte[] project_bin = null;
        String codeLenth = null;
        String crc = null;
        String xorString = null;
        String cmdStr = null;
        byte[] cmd = null;
        try {
            project_bin = UsbIdCard.getBytes4File(String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + "/project.bin");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        codeLenth = Integer.toHexString(project_bin.length);
        if (codeLenth.length() == 4) {
            codeLenth = "0000" + codeLenth;
        } else if (codeLenth.length() == 6) {
            codeLenth = "00" + codeLenth;
        }
        int codeSize = codeLenth.length();
        codeLenth = String.valueOf(codeLenth.substring(codeSize - 2, codeSize)) + codeLenth.substring(codeSize - 4, codeSize - 2) + codeLenth.substring(codeSize - 6, codeSize - 4) + codeLenth.substring(0, codeSize - 6);
        String tempCRC = Long.toHexString(this.getCRC(project_bin, project_bin.length));
        crc = String.valueOf(tempCRC.substring(tempCRC.length() - 2, tempCRC.length())) + tempCRC.substring(tempCRC.length() - 4, tempCRC.length() - 2);
        xorString = "00078020" + codeLenth + crc;
        byte xorByte = UsbIdCard.getXor(UsbIdCard.hexStringToBytes(xorString));
        cmdStr = "AAAAAA966900078020" + codeLenth + crc + StringUtil.toHexString(new byte[]{xorByte});
        cmd = UsbIdCard.hexStringToBytes(cmdStr);
        return this.requestUpdateDataBtn(cmd, status);
    }

    private boolean downloadFile() {
        if (this.connectUsb(649, 10473)) {
            byte[] project_bin = null;
            byte[] project_bin_1 = null;
            byte[] project_bin_2 = null;
            try {
                project_bin = UsbIdCard.getBytes4File(String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + "/project.bin");
                project_bin_1 = Arrays.copyOfRange(project_bin, 0, 16385);
                project_bin_2 = Arrays.copyOfRange(project_bin, 16384, project_bin.length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (project_bin != null) {
                this.requestUpdateDataBtn(project_bin_1, 2);
                return this.requestUpdateDataBtn(project_bin_2, 3);
            }
        }
        return false;
    }

    private static byte[] getBytes4File(String filePath) throws IOException {
        FileInputStream in = null;
        BufferedInputStream buffer = null;
        FilterInputStream dataIn = null;
        ByteArrayOutputStream bos = null;
        FilterOutputStream dos = null;
        byte[] bArray = null;
        try {
            try {
                int len;
                in = new FileInputStream(filePath);
                buffer = new BufferedInputStream(in);
                dataIn = new DataInputStream(buffer);
                bos = new ByteArrayOutputStream();
                dos = new DataOutputStream(bos);
                byte[] buf = new byte[1024];
                while ((len = ((DataInputStream)dataIn).read(buf)) >= 0) {
                    ((DataOutputStream)dos).write(buf, 0, len);
                }
                bArray = bos.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (dataIn != null) {
                    dataIn.close();
                }
                if (buffer != null) {
                    buffer.close();
                }
                if (bos != null) {
                    bos.close();
                }
                if (dos != null) {
                    dos.close();
                }
                return null;
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (dataIn != null) {
                dataIn.close();
            }
            if (buffer != null) {
                buffer.close();
            }
            if (bos != null) {
                bos.close();
            }
            if (dos != null) {
                dos.close();
            }
        }
        return bArray;
    }

    private static byte getXor(byte[] datas) {
        byte temp = datas[0];
        int i = 1;
        while (i < datas.length) {
            temp = (byte)(temp ^ datas[i]);
            ++i;
        }
        return temp;
    }

    private static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase().replace(" ", "");
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(UsbIdCard.charToByte(hexChars[pos]) << 4 | UsbIdCard.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    private long getCRC(byte[] project, int length) {
        long cksum = 0L;
        int i = 0;
        while (i < length) {
            cksum = this.crc_16tab[(int)((cksum >> 8 ^ (long)project[i]) & 0xFFL)] ^ cksum << 8;
            ++i;
        }
        return cksum;
    }
}

