/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.led;

import android.os.Handler;
import android.util.Log;
import android_serialport_api.SerialPort;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class SerialUtil {
    private final Handler handler;
    private SerialPort serialPort;
    private ReadThread readThread;
    private InputStream inputStream;
    private OutputStream outputStream;
    private ByteBuffer rcvBuffer = ByteBuffer.allocate(4096);
    private static final String Tag = "SerialUtil";

    public SerialUtil(Handler hd) {
        this.handler = hd;
    }

    public void open(String path, int baudrate) throws SecurityException, IOException {
        if (this.serialPort == null) {
            Log.i((String)Tag, (String)path);
            this.serialPort = new SerialPort(new File(path), baudrate, 0);
            if (this.serialPort != null) {
                if (this.readThread == null) {
                    this.readThread = new ReadThread();
                    this.readThread.start();
                }
                this.inputStream = this.serialPort.getInputStream();
                this.outputStream = this.serialPort.getOutputStream();
                Log.d((String)Tag, (String)"Open serial port OK!");
            }
        }
    }

    public void close() {
        if (this.readThread != null) {
            this.readThread.interrupt();
            this.readThread = null;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                Log.d((String)Tag, (String)"inputStream close failed!");
                e.printStackTrace();
            }
            this.inputStream = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                Log.d((String)Tag, (String)"outputStream close failed!");
                e.printStackTrace();
            }
            this.outputStream = null;
        }
        if (this.serialPort != null) {
            this.serialPort.close();
            this.serialPort = null;
        }
        Log.d((String)Tag, (String)"close serial port OK!");
    }

    public void send(byte[] data) {
        if (this.outputStream != null) {
            int len = data.length;
            try {
                int i = 0;
                while (i < len) {
                    this.outputStream.write(data[i]);
                    this.outputStream.flush();
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(byte[] buf) {
        int count = 0;
        ByteBuffer byteBuffer = this.rcvBuffer;
        synchronized (byteBuffer) {
            this.rcvBuffer.flip();
            if (this.rcvBuffer.hasRemaining()) {
                count = this.rcvBuffer.remaining() < buf.length ? this.rcvBuffer.remaining() : buf.length;
                this.rcvBuffer.get(buf, 0, count);
            }
            this.rcvBuffer.compact();
        }
        return count;
    }

    public boolean isOpen() {
        return this.serialPort != null;
    }

    private class ReadThread
    extends Thread {
        private ReadThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            byte[] buffer = new byte[1024];
            Log.d((String)SerialUtil.Tag, (String)"Read thread start!");
            super.run();
            try {
                while (!this.isInterrupted()) {
                    int size;
                    ReadThread.sleep(200L);
                    if (SerialUtil.this.inputStream.available() <= 0 || (size = SerialUtil.this.inputStream.read(buffer)) <= 0) continue;
                    ByteBuffer byteBuffer = SerialUtil.this.rcvBuffer;
                    synchronized (byteBuffer) {
                        if (SerialUtil.this.rcvBuffer.hasRemaining()) {
                            int count = SerialUtil.this.rcvBuffer.remaining() < size ? SerialUtil.this.rcvBuffer.remaining() : size;
                            SerialUtil.this.rcvBuffer.put(buffer, 0, count);
                        }
                    }
                    SerialUtil.this.handler.sendEmptyMessage(1);
                }
            }
            catch (Exception e) {
                Log.d((String)SerialUtil.Tag, (String)"Read thread end for IOException!");
                e.printStackTrace();
            }
            Log.d((String)SerialUtil.Tag, (String)"Read thread end!");
        }
    }
}

