/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.magnetic;

import android.content.Context;
import android.util.Log;
import com.telpo.tps550.api.DeviceAlreadyOpenException;
import com.telpo.tps550.api.DeviceNotOpenException;
import com.telpo.tps550.api.InternalErrorException;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.TimeoutException;
import com.telpo.tps550.api.magnetic.MagneticCard2;
import com.telpo.tps550.api.util.StringUtil;
import com.telpo.tps550.api.util.SystemUtil;
import java.io.UnsupportedEncodingException;

public class MagneticCard {
    private static final String TAG = "TELPO_SDK";

    static {
        if (SystemUtil.getDeviceType() != StringUtil.DeviceModelEnum.TPS900.ordinal() && SystemUtil.getDeviceType() != StringUtil.DeviceModelEnum.TPS390P.ordinal() && SystemUtil.getDeviceType() != StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            System.loadLibrary("telpo_msr");
        }
    }

    public static synchronized void open() throws TelpoException {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            return;
        }
        int ret = MagneticCard.open_msr();
        switch (ret) {
            case -2: {
                throw new DeviceAlreadyOpenException("The magnetic stripe card reader has been opened!");
            }
            case -3: {
                throw new InternalErrorException("Cannot open magnetic stripe card reader!");
            }
        }
    }

    public static synchronized void open(Context context) throws TelpoException {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            MagneticCard2.open(context);
            return;
        }
        int ret = MagneticCard.open_msr();
        switch (ret) {
            case -2: {
                throw new DeviceAlreadyOpenException("The magnetic stripe card reader has been opened!");
            }
            case -3: {
                throw new InternalErrorException("Cannot open magnetic stripe card reader!");
            }
        }
    }

    public static synchronized void close() {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                MagneticCard2.close();
            }
            catch (TelpoException e) {
                e.printStackTrace();
            }
            return;
        }
        MagneticCard.close_msr();
    }

    public static synchronized String[] check(int timeout) throws TelpoException {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            if (MagneticCard2.check(timeout) != 0) {
                throw new TimeoutException("Timeout to get magnetic stripe card data!");
            }
            return MagneticCard2.read();
        }
        byte[] result = new byte[256];
        int ret = MagneticCard.check_msr(timeout, result);
        Log.d((String)"TAG", (String)"after check_msr");
        Log.d((String)"TAG", (String)("ret is" + ret));
        switch (ret) {
            case -1: {
                throw new DeviceNotOpenException("The magnetic stripe card reader has not been opened!");
            }
            case -3: {
                throw new InternalErrorException("Cannot get magnetic stripe card data!");
            }
            case -4: {
                throw new TimeoutException("Timeout to get magnetic stripe card data!");
            }
        }
        Log.d((String)"TAG", (String)"after switch");
        return MagneticCard.ParseData(ret, result);
    }

    private static String[] ParseData(int size, byte[] data) throws TelpoException {
        Log.d((String)"TAG", (String)"parseData");
        String[] result = new String[3];
        int pos = 0;
        byte len = data[pos];
        if (len == 0) {
            result[0] = "";
        } else {
            try {
                result[0] = new String(data, pos + 1, (int)len, "GBK");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
        }
        pos = data[0] + 1;
        len = data[pos];
        if (len == 0) {
            result[1] = "";
        } else {
            try {
                result[1] = new String(data, pos + 1, (int)len, "GBK");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
        }
        pos += data[pos] + 1;
        len = data[pos];
        if (len == 0) {
            result[2] = "";
        } else {
            try {
                result[2] = new String(data, pos + 1, (int)len, "GBK");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
        }
        return result;
    }

    public static int startReading() {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            return 0;
        }
        return MagneticCard.ready_for_read();
    }

    private static native int open_msr();

    private static native void close_msr();

    private static native int check_msr(int var0, byte[] var1);

    private static native int ready_for_read();
}

