/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.nfc;

import android.content.Context;
import android.util.Log;
import com.telpo.tps550.api.DeviceAlreadyOpenException;
import com.telpo.tps550.api.DeviceNotOpenException;
import com.telpo.tps550.api.InternalErrorException;
import com.telpo.tps550.api.TelpoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Nfc {
    private Context mContext = null;
    private boolean openFlag = false;

    public Nfc(Context context) {
        this.mContext = context;
    }

    public synchronized void open() throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        if (this.openFlag) {
            throw new DeviceAlreadyOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("open", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, new Object[0]);
            this.openFlag = true;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
    }

    public synchronized void close() throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("close", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, new Object[0]);
            this.openFlag = false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
    }

    public synchronized byte[] activate(int timeOut) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        byte[] result = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("activate", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            result = (byte[])method.invoke(obj, timeOut);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
        return result;
    }

    public synchronized byte[] cpu_get_ats() throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        byte[] result = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("cpu_get_ats", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            result = (byte[])method.invoke(obj, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
        return result;
    }

    public synchronized byte[] transmit(byte[] sendBuffer, int sendBufferLength) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        byte[] result = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("cpu_transmit", byte[].class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            result = (byte[])method.invoke(obj, sendBuffer, sendBufferLength);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
        return result;
    }

    public synchronized byte[] m1_read_block(byte noBlock) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        byte[] result = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("m1_read_block", Byte.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            result = (byte[])method.invoke(obj, noBlock);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
        return result;
    }

    public synchronized void m1_write_block(byte noBlock, byte[] inBuf, int inLen) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("m1_write_block", Byte.TYPE, byte[].class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, noBlock, inBuf, inLen);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
    }

    public synchronized byte[] m1_read_value(byte noBlock) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        byte[] result = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("m1_read_value", Byte.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            result = (byte[])method.invoke(obj, noBlock);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
        return result;
    }

    public synchronized void m1_write_value(byte noBlock, byte[] inBuf, int inLen) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("m1_write_value", Byte.TYPE, byte[].class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, noBlock, inBuf, inLen);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
    }

    public synchronized void m1_increment(byte srcAddr, byte destAddr, byte[] inBuf, int inLen) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("m1_increment", Byte.TYPE, Byte.TYPE, byte[].class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, srcAddr, destAddr, inBuf, inLen);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
    }

    public synchronized void m1_decrement(byte srcAddr, byte destAddr, byte[] inBuf, int inLen) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("m1_decrement", Byte.TYPE, Byte.TYPE, byte[].class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, srcAddr, destAddr, inBuf, inLen);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
    }

    public synchronized void halt() throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("halt", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
    }

    public synchronized void remove(int timeOut) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("remove", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, timeOut);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
    }

    public synchronized void m1_authenticate(byte noBlock, byte passwdType, byte[] passwd) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("m1_authenticate", Byte.TYPE, Byte.TYPE, byte[].class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, noBlock, passwdType, passwd);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
    }

    public synchronized byte[] read_idcard(int timeOut) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        byte[] result = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("read_idcard", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            result = (byte[])method.invoke(obj, timeOut);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
        return result;
    }

    public synchronized void mp_sl0_personalization(byte[] keyBuf, int keyLen, byte[] dataBuf, int dataLen) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        int i = 0;
        int j = 0;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        i = 0;
        while (i < keyBuf.length) {
            Log.w((String)"Nfc", (String)("keyBuf = " + keyBuf[i]));
            ++i;
        }
        j = 0;
        while (j < dataBuf.length) {
            Log.w((String)"Nfc", (String)("dataBuf = " + dataBuf[j]));
            ++j;
        }
        Log.w((String)"Nfc", (String)("keyBuf len = " + keyBuf.length + "  keyLen = " + keyLen));
        Log.w((String)"Nfc", (String)("dataBuf len = " + dataBuf.length + "  dataLen = " + dataLen));
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("mp_sl0_personalization", byte[].class, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, keyBuf, keyLen, dataBuf, dataLen);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Exception targetExp = (Exception)e.getTargetException();
            if (targetExp instanceof TelpoException) {
                throw (TelpoException)targetExp;
            }
            throw new InternalErrorException();
        }
    }

    public synchronized void mp_sl0_commit() throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("mp_sl0_commit", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Exception targetExp = (Exception)e.getTargetException();
            if (targetExp instanceof TelpoException) {
                throw (TelpoException)targetExp;
            }
            throw new InternalErrorException();
        }
    }

    public synchronized void mp_sl1_switch_sl3(byte[] aesKey) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("mp_sl1_switch_sl3", byte[].class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, new Object[]{aesKey});
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Exception targetExp = (Exception)e.getTargetException();
            if (targetExp instanceof TelpoException) {
                throw (TelpoException)targetExp;
            }
            throw new InternalErrorException();
        }
    }

    public synchronized void mp_sl3_auth(byte noBlock, byte key, byte[] aesKey) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        int i = 0;
        Log.w((String)"Nfc", (String)"enter in the mp_sl3_auth");
        Log.w((String)"Nfc", (String)("noBlock = " + noBlock));
        Log.w((String)"Nfc", (String)("key = " + key));
        i = 0;
        while (i < 16) {
            Log.w((String)"Nfc", (String)("aesKey = " + aesKey[i]));
            ++i;
        }
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Log.e((String)"Nfc", (String)"mp_sl3_auth fail");
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("mp_sl3_auth", Byte.TYPE, Byte.TYPE, byte[].class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            Log.e((String)"Nfc", (String)"the mp_sl3_auth method fail");
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, noBlock, key, aesKey);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            Log.e((String)"Nfc", (String)"the mp_sl3_auth invoke fail");
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            Log.e((String)"Nfc", (String)"the mp_sl3_auth invoke fail 2");
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Log.e((String)"Nfc", (String)"the mp_sl3_auth invoke fail 3");
            Exception targetExp = (Exception)e.getTargetException();
            if (targetExp instanceof TelpoException) {
                Log.e((String)"Nfc", (String)"the mp_sl3_auth invoke fail 4");
                throw (TelpoException)targetExp;
            }
            Log.e((String)"Nfc", (String)"the mp_sl3_auth invoke fail 5");
            throw new InternalErrorException();
        }
    }

    public synchronized byte[] mp_sl3_readblock_plain(byte noBlock) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        byte[] result = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("mp_sl3_readblock_plain", Byte.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            result = (byte[])method.invoke(obj, noBlock);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Exception targetExp = (Exception)e.getTargetException();
            if (targetExp instanceof TelpoException) {
                throw (TelpoException)targetExp;
            }
            throw new InternalErrorException();
        }
        return result;
    }

    public synchronized void mp_sl3_writeblock_plain(byte noBlock, byte[] inBuf, int inLen) throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        int i = 0;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        Log.w((String)"Nfc", (String)"enter in the mp_sl3_writeblock_plain");
        Log.w((String)"Nfc", (String)("noBlock = " + noBlock));
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        i = 0;
        while (i < inLen) {
            Log.w((String)"Nfc", (String)("inBuf = " + inBuf[i]));
            ++i;
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("mp_sl3_writeblock_plain", Byte.TYPE, byte[].class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, noBlock, inBuf, inLen);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Exception targetExp = (Exception)e.getTargetException();
            if (targetExp instanceof TelpoException) {
                throw (TelpoException)targetExp;
            }
            throw new InternalErrorException();
        }
    }

    public synchronized byte[] get_uid() throws TelpoException {
        Class<?> nfccard = null;
        Method method = null;
        Object obj = null;
        byte[] result = null;
        if (!this.openFlag) {
            throw new DeviceNotOpenException();
        }
        try {
            nfccard = Class.forName("com.common.sdk.nfc.NFCServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("NFC");
        try {
            method = nfccard.getMethod("get_uid", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            result = (byte[])method.invoke(obj, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            throw new TelpoException();
        }
        return result;
    }
}

