/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.printer;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.util.ArrayList;
import java.util.List;

public class PT723F08401PrinterCore {
    public static int BitmapWidth = 0;
    public static int PrintDataHeight = 0;
    private static int LBlank = 0;
    private static int RBlank = 0;

    public static byte[] PrintDataFormat(Bitmap bmp) {
        try {
            byte[] bPrintData = PT723F08401PrinterCore.CreatePrintBitmpaData(bmp);
            return PT723F08401PrinterCore.CompressPrintData(bPrintData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] CompressPrintData(byte[] pData) {
        try {
            byte[] bOneLine = new byte[BitmapWidth];
            ArrayList<byte[]> AllDatas = new ArrayList<byte[]>();
            ArrayList<Object> LineDatas = new ArrayList<byte[]>();
            ArrayList<Object> BlankDatas = new ArrayList<byte[]>();
            int rowL = 0;
            int rowR = 0;
            int i = 0;
            while (i < PrintDataHeight) {
                boolean bBlankLine = true;
                byte OnePix = 0;
                rowL = 0;
                rowR = 0;
                int iRowColIdx = i * BitmapWidth;
                bOneLine = new byte[BitmapWidth];
                int j = 0;
                while (j < BitmapWidth) {
                    OnePix = pData[iRowColIdx + j];
                    if (OnePix != 0) {
                        if (j == 0) {
                            rowL = 0;
                        } else if (rowL > rowR) {
                            rowL = rowR;
                        }
                        rowR = j;
                        bBlankLine = false;
                    }
                    bOneLine[j] = OnePix;
                    ++j;
                }
                if (!bBlankLine) {
                    LBlank = LBlank == 0 ? rowL : (LBlank < rowL ? LBlank : rowL);
                    RBlank = RBlank < rowR ? rowR : RBlank;
                    int BlankDatasSize = BlankDatas.size();
                    if (BlankDatasSize > 0) {
                        if (BlankDatasSize > 24) {
                            if (LineDatas.size() > 0) {
                                AllDatas.add(PT723F08401PrinterCore.TrimBitmapBlank(LineDatas));
                            }
                            AllDatas.add(PT723F08401PrinterCore.CreateFeedLineCMD(BlankDatas));
                            LineDatas = new ArrayList();
                        } else {
                            LineDatas.addAll(BlankDatas);
                        }
                        BlankDatas = new ArrayList();
                    }
                    LineDatas.add(bOneLine);
                    if (LineDatas.size() == 100) {
                        AllDatas.add(PT723F08401PrinterCore.TrimBitmapBlank(LineDatas));
                        LineDatas = new ArrayList();
                    }
                } else {
                    BlankDatas.add(bOneLine);
                }
                ++i;
            }
            int BlankDatasSize = BlankDatas.size();
            if (BlankDatasSize > 0) {
                if (BlankDatasSize > 24) {
                    if (LineDatas.size() > 0) {
                        AllDatas.add(PT723F08401PrinterCore.TrimBitmapBlank(LineDatas));
                    }
                    AllDatas.add(PT723F08401PrinterCore.CreateFeedLineCMD(BlankDatas));
                } else {
                    LineDatas.addAll(BlankDatas);
                    AllDatas.add(PT723F08401PrinterCore.TrimBitmapBlank(LineDatas));
                }
            } else {
                AllDatas.add(PT723F08401PrinterCore.TrimBitmapBlank(LineDatas));
            }
            return PT723F08401PrinterCore.sysCopy(AllDatas);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] CreateFeedLineCMD(List<byte[]> BlankDatas) {
        try {
            int mm = 8;
            ArrayList<byte[]> BL = new ArrayList<byte[]>();
            int iLine = 0;
            int iLineCnt = BlankDatas.size();
            while (iLine < iLineCnt) {
                byte[] byArray = new byte[3];
                byArray[0] = 27;
                byArray[1] = 74;
                byte[] OneFeedCMD = byArray;
                OneFeedCMD[2] = iLineCnt - iLine > 240 ? -16 : (byte)((iLineCnt - iLine) * 8 / mm);
                BL.add(OneFeedCMD);
                iLine += 240;
            }
            return PT723F08401PrinterCore.sysCopy(BL);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] TrimBitmapBlank(List<byte[]> LineDatas) {
        try {
            int iDataWid = RBlank - LBlank + 1;
            int iLine = 0;
            int iLineCnt = LineDatas.size();
            int iMaxHeight = 2300;
            int iPKIndex = 0;
            int iPackage = iLineCnt % iMaxHeight > 0 ? iLineCnt / iMaxHeight + 1 : iLineCnt / iMaxHeight;
            byte[] RtnData = new byte[iDataWid * iLineCnt + 8 * iPackage];
            while (iLine < iLineCnt) {
                int iCurPackageLine = iLine + iMaxHeight < iLineCnt ? iMaxHeight : iLineCnt - iLine;
                int iCurPackageBegin = (8 + iMaxHeight) * iPKIndex;
                RtnData[iCurPackageBegin] = 29;
                RtnData[iCurPackageBegin + 1] = 118;
                RtnData[iCurPackageBegin + 2] = 48;
                RtnData[iCurPackageBegin + 3] = 0;
                RtnData[iCurPackageBegin + 4] = (byte)(iDataWid % 256);
                RtnData[iCurPackageBegin + 5] = (byte)(iDataWid / 256);
                RtnData[iCurPackageBegin + 6] = (byte)(iCurPackageLine % 256);
                RtnData[iCurPackageBegin + 7] = (byte)(iCurPackageLine / 256);
                int l = iLine;
                while (l < iLineCnt) {
                    System.arraycopy(LineDatas.get(l), LBlank, RtnData, (8 + iMaxHeight) * iPKIndex + l * iDataWid + 8, iDataWid);
                    ++l;
                }
                iLine += iMaxHeight;
                ++iPKIndex;
            }
            LBlank = 0;
            RBlank = 0;
            return RtnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] CreatePrintBitmpaData(Bitmap bmp) {
        int r = 0;
        int g = 0;
        int b = 0;
        int startLine = 0;
        int nDataIndex = 0;
        int nBitIndex = 0;
        try {
            int nHeight;
            int nWidth = bmp.getWidth();
            PrintDataHeight = nHeight = bmp.getHeight();
            int nRealWidth = nWidth % 8 == 0 ? nWidth : (nWidth / 8 + 1) * 8;
            BitmapWidth = nRealWidth / 8;
            int nSize = nHeight * BitmapWidth;
            byte[] bPrintData = new byte[nSize];
            int i = 0;
            while (i < nSize) {
                bPrintData[i] = 0;
                ++i;
            }
            while (startLine < nHeight) {
                int[] arrPixColor = new int[nWidth];
                bmp.getPixels(arrPixColor, 0, nWidth, 0, startLine, nWidth, 1);
                nBitIndex = 0;
                int w = 0;
                while (w < nWidth) {
                    int nPixColor = arrPixColor[w];
                    if (++nBitIndex > 8) {
                        nBitIndex = 1;
                        ++nDataIndex;
                    }
                    if (nPixColor != -1) {
                        int nTempValue = 1;
                        nTempValue <<= 8 - nBitIndex;
                        r = Color.red((int)nPixColor);
                        g = Color.green((int)nPixColor);
                        b = Color.blue((int)nPixColor);
                        if (r < 128 || g < 128 || b < 128) {
                            bPrintData[nDataIndex] = (byte)(bPrintData[nDataIndex] | nTempValue);
                        }
                    }
                    ++w;
                }
                nDataIndex = BitmapWidth * (startLine + 1);
                ++startLine;
            }
            return bPrintData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] sysCopy(List<byte[]> srcArrays) {
        int len = 0;
        for (byte[] srcArray : srcArrays) {
            len += srcArray.length;
        }
        byte[] destArray = new byte[len];
        int destLen = 0;
        for (byte[] srcArray : srcArrays) {
            System.arraycopy(srcArray, 0, destArray, destLen, srcArray.length);
            destLen += srcArray.length;
        }
        return destArray;
    }
}

