/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.printer;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.telpo.tps550.api.DeviceAlreadyOpenException;
import com.telpo.tps550.api.DeviceNotOpenException;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.iccard.NotEnoughBufferException;
import com.telpo.tps550.api.printer.ICommitCallback;
import com.telpo.tps550.api.printer.NoPaperException;
import com.telpo.tps550.api.printer.OverHeatException;
import com.telpo.tps550.api.printer.StyleConfig;
import com.telpo.tps550.api.printer.ThermalPrinter;
import com.telpo.tps550.api.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Printer {
    private static final String TAG = "Printer";
    private static final int MODE_TEXT = 0;
    private static final int MODE_PIC = 1;
    private static final int MODE_BAR = 2;
    private static final int ACTION_PRINT = 0;
    private static final int ACTION_STATUS = 1;
    private static final int ACTION_LED = 2;
    private static final int ACTION_VERSION = 3;
    private static final int ACTION_MARK = 4;
    private static final int ACTION_CMD = 5;
    public static final int STATUS_OK = 0;
    public static final int STATUS_NO_PAPER = -1001;
    public static final int STATUS_OVER_HEAT = -1002;
    public static final int STATUS_OVER_FLOW = -1003;
    public static final int STATUS_DISCONNECT = -1004;
    public static final int STATUS_UNKNOWN = -9999;
    private static List<PrintItem> printList = null;
    private static HandlerThread handlerThread = null;
    private static Handler handler = null;
    private static int barcode_mode = -1;
    private static int mStatus = -9999;
    private static String mVersion = null;
    private static Object lock = new Object();
    public static final int WORKING_LED = 2;
    public static final int POWER_LED = 1;
    public static final int ERROR_LED = 7;
    public static final int NO_PAPER_LED = 4;
    public static final int LED_ON = 1;
    public static final int LED_OFF = 0;

    public static synchronized void printText(String txt, StyleConfig style) {
        if (txt == null || printList == null) {
            return;
        }
        StyleConfig styleConfig = new StyleConfig();
        if (style != null) {
            styleConfig.fontFamily = style.fontFamily;
            styleConfig.fontSize = style.fontSize;
            styleConfig.fontStyle = style.fontStyle;
            styleConfig.align = style.align;
            styleConfig.gray = style.gray;
            styleConfig.lineSpace = style.lineSpace;
            styleConfig.newLine = style.newLine;
        }
        printList.add(new PrintItem(txt, styleConfig));
    }

    public static synchronized void printBarCode(String barcode, StyleConfig.Align align) {
        if (barcode == null || printList == null) {
            return;
        }
        if (barcode_mode < 0) {
            barcode_mode = 0;
            try {
                String version = ThermalPrinter.getVersion().trim();
                if (version.substring(version.length() - 8).compareTo("20151106") >= 0) {
                    barcode_mode = 1;
                }
            }
            catch (TelpoException e) {
                e.printStackTrace();
            }
        }
        if (barcode_mode == 1) {
            StyleConfig styleConfig = new StyleConfig();
            styleConfig.align = align;
            PrintItem printItem = new PrintItem(barcode, styleConfig);
            printItem.mode = 2;
            printList.add(printItem);
        } else {
            try {
                Bitmap bitmap = Printer.CreateCode(barcode, BarcodeFormat.CODE_128, 360, 64);
                Bitmap newBitmap = Printer.adjustBitmap(bitmap, align);
                printList.add(new PrintItem(newBitmap, new StyleConfig()));
            }
            catch (WriterException e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized void printQRCode(String QRCode, StyleConfig.Align align) {
        if (QRCode == null || printList == null) {
            return;
        }
        try {
            Bitmap bitmap = Printer.CreateCode(QRCode, BarcodeFormat.QR_CODE, 256, 256);
            Bitmap cutBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)40, (int)40, (int)(bitmap.getWidth() - 80), (int)(bitmap.getHeight() - 80));
            Bitmap newBitmap = Printer.adjustBitmap(cutBitmap, align);
            printList.add(new PrintItem(newBitmap, new StyleConfig()));
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
    }

    public static synchronized void printImage(String path, StyleConfig.Align align) {
        if (path == null || printList == null) {
            return;
        }
        File file = new File(path);
        if (file.exists()) {
            Bitmap bitmap = BitmapFactory.decodeFile((String)path);
            Bitmap cutBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)16, (int)bitmap.getWidth(), (int)(bitmap.getHeight() - 32));
            Bitmap newBitmap = Printer.adjustBitmap(cutBitmap, align);
            printList.add(new PrintItem(newBitmap, new StyleConfig()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void commitOperation(List<PrintItem> contentList, ICommitCallback commitCallback) {
        printFlag = false;
        printIterator = contentList.iterator();
        try {
            status = ThermalPrinter.checkStatus();
            if (status != 0) {
                switch (status) {
                    case 1: {
                        status = -1001;
                        msg = "Printer out of paper";
                        break;
                    }
                    case 2: {
                        status = -1002;
                        msg = "Printer over heat";
                        break;
                    }
                    case 3: {
                        status = -1003;
                        msg = "Printer over flow";
                        break;
                    }
                    default: {
                        status = -9999;
                        msg = "Printer error";
                    }
                }
                Printer.printerReset();
                if (commitCallback != null) {
                    commitCallback.printerStatus(status, msg);
                }
                return;
            }
            ** GOTO lbl33
        }
        catch (DeviceNotOpenException e1) {
            if (commitCallback != null) {
                commitCallback.printerStatus(-1004, "Printer disconnect");
            }
            return;
        }
        catch (TelpoException e1) {
            e1.printStackTrace();
lbl33:
            // 5 sources

            ** while (printIterator.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            printItem = printIterator.next();
            if (printItem.mode == 1) {
                try {
                    if (printFlag) {
                        ThermalPrinter.printString();
                        printFlag = false;
                        Thread.sleep(200L);
                    }
                    ThermalPrinter.setAlgin(0);
                    ThermalPrinter.setGray(printItem.styleConfig.gray);
                    ThermalPrinter.printLogo(printItem.bitmap);
                    continue;
                }
                catch (DeviceNotOpenException e) {
                    e.printStackTrace();
                    if (commitCallback != null) {
                        commitCallback.printerStatus(-1004, "Printer disconnect");
                    }
                    return;
                }
                catch (NoPaperException e) {
                    e.printStackTrace();
                    Printer.printerReset();
                    if (commitCallback != null) {
                        commitCallback.printerStatus(-1001, "Printer out of paper");
                    }
                    return;
                }
                catch (NotEnoughBufferException e) {
                    e.printStackTrace();
                    Printer.printerReset();
                    if (commitCallback != null) {
                        commitCallback.printerStatus(-1003, "Printer over flow");
                    }
                    return;
                }
                catch (OverHeatException e) {
                    e.printStackTrace();
                    Printer.printerReset();
                    if (commitCallback != null) {
                        commitCallback.printerStatus(-1002, "Printer over heat");
                    }
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Printer.printerReset();
                    if (commitCallback != null) {
                        commitCallback.printerStatus(-9999, "Printer error");
                    }
                    return;
                }
            }
            try {
                if (printItem.styleConfig.fontSize == StyleConfig.FontSize.F1) {
                    ThermalPrinter.setFontSize(1);
                    ThermalPrinter.enlargeFontSize(1, 1);
                } else if (printItem.styleConfig.fontSize == StyleConfig.FontSize.F3) {
                    ThermalPrinter.setFontSize(1);
                    ThermalPrinter.enlargeFontSize(2, 2);
                } else if (printItem.styleConfig.fontSize == StyleConfig.FontSize.F4) {
                    ThermalPrinter.setFontSize(2);
                    ThermalPrinter.enlargeFontSize(2, 2);
                } else {
                    ThermalPrinter.setFontSize(2);
                    ThermalPrinter.enlargeFontSize(1, 1);
                }
                if (printItem.styleConfig.align == StyleConfig.Align.CENTER) {
                    ThermalPrinter.setAlgin(1);
                } else if (printItem.styleConfig.align == StyleConfig.Align.RIGHT) {
                    ThermalPrinter.setAlgin(2);
                } else {
                    ThermalPrinter.setAlgin(0);
                }
                ThermalPrinter.setGray(printItem.styleConfig.gray);
                ThermalPrinter.setLineSpace(printItem.styleConfig.lineSpace);
                if (printItem.string.length() > 0) {
                    if (printItem.mode == 0) {
                        ThermalPrinter.addString(printItem.string);
                        if (printItem.styleConfig.newLine) {
                            ThermalPrinter.addString("\n");
                        }
                    } else if (printItem.mode == 2) {
                        ThermalPrinter.addBarcode(printItem.string);
                    }
                }
                if (printItem.feed > 0) {
                    ThermalPrinter.printStringAndWalk(0, 0, printItem.feed);
                    printFlag = false;
                    continue;
                }
                printFlag = true;
                continue;
            }
            catch (DeviceNotOpenException e) {
                e.printStackTrace();
                if (commitCallback != null) {
                    commitCallback.printerStatus(-1004, "Printer disconnect");
                }
                return;
            }
            catch (NoPaperException e) {
                e.printStackTrace();
                Printer.printerReset();
                if (commitCallback != null) {
                    commitCallback.printerStatus(-1001, "Printer out of paper");
                }
                return;
            }
            catch (NotEnoughBufferException e) {
                e.printStackTrace();
                Printer.printerReset();
                if (commitCallback != null) {
                    commitCallback.printerStatus(-1003, "Printer over flow");
                }
                return;
            }
            catch (OverHeatException e) {
                e.printStackTrace();
                Printer.printerReset();
                if (commitCallback != null) {
                    commitCallback.printerStatus(-1002, "Printer over heat");
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                Printer.printerReset();
                if (commitCallback != null) {
                    commitCallback.printerStatus(-9999, "Printer error");
                }
                return;
            }
        }
lbl141:
        // 1 sources

        if (printFlag) {
            try {
                ThermalPrinter.printString();
            }
            catch (DeviceNotOpenException e) {
                e.printStackTrace();
                if (commitCallback != null) {
                    commitCallback.printerStatus(-1004, "Printer disconnect");
                }
                return;
            }
            catch (NoPaperException e) {
                e.printStackTrace();
                Printer.printerReset();
                if (commitCallback != null) {
                    commitCallback.printerStatus(-1001, "Printer out of paper");
                }
                return;
            }
            catch (NotEnoughBufferException e) {
                e.printStackTrace();
                Printer.printerReset();
                if (commitCallback != null) {
                    commitCallback.printerStatus(-1003, "Printer over flow");
                }
                return;
            }
            catch (OverHeatException e) {
                e.printStackTrace();
                Printer.printerReset();
                if (commitCallback != null) {
                    commitCallback.printerStatus(-1002, "Printer over heat");
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                Printer.printerReset();
                if (commitCallback != null) {
                    commitCallback.printerStatus(-9999, "Printer error");
                }
                return;
            }
        }
        if (commitCallback != null) {
            commitCallback.printerStatus(0, "Printer OK");
        }
    }

    public static synchronized void commitOperation() {
        if (printList == null || handler == null) {
            return;
        }
        ArrayList<PrintItem> list = new ArrayList<PrintItem>(printList.size());
        Iterator<PrintItem> iterator = printList.iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        CommitData commitData = new CommitData();
        commitData.printList = list;
        commitData.callback = null;
        Message message = handler.obtainMessage(0, (Object)commitData);
        handler.sendMessage(message);
        printList.clear();
    }

    public static synchronized void commitOperation(ICommitCallback callback) {
        if (printList == null || handler == null) {
            return;
        }
        ArrayList<PrintItem> list = new ArrayList<PrintItem>(printList.size());
        Iterator<PrintItem> iterator = printList.iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        CommitData commitData = new CommitData();
        commitData.printList = list;
        commitData.callback = callback;
        Message message = handler.obtainMessage(0, (Object)commitData);
        handler.sendMessage(message);
        printList.clear();
    }

    public static synchronized int connect() {
        int ret = 0;
        try {
            if (printList == null) {
                printList = new ArrayList<PrintItem>();
            }
            if (handlerThread == null) {
                handlerThread = new HandlerThread(TAG);
                handlerThread.start();
                handler = new MyHandler(handlerThread.getLooper());
            }
            ThermalPrinter.start();
        }
        catch (DeviceAlreadyOpenException deviceAlreadyOpenException) {
        }
        catch (TelpoException e) {
            e.printStackTrace();
            ret = -1;
        }
        return ret;
    }

    public static synchronized void disconnect() {
        ThermalPrinter.stop();
        if (printList != null) {
            printList.clear();
            printList = null;
        }
        if (handlerThread != null) {
            handlerThread.quit();
            handlerThread = null;
            handler = null;
        }
        barcode_mode = -1;
        mVersion = null;
    }

    public static synchronized void reset() {
        try {
            ThermalPrinter.reset();
        }
        catch (TelpoException e) {
            e.printStackTrace();
        }
        if (printList != null) {
            printList.clear();
        }
    }

    public static synchronized void feedPaper(int lines) {
        if (lines <= 0 || printList == null) {
            return;
        }
        PrintItem printItem = new PrintItem("", new StyleConfig());
        printItem.feed = lines;
        printList.add(printItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getStatus() {
        Object object = lock;
        synchronized (object) {
            mStatus = -9999;
            handler.sendEmptyMessage(1);
            try {
                lock.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return mStatus;
    }

    public static synchronized boolean isConnected() {
        return printList != null && handlerThread != null;
    }

    public static synchronized void ledCtrl(int ledType, int onOff) {
        Message msg = handler.obtainMessage(2, ledType, onOff);
        handler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getVersion() {
        if (mVersion == null) {
            Object object = lock;
            synchronized (object) {
                handler.sendEmptyMessage(3);
                try {
                    lock.wait(30000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return mVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void searchMark(int search_disdance, int walk_disdance) {
        Object object = lock;
        synchronized (object) {
            int[] obj = new int[]{search_disdance, walk_disdance};
            Message msg = handler.obtainMessage(4, (Object)obj);
            handler.sendMessage(msg);
            try {
                lock.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void sendCommand(byte[] cmd, int len) {
        Object object = lock;
        synchronized (object) {
            Message msg = handler.obtainMessage(5, len, len, (Object)cmd);
            handler.sendMessage(msg);
            try {
                lock.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void sendCommand(String cmdStr) {
        if (cmdStr == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            byte[] cmd = StringUtil.toBytes(cmdStr.replace(" ", ""));
            Message msg = handler.obtainMessage(5, cmd.length, cmd.length, (Object)cmd);
            handler.sendMessage(msg);
            try {
                lock.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static Bitmap adjustBitmap(Bitmap bitmap, StyleConfig.Align align) {
        if (bitmap == null) {
            return null;
        }
        int adjustWidth = bitmap.getWidth();
        int adjustHeight = bitmap.getHeight();
        int offset = 0;
        int temp = 0;
        if (align == StyleConfig.Align.CENTER) {
            if ((temp = (adjustWidth += (offset = (384 - adjustWidth) / 2)) % 8) != 0) {
                adjustWidth += 8 - temp;
            }
        } else if (align == StyleConfig.Align.RIGHT) {
            offset = 384 - adjustWidth;
            adjustWidth = 384;
        } else {
            temp = adjustWidth % 8;
            if (temp != 0) {
                adjustWidth += 8 - temp;
            }
        }
        Bitmap newBitmap = Bitmap.createBitmap((int)adjustWidth, (int)adjustHeight, (Bitmap.Config)bitmap.getConfig());
        Paint paint = new Paint();
        paint.setColor(-1);
        Canvas canvas = new Canvas(newBitmap);
        canvas.drawRect(0.0f, 0.0f, (float)adjustWidth, (float)adjustHeight, paint);
        canvas.drawBitmap(bitmap, (float)offset, 0.0f, null);
        return newBitmap;
    }

    private static Bitmap CreateCode(String str, BarcodeFormat type, int bmpWidth, int bmpHeight) throws WriterException {
        BitMatrix matrix = new MultiFormatWriter().encode(str, type, bmpWidth, bmpHeight);
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int[] pixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                pixels[y * width + x] = matrix.get(x, y) ? -16777216 : -1;
                ++x;
            }
            ++y;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }

    private static void printerReset() {
        try {
            ThermalPrinter.reset();
        }
        catch (TelpoException e) {
            e.printStackTrace();
        }
    }

    private static class CommitData {
        public List<PrintItem> printList = null;
        public ICommitCallback callback = null;

        private CommitData() {
        }
    }

    private static class MyHandler
    extends Handler {
        public MyHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                CommitData data = (CommitData)msg.obj;
                Printer.commitOperation(data.printList, data.callback);
                try {
                    ThermalPrinter.clearString();
                }
                catch (TelpoException e) {
                    e.printStackTrace();
                }
            } else {
                if (msg.what == 1) {
                    Object data = lock;
                    synchronized (data) {
                        try {
                            int status = ThermalPrinter.checkStatus();
                            switch (status) {
                                case 0: {
                                    mStatus = 0;
                                    break;
                                }
                                case 1: {
                                    mStatus = -1001;
                                    break;
                                }
                                case 2: {
                                    mStatus = -1002;
                                    break;
                                }
                                case 3: {
                                    mStatus = -1003;
                                    break;
                                }
                                default: {
                                    mStatus = -9999;
                                    break;
                                }
                            }
                        }
                        catch (DeviceNotOpenException e1) {
                            mStatus = -1004;
                        }
                        catch (TelpoException e) {
                            e.printStackTrace();
                            mStatus = -9999;
                        }
                        lock.notify();
                    }
                }
                if (msg.what == 2) {
                    byte[] cmd = new byte[]{27, 8, (byte)msg.arg1, (byte)msg.arg2};
                    try {
                        ThermalPrinter.sendCommand(cmd, cmd.length);
                    }
                    catch (TelpoException e) {
                        e.printStackTrace();
                    }
                } else {
                    if (msg.what == 3) {
                        Object object = lock;
                        synchronized (object) {
                            try {
                                mVersion = ThermalPrinter.getVersion();
                            }
                            catch (TelpoException e) {
                                e.printStackTrace();
                            }
                            lock.notify();
                        }
                    }
                    if (msg.what == 4) {
                        Object object = lock;
                        synchronized (object) {
                            int[] obj = (int[])msg.obj;
                            try {
                                ThermalPrinter.searchMark(obj[0], obj[1]);
                            }
                            catch (TelpoException e) {
                                e.printStackTrace();
                            }
                            lock.notify();
                        }
                    }
                    if (msg.what == 5) {
                        Object object = lock;
                        synchronized (object) {
                            byte[] cmd = (byte[])msg.obj;
                            try {
                                ThermalPrinter.sendCommand(cmd, msg.arg1);
                            }
                            catch (TelpoException e) {
                                e.printStackTrace();
                            }
                            lock.notify();
                        }
                    }
                }
            }
        }
    }

    private static class PrintItem {
        public StyleConfig styleConfig = null;
        public String string = null;
        public Bitmap bitmap = null;
        public int feed = 0;
        public int mode = 0;

        public PrintItem(String string, StyleConfig styleConfig) {
            this.string = string;
            this.styleConfig = styleConfig;
        }

        public PrintItem(Bitmap bitmap, StyleConfig styleConfig) {
            this.styleConfig = styleConfig;
            this.bitmap = bitmap;
            this.mode = 1;
        }
    }
}

