/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.printer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.Log;
import com.telpo.tps550.api.InternalErrorException;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.printer.ThermalPrinter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class SY581ThermalPrinter
extends ThermalPrinter {
    public static final int ALIGN_LEFT = 0;
    public static final int ALGIN_MIDDLE = 1;
    public static final int ALGIN_RIGHT = 2;
    public static final int DIRECTION_FORWORD = 0;
    public static final int DIRECTION_BACK = 1;
    public static final int WALK_DOTLINE = 0;
    public static final int WALK_LINE = 1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_OVER_HEAT = 1;
    public static final int STATUS_NO_PAPER = 2;
    public static final int STATUS_GATE_OPEN = 3;
    public static final int STATUS_CUT_ERROR = 4;
    public static final int STATUS_UNKNOWN = 5;
    public static final int BARCODE_TYPE_UPCA = 65;
    public static final int BARCODE_TYPE_UPCE = 66;
    public static final int BARCODE_TYPE_EAN13 = 67;
    public static final int BARCODE_TYPE_EAN8 = 68;
    public static final int BARCODE_TYPE_CODE39 = 69;
    public static final int BARCODE_TYPE_ITF = 70;
    public static final int BARCODE_TYPE_CODABAR = 71;
    public static final int BARCODE_TYPE_CODE93 = 72;
    public static final int BARCODE_TYPE_CODE128 = 73;
    private static final String TAG = "SY581ThermalPrinter";
    public static volatile byte buffull_flag;
    private static Bitmap bitmap;
    public volatile byte buffull_flag1;
    private static Canvas canvas;
    private static int line_number;
    private static int origin_x;
    private static int origin_y;
    private static Paint paint;
    private static TextPaint textPaint;
    private static final int PAPER_WIDTH = 576;
    private static StringBuilder builder;
    private static int align_mode;
    private static int indent;
    private static int font_size;
    private static int line_space;
    private static int width_mult;
    private static int height_mult;
    private static final int ARGB_MASK_RED = 0xFF0000;
    private static final int ARGB_MASK_GREEN = 65280;
    private static final int ARGB_MASK_BLUE = 255;
    private static final int RGB565_MASK_RED = 63488;
    private static final int RGB565_MASK_GREEN = 2016;
    private static final int RGB565_MASK_BLUE = 31;
    private static final int color = 128;

    static {
        align_mode = 0;
        indent = 0;
        font_size = 2;
        line_space = 14 * font_size + 3;
        width_mult = 1;
        height_mult = 1;
    }

    public SY581ThermalPrinter(Context context) {
        super(context);
    }

    public static synchronized void reset() throws TelpoException {
        SY581ThermalPrinter.initCanvas();
    }

    public static synchronized int checkStatus() throws TelpoException {
        int ret = 1;
        switch (ret) {
            case 0: {
                return 0;
            }
            case 61697: {
                return 2;
            }
            case 61701: {
                return 3;
            }
            case 61698: {
                return 1;
            }
            case 61702: {
                return 4;
            }
        }
        return 5;
    }

    public static synchronized void setAlign(int mode) throws TelpoException {
        align_mode = mode;
    }

    public static synchronized void enlargeFontSize(int widthMultiple, int heightMultiple) throws TelpoException {
        width_mult = widthMultiple;
        height_mult = heightMultiple;
    }

    public static synchronized void setFontSize(int type) throws TelpoException {
        if (type < 1 || type > 2) {
            throw new InternalErrorException();
        }
        font_size = type;
        line_space = 14 * font_size + 3;
        textPaint.setTextSize((float)(14 * font_size));
        paint.setTextSize((float)(14 * font_size));
    }

    public static synchronized void addString(String content) throws TelpoException {
        builder.append(content);
    }

    public static synchronized void addBarcode(String barcode) throws TelpoException {
        byte[] data = barcode.getBytes();
        boolean ret = true;
    }

    public static synchronized void clearString() throws TelpoException {
        builder.delete(0, builder.length() - 1);
    }

    public static synchronized void printString() throws TelpoException {
        Layout.Alignment align = null;
        switch (align_mode) {
            case 0: {
                align = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 1: {
                align = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 2: {
                align = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            default: {
                align = Layout.Alignment.ALIGN_NORMAL;
            }
        }
        origin_x = indent;
        int temp = (int)textPaint.getTextSize();
        textPaint.setTextSize((float)(temp * width_mult));
        StaticLayout layout = new StaticLayout((CharSequence)builder.toString(), textPaint, 576 - origin_x, align, 1.0f, 0.0f, true);
        canvas.translate((float)origin_x, (float)origin_y);
        origin_y += layout.getHeight();
        layout.draw(canvas);
        textPaint.setTextSize((float)temp);
        File file = new File("/sdcard/ttt.png");
        if (file.exists()) {
            file.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            if (bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out)) {
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.d((String)TAG, (String)("image height = " + origin_y));
        SY581ThermalPrinter.printLogoWithinHeight(bitmap, origin_y);
    }

    public static synchronized void printStringAndWalk(int direction, int mode, int lines) throws TelpoException {
    }

    public static synchronized void setLineSpace(int lineSpace) throws TelpoException {
        line_space = lineSpace;
    }

    public static synchronized void setLeftIndent(int space) throws TelpoException {
        indent = space;
    }

    public static synchronized void printLogo(int width, int height, char[] logo) throws TelpoException {
        int printer_type = 1;
        if (printer_type == 3 || printer_type == 4 || printer_type == 5) {
            if (width > 576 || width % 8 != 0) {
                throw new IllegalArgumentException("The width of the image to print is illegal!");
            }
        } else if (width > 384 || height % 8 != 0) {
            throw new IllegalArgumentException("The width or the height of the image to print is illegal!");
        }
        byte[] logoBytes = new byte[logo.length];
        int i = 0;
        while (i < logo.length) {
            logoBytes[i] = (byte)logo[i];
            ++i;
        }
        boolean ret = true;
    }

    public static synchronized void printLogo(Bitmap image) throws TelpoException {
        if (image == null) {
            throw new NullPointerException();
        }
        int height = image.getHeight();
        int width = image.getWidth();
        int image_row_bytes = (width - 1 >> 3) + 1;
        int pos = 0;
        boolean ret = false;
        int temp = 0;
        byte[] Imagelogo = new byte[image_row_bytes * height];
        int row_index = 0;
        while (row_index < height) {
            int col_index = 0;
            int h = 0;
            while (col_index < image_row_bytes) {
                temp = 0;
                int i = 0;
                while (i < 8) {
                    if (i + h >= width) {
                        temp <<= 8 - i;
                        break;
                    }
                    int Pixel_val = image.getPixel(i + h, row_index);
                    temp = (Pixel_val & 0xFF0000) >> 16 > 128 && (Pixel_val & 0xFF00) >> 8 > 128 && (Pixel_val & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                    ++i;
                }
                Imagelogo[pos++] = (byte)temp;
                ++col_index;
                h += 8;
            }
            ++row_index;
        }
        Log.d((String)TAG, (String)("width = " + width + ",image_row_bytes = " + image_row_bytes + ",height = " + height));
        Log.d((String)TAG, (String)("data length = " + Imagelogo.length));
    }

    public static synchronized void printLogo(Bitmap image, int mode) throws TelpoException {
        if (image == null) {
            throw new NullPointerException();
        }
        int height = image.getHeight();
        int width = image.getWidth();
        int image_row_bytes = (width - 1 >> 3) + 1;
        int pos = 0;
        boolean ret = false;
        int temp = 0;
        byte[] Imagelogo = new byte[image_row_bytes * image.getHeight()];
        Log.d((String)TAG, (String)("width = " + width + ",image_row_bytes = " + image_row_bytes));
        int row_index = 0;
        while (row_index < height) {
            int col_index = 0;
            int h = 0;
            while (col_index < width) {
                temp = 0;
                int i = 0;
                while (i < 8) {
                    if (i + h >= width) {
                        temp <<= 8 - i;
                        break;
                    }
                    int Pixel_val = image.getPixel(i + h, row_index);
                    temp = (Pixel_val & 0xFF0000) >> 16 > 128 && (Pixel_val & 0xFF00) >> 8 > 128 && (Pixel_val & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                    ++i;
                }
                Imagelogo[pos++] = (byte)temp;
                ++col_index;
                h += 8;
            }
            ++row_index;
        }
    }

    public static void paperCut() throws TelpoException {
        boolean ret = true;
    }

    public static void setBold(boolean isBold) throws TelpoException {
        textPaint.setFakeBoldText(isBold);
        paint.setFakeBoldText(isBold);
    }

    private static void initCanvas() {
        align_mode = 0;
        indent = 0;
        font_size = 2;
        line_space = 14 * font_size + 3;
        width_mult = 1;
        height_mult = 1;
        bitmap = Bitmap.createBitmap((int)576, (int)3000, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        canvas = new Canvas(bitmap);
        textPaint = new TextPaint();
        paint = new Paint();
        canvas.drawColor(-1);
        textPaint.setColor(-16777216);
        textPaint.setStyle(Paint.Style.FILL);
        textPaint.setTextSize((float)(14 * font_size));
        textPaint.setFakeBoldText(false);
        origin_y = 0;
        origin_x = 0;
        paint.setColor(-16777216);
        paint.setStyle(Paint.Style.FILL);
        paint.setStrokeWidth(8.0f);
        builder = new StringBuilder();
    }

    private static synchronized void printLogoWithinHeight(Bitmap image, int height) throws TelpoException {
        if (image == null) {
            throw new NullPointerException();
        }
        int width = image.getWidth();
        int image_row_bytes = (width - 1 >> 3) + 1;
        int pos = 0;
        boolean ret = false;
        int temp = 0;
        byte[] Imagelogo = new byte[image_row_bytes * height];
        Log.d((String)TAG, (String)("print logo width = " + width + ",image_row_bytes = " + image_row_bytes + ",height = " + height));
        int row_index = 0;
        while (row_index < height) {
            int col_index = 0;
            int h = 0;
            while (col_index < image_row_bytes) {
                temp = 0;
                int i = 0;
                while (i < 8) {
                    if (i + h >= width) {
                        temp <<= 8 - i;
                        break;
                    }
                    int Pixel_val = image.getPixel(i + h, row_index);
                    temp = (Pixel_val & 0xFF0000) >> 16 > 128 && (Pixel_val & 0xFF00) >> 8 > 128 && (Pixel_val & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                    ++i;
                }
                Imagelogo[pos++] = (byte)temp;
                ++col_index;
                h += 8;
            }
            ++row_index;
        }
    }

    public static String byte2HexString(byte[] data) {
        if (data == null) {
            return "";
        }
        int length = data.length;
        return SY581ThermalPrinter.byte2HexString(data, 0, length);
    }

    public static String byte2HexString(byte[] data, int start, int len) {
        if (data == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            String hex = Integer.toHexString(data[start + i] & 0xFF).toUpperCase();
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }
}

