/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.printer;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Build;
import android.util.Log;
import android_serialport_api.SerialPort;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.telpo.tps550.api.DeviceAlreadyOpenException;
import com.telpo.tps550.api.DeviceNotOpenException;
import com.telpo.tps550.api.InternalErrorException;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.iccard.NotEnoughBufferException;
import com.telpo.tps550.api.printer.GateOpenException;
import com.telpo.tps550.api.printer.NoPaperException;
import com.telpo.tps550.api.printer.OverHeatException;
import com.telpo.tps550.api.printer.PaperCutException;
import com.telpo.tps550.api.printer.ThermalPrinterSY581;
import com.telpo.tps550.api.printer.UsbThermalPrinter;
import com.telpo.tps550.api.util.ShellUtils;
import com.telpo.tps550.api.util.StringUtil;
import com.telpo.tps550.api.util.SystemUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class ThermalPrinter {
    private static final String TAG = "TELPO_SDK";
    public static final int ALGIN_LEFT = 0;
    public static final int ALGIN_MIDDLE = 1;
    public static final int ALGIN_RIGHT = 2;
    public static final int DIRECTION_FORWORD = 0;
    public static final int DIRECTION_BACK = 1;
    public static final int WALK_DOTLINE = 0;
    public static final int WALK_LINE = 1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_NO_PAPER = 1;
    public static final int STATUS_OVER_HEAT = 2;
    public static final int STATUS_OVER_FLOW = 3;
    public static final int STATUS_UNKNOWN = 4;
    public static final int BARCODE_TYPE_UPCA = 65;
    public static final int BARCODE_TYPE_UPCE = 66;
    public static final int BARCODE_TYPE_EAN13 = 67;
    public static final int BARCODE_TYPE_EAN8 = 68;
    public static final int BARCODE_TYPE_CODE39 = 69;
    public static final int BARCODE_TYPE_ITF = 70;
    public static final int BARCODE_TYPE_CODABAR = 71;
    public static final int BARCODE_TYPE_CODE93 = 72;
    public static final int BARCODE_TYPE_CODE128 = 73;
    private static UsbThermalPrinter mUsbThermalPrinter = null;
    private static int printerCheck = -1;
    private static int tps550aPrinterCheck = -1;
    private static final String FILE_NAME = "/sdcard/tpsdk/printerVersion.txt";
    private static final String TPS550A_FILE_NAME = "/sdcard/tpsdk/tps550APrinterVersion.txt";
    private static boolean openFlag = false;
    public static boolean xon = false;
    private static final int ARGB_MASK_RED = 0xFF0000;
    private static final int ARGB_MASK_GREEN = 65280;
    private static final int ARGB_MASK_BLUE = 255;
    private static final int RGB565_MASK_RED = 63488;
    private static final int RGB565_MASK_GREEN = 2016;
    private static final int RGB565_MASK_BLUE = 31;
    private static final int color = 128;

    static {
        if (Build.MODEL.equals("MTDP-618A") || Build.MODEL.equals("TPS650M")) {
            System.loadLibrary("telpo_printer_48");
        } else if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650.ordinal()) {
            if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581")) {
                System.loadLibrary("telpo_printer_581");
            } else {
                System.loadLibrary("telpo_printer");
            }
        } else if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
            System.loadLibrary("telpo_printer_581");
        } else {
            System.loadLibrary("telpo_printer");
        }
    }

    protected static native int device_open();

    protected static native int device_opened();

    protected static native int device_close();

    protected static native int init();

    protected static native int walk_paper(int var0);

    protected static native int enlarge(int var0, int var1);

    protected static native int highlight(boolean var0);

    protected static native int gray(int var0);

    protected static native int algin(int var0);

    protected static native int line_space(int var0);

    protected static native int add_string(byte[] var0, int var1);

    protected static native int clear_string();

    protected static native int print_and_walk(int var0, int var1, int var2);

    protected static native int print_logo(int var0, int var1, byte[] var2);

    protected static native int print_barcode(int var0, byte[] var1, int var2);

    protected static native int check_status();

    protected static native int set_font(int var0);

    protected static native int get_version(byte[] var0);

    protected static native int indent(int var0);

    protected static native void sleep_ms(int var0);

    protected static native int get_printer_type();

    protected static native int search_mark(int var0, int var1, int var2);

    protected static native int paper_cut();

    protected static native int paper_cut_all();

    protected static native int send_command(byte[] var0, int var1);

    protected static native int add_barcode(byte[] var0, int var1);

    protected static native int set_bold(int var0);

    protected static TelpoException getException(int ret) {
        switch (ret) {
            case 61444: {
                return new DeviceAlreadyOpenException();
            }
            case 61443: {
                return new DeviceNotOpenException();
            }
            case 61448: {
                return new InternalErrorException();
            }
            case 61697: {
                return new NoPaperException();
            }
            case 61445: {
                return new NotEnoughBufferException();
            }
            case 61698: {
                return new OverHeatException();
            }
            case 61701: {
                return new GateOpenException();
            }
            case 61702: {
                return new PaperCutException();
            }
        }
        return new InternalErrorException();
    }

    public ThermalPrinter() {
    }

    public ThermalPrinter(Context context) {
        File file = new File(TPS550A_FILE_NAME);
        if (!file.exists() || ThermalPrinter.getFileContent(TPS550A_FILE_NAME) == null) {
            Log.d((String)"TAG", (String)"tps550a printer choose");
            mUsbThermalPrinter = new UsbThermalPrinter(context);
            try {
                mUsbThermalPrinter.start(1);
            }
            catch (TelpoException e1) {
                e1.printStackTrace();
            }
            ShellUtils.CommandResult commandResult = ShellUtils.execCommand("cat /sys/kernel/debug/usb/devices", false);
            tps550aPrinterCheck = commandResult.successMsg.contains("USB Thermal Printer") ? 0 : 1;
            ThermalPrinter.writeData();
        } else if (ThermalPrinter.getFileContent(TPS550A_FILE_NAME) != null && ThermalPrinter.getFileContent(TPS550A_FILE_NAME).equals("USB_PRINTER")) {
            mUsbThermalPrinter = new UsbThermalPrinter(context);
        }
        Log.d((String)"TAG", (String)("check tps550a printer:" + ThermalPrinter.getFileContent(TPS550A_FILE_NAME)));
        if (ThermalPrinter.getFileContent(TPS550A_FILE_NAME) != null && !ThermalPrinter.getFileContent(TPS550A_FILE_NAME).equals("USB_PRINTER")) {
            mUsbThermalPrinter = null;
        }
    }

    public boolean isUsbType(Context context) {
        UsbThermalPrinter usbThermalPrinter = new UsbThermalPrinter(context);
        try {
            usbThermalPrinter.start(1);
        }
        catch (TelpoException e1) {
            e1.printStackTrace();
        }
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand("cat /sys/kernel/debug/usb/devices", false);
        return commandResult.successMsg.contains("USB Thermal Printer");
    }

    private static void writeData() {
        Log.d((String)"TAG", (String)("printerCheck:" + printerCheck));
        Log.d((String)"TAG", (String)("tps550aPrinterCheck:" + tps550aPrinterCheck));
        if (printerCheck == 8) {
            ThermalPrinter.writeTxtToFile("SY581", FILE_NAME);
        } else if (printerCheck == 7) {
            ThermalPrinter.writeTxtToFile("PT72", FILE_NAME);
        } else if (tps550aPrinterCheck == 0) {
            ThermalPrinter.writeTxtToFile("USB_PRINTER", TPS550A_FILE_NAME);
        } else if (tps550aPrinterCheck == 1) {
            ThermalPrinter.writeTxtToFile("SERIAL_PRINTER", TPS550A_FILE_NAME);
        }
    }

    private static void writeTxtToFile(String strcontent, String fileName) {
        String strContent = strcontent;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            RandomAccessFile raf = new RandomAccessFile(file, "rwd");
            raf.seek(file.length());
            raf.write(strContent.getBytes());
            raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized String getVersionNum(String version) {
        String finalVersion = null;
        try {
            String realVersion = version.substring(version.indexOf("14") + 2, version.indexOf("14") + 4);
            Log.d((String)"TAG", (String)("realVersion:" + realVersion));
            int nowVersion = Integer.parseInt(realVersion) - Integer.parseInt("91");
            Log.d((String)"TAG", (String)("nowVersion:" + nowVersion));
            finalVersion = "1." + (45 + nowVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return finalVersion;
    }

    public static synchronized void start() throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.start(1);
        } else {
            if (openFlag) {
                throw new DeviceAlreadyOpenException();
            }
            int ret = ThermalPrinter.device_open();
            if (ret == 0) {
                openFlag = true;
            } else {
                throw ThermalPrinter.getException(ret);
            }
        }
    }

    public static synchronized void start(Context context) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.start(1);
        } else {
            if (openFlag) {
                throw new DeviceAlreadyOpenException();
            }
            int ret = ThermalPrinter.device_open();
            if (ret == 0) {
                openFlag = true;
                context.sendBroadcast(new Intent("com.telpo.printer.thermalprinter.start"));
            } else {
                throw ThermalPrinter.getException(ret);
            }
        }
    }

    public static synchronized void start(Context context, int i) throws TelpoException {
        Log.d((String)"TAG", (String)"device open");
        int ret = ThermalPrinter.device_opened();
    }

    public static synchronized void reset() throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.reset();
        } else {
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
                ThermalPrinterSY581.reset();
            } else {
                int ret = ThermalPrinter.init();
                if (ret != 0) {
                    throw ThermalPrinter.getException(ret);
                }
            }
        }
    }

    public static synchronized void walkPaper(int line) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.walkPaper(line);
        } else {
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (line <= 0) {
                throw new IllegalArgumentException();
            }
            if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS681.ordinal()) {
                ThermalPrinter.walkPaper681(line);
            } else {
                int ret = ThermalPrinter.walk_paper(line);
                if (ret != 0) {
                    throw ThermalPrinter.getException(ret);
                }
            }
        }
    }

    public static synchronized void walkPaper681(int line) {
        try {
            StringBuffer sBuffer = new StringBuffer();
            int walkLine = 0;
            walkLine = line >= 10 ? line / 10 : line % 10;
            int i = 0;
            while (i < walkLine) {
                sBuffer.append(" \n");
                ++i;
            }
            ThermalPrinter.reset();
            ThermalPrinter.addString(sBuffer.toString());
            ThermalPrinter.printString();
        }
        catch (TelpoException e) {
            e.printStackTrace();
        }
    }

    public static synchronized void stop() {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.stop();
        } else if (openFlag) {
            ThermalPrinter.device_close();
            openFlag = false;
        }
    }

    public static synchronized void stop(Context context) {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.stop();
        } else if (openFlag) {
            ThermalPrinter.device_close();
            openFlag = false;
            context.sendBroadcast(new Intent("com.telpo.printer.thermalprinter.stop"));
        }
    }

    public static synchronized void stop(Context context, int i) {
        ThermalPrinter.device_close();
    }

    public static synchronized int checkStatus() throws TelpoException {
        if (mUsbThermalPrinter != null) {
            return mUsbThermalPrinter.checkStatus();
        }
        if (!openFlag) {
            throw new DeviceNotOpenException();
        }
        int ret = 0;
        if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
            ThermalPrinterSY581.checkStatus();
        } else {
            ret = ThermalPrinter.check_status();
        }
        switch (ret) {
            case 0: {
                return 0;
            }
            case 61697: {
                return 1;
            }
            case 61445: {
                return 3;
            }
            case 61698: {
                return 2;
            }
        }
        return 4;
    }

    public static synchronized void enlargeFontSize(int widthMultiple, int heightMultiple) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.enlargeFontSize(widthMultiple, heightMultiple);
        } else {
            int ret;
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (!(ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal() || (ret = ThermalPrinter.enlarge(widthMultiple, heightMultiple)) == 0)) {
                throw ThermalPrinter.getException(ret);
            }
        }
    }

    public static synchronized void setFontSize(int type) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.setFontSize(type);
        } else {
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
                ThermalPrinterSY581.setFont(type);
            } else {
                int ret = ThermalPrinter.set_font(type);
                if (ret != 0) {
                    throw ThermalPrinter.getException(ret);
                }
            }
        }
    }

    public static synchronized void setTem(int tem) throws TelpoException {
        if (!openFlag) {
            throw new DeviceNotOpenException();
        }
        if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
            ThermalPrinterSY581.setTem(tem);
        }
    }

    public static synchronized void setHighlight(boolean mode) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.setHighlight(mode);
        } else {
            int ret;
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (!(ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal() || (ret = ThermalPrinter.highlight(mode)) == 0)) {
                throw ThermalPrinter.getException(ret);
            }
        }
    }

    public static synchronized void setGray(int level) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.setGray(level);
        } else {
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
                ThermalPrinterSY581.setGray(level);
            } else {
                int ret = ThermalPrinter.gray(level);
                if (ret != 0) {
                    throw ThermalPrinter.getException(ret);
                }
            }
        }
    }

    public static synchronized void setAlgin(int mode) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.setAlgin(mode);
        } else {
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
                ThermalPrinterSY581.setAlign(mode);
            } else {
                int ret = ThermalPrinter.algin(mode);
                if (ret != 0) {
                    throw ThermalPrinter.getException(ret);
                }
            }
        }
    }

    public static synchronized void addString(String content) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.addString(content);
        } else {
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (content == null || content.length() == 0) {
                throw new NullPointerException();
            }
            if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
                content = " " + content;
            }
            byte[] text = null;
            try {
                text = content.getBytes("GBK");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            int ret = ThermalPrinter.add_string(text, text.length);
            if (ret != 0) {
                throw ThermalPrinter.getException(ret);
            }
        }
    }

    public static synchronized void addBarcode(String barcode) throws TelpoException {
        int ret;
        if (!openFlag) {
            throw new DeviceNotOpenException();
        }
        if (barcode == null || barcode.length() == 0) {
            throw new NullPointerException();
        }
        byte[] barcodeCmd = new byte[53];
        barcodeCmd[0] = 29;
        barcodeCmd[1] = 104;
        barcodeCmd[2] = 84;
        barcodeCmd[3] = 29;
        barcodeCmd[4] = 108;
        Bitmap bitmap = ThermalPrinter.CreateCode(barcode, BarcodeFormat.CODE_128, 360, 108);
        int temp = 0;
        int pix = 0;
        int ss = 5;
        int widthOctet = bitmap.getWidth() / 8;
        int width = 0;
        int column = 0;
        while (width < widthOctet) {
            temp = 0;
            int i = 0;
            while (i < 8) {
                pix = bitmap.getPixel(i + column, 0);
                temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                ++i;
            }
            barcodeCmd[ss] = (byte)temp;
            ++ss;
            ++width;
            column += 8;
        }
        if (!(ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal() || (ret = ThermalPrinter.add_barcode(barcodeCmd, barcodeCmd.length)) == 0)) {
            throw ThermalPrinter.getException(ret);
        }
    }

    public static synchronized void clearString() throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.clearString();
        } else {
            int ret;
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (!(ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal() || (ret = ThermalPrinter.clear_string()) == 0)) {
                throw ThermalPrinter.getException(ret);
            }
        }
    }

    public static synchronized void printString() throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.printString();
        } else {
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            int ret = ThermalPrinter.print_and_walk(0, 0, 0);
            if (ret != 0) {
                throw ThermalPrinter.getException(ret);
            }
        }
    }

    public static synchronized void printStringAndWalk(int direction, int mode, int lines) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.printStringAndWalk(direction, mode, lines);
        } else {
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (direction != 1 && direction != 0) {
                throw new IllegalArgumentException();
            }
            if (mode != 1 && mode != 0) {
                throw new IllegalArgumentException();
            }
            int ret = ThermalPrinter.print_and_walk(direction, mode, lines);
            if (ret != 0) {
                throw ThermalPrinter.getException(ret);
            }
        }
    }

    public static synchronized void setLineSpace(int lineSpace) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.setLineSpace(lineSpace);
        } else {
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (lineSpace < 0 || lineSpace > 255) {
                throw new IllegalArgumentException();
            }
            if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
                ThermalPrinterSY581.setLineSpace(lineSpace);
            } else {
                int ret = ThermalPrinter.line_space(lineSpace);
                if (ret != 0) {
                    throw ThermalPrinter.getException(ret);
                }
            }
        }
    }

    public static synchronized void setLeftIndent(int space) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.setLeftIndent(space);
        } else {
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (space < 0 || space > 255) {
                throw new IllegalArgumentException();
            }
            if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
                ThermalPrinterSY581.setLeftDistance(space);
            } else {
                int ret = ThermalPrinter.indent(space);
                if (ret != 0) {
                    throw ThermalPrinter.getException(ret);
                }
            }
        }
    }

    private static synchronized void printLogo581SetLeft(int left, Bitmap bitmap) {
        SerialPort serial = null;
        byte[] cmdStr = null;
        Bitmap picture = null;
        int count = 0;
        try {
            serial = SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal() ? new SerialPort(new File("/dev/ttyS0"), 460800, 0) : new SerialPort(new File("/dev/ttyS4"), 460800, 0);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        picture = bitmap.getWidth() % 8 != 0 ? ThermalPrinter.zoomImg(bitmap, (bitmap.getWidth() / 8 + 1) * 8, bitmap.getHeight()) : bitmap;
        try {
            byte[] picture_haschange = ThermalPrinter.changeBitmap(picture);
            cmdStr = new byte[8 + picture_haschange.length];
            cmdStr[0] = 29;
            cmdStr[1] = 118;
            if (left == 0) {
                cmdStr[2] = 48;
            } else if (left == 1) {
                cmdStr[2] = (576 - bitmap.getWidth()) / 2 > 255 ? StringUtil.toBytes(Integer.toHexString(255))[0] : StringUtil.toBytes(Integer.toHexString((576 - bitmap.getWidth()) / 2))[0];
            } else if (left == 2) {
                cmdStr[2] = 576 - bitmap.getWidth() > 255 ? StringUtil.toBytes(Integer.toHexString(255))[0] : StringUtil.toBytes(Integer.toHexString(576 - bitmap.getWidth()))[0];
            } else {
                if (left > 255) {
                    left = 255;
                }
                cmdStr[2] = StringUtil.toBytes(Integer.toHexString(left))[0];
            }
            cmdStr[3] = 0;
            String xl = Integer.toHexString(picture.getWidth() / 8 % 256);
            String xh = Integer.toHexString(picture.getWidth() / 8 / 256);
            String yl = Integer.toHexString(picture.getHeight() % 256);
            String yh = Integer.toHexString(picture.getHeight() / 256);
            if (xl.length() == 1) {
                xl = "0" + xl;
            }
            if (xh.length() == 1) {
                xh = "0" + xh;
            }
            if (yl.length() == 1) {
                yl = "0" + yl;
            }
            if (yh.length() == 1) {
                yh = "0" + yh;
            }
            cmdStr[4] = ThermalPrinter.parseHexStr2Byte(xl)[0];
            cmdStr[5] = ThermalPrinter.parseHexStr2Byte(xh)[0];
            cmdStr[6] = ThermalPrinter.parseHexStr2Byte(yl)[0];
            cmdStr[7] = ThermalPrinter.parseHexStr2Byte(yh)[0];
            int i = 8;
            int j = 0;
            while (i < cmdStr.length) {
                cmdStr[i] = picture_haschange[j];
                ++i;
                ++j;
            }
        }
        catch (TelpoException e2) {
            e2.printStackTrace();
        }
        OutputStream mOutputStream = serial.getOutputStream();
        xon = true;
        while (cmdStr.length - count > 150) {
            try {
                if (!xon) continue;
                mOutputStream.write(cmdStr, count, 150);
                count += 150;
                try {
                    Thread.sleep(4L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            mOutputStream.write(cmdStr, count, cmdStr.length - count);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (serial != null) {
            serial.close();
            serial = null;
        }
        serial = null;
        try {
            mOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static synchronized void printLogo581(Bitmap bitmap) {
        SerialPort serial = null;
        byte[] cmdStr = null;
        Bitmap picture = null;
        int count = 0;
        try {
            serial = SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal() ? new SerialPort(new File("/dev/ttyS0"), 460800, 0) : new SerialPort(new File("/dev/ttyS4"), 460800, 0);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        picture = bitmap.getWidth() % 8 != 0 ? ThermalPrinter.zoomImg(bitmap, (bitmap.getWidth() / 8 + 1) * 8, bitmap.getHeight()) : bitmap;
        try {
            byte[] picture_haschange = ThermalPrinter.changeBitmap(picture);
            cmdStr = new byte[8 + picture_haschange.length];
            cmdStr[0] = 29;
            cmdStr[1] = 118;
            cmdStr[2] = 48;
            cmdStr[3] = 0;
            String xl = Integer.toHexString(picture.getWidth() / 8 % 256);
            String xh = Integer.toHexString(picture.getWidth() / 8 / 256);
            String yl = Integer.toHexString(picture.getHeight() % 256);
            String yh = Integer.toHexString(picture.getHeight() / 256);
            if (xl.length() == 1) {
                xl = "0" + xl;
            }
            if (xh.length() == 1) {
                xh = "0" + xh;
            }
            if (yl.length() == 1) {
                yl = "0" + yl;
            }
            if (yh.length() == 1) {
                yh = "0" + yh;
            }
            cmdStr[4] = ThermalPrinter.parseHexStr2Byte(xl)[0];
            cmdStr[5] = ThermalPrinter.parseHexStr2Byte(xh)[0];
            cmdStr[6] = ThermalPrinter.parseHexStr2Byte(yl)[0];
            cmdStr[7] = ThermalPrinter.parseHexStr2Byte(yh)[0];
            int i = 8;
            int j = 0;
            while (i < cmdStr.length) {
                cmdStr[i] = picture_haschange[j];
                ++i;
                ++j;
            }
        }
        catch (TelpoException e2) {
            e2.printStackTrace();
        }
        OutputStream mOutputStream = serial.getOutputStream();
        xon = true;
        while (cmdStr.length - count > 150) {
            try {
                if (!xon) continue;
                mOutputStream.write(cmdStr, count, 150);
                count += 150;
                try {
                    Thread.sleep(4L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            mOutputStream.write(cmdStr, count, cmdStr.length - count);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (serial != null) {
            serial.close();
            serial = null;
        }
        serial = null;
        try {
            mOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static synchronized byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        int i = 0;
        while (i < hexStr.length() / 2) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
            ++i;
        }
        return result;
    }

    private static synchronized Bitmap zoomImg(Bitmap bm, int newWidth, int newHeight) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newbm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return newbm;
    }

    private static synchronized byte[] changeBitmap(Bitmap image) throws TelpoException {
        byte[] Imagelogo;
        block35: {
            int ss;
            int pix;
            int row;
            int temp;
            int with;
            int height;
            block36: {
                block34: {
                    height = 0;
                    with = 0;
                    temp = 0;
                    row = 0;
                    pix = 0;
                    ss = 0;
                    boolean ret = false;
                    int printHeight = 0;
                    int printWidth = 0;
                    int widthLeft = 0;
                    int widthOctet = 0;
                    int width = 0;
                    int column = 0;
                    if (image == null) {
                        throw new NullPointerException();
                    }
                    int printer_type = -1;
                    if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
                        printer_type = 8;
                    }
                    if (printer_type == 5 || printer_type == 3 || printer_type == 4 || printer_type == 8) {
                        if (image.getWidth() > 576 || image.getHeight() < 1) {
                            throw new IllegalArgumentException("The width or the height of the image to print is illegal!");
                        }
                        widthLeft = image.getWidth() % 8;
                        printWidth = widthLeft != 0 ? image.getWidth() - widthLeft + 8 : image.getWidth();
                        byte[] Imagelogo2 = new byte[printWidth / 8 * image.getHeight()];
                        if (image.getConfig().equals((Object)Bitmap.Config.ARGB_8888)) {
                            widthOctet = image.getWidth() / 8;
                            row = 0;
                            while (row < image.getHeight()) {
                                int i;
                                width = 0;
                                column = 0;
                                while (width < widthOctet) {
                                    temp = 0;
                                    i = 0;
                                    while (i < 8) {
                                        pix = image.getPixel(i + column, row);
                                        temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                                        ++i;
                                    }
                                    Imagelogo2[ss] = (byte)temp;
                                    ++ss;
                                    ++width;
                                    column += 8;
                                }
                                if (widthLeft != 0) {
                                    temp = 0;
                                    i = 0;
                                    while (i < widthLeft) {
                                        pix = image.getPixel(i + column, row);
                                        temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                                        ++i;
                                    }
                                    Imagelogo2[ss] = (byte)(temp <<= 8 - widthLeft);
                                    ++ss;
                                }
                                ++row;
                            }
                            return Imagelogo2;
                        }
                        if (image.getConfig().equals((Object)Bitmap.Config.ALPHA_8)) {
                            widthOctet = image.getWidth() / 8;
                            row = 0;
                            while (row < image.getHeight()) {
                                int i;
                                width = 0;
                                column = 0;
                                while (width < widthOctet) {
                                    temp = 0;
                                    i = 0;
                                    while (i < 8) {
                                        pix = image.getPixel(i + column, row);
                                        temp = (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                                        ++i;
                                    }
                                    Imagelogo2[ss] = (byte)temp;
                                    ++ss;
                                    ++width;
                                    column += 8;
                                }
                                if (widthLeft != 0) {
                                    temp = 0;
                                    i = 0;
                                    while (i < widthLeft) {
                                        pix = image.getPixel(i + column, row);
                                        temp = (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                                        ++i;
                                    }
                                    Imagelogo2[ss] = (byte)(temp <<= 8 - widthLeft);
                                    ++ss;
                                }
                                ++row;
                            }
                            return Imagelogo2;
                        }
                        if (image.getConfig().equals((Object)Bitmap.Config.RGB_565)) {
                            widthOctet = image.getWidth() / 8;
                            row = 0;
                            while (row < image.getHeight()) {
                                int i;
                                width = 0;
                                column = 0;
                                while (width < widthOctet) {
                                    temp = 0;
                                    i = 0;
                                    while (i < 8) {
                                        pix = image.getPixel(i + column, row);
                                        temp = (pix & 0xF800) >> 11 > 15 && (pix & 0x7E0) >> 5 > 30 && (pix & 0x1F) > 15 ? (temp <<= 1) : (temp << 1) + 1;
                                        ++i;
                                    }
                                    Imagelogo2[ss] = (byte)temp;
                                    ++ss;
                                    ++width;
                                    column += 8;
                                }
                                if (widthLeft != 0) {
                                    temp = 0;
                                    i = 0;
                                    while (i < widthLeft) {
                                        pix = image.getPixel(i + column, row);
                                        temp = (pix & 0xF800) >> 11 > 15 && (pix & 0x7E0) >> 5 > 30 && (pix & 0x1F) > 15 ? (temp <<= 1) : (temp << 1) + 1;
                                        ++i;
                                    }
                                    Imagelogo2[ss] = (byte)(temp <<= 8 - widthLeft);
                                    ++ss;
                                }
                                ++row;
                            }
                            return Imagelogo2;
                        }
                        return Imagelogo2;
                    }
                    if (image.getWidth() > 384 || image.getHeight() < 1) {
                        throw new IllegalArgumentException("The width or the height of the image to print is illegal!");
                    }
                    printHeight = image.getHeight() % 8 != 0 ? (image.getHeight() / 8 + 1) * 8 : image.getHeight();
                    Imagelogo = new byte[image.getWidth() * printHeight / 8];
                    if (!image.getConfig().equals((Object)Bitmap.Config.ARGB_8888)) break block34;
                    row = 0;
                    while (row < image.getHeight() / 8) {
                        with = 0;
                        while (with < image.getWidth()) {
                            temp = 0;
                            height = row * 8;
                            while (height < row * 8 + 8) {
                                pix = image.getPixel(with, height);
                                temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                                ++height;
                            }
                            Imagelogo[ss] = (byte)temp;
                            ++ss;
                            ++with;
                        }
                        ++row;
                    }
                    break block35;
                }
                if (!image.getConfig().equals((Object)Bitmap.Config.ALPHA_8)) break block36;
                row = 0;
                while (row < image.getHeight() / 8) {
                    with = 0;
                    while (with < image.getWidth()) {
                        temp = 0;
                        height = row * 8;
                        while (height < row * 8 + 8) {
                            pix = image.getPixel(with, height);
                            if ((pix & 0xFF) > 128) {
                                temp *= 2;
                                temp <<= 1;
                            } else {
                                temp = (temp << 1) + 1;
                            }
                            ++height;
                        }
                        Imagelogo[ss] = (byte)temp;
                        ++ss;
                        ++with;
                    }
                    ++row;
                }
                break block35;
            }
            if (!image.getConfig().equals((Object)Bitmap.Config.RGB_565)) break block35;
            row = 0;
            while (row < image.getHeight() / 8) {
                with = 0;
                while (with < image.getWidth()) {
                    temp = 0;
                    height = row * 8;
                    while (height < row * 8 + 8) {
                        pix = image.getPixel(with, height);
                        temp = (pix & 0xF800) >> 11 > 15 && (pix & 0x7E0) >> 5 > 30 && (pix & 0x1F) > 15 ? (temp <<= 1) : (temp << 1) + 1;
                        ++height;
                    }
                    Imagelogo[ss] = (byte)temp;
                    ++ss;
                    ++with;
                }
                ++row;
            }
        }
        return Imagelogo;
    }

    public static synchronized void printLogo(int width, int height, char[] logo) throws TelpoException {
        if (!openFlag) {
            throw new DeviceNotOpenException("The printer has not been init!");
        }
        int printer_type = ThermalPrinter.get_printer_type();
        if (printer_type == 3 || printer_type == 4 || printer_type == 5) {
            if (width > 576 || width % 8 != 0) {
                throw new IllegalArgumentException("The width of the image to print is illegal!");
            }
        } else if (width > 384 || height % 8 != 0) {
            throw new IllegalArgumentException("The width or the height of the image to print is illegal!");
        }
        byte[] logoBytes = new byte[logo.length];
        int i = 0;
        while (i < logo.length) {
            logoBytes[i] = (byte)logo[i];
            ++i;
        }
        int ret = ThermalPrinter.print_logo(width, height, logoBytes);
        if (ret != 0) {
            throw ThermalPrinter.getException(ret);
        }
    }

    public static synchronized void printLogo581Left(int left, Bitmap image) {
        ThermalPrinter.printLogo581SetLeft(left, image);
    }

    public static synchronized void printLogo(Bitmap image) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.printLogo(image, false);
        } else if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
            ThermalPrinter.printLogo581(image);
        } else {
            int height = 0;
            int with = 0;
            int temp = 0;
            int row = 0;
            int pix = 0;
            int ss = 0;
            int ret = 0;
            int printHeight = 0;
            int printWidth = 0;
            int widthLeft = 0;
            int widthOctet = 0;
            int width = 0;
            int column = 0;
            if (!openFlag) {
                throw new DeviceNotOpenException("The printer has not been init!");
            }
            if (image == null) {
                throw new NullPointerException();
            }
            int printer_type = SystemUtil.getPrinterType();
            if (Build.MODEL.equals("MTDP-618A") || Build.MODEL.equals("TPS650M")) {
                printer_type = 2;
            }
            if (printer_type == 6 || printer_type == 7) {
                int image_row_bytes = 0;
                int img_height = 0;
                int img_width = 0;
                int Pixel_val = 0;
                boolean gray_val = false;
                img_height = image.getHeight();
                img_width = image.getWidth();
                image_row_bytes = img_height + 7 >> 3;
                byte[] bitmap_mode_cmd = new byte[]{27, 42, 1, (byte)(img_width & 0xFF), (byte)(img_width >> 8 & 0xFF)};
                byte[] buffer = new byte[img_width * image_row_bytes + image_row_bytes + bitmap_mode_cmd.length * image_row_bytes + 6 + 3 + 2];
                buffer[0] = 29;
                buffer[1] = 69;
                buffer[2] = 14;
                buffer[3] = 27;
                buffer[4] = 51;
                buffer[5] = 0;
                ss = 6;
                int row_index = 0;
                int h = 0;
                while (row_index < image_row_bytes) {
                    System.arraycopy(bitmap_mode_cmd, 0, buffer, ss, bitmap_mode_cmd.length);
                    ss += bitmap_mode_cmd.length;
                    int col_index = 0;
                    while (col_index < img_width) {
                        temp = 0;
                        int i = 0;
                        while (i < 8 && i + h < img_height) {
                            Pixel_val = image.getPixel(col_index, i + h);
                            temp = (Pixel_val & 0xFF0000) >> 16 > 128 && (Pixel_val & 0xFF00) >> 8 > 128 && (Pixel_val & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        buffer[ss++] = (byte)temp;
                        ++col_index;
                    }
                    buffer[ss++] = 10;
                    ++row_index;
                    h += 8;
                }
                buffer[ss++] = 29;
                buffer[ss++] = 69;
                buffer[ss++] = 1;
                buffer[ss++] = 27;
                buffer[ss++] = 64;
                ret = ThermalPrinter.print_logo(buffer.length, 0, buffer);
            } else if (printer_type == 5 || printer_type == 3 || printer_type == 4) {
                if (image.getWidth() > 576 || image.getHeight() < 1) {
                    throw new IllegalArgumentException("The width or the height of the image to print is illegal!");
                }
                widthLeft = image.getWidth() % 8;
                printWidth = widthLeft != 0 ? image.getWidth() - widthLeft + 8 : image.getWidth();
                byte[] Imagelogo = new byte[printWidth / 8 * image.getHeight()];
                if (image.getConfig().equals((Object)Bitmap.Config.ARGB_8888)) {
                    widthOctet = image.getWidth() / 8;
                    row = 0;
                    while (row < image.getHeight()) {
                        int i;
                        width = 0;
                        column = 0;
                        while (width < widthOctet) {
                            temp = 0;
                            i = 0;
                            while (i < 8) {
                                pix = image.getPixel(i + column, row);
                                temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                                ++i;
                            }
                            Imagelogo[ss] = (byte)temp;
                            ++ss;
                            ++width;
                            column += 8;
                        }
                        if (widthLeft != 0) {
                            temp = 0;
                            i = 0;
                            while (i < widthLeft) {
                                pix = image.getPixel(i + column, row);
                                temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                                ++i;
                            }
                            Imagelogo[ss] = (byte)(temp <<= 8 - widthLeft);
                            ++ss;
                        }
                        ++row;
                    }
                    Log.i((String)TAG, (String)"dealing ARGB_8888 image");
                } else if (image.getConfig().equals((Object)Bitmap.Config.ALPHA_8)) {
                    widthOctet = image.getWidth() / 8;
                    row = 0;
                    while (row < image.getHeight()) {
                        int i;
                        width = 0;
                        column = 0;
                        while (width < widthOctet) {
                            temp = 0;
                            i = 0;
                            while (i < 8) {
                                pix = image.getPixel(i + column, row);
                                temp = (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                                ++i;
                            }
                            Imagelogo[ss] = (byte)temp;
                            ++ss;
                            ++width;
                            column += 8;
                        }
                        if (widthLeft != 0) {
                            temp = 0;
                            i = 0;
                            while (i < widthLeft) {
                                pix = image.getPixel(i + column, row);
                                temp = (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                                ++i;
                            }
                            Imagelogo[ss] = (byte)(temp <<= 8 - widthLeft);
                            ++ss;
                        }
                        ++row;
                    }
                    Log.i((String)TAG, (String)"dealing ALPHA_8 image");
                } else if (image.getConfig().equals((Object)Bitmap.Config.RGB_565)) {
                    widthOctet = image.getWidth() / 8;
                    row = 0;
                    while (row < image.getHeight()) {
                        int i;
                        width = 0;
                        column = 0;
                        while (width < widthOctet) {
                            temp = 0;
                            i = 0;
                            while (i < 8) {
                                pix = image.getPixel(i + column, row);
                                temp = (pix & 0xF800) >> 11 > 15 && (pix & 0x7E0) >> 5 > 30 && (pix & 0x1F) > 15 ? (temp <<= 1) : (temp << 1) + 1;
                                ++i;
                            }
                            Imagelogo[ss] = (byte)temp;
                            ++ss;
                            ++width;
                            column += 8;
                        }
                        if (widthLeft != 0) {
                            temp = 0;
                            i = 0;
                            while (i < widthLeft) {
                                pix = image.getPixel(i + column, row);
                                temp = (pix & 0xF800) >> 11 > 15 && (pix & 0x7E0) >> 5 > 30 && (pix & 0x1F) > 15 ? (temp <<= 1) : (temp << 1) + 1;
                                ++i;
                            }
                            Imagelogo[ss] = (byte)(temp <<= 8 - widthLeft);
                            ++ss;
                        }
                        ++row;
                    }
                    Log.i((String)TAG, (String)"dealing RGB_565 image");
                } else {
                    Log.e((String)TAG, (String)"unsupport image formate!");
                }
                ret = ThermalPrinter.print_logo(printWidth, image.getHeight(), Imagelogo);
            } else {
                if (image.getWidth() > 384 || image.getHeight() < 1) {
                    throw new IllegalArgumentException("The width or the height of the image to print is illegal!");
                }
                printHeight = image.getHeight() % 8 != 0 ? (image.getHeight() / 8 + 1) * 8 : image.getHeight();
                byte[] Imagelogo = new byte[image.getWidth() * printHeight / 8];
                if (image.getConfig().equals((Object)Bitmap.Config.ARGB_8888)) {
                    row = 0;
                    while (row < image.getHeight() / 8) {
                        with = 0;
                        while (with < image.getWidth()) {
                            temp = 0;
                            height = row * 8;
                            while (height < row * 8 + 8) {
                                pix = image.getPixel(with, height);
                                temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                                ++height;
                            }
                            Imagelogo[ss] = (byte)temp;
                            ++ss;
                            ++with;
                        }
                        ++row;
                    }
                    Log.i((String)TAG, (String)"dealing ARGB_8888 image");
                } else if (image.getConfig().equals((Object)Bitmap.Config.ALPHA_8)) {
                    row = 0;
                    while (row < image.getHeight() / 8) {
                        with = 0;
                        while (with < image.getWidth()) {
                            temp = 0;
                            height = row * 8;
                            while (height < row * 8 + 8) {
                                pix = image.getPixel(with, height);
                                if ((pix & 0xFF) > 128) {
                                    temp *= 2;
                                    temp <<= 1;
                                } else {
                                    temp = (temp << 1) + 1;
                                }
                                ++height;
                            }
                            Imagelogo[ss] = (byte)temp;
                            ++ss;
                            ++with;
                        }
                        ++row;
                    }
                    Log.i((String)TAG, (String)"dealing ALPHA_8 image");
                } else if (image.getConfig().equals((Object)Bitmap.Config.RGB_565)) {
                    row = 0;
                    while (row < image.getHeight() / 8) {
                        with = 0;
                        while (with < image.getWidth()) {
                            temp = 0;
                            height = row * 8;
                            while (height < row * 8 + 8) {
                                pix = image.getPixel(with, height);
                                temp = (pix & 0xF800) >> 11 > 15 && (pix & 0x7E0) >> 5 > 30 && (pix & 0x1F) > 15 ? (temp <<= 1) : (temp << 1) + 1;
                                ++height;
                            }
                            Imagelogo[ss] = (byte)temp;
                            ++ss;
                            ++with;
                        }
                        ++row;
                    }
                    Log.i((String)TAG, (String)"dealing RGB_565 image");
                } else {
                    Log.e((String)TAG, (String)"unsupport image formate!");
                }
                ret = ThermalPrinter.print_logo(image.getWidth(), printHeight, Imagelogo);
            }
            if (ret != 0) {
                if (ret == 61441) {
                    throw new IllegalArgumentException();
                }
                throw ThermalPrinter.getException(ret);
            }
        }
    }

    public static synchronized String getVersion() throws TelpoException {
        if (mUsbThermalPrinter != null) {
            return mUsbThermalPrinter.getVersion();
        }
        if (!openFlag) {
            throw new DeviceNotOpenException();
        }
        String ver = null;
        byte[] version = new byte[128];
        if (ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
            return ThermalPrinterSY581.getVersion();
        }
        int ret = ThermalPrinter.get_version(version);
        if (ret != 0) {
            throw ThermalPrinter.getException(ret);
        }
        try {
            if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal()) {
                return ThermalPrinter.getVersionNum(ver);
            }
            ver = new String(version, 1, (int)version[0], "UTF-8");
            Log.d((String)"TAG", (String)("printer version:" + ver));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return ver;
    }

    public static synchronized void printLogo(Bitmap image, int mode) throws TelpoException {
        if (!openFlag) {
            throw new DeviceNotOpenException("The printer has not been init!");
        }
        if (image == null) {
            throw new NullPointerException();
        }
        int printer_type = SystemUtil.getPrinterType();
        if (Build.MODEL.equals("MTDP-618A") || Build.MODEL.equals("TPS650M")) {
            printer_type = 2;
        }
        int height = 0;
        int width = 0;
        int temp = 0;
        int row = 0;
        int pix = 0;
        int ss = 0;
        int ret = 0;
        int printHeight = 0;
        int printWidth = 0;
        int widthLeft = 0;
        int widthOctet = 0;
        int column = 0;
        if (printer_type == 7) {
            int image_col_bytes = 0;
            int img_height = 0;
            int img_width = 0;
            int Pixel_val = 0;
            img_height = image.getHeight();
            img_width = image.getWidth();
            image_col_bytes = img_width + 7 >> 3;
            byte[] buffer = new byte[img_height * image_col_bytes + 8 + 3];
            buffer[0] = 27;
            buffer[1] = 97;
            buffer[2] = mode == 1 ? 1 : (mode == 2 ? 2 : 0);
            buffer[3] = 29;
            buffer[4] = 118;
            buffer[5] = 48;
            buffer[6] = 0;
            buffer[7] = (byte)image_col_bytes;
            buffer[8] = (byte)(image_col_bytes >> 8);
            buffer[9] = (byte)img_height;
            buffer[10] = (byte)(img_height >> 8);
            ss = 11;
            int row_index = 0;
            while (row_index < img_height) {
                int col_index = 0;
                int h = 0;
                while (col_index < image_col_bytes) {
                    temp = 0;
                    int i = 0;
                    while (i < 8) {
                        if (i + h >= img_width) {
                            temp <<= 8 - i;
                            break;
                        }
                        Pixel_val = image.getPixel(i + h, row_index);
                        temp = (Pixel_val & 0xFF0000) >> 16 > 128 && (Pixel_val & 0xFF00) >> 8 > 128 && (Pixel_val & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                        ++i;
                    }
                    buffer[ss++] = (byte)temp;
                    ++col_index;
                    h += 8;
                }
                ++row_index;
            }
            ret = ThermalPrinter.print_logo(buffer.length, 0, buffer);
        } else if (printer_type == 6) {
            Bitmap bitmap = ThermalPrinter.adjustBitmap(image, mode);
            int image_row_bytes = 0;
            int img_height = 0;
            int img_width = 0;
            int Pixel_val = 0;
            boolean gray_val = false;
            img_height = bitmap.getHeight();
            img_width = bitmap.getWidth();
            image_row_bytes = img_height + 7 >> 3;
            byte[] bitmap_mode_cmd = new byte[]{27, 42, 1, (byte)(img_width & 0xFF), (byte)(img_width >> 8 & 0xFF)};
            byte[] buffer = new byte[img_width * image_row_bytes + image_row_bytes + bitmap_mode_cmd.length * image_row_bytes + 6 + 3 + 2];
            buffer[0] = 29;
            buffer[1] = 69;
            buffer[2] = 14;
            buffer[3] = 27;
            buffer[4] = 51;
            buffer[5] = 0;
            ss = 6;
            int row_index = 0;
            int h = 0;
            while (row_index < image_row_bytes) {
                System.arraycopy(bitmap_mode_cmd, 0, buffer, ss, bitmap_mode_cmd.length);
                ss += bitmap_mode_cmd.length;
                int col_index = 0;
                while (col_index < img_width) {
                    temp = 0;
                    int i = 0;
                    while (i < 8 && i + h < img_height) {
                        Pixel_val = bitmap.getPixel(col_index, i + h);
                        temp = (Pixel_val & 0xFF0000) >> 16 > 128 && (Pixel_val & 0xFF00) >> 8 > 128 && (Pixel_val & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                        ++i;
                    }
                    buffer[ss++] = (byte)temp;
                    ++col_index;
                }
                buffer[ss++] = 10;
                ++row_index;
                h += 8;
            }
            buffer[ss++] = 29;
            buffer[ss++] = 69;
            buffer[ss++] = 1;
            buffer[ss++] = 27;
            buffer[ss++] = 64;
            ret = ThermalPrinter.print_logo(buffer.length, 0, buffer);
        } else if (printer_type == 5 || printer_type == 3 || printer_type == 4) {
            if (image.getWidth() > 576 || image.getHeight() < 1) {
                throw new IllegalArgumentException("The width or the height of the image to print is illegal!");
            }
            widthLeft = image.getWidth() % 8;
            printWidth = widthLeft != 0 ? image.getWidth() - widthLeft + 8 : image.getWidth();
            int initWidth = 0;
            switch (mode) {
                case 0: {
                    initWidth = 0;
                    break;
                }
                case 1: {
                    initWidth = (576 - printWidth) / 2;
                    temp = initWidth % 8;
                    if (temp != 0) {
                        initWidth = initWidth - temp + 8;
                    }
                    printWidth += initWidth;
                    break;
                }
                case 2: {
                    initWidth = 576 - printWidth;
                    printWidth = 576;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The mode algin of the image to print is illegal!");
                }
            }
            Log.i((String)TAG, (String)("printWidth: " + printWidth));
            byte[] Imagelogo = new byte[printWidth / 8 * image.getHeight()];
            ss = initWidth /= 8;
            if (image.getConfig().equals((Object)Bitmap.Config.ARGB_8888)) {
                widthOctet = image.getWidth() / 8;
                row = 0;
                while (row < image.getHeight()) {
                    int i;
                    width = 0;
                    column = 0;
                    while (width < widthOctet) {
                        temp = 0;
                        i = 0;
                        while (i < 8) {
                            pix = image.getPixel(i + column, row);
                            temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        Imagelogo[ss] = (byte)temp;
                        ++ss;
                        ++width;
                        column += 8;
                    }
                    if (widthLeft != 0) {
                        temp = 0;
                        i = 0;
                        while (i < widthLeft) {
                            pix = image.getPixel(i + column, row);
                            temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        Imagelogo[ss] = (byte)(temp <<= 8 - widthLeft);
                        ++ss;
                    }
                    ss += initWidth;
                    ++row;
                }
                Log.i((String)TAG, (String)"dealing ARGB_8888 image");
            } else if (image.getConfig().equals((Object)Bitmap.Config.ALPHA_8)) {
                widthOctet = image.getWidth() / 8;
                row = 0;
                while (row < image.getHeight()) {
                    int i;
                    width = 0;
                    column = 0;
                    while (width < widthOctet) {
                        temp = 0;
                        i = 0;
                        while (i < 8) {
                            pix = image.getPixel(i + column, row);
                            temp = (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        Imagelogo[ss] = (byte)temp;
                        ++ss;
                        ++width;
                        column += 8;
                    }
                    if (widthLeft != 0) {
                        temp = 0;
                        i = 0;
                        while (i < widthLeft) {
                            pix = image.getPixel(i + column, row);
                            temp = (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        Imagelogo[ss] = (byte)(temp <<= 8 - widthLeft);
                        ++ss;
                    }
                    ss += initWidth;
                    ++row;
                }
                Log.i((String)TAG, (String)"dealing ALPHA_8 image");
            } else if (image.getConfig().equals((Object)Bitmap.Config.RGB_565)) {
                widthOctet = image.getWidth() / 8;
                row = 0;
                while (row < image.getHeight()) {
                    int i;
                    width = 0;
                    column = 0;
                    while (width < widthOctet) {
                        temp = 0;
                        i = 0;
                        while (i < 8) {
                            pix = image.getPixel(i + column, row);
                            temp = (pix & 0xF800) >> 11 > 15 && (pix & 0x7E0) >> 5 > 30 && (pix & 0x1F) > 15 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        Imagelogo[ss] = (byte)temp;
                        ++ss;
                        ++width;
                        column += 8;
                    }
                    if (widthLeft != 0) {
                        temp = 0;
                        i = 0;
                        while (i < widthLeft) {
                            pix = image.getPixel(i + column, row);
                            temp = (pix & 0xF800) >> 11 > 15 && (pix & 0x7E0) >> 5 > 30 && (pix & 0x1F) > 15 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        Imagelogo[ss] = (byte)(temp <<= 8 - widthLeft);
                        ++ss;
                    }
                    ss += initWidth;
                    ++row;
                }
                Log.i((String)TAG, (String)"dealing RGB_565 image");
            } else {
                Log.e((String)TAG, (String)"unsupport image formate!");
            }
            ret = ThermalPrinter.print_logo(printWidth, image.getHeight(), Imagelogo);
        } else {
            printHeight = image.getHeight() % 8 != 0 ? (image.getHeight() / 8 + 1) * 8 : image.getHeight();
            if (image.getWidth() > 384) {
                throw new IllegalArgumentException("The width or the height of the image to print is illegal!");
            }
            int initWidth = 0;
            printWidth = 0;
            switch (mode) {
                case 0: {
                    printWidth = image.getWidth();
                    initWidth = 0;
                    break;
                }
                case 1: {
                    printWidth = (384 - image.getWidth()) / 2 + image.getWidth();
                    initWidth = (384 - image.getWidth()) / 2;
                    break;
                }
                case 2: {
                    printWidth = 384;
                    initWidth = 384 - image.getWidth();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The mode algin of the image to print is illegal!");
                }
            }
            byte[] Imagelogo = new byte[printWidth * printHeight / 8];
            Log.e((String)TAG, (String)(":" + initWidth + ":" + printWidth + ":" + printHeight));
            ss = initWidth;
            if (image.getConfig().equals((Object)Bitmap.Config.ARGB_8888)) {
                row = 0;
                while (row < printHeight / 8) {
                    width = initWidth;
                    while (width < initWidth + image.getWidth()) {
                        temp = 0;
                        height = row * 8;
                        while (height < Math.min(row * 8 + 8, image.getHeight())) {
                            pix = image.getPixel(width - initWidth, height);
                            temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                            ++height;
                        }
                        Imagelogo[ss] = (byte)temp;
                        ++ss;
                        ++width;
                    }
                    ss += initWidth;
                    ++row;
                }
                Log.i((String)TAG, (String)"dealing ARGB_8888 image");
            } else if (image.getConfig().equals((Object)Bitmap.Config.ALPHA_8)) {
                row = 0;
                while (row < printHeight / 8) {
                    width = initWidth;
                    while (width < initWidth + image.getWidth()) {
                        temp = 0;
                        height = row * 8;
                        while (height < Math.min(row * 8 + 8, image.getHeight())) {
                            pix = image.getPixel(width - initWidth, height);
                            if ((pix & 0xFF) > 128) {
                                temp *= 2;
                                temp <<= 1;
                            } else {
                                temp = (temp << 1) + 1;
                            }
                            ++height;
                        }
                        Imagelogo[ss] = (byte)temp;
                        ++ss;
                        ++width;
                    }
                    ss += initWidth;
                    ++row;
                }
                Log.i((String)TAG, (String)"dealing ALPHA_8 image");
            } else if (image.getConfig().equals((Object)Bitmap.Config.RGB_565)) {
                row = 0;
                while (row < printHeight / 8) {
                    height = row * 8;
                    while (height < Math.min(row * 8 + 8, image.getHeight())) {
                        temp = 0;
                        height = row * 8;
                        while (height < row * 8 + 8) {
                            pix = image.getPixel(width - initWidth, height);
                            temp = (pix & 0xF800) >> 11 > 15 && (pix & 0x7E0) >> 5 > 30 && (pix & 0x1F) > 15 ? (temp <<= 1) : (temp << 1) + 1;
                            ++height;
                        }
                        Imagelogo[ss] = (byte)temp;
                        ++ss;
                        ++height;
                    }
                    ss += initWidth;
                    ++row;
                }
                Log.i((String)TAG, (String)"dealing RGB_565 image");
            } else {
                Log.e((String)TAG, (String)"unsupport image formate!");
            }
            ret = ThermalPrinter.print_logo(printWidth, printHeight, Imagelogo);
        }
        if (ret != 0) {
            throw ThermalPrinter.getException(ret);
        }
    }

    private static Bitmap CreateCode(String str, BarcodeFormat type, int bmpWidth, int bmpHeight) throws InternalErrorException {
        BitMatrix matrix = null;
        try {
            matrix = new MultiFormatWriter().encode(str, type, bmpWidth, bmpHeight);
        }
        catch (WriterException e) {
            e.printStackTrace();
            throw new InternalErrorException("Failed to encode bitmap");
        }
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int[] pixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                pixels[y * width + x] = matrix.get(x, y) ? -16777216 : -1;
                ++x;
            }
            ++y;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }

    public static void searchMark(int search_distance, int walk_distance) throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.searchMark(search_distance, walk_distance);
        } else {
            int ret;
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            if (!(ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal() || (ret = ThermalPrinter.search_mark(0, search_distance, walk_distance)) == 0)) {
                throw ThermalPrinter.getException(ret);
            }
        }
    }

    public static void paperCut() throws TelpoException {
        if (mUsbThermalPrinter != null) {
            mUsbThermalPrinter.paperCut();
        } else {
            if (!openFlag) {
                throw new DeviceNotOpenException();
            }
            int ret = ThermalPrinter.paper_cut();
            if (ret != 0) {
                throw ThermalPrinter.getException(ret);
            }
        }
    }

    public static void paperCutAll() throws TelpoException {
        if (!openFlag) {
            throw new DeviceNotOpenException();
        }
        int ret = ThermalPrinter.paper_cut_all();
        if (ret != 0) {
            throw ThermalPrinter.getException(ret);
        }
    }

    public static void sendCommand(String cmdStr) throws TelpoException {
        if (!openFlag) {
            throw new DeviceNotOpenException();
        }
        if (cmdStr == null) {
            throw new IllegalArgumentException();
        }
        byte[] cmd = ThermalPrinter.str2BCD(cmdStr.replace(" ", ""));
        int ret = ThermalPrinter.send_command(cmd, cmd.length);
        if (ret != 0) {
            throw ThermalPrinter.getException(ret);
        }
    }

    public static void sendCommand(byte[] cmdStr, int len) throws TelpoException {
        if (!openFlag) {
            throw new DeviceNotOpenException();
        }
        if (cmdStr == null) {
            throw new IllegalArgumentException();
        }
        int ret = ThermalPrinter.send_command(cmdStr, len);
        if (ret != 0) {
            throw ThermalPrinter.getException(ret);
        }
    }

    public static void setBold(boolean isBold) throws TelpoException {
        if (!openFlag) {
            throw new DeviceNotOpenException();
        }
        if (!(ThermalPrinter.getFileContent(FILE_NAME) != null && ThermalPrinter.getFileContent(FILE_NAME).equals("SY581") || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal())) {
            if (isBold) {
                ThermalPrinter.set_bold(1);
            } else {
                ThermalPrinter.set_bold(0);
            }
        }
    }

    private static byte[] str2BCD(String string) {
        String str;
        String hexStr = "0123456789ABCDEF";
        int len = string.length();
        if (len % 2 == 1) {
            str = String.valueOf(string) + "0";
            len = len + 1 >> 1;
        } else {
            str = string;
            len >>= 1;
        }
        byte[] bytes = new byte[len];
        int i = 0;
        int j = 0;
        while (i < len) {
            byte high = (byte)(hexStr.indexOf(str.charAt(j)) << 4);
            byte low = (byte)hexStr.indexOf(str.charAt(j + 1));
            bytes[i] = (byte)(high | low);
            ++i;
            j += 2;
        }
        return bytes;
    }

    private static int getGreyLevel(int pixel, float intensity) {
        float red = Color.red((int)pixel);
        float green = Color.green((int)pixel);
        float blue = Color.blue((int)pixel);
        float parcial = red + green + blue;
        int gray = (int)((parcial = (float)((double)parcial / 3.0)) * intensity);
        if (gray > 255) {
            gray = 255;
        }
        return gray;
    }

    private static Bitmap adjustBitmap(Bitmap bitmap, int align) {
        if (bitmap == null) {
            return null;
        }
        int adjustWidth = bitmap.getWidth();
        int adjustHeight = bitmap.getHeight();
        int offset = 0;
        int temp = 0;
        if (align == 1) {
            if ((temp = (adjustWidth += (offset = (384 - adjustWidth) / 2)) % 8) != 0) {
                adjustWidth += 8 - temp;
            }
        } else if (align == 2) {
            offset = 384 - adjustWidth;
            adjustWidth = 384;
        } else {
            temp = adjustWidth % 8;
            if (temp != 0) {
                adjustWidth += 8 - temp;
            }
        }
        Bitmap newBitmap = Bitmap.createBitmap((int)adjustWidth, (int)adjustHeight, (Bitmap.Config)bitmap.getConfig());
        Paint paint = new Paint();
        paint.setColor(-1);
        Canvas canvas = new Canvas(newBitmap);
        canvas.drawRect(0.0f, 0.0f, (float)adjustWidth, (float)adjustHeight, paint);
        canvas.drawBitmap(bitmap, (float)offset, 0.0f, null);
        return newBitmap;
    }

    private static String getFileContent(String file_name) {
        String filePath = file_name;
        String fileContent = null;
        try {
            File file = new File(filePath);
            if (file.isFile() && file.exists()) {
                InputStreamReader isr = new InputStreamReader(new FileInputStream(file));
                BufferedReader br = new BufferedReader(isr);
                String lineTxt = null;
                while ((lineTxt = br.readLine()) != null) {
                    fileContent = lineTxt;
                }
                isr.close();
                br.close();
            } else {
                Log.e((String)"TAG", (String)"can not find file");
                file.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileContent;
    }
}

