/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.printer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.util.Log;
import android_serialport_api.SerialPort;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.util.StringUtil;
import com.telpo.tps550.api.util.SystemUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ThermalPrinterSY581 {
    private static final String TAG = "TELPO_SDK";
    public static final int ALGIN_LEFT = 0;
    public static final int ALGIN_MIDDLE = 1;
    public static final int ALGIN_RIGHT = 2;
    private static final int ARGB_MASK_RED = 0xFF0000;
    private static final int ARGB_MASK_GREEN = 65280;
    private static final int ARGB_MASK_BLUE = 255;
    private static final int RGB565_MASK_RED = 63488;
    private static final int RGB565_MASK_GREEN = 2016;
    private static final int RGB565_MASK_BLUE = 31;
    private static final int color = 128;
    private static SerialPort checkSerialPort;
    private static InputStream checkInputStream;
    private static ReadThread checkReadThread;
    static int count;

    static {
        count = 0;
    }

    public static synchronized void openCheckThread() {
        try {
            checkSerialPort = SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal() ? new SerialPort(new File("/dev/ttyS0"), 460800, 0) : new SerialPort(new File("/dev/ttyS4"), 460800, 0);
            checkInputStream = checkSerialPort.getInputStream();
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        checkReadThread = new ReadThread();
        checkReadThread.start();
    }

    public static synchronized void closeCheckThread() {
        if (checkReadThread != null) {
            checkReadThread.interrupt();
        }
        if (checkSerialPort != null) {
            checkSerialPort.close();
            checkSerialPort = null;
        }
        checkSerialPort = null;
        try {
            checkInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void reset() {
        byte[] cmdStr = new byte[]{27, 121};
        ThermalPrinterSY581.sendCommand(cmdStr);
    }

    public static synchronized void checkStatus() {
        final byte[] cmdStr = new byte[]{27, 22};
        new Thread(new Runnable(){

            @Override
            public void run() {
                ThermalPrinterSY581.sendCommand(cmdStr);
            }
        }).start();
    }

    public static synchronized void setLineSpace(int lineSpace) {
        String lineSpaceStr = "";
        lineSpaceStr = lineSpace == 1 ? "01" : (lineSpace == 2 ? "02" : (lineSpace == 3 ? "03" : (lineSpace == 4 ? "04" : (lineSpace == 5 ? "05" : (lineSpace == 6 ? "06" : (lineSpace == 7 ? "07" : (lineSpace == 8 ? "08" : (lineSpace == 9 ? "09" : "" + lineSpace))))))));
        byte lineSpaceByte = ThermalPrinterSY581.parseHexStr2Byte(lineSpaceStr)[0];
        byte[] cmdStr = new byte[]{27, 51, lineSpaceByte};
        ThermalPrinterSY581.sendCommand(cmdStr);
    }

    public static synchronized void setGray(int gray) {
        String grayStr = "";
        if (gray == 0) {
            grayStr = "08";
        } else if (gray == 1) {
            grayStr = "07";
        } else if (gray == 2) {
            grayStr = "06";
        } else if (gray == 3) {
            grayStr = "05";
        } else if (gray == 4) {
            grayStr = "04";
        } else if (gray == 5) {
            grayStr = "03";
        }
        byte grayByte = ThermalPrinterSY581.parseHexStr2Byte(grayStr)[0];
        byte[] cmdStr = new byte[]{27, 115, grayByte};
        ThermalPrinterSY581.sendCommand(cmdStr);
    }

    public static synchronized void setAlign(int mode) {
        byte[] cmdStr = null;
        if (mode == 0) {
            byte[] byArray = new byte[3];
            byArray[0] = 27;
            byArray[1] = 97;
            cmdStr = byArray;
        } else if (mode == 1) {
            cmdStr = new byte[]{27, 97, 1};
        } else if (mode == 2) {
            cmdStr = new byte[]{27, 97, 2};
        }
        ThermalPrinterSY581.sendCommand(cmdStr);
    }

    public static synchronized String getVersion() {
        byte[] cmdStr = new byte[]{27, 119};
        ThermalPrinterSY581.sendCommand(cmdStr);
        return "";
    }

    public static synchronized void setTem(int tem) {
        String tempreture = Integer.toHexString(tem);
        byte[] cmdStr = new byte[]{29, 40, StringUtil.toBytes(tempreture)[0]};
        ThermalPrinterSY581.sendCommand(cmdStr);
    }

    public static synchronized void setLeftDistance(int leftDistance) {
        if (leftDistance < 0 || leftDistance > 255) {
            return;
        }
        String nL_str_16 = Integer.toHexString(leftDistance);
        if (nL_str_16.length() == 1) {
            nL_str_16 = "0" + nL_str_16;
        }
        byte nL = ThermalPrinterSY581.parseHexStr2Byte(nL_str_16)[0];
        byte[] byArray = new byte[4];
        byArray[0] = 27;
        byArray[1] = 108;
        byArray[2] = nL;
        byte[] cmdStr = byArray;
        ThermalPrinterSY581.sendCommand(cmdStr);
    }

    public static synchronized void setFont(int multiple) {
        if (multiple < 0 || multiple > 7) {
            return;
        }
        if (multiple == 0) {
            ThermalPrinterSY581.setFont(0, 0);
        } else if (multiple == 1) {
            ThermalPrinterSY581.setFont(1, 1);
        } else if (multiple == 2) {
            ThermalPrinterSY581.setFont(2, 2);
        } else if (multiple == 3) {
            ThermalPrinterSY581.setFont(3, 3);
        } else if (multiple == 4) {
            ThermalPrinterSY581.setFont(4, 4);
        } else if (multiple == 5) {
            ThermalPrinterSY581.setFont(5, 5);
        } else if (multiple == 6) {
            ThermalPrinterSY581.setFont(6, 6);
        } else if (multiple == 7) {
            ThermalPrinterSY581.setFont(7, 7);
        }
    }

    public static synchronized void setFont(int widthMultiple, int heightMultiple) {
        if (heightMultiple < 0 || heightMultiple > 7 || widthMultiple < 0 || widthMultiple > 7) {
            return;
        }
        if (widthMultiple == 0) {
            widthMultiple = 0;
        } else if (widthMultiple == 1) {
            widthMultiple = 10;
        } else if (widthMultiple == 2) {
            widthMultiple = 20;
        } else if (widthMultiple == 3) {
            widthMultiple = 30;
        } else if (widthMultiple == 4) {
            widthMultiple = 40;
        } else if (widthMultiple == 5) {
            widthMultiple = 50;
        } else if (widthMultiple == 6) {
            widthMultiple = 60;
        } else if (widthMultiple == 7) {
            widthMultiple = 70;
        }
        String fontSize = null;
        fontSize = widthMultiple == 0 ? "0" + heightMultiple : "" + heightMultiple + widthMultiple;
        byte font = ThermalPrinterSY581.parseHexStr2Byte(fontSize)[0];
        byte[] cmdStr = null;
        if (fontSize.equals("00")) {
            byte[] byArray = new byte[3];
            byArray[0] = 28;
            byArray[1] = 33;
            cmdStr = byArray;
        } else {
            cmdStr = new byte[]{29, 33, font};
        }
        ThermalPrinterSY581.sendCommand(cmdStr);
    }

    public static synchronized void printLogo(Bitmap bitmap) {
        SerialPort serial = null;
        byte[] cmdStr = null;
        Bitmap picture = null;
        int count = 0;
        try {
            serial = SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal() ? new SerialPort(new File("/dev/ttyS0"), 460800, 0) : new SerialPort(new File("/dev/ttyS4"), 460800, 0);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        picture = bitmap.getWidth() % 8 != 0 ? ThermalPrinterSY581.zoomImg(bitmap, (bitmap.getWidth() / 8 + 1) * 8, bitmap.getHeight()) : bitmap;
        try {
            byte[] picture_haschange = ThermalPrinterSY581.changeBitmap(picture);
            cmdStr = new byte[8 + picture_haschange.length];
            cmdStr[0] = 29;
            cmdStr[1] = 118;
            cmdStr[2] = 48;
            cmdStr[3] = 0;
            String xl = Integer.toHexString(picture.getWidth() / 8 % 256);
            String xh = Integer.toHexString(picture.getWidth() / 8 / 256);
            String yl = Integer.toHexString(picture.getHeight() % 256);
            String yh = Integer.toHexString(picture.getHeight() / 256);
            if (xl.length() == 1) {
                xl = "0" + xl;
            }
            if (xh.length() == 1) {
                xh = "0" + xh;
            }
            if (yl.length() == 1) {
                yl = "0" + yl;
            }
            if (yh.length() == 1) {
                yh = "0" + yh;
            }
            cmdStr[4] = ThermalPrinterSY581.parseHexStr2Byte(xl)[0];
            cmdStr[5] = ThermalPrinterSY581.parseHexStr2Byte(xh)[0];
            cmdStr[6] = ThermalPrinterSY581.parseHexStr2Byte(yl)[0];
            cmdStr[7] = ThermalPrinterSY581.parseHexStr2Byte(yh)[0];
            int i = 8;
            int j = 0;
            while (i < cmdStr.length) {
                cmdStr[i] = picture_haschange[j];
                ++i;
                ++j;
            }
        }
        catch (TelpoException e2) {
            e2.printStackTrace();
        }
        OutputStream mOutputStream = serial.getOutputStream();
        Log.d((String)"TAG", (String)("cmd length:" + cmdStr.length));
        while (cmdStr.length - count > 100) {
            try {
                mOutputStream.write(cmdStr, count, 100);
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Log.d((String)"TAG", (String)("write:" + count));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            count += 100;
        }
        try {
            mOutputStream.write(cmdStr, count, cmdStr.length - count);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (serial != null) {
            serial.close();
            serial = null;
        }
        serial = null;
        try {
            mOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static synchronized Bitmap zoomImg(Bitmap bm, int newWidth, int newHeight) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newbm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return newbm;
    }

    private static synchronized byte[] changeBitmap(Bitmap image) throws TelpoException {
        int height = 0;
        int with = 0;
        int temp = 0;
        int row = 0;
        int pix = 0;
        int ss = 0;
        boolean ret = false;
        int printHeight = 0;
        int printWidth = 0;
        int widthLeft = 0;
        int widthOctet = 0;
        int width = 0;
        int column = 0;
        if (image == null) {
            throw new NullPointerException();
        }
        int printer_type = SystemUtil.checkPrinter581();
        if (printer_type == 5 || printer_type == 3 || printer_type == 4 || printer_type == 8) {
            Log.d((String)"TAG", (String)("img_width:" + image.getWidth()));
            Log.d((String)"TAG", (String)("img_height:" + image.getHeight()));
            Log.d((String)"TAG", (String)("picture config is:" + image.getConfig()));
            if (image.getWidth() > 576 || image.getHeight() < 1) {
                throw new IllegalArgumentException("The width or the height of the image to print is illegal!");
            }
            widthLeft = image.getWidth() % 8;
            printWidth = widthLeft != 0 ? image.getWidth() - widthLeft + 8 : image.getWidth();
            byte[] Imagelogo = new byte[printWidth / 8 * image.getHeight()];
            Log.d((String)"TAG", (String)("imagelogo length:" + Imagelogo.length));
            if (image.getConfig().equals((Object)Bitmap.Config.ARGB_8888)) {
                widthOctet = image.getWidth() / 8;
                row = 0;
                while (row < image.getHeight()) {
                    int i;
                    width = 0;
                    column = 0;
                    while (width < widthOctet) {
                        temp = 0;
                        i = 0;
                        while (i < 8) {
                            pix = image.getPixel(i + column, row);
                            temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        Imagelogo[ss] = (byte)temp;
                        ++ss;
                        ++width;
                        column += 8;
                    }
                    if (widthLeft != 0) {
                        temp = 0;
                        i = 0;
                        while (i < widthLeft) {
                            pix = image.getPixel(i + column, row);
                            temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        Imagelogo[ss] = (byte)(temp <<= 8 - widthLeft);
                        ++ss;
                    }
                    ++row;
                }
                Log.i((String)"TAG", (String)"dealing ARGB_8888 image");
                return Imagelogo;
            }
            if (image.getConfig().equals((Object)Bitmap.Config.ALPHA_8)) {
                widthOctet = image.getWidth() / 8;
                row = 0;
                while (row < image.getHeight()) {
                    int i;
                    width = 0;
                    column = 0;
                    while (width < widthOctet) {
                        temp = 0;
                        i = 0;
                        while (i < 8) {
                            pix = image.getPixel(i + column, row);
                            temp = (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        Imagelogo[ss] = (byte)temp;
                        ++ss;
                        ++width;
                        column += 8;
                    }
                    if (widthLeft != 0) {
                        temp = 0;
                        i = 0;
                        while (i < widthLeft) {
                            pix = image.getPixel(i + column, row);
                            temp = (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        Imagelogo[ss] = (byte)(temp <<= 8 - widthLeft);
                        ++ss;
                    }
                    ++row;
                }
                Log.i((String)"TAG", (String)"dealing ALPHA_8 image");
                return Imagelogo;
            }
            if (image.getConfig().equals((Object)Bitmap.Config.RGB_565)) {
                widthOctet = image.getWidth() / 8;
                row = 0;
                while (row < image.getHeight()) {
                    int i;
                    width = 0;
                    column = 0;
                    while (width < widthOctet) {
                        temp = 0;
                        i = 0;
                        while (i < 8) {
                            pix = image.getPixel(i + column, row);
                            temp = (pix & 0xF800) >> 11 > 15 && (pix & 0x7E0) >> 5 > 30 && (pix & 0x1F) > 15 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        Imagelogo[ss] = (byte)temp;
                        ++ss;
                        ++width;
                        column += 8;
                    }
                    if (widthLeft != 0) {
                        temp = 0;
                        i = 0;
                        while (i < widthLeft) {
                            pix = image.getPixel(i + column, row);
                            temp = (pix & 0xF800) >> 11 > 15 && (pix & 0x7E0) >> 5 > 30 && (pix & 0x1F) > 15 ? (temp <<= 1) : (temp << 1) + 1;
                            ++i;
                        }
                        Imagelogo[ss] = (byte)(temp <<= 8 - widthLeft);
                        ++ss;
                    }
                    ++row;
                }
                Log.i((String)"TAG", (String)"dealing RGB_565 image");
                return Imagelogo;
            }
            Log.e((String)"TAG", (String)"unsupport image formate!");
            return Imagelogo;
        }
        if (image.getWidth() > 384 || image.getHeight() < 1) {
            throw new IllegalArgumentException("The width or the height of the image to print is illegal!");
        }
        printHeight = image.getHeight() % 8 != 0 ? (image.getHeight() / 8 + 1) * 8 : image.getHeight();
        byte[] Imagelogo = new byte[image.getWidth() * printHeight / 8];
        if (image.getConfig().equals((Object)Bitmap.Config.ARGB_8888)) {
            row = 0;
            while (row < image.getHeight() / 8) {
                with = 0;
                while (with < image.getWidth()) {
                    temp = 0;
                    height = row * 8;
                    while (height < row * 8 + 8) {
                        pix = image.getPixel(with, height);
                        temp = (pix & 0xFF0000) >> 16 > 128 && (pix & 0xFF00) >> 8 > 128 && (pix & 0xFF) > 128 ? (temp <<= 1) : (temp << 1) + 1;
                        ++height;
                    }
                    Imagelogo[ss] = (byte)temp;
                    ++ss;
                    ++with;
                }
                ++row;
            }
            Log.i((String)"TAG", (String)"dealing ARGB_8888 image");
        } else if (image.getConfig().equals((Object)Bitmap.Config.ALPHA_8)) {
            row = 0;
            while (row < image.getHeight() / 8) {
                with = 0;
                while (with < image.getWidth()) {
                    temp = 0;
                    height = row * 8;
                    while (height < row * 8 + 8) {
                        pix = image.getPixel(with, height);
                        if ((pix & 0xFF) > 128) {
                            temp *= 2;
                            temp <<= 1;
                        } else {
                            temp = (temp << 1) + 1;
                        }
                        ++height;
                    }
                    Imagelogo[ss] = (byte)temp;
                    ++ss;
                    ++with;
                }
                ++row;
            }
            Log.i((String)"TAG", (String)"dealing ALPHA_8 image");
        } else if (image.getConfig().equals((Object)Bitmap.Config.RGB_565)) {
            row = 0;
            while (row < image.getHeight() / 8) {
                with = 0;
                while (with < image.getWidth()) {
                    temp = 0;
                    height = row * 8;
                    while (height < row * 8 + 8) {
                        pix = image.getPixel(with, height);
                        temp = (pix & 0xF800) >> 11 > 15 && (pix & 0x7E0) >> 5 > 30 && (pix & 0x1F) > 15 ? (temp <<= 1) : (temp << 1) + 1;
                        ++height;
                    }
                    Imagelogo[ss] = (byte)temp;
                    ++ss;
                    ++with;
                }
                ++row;
            }
            Log.i((String)"TAG", (String)"dealing RGB_565 image");
        } else {
            Log.e((String)"TAG", (String)"unsupport image formate!");
        }
        return Imagelogo;
    }

    private static synchronized byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        int i = 0;
        while (i < hexStr.length() / 2) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
            ++i;
        }
        return result;
    }

    /*
     * Loose catch block
     */
    private static synchronized void sendCommand(byte[] cmdStr) {
        SerialPort serial = null;
        OutputStream mOutputStream = null;
        try {
            try {
                serial = SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS650T.ordinal() ? new SerialPort(new File("/dev/ttyS0"), 460800, 0) : new SerialPort(new File("/dev/ttyS4"), 460800, 0);
                mOutputStream = serial.getOutputStream();
                int i = 0;
                while (i < cmdStr.length) {
                    mOutputStream.write(cmdStr[i]);
                    ++i;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (mOutputStream != null) {
                        mOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (serial != null) {
                    serial.close();
                    serial = null;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
                try {
                    if (mOutputStream != null) {
                        mOutputStream.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                if (serial != null) {
                    serial.close();
                    serial = null;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (mOutputStream != null) {
                        mOutputStream.close();
                    }
                }
                catch (IOException e3) {
                    // empty catch block
                }
                if (serial != null) {
                    serial.close();
                    serial = null;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e4) {
                    e4.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (mOutputStream != null) {
                    mOutputStream.close();
                }
            }
            catch (IOException e) {}
            if (serial != null) {
                serial.close();
                serial = null;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static class ReadThread
    extends Thread {
        @Override
        public void run() {
            super.run();
            while (!this.isInterrupted()) {
                try {
                    byte[] buffer = new byte[64];
                    int size = checkInputStream.read(buffer);
                    if (size <= 0) continue;
                    byte name = buffer[0];
                    if (name == 17) {
                        Log.d((String)"TAG", (String)"\u7ee7\u7eed\u53d1\u9001");
                        continue;
                    }
                    if (name != 19) continue;
                    Log.d((String)"TAG", (String)"\u505c\u6b62\u53d1\u9001");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }
}

