/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.printer;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.telpo.tps550.api.InternalErrorException;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.printer.BlackBlockNotFoundException;
import com.telpo.tps550.api.printer.NoPaperException;
import com.telpo.tps550.api.printer.OverHeatException;
import com.telpo.tps550.api.util.StringUtil;
import com.telpo.tps550.api.util.SystemUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UsbThermalPrinter {
    private Context mContext = null;
    private Object EscPos;
    private int powerValue;
    public static final int ALGIN_LEFT = 0;
    public static final int ALGIN_MIDDLE = 1;
    public static final int ALGIN_RIGHT = 2;
    public static final int DIRECTION_FORWORD = 0;
    public static final int DIRECTION_BACK = 1;
    public static final int WALK_DOTLINE = 0;
    public static final int WALK_LINE = 1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_NO_PAPER = 1;
    public static final int STATUS_OVER_HEAT = 2;
    public static final int STATUS_OVER_FLOW = 3;
    public static final int STATUS_UNKNOWN = 4;

    public UsbThermalPrinter(Context context) {
        this.mContext = context;
    }

    public synchronized void start(int mode) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("start", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("start", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, mode);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void reset() throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("reset", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("reset", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void walkPaper(int line) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("walkPaper", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, line);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("walkPaper", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, line);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void stop() {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("stop", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("stop", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized int checkStatus() throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        int iResult = 0;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("checkStatus", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                iResult = (Integer)method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("checkStatus", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                iResult = (Integer)method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
        return iResult;
    }

    public synchronized void enlargeFontSize(int widthMultiple, int heightMultiple) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("enlargeFontSize", Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, widthMultiple, heightMultiple);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("enlargeFontSize", Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, widthMultiple, heightMultiple);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void setFontSize(int type) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("setFontSize", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, type);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("setFontSize", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, type);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setTextSize(int size) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("setTextSize", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, size);
                return;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                Exception targetExp = (Exception)e.getTargetException();
                if (!(targetExp instanceof TelpoException)) return;
                throw (TelpoException)targetExp;
            }
        }
        try {
            thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("UsbPrinter");
        try {
            method = thermalPrinter.getMethod("setTextSize", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, size);
            return;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Exception targetExp = (Exception)e.getTargetException();
            if (!(targetExp instanceof TelpoException)) return;
            throw (TelpoException)targetExp;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setUnderline(boolean mode) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("setUnderline", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, mode);
                return;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                Exception targetExp = (Exception)e.getTargetException();
                if (!(targetExp instanceof TelpoException)) return;
                throw (TelpoException)targetExp;
            }
        }
        try {
            thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("UsbPrinter");
        try {
            method = thermalPrinter.getMethod("setUnderline", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, mode);
            return;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Exception targetExp = (Exception)e.getTargetException();
            if (!(targetExp instanceof TelpoException)) return;
            throw (TelpoException)targetExp;
        }
    }

    public synchronized void setMonoSpace(boolean isMonoSpace) throws TelpoException {
        block9: {
            Class<?> thermalPrinter = null;
            Method method = null;
            Object obj = null;
            if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
                try {
                    thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    throw new InternalErrorException();
                }
                obj = this.mContext.getSystemService("ThermalPrinter");
                try {
                    method = thermalPrinter.getMethod("setMonoSpace", Boolean.TYPE);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    throw new InternalErrorException();
                }
                try {
                    method.invoke(obj, isMonoSpace);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    throw new InternalErrorException();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new InternalErrorException();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    Exception targetExp = (Exception)e.getTargetException();
                    if (!(targetExp instanceof TelpoException)) break block9;
                    throw (TelpoException)targetExp;
                }
            }
        }
    }

    public synchronized void setHighlight(boolean mode) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("setHighlight", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, mode);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("setHighlight", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, mode);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void setGray(int level) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("setGray", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, level);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("setGray", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, level);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void setAlgin(int mode) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("setAlgin", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, mode);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("setAlgin", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, mode);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void addString(String content) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("addString", String.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, content);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("addString", String.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, content);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void addStringOffset(int offset, String content) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("addStringOffset", Integer.TYPE, String.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, offset, content);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("addStringOffset", Integer.TYPE, String.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, offset, content);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void endLine() throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("endLine", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("endLine", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void clearString() throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("clearString", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("clearString", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void printString() throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("printString", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("printString", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void printStringAndWalk(int direction, int mode, int lines) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("printStringAndWalk", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, direction, mode, lines);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("printStringAndWalk", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, direction, mode, lines);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void setLineSpace(int lineSpace) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("setLineSpace", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, lineSpace);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("setLineSpace", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, lineSpace);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void setLeftIndent(int space) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("setLeftIndent", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, space);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("setLeftIndent", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, space);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void printLogo(Bitmap image, boolean isBuffer) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("printLogo", Bitmap.class, Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, image, isBuffer);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("printLogo", Bitmap.class, Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, image, isBuffer);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized String getVersion() throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        String version = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("getVersion", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                version = (String)method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("getVersion", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                version = (String)method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
        return version;
    }

    public synchronized void searchMark(int search_disdance, int walk_disdance) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("searchMark", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, 0, search_disdance, walk_disdance);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("searchMark", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, 0, search_disdance, walk_disdance);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void paperCut() throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("paperCut", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("paperCut", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void setBold(boolean isBold) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("setBold", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, isBold);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("setBold", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, isBold);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public int measureText(String text) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        int iRet = -1;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("measureText", String.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                iRet = (Integer)method.invoke(obj, text);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("measureText", String.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                iRet = (Integer)method.invoke(obj, text);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
        return iRet;
    }

    public synchronized void autoBreakSet(boolean isAutoBreak) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("setAutoBreak", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, isAutoBreak);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("setAutoBreak", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, isAutoBreak);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException e) {
                this.throwException(e);
            }
        }
    }

    public synchronized void setThripleHeight(boolean isThripleHeight) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        try {
            thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("UsbPrinter");
        try {
            method = thermalPrinter.getMethod("setTripleHeight", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, isThripleHeight);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            this.throwException(e);
        }
    }

    public synchronized void printLogoRaw(byte[] logo, int width, int length) throws TelpoException {
        Class<?> thermalPrinter = null;
        Method method = null;
        Object obj = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal()) {
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.ThermalPrinterServiceManager");
            }
            catch (ClassNotFoundException var17) {
                var17.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("ThermalPrinter");
            try {
                method = thermalPrinter.getMethod("printLogoRaw", byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, logo, width, length, false);
            }
            catch (IllegalArgumentException var13) {
                var13.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException var14) {
                var14.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException var15) {
                this.throwException(var15);
            }
        } else {
            try {
                thermalPrinter = Class.forName("com.common.sdk.printer.UsbPrinterManager");
            }
            catch (ClassNotFoundException var12) {
                var12.printStackTrace();
                throw new InternalErrorException();
            }
            obj = this.mContext.getSystemService("UsbPrinter");
            try {
                method = thermalPrinter.getMethod("printLogoRaw", byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException var11) {
                var11.printStackTrace();
                throw new InternalErrorException();
            }
            try {
                method.invoke(obj, logo, width, length);
            }
            catch (IllegalArgumentException var8) {
                var8.printStackTrace();
                throw new InternalErrorException();
            }
            catch (IllegalAccessException var9) {
                var9.printStackTrace();
                throw new InternalErrorException();
            }
            catch (InvocationTargetException var10) {
                this.throwException(var10);
            }
        }
    }

    public synchronized void EscPosCommandExe(byte[] data) {
        block26: {
            Class<?> thermalPrinter = null;
            Method method = null;
            Object obj = null;
            Constructor<?> constructor = null;
            try {
                thermalPrinter = Class.forName("com.common.sdk.thermalprinter.escpos.EscPos");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                try {
                    throw new InternalErrorException();
                }
                catch (InternalErrorException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                constructor = thermalPrinter.getConstructor(Context.class);
            }
            catch (NoSuchMethodException e2) {
                e2.printStackTrace();
            }
            if (this.EscPos == null) {
                try {
                    this.EscPos = constructor.newInstance(this.mContext);
                }
                catch (InstantiationException e2) {
                    e2.printStackTrace();
                }
                catch (IllegalAccessException e2) {
                    e2.printStackTrace();
                }
                catch (IllegalArgumentException e2) {
                    e2.printStackTrace();
                }
                catch (InvocationTargetException e2) {
                    e2.printStackTrace();
                }
            }
            try {
                method = thermalPrinter.getMethod("EscPosCommandExe", byte[].class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                try {
                    throw new InternalErrorException();
                }
                catch (InternalErrorException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                method.invoke(this.EscPos, new Object[]{data});
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                try {
                    throw new InternalErrorException();
                }
                catch (InternalErrorException e1) {
                    e1.printStackTrace();
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                try {
                    throw new InternalErrorException();
                }
                catch (InternalErrorException e1) {
                    e1.printStackTrace();
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                Exception targetExp = (Exception)e.getTargetException();
                if (!(targetExp instanceof TelpoException)) break block26;
                try {
                    throw (TelpoException)targetExp;
                }
                catch (TelpoException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void throwException(InvocationTargetException e) throws TelpoException {
        Log.d((String)"tagg", (String)("exception:" + e.getTargetException().toString()));
        if (e.getTargetException().toString().contains("NoPaper")) {
            throw new NoPaperException();
        }
        if (e.getTargetException().toString().contains("OverHeat")) {
            throw new OverHeatException();
        }
        if (e.getTargetException().toString().contains("BlackBlock")) {
            throw new BlackBlockNotFoundException();
        }
        throw new TelpoException();
    }
}

