/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.reader;

import amlib.ccid.Reader;
import amlib.ccid.Reader4428;
import amlib.ccid.Reader4442;
import amlib.hw.HWType;
import amlib.hw.HardwareInterface;
import amlib.hw.ReaderHwException;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.collect.Collect;
import com.telpo.tps550.api.reader.ICCardReader;
import com.telpo.tps550.api.usb.UsbUtil;
import com.telpo.tps550.api.util.ShellUtils;
import com.telpo.tps550.api.util.StringUtil;
import com.telpo.tps550.api.util.SystemUtil;
import java.io.FileOutputStream;

public class CardReader {
    private static final String TAG = "TELPO_SDK";
    public static final int CARD_TYPE_UNKNOWN = -1;
    public static final int CARD_TYPE_MSC = 0;
    public static final int CARD_TYPE_ISO7816 = 1;
    public static final int CARD_TYPE_SLE4442 = 2;
    public static final int CARD_TYPE_SLE4428 = 3;
    public static final int CARD_TYPE_AT88SC153 = 4;
    public static final int SLOT_STATUS_ICC_ACTIVE = 0;
    public static final int SLOT_STATUS_ICC_INACTIVE = 1;
    public static final int SLOT_STATUS_ICC_ABSENT = 2;
    public static final int CARDREADER_HUB = 1;
    protected Context context;
    protected ICCardReader mICCardReader;
    protected int cardType = 1;
    protected boolean correct_psc_verification = false;
    protected UsbDevice usbDev;
    protected HardwareInterface myDev;
    protected UsbManager usbManager;
    protected int mSlot = 0;
    protected Reader reader = null;
    protected byte[] mATR = null;
    protected int reader_type = -1;
    Reader4442 m4442 = null;
    private PendingIntent permissionIntent;
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    private HandlerThread handlerThread;
    private Handler handler;
    private Object lock = new Object();
    String[] portNum = new String[20];
    String[] productNum = new String[20];
    String[] readerNum = new String[4];
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Log.d((String)CardReader.TAG, (String)"Broadcast Receiver");
            String action = intent.getAction();
            if (CardReader.ACTION_USB_PERMISSION.equals(action)) {
                Object object = CardReader.this.lock;
                synchronized (object) {
                    UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        if (device != null && device.equals((Object)CardReader.this.usbDev)) {
                            try {
                                if (CardReader.this.myDev.Init(CardReader.this.usbManager, CardReader.this.usbDev)) {
                                    try {
                                        if (CardReader.this.cardType == 2) {
                                            CardReader.this.reader = new Reader4442(CardReader.this.myDev);
                                            Log.d((String)"TAG", (String)("reader = new Reader4442(myDev);\ndevice name:" + CardReader.this.usbDev.getDeviceName()));
                                        } else if (CardReader.this.cardType == 3) {
                                            CardReader.this.reader = new Reader4428(CardReader.this.myDev);
                                        } else {
                                            CardReader.this.reader = new Reader(CardReader.this.myDev);
                                            CardReader.this.reader.switchMode((byte)1);
                                        }
                                        Log.d((String)"TAG", (String)("reader.open:" + CardReader.this.reader.open()));
                                        CardReader.this.reader.setSlot((byte)0);
                                    }
                                    catch (Exception e) {
                                        Log.e((String)CardReader.TAG, (String)("Get Exception : " + e.getMessage()));
                                        e.printStackTrace();
                                    }
                                }
                            }
                            catch (ReaderHwException e) {
                                e.printStackTrace();
                            }
                            CardReader.this.lock.notify();
                        }
                    } else {
                        Log.d((String)CardReader.TAG, (String)("Permission denied for device " + device.getDeviceName()));
                        CardReader.this.lock.notify();
                    }
                }
            }
            if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                Log.d((String)CardReader.TAG, (String)"Device Detached");
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                if (device != null && device.equals((Object)CardReader.this.usbDev)) {
                    if (CardReader.this.reader != null) {
                        CardReader.this.reader.close();
                    }
                    if (CardReader.this.myDev != null) {
                        CardReader.this.myDev.Close();
                    }
                }
            }
        }
    };

    static {
        if (SystemUtil.getDeviceType() != StringUtil.DeviceModelEnum.TPS900.ordinal() && SystemUtil.getDeviceType() != StringUtil.DeviceModelEnum.TPS390P.ordinal() && SystemUtil.getDeviceType() != StringUtil.DeviceModelEnum.TPS900MB.ordinal() && SystemUtil.getDeviceType() != StringUtil.DeviceModelEnum.TPS450CIC.ordinal()) {
            System.loadLibrary("card_reader");
        }
    }

    protected static native int open_device(int var0, int var1);

    protected static native int close_device();

    protected static native byte[] icc_power_on(int var0);

    protected static native int icc_power_off();

    protected static native int get_card_status();

    protected static native int switch_mode(int var0);

    protected static native byte[] read_main_mem(int var0, int var1, int var2);

    protected static native int psc_verify(int var0, byte[] var1);

    protected static native int update_main_mem(int var0, int var1, byte[] var2);

    protected static native int psc_modify(int var0, byte[] var1);

    protected static native int send_apdu(byte[] var0, byte[] var1);

    protected static native int telpo_switch_psam(int var0);

    private native int device_power(int var1);

    public CardReader() {
    }

    public CardReader(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS450CIC.ordinal()) {
            try {
                this.mICCardReader.open(this.mSlot);
                return true;
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return false;
            }
        }
        int type = SystemUtil.getICCReaderType();
        Log.d((String)"TAG", (String)("CardReader type is:" + type));
        Log.d((String)"TAG", (String)("mSlot is:" + this.mSlot));
        if (this.mSlot == 0 && (type == 2 || type == 1 || type == 0) || this.mSlot == 1 && (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS350_4G.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS350L.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS573.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS450.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS450C.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS365.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS360C.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS360IC.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS360A.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS470.ordinal()) || this.mSlot == 2 && SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS573.ordinal()) {
            Log.e((String)"TAG", (String)"AU9560_GCS-------");
            if (CardReader.open_device(this.cardType, this.mSlot) < 0) {
                Log.d((String)"TAG", (String)"open_device(cardType, mSlot) < 0");
                return false;
            }
        } else {
            if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390U.ordinal()) {
                this.device_power(1);
            }
            type = 3;
            this.usbManager = (UsbManager)this.context.getSystemService("usb");
            this.usbDev = this.getUsbDevice();
            if (this.usbDev == null) {
                Log.e((String)TAG, (String)"get usb manager failed");
                return false;
            }
            this.reader = null;
            this.myDev = new HardwareInterface(HWType.eUSB, this.context);
            this.handlerThread = new HandlerThread("card reader");
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
            this.toRegisterReceiver();
            this.usbManager.requestPermission(this.usbDev, this.permissionIntent);
            Object object = this.lock;
            synchronized (object) {
                if (this.reader == null) {
                    try {
                        this.lock.wait(30000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.context.unregisterReceiver(this.mReceiver);
            this.handlerThread.quit();
            this.handlerThread = null;
            if (this.reader == null) {
                Log.e((String)TAG, (String)"reader is null");
                this.myDev.Close();
                this.myDev = null;
                this.usbManager = null;
                this.usbDev = null;
                return false;
            }
        }
        this.reader_type = type;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(int isIC) {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS360IC.ordinal()) {
            try {
                this.mICCardReader.open(this.mSlot);
                return true;
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return false;
            }
        }
        int type = -1;
        type = isIC == 0 ? SystemUtil.getICCReaderType() : 3;
        Log.d((String)"TAG", (String)("CardReader type is:" + type));
        if (this.mSlot == 0 && (type == 2 || type == 1 || type == 0) || this.mSlot == 1 && (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS350_4G.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS350L.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS450.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS365.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS360C.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS360A.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS470.ordinal())) {
            Log.e((String)"TAG", (String)"AU9560_GCS-------");
            if (CardReader.open_device(this.cardType, this.mSlot) < 0) {
                Log.d((String)"TAG", (String)"open_device(cardType, mSlot) < 0");
                return false;
            }
        } else {
            if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390U.ordinal()) {
                this.device_power(1);
            }
            type = 3;
            this.usbManager = (UsbManager)this.context.getSystemService("usb");
            this.usbDev = this.getUsbDevice();
            if (this.usbDev == null) {
                Log.e((String)TAG, (String)"get usb manager failed");
                return false;
            }
            this.reader = null;
            this.myDev = new HardwareInterface(HWType.eUSB, this.context);
            this.handlerThread = new HandlerThread("card reader");
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
            this.toRegisterReceiver();
            this.usbManager.requestPermission(this.usbDev, this.permissionIntent);
            Object object = this.lock;
            synchronized (object) {
                if (this.reader == null) {
                    try {
                        this.lock.wait(30000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.context.unregisterReceiver(this.mReceiver);
            this.handlerThread.quit();
            this.handlerThread = null;
            if (this.reader == null) {
                Log.e((String)TAG, (String)"reader is null");
                this.myDev.Close();
                this.myDev = null;
                this.usbManager = null;
                this.usbDev = null;
                return false;
            }
        }
        this.reader_type = type;
        return true;
    }

    public UsbDevice getAT88SC153Device() {
        if (this.usbManager == null) {
            this.usbManager = (UsbManager)this.context.getSystemService("usb");
        }
        UsbDevice mUsbDev = this.getUsbDevice();
        Log.d((String)"TAG", (String)("getAT88SC153Device:pid:" + mUsbDev.getProductId() + "device name:" + mUsbDev.getDeviceName()));
        return mUsbDev;
    }

    public boolean close() {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS450CIC.ordinal()) {
            try {
                this.mICCardReader.close(this.mSlot);
                return true;
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            if (CardReader.close_device() < 0) {
                return false;
            }
        } else {
            if (this.reader != null) {
                int status;
                while ((status = this.reader.close()) == 3) {
                }
            }
            if (this.myDev != null) {
                this.myDev.Close();
            }
            if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390U.ordinal()) {
                this.device_power(0);
            }
        }
        this.reader_type = -1;
        return true;
    }

    public boolean close(int ic360) {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS360IC.ordinal()) {
            try {
                this.mICCardReader.close(this.mSlot);
                return true;
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            if (CardReader.close_device() < 0) {
                return false;
            }
        } else {
            if (this.reader != null) {
                int status;
                while ((status = this.reader.close()) == 3) {
                }
            }
            if (this.myDev != null) {
                this.myDev.Close();
            }
            if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390U.ordinal()) {
                this.device_power(0);
            }
        }
        this.reader_type = -1;
        return true;
    }

    public boolean iccPowerOn() {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS450CIC.ordinal()) {
            try {
                if (this.mICCardReader.detect(this.mSlot, 500) == 0) {
                    this.mICCardReader.power_on(this.mSlot);
                    return true;
                }
                return false;
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            Log.d((String)"TAG", (String)("reader_type:" + this.reader_type));
            this.mATR = CardReader.icc_power_on(this.cardType);
            if (this.mATR == null) {
                return false;
            }
        } else {
            Log.d((String)"TAG", (String)("reader_type:" + this.reader_type));
            byte[] status = new byte[1];
            byte[] pCardStatus = new byte[1];
            if (this.reader == null || this.reader.getCardStatus(status) != 0) {
                return false;
            }
            if (status[0] == 2) {
                return false;
            }
            int result = this.reader.setPower(1);
            if (result != 0) {
                Log.e((String)TAG, (String)("setPower failed: " + result));
                return false;
            }
        }
        if (this.mSlot == 0) {
            Collect.collectInfo(2, 1, null);
        } else {
            Collect.collectInfo(3, 1, null);
        }
        return true;
    }

    public boolean iccPowerOn(int ic360) {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS360IC.ordinal()) {
            try {
                if (this.mICCardReader.detect(this.mSlot, 500) == 0) {
                    this.mICCardReader.power_on(this.mSlot);
                    return true;
                }
                return false;
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            Log.d((String)"TAG", (String)("reader_type:" + this.reader_type));
            this.mATR = CardReader.icc_power_on(this.cardType);
            if (this.mATR == null) {
                return false;
            }
        } else {
            Log.d((String)"TAG", (String)("reader_type:" + this.reader_type));
            byte[] status = new byte[1];
            byte[] pCardStatus = new byte[1];
            if (this.reader == null || this.reader.getCardStatus(status) != 0) {
                return false;
            }
            if (status[0] == 2) {
                return false;
            }
            int result = this.reader.setPower(1);
            if (result != 0) {
                Log.e((String)TAG, (String)("setPower failed: " + result));
                return false;
            }
        }
        if (this.mSlot == 0) {
            Collect.collectInfo(2, 1, null);
        } else {
            Collect.collectInfo(3, 1, null);
        }
        return true;
    }

    public boolean iccPowerOff() {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS450CIC.ordinal()) {
            try {
                this.mICCardReader.power_off(this.mSlot);
                return true;
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            if (CardReader.icc_power_off() < 0) {
                return false;
            }
        } else {
            byte[] status = new byte[1];
            if (this.reader == null || this.reader.getCardStatus(status) != 0) {
                return false;
            }
            if (status[0] == 2) {
                return false;
            }
            if (this.reader.setPower(-1) != 0) {
                return false;
            }
        }
        this.mATR = null;
        this.correct_psc_verification = false;
        return true;
    }

    public boolean iccPowerOff(int ic360) {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS360IC.ordinal()) {
            try {
                this.mICCardReader.power_off(this.mSlot);
                return true;
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            if (CardReader.icc_power_off() < 0) {
                return false;
            }
        } else {
            byte[] status = new byte[1];
            if (this.reader == null || this.reader.getCardStatus(status) != 0) {
                return false;
            }
            if (status[0] == 2) {
                return false;
            }
            if (this.reader.setPower(-1) != 0) {
                return false;
            }
        }
        this.mATR = null;
        this.correct_psc_verification = false;
        return true;
    }

    public int getICCStatus() {
        int result = 0;
        int iccStatus = 2;
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            iccStatus = CardReader.get_card_status();
            if (iccStatus < 0) {
                iccStatus = 2;
            }
        } else {
            byte[] status = new byte[1];
            result = this.reader.getCardStatus(status);
            if (result == 0) {
                if (status[0] == 0) {
                    iccStatus = 0;
                } else if (status[0] == 1) {
                    iccStatus = 1;
                }
            }
        }
        return iccStatus;
    }

    public boolean isICCPresent() {
        int status;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS450CIC.ordinal()) {
            try {
                return this.mICCardReader.detect(this.mSlot, 500) == 0;
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return false;
            }
        }
        return this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0 ? (status = CardReader.get_card_status()) == 0 || status == 1 : this.reader.getCardStatus(status = new byte[1]) == 0 && status[0] != 2;
    }

    public boolean isICCPresent(int ic360) {
        int status;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS360IC.ordinal()) {
            try {
                return this.mICCardReader.detect(this.mSlot, 500) == 0;
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return false;
            }
        }
        return this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0 ? (status = CardReader.get_card_status()) == 0 || status == 1 : this.reader.getCardStatus(status = new byte[1]) == 0 && status[0] != 2;
    }

    public String getATRString() {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS450CIC.ordinal()) {
            try {
                return this.mICCardReader.getAtr(this.mSlot);
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            if (this.mATR == null) {
                return null;
            }
            return StringUtil.toHexString(this.mATR);
        }
        return this.reader.getAtrString();
    }

    public String getATRString(int isic360) {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390P.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS900MB.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS360IC.ordinal()) {
            try {
                return this.mICCardReader.getAtr(this.mSlot);
            }
            catch (TelpoException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            if (this.mATR == null) {
                return null;
            }
            return StringUtil.toHexString(this.mATR);
        }
        return this.reader.getAtrString();
    }

    public int getCardType() {
        String atr = this.getATRString();
        if (atr == null) {
            return -1;
        }
        String atrString = atr.replace(" ", "");
        Log.i((String)TAG, (String)("ATR: " + atrString));
        if (atrString.contains("A2131091")) {
            return 2;
        }
        if (atrString.contains("92231091")) {
            return 3;
        }
        return -1;
    }

    public boolean switchMode(int cardType) {
        return this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0 ? CardReader.switch_mode(cardType) == 0 : (cardType == 1 ? this.reader.switchMode((byte)1) == 0 : (cardType == 2 ? this.reader.switchMode((byte)4) == 0 : cardType == 3 && this.reader.switchMode((byte)3) == 0));
    }

    private UsbDevice getUsbDevice() {
        String deviceName = null;
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS510A_NHW.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS510D.ordinal()) {
            this.searchAllIndex(ShellUtils.execCommand((String)"cat /sys/kernel/debug/usb/devices", (boolean)false).successMsg, "Port=", 1);
            this.searchAllIndex(ShellUtils.execCommand((String)"cat /sys/kernel/debug/usb/devices", (boolean)false).successMsg, "Product=", 2);
            this.checkPort(this.portNum, this.productNum);
            if (this.readerNum[0] != null && this.readerNum[0].equals("05") || this.readerNum[1] != null && this.readerNum[1].equals("05") || this.readerNum[2] != null && this.readerNum[2].equals("05") || this.readerNum[3] != null && this.readerNum[3].equals("05")) {
                Log.d((String)"TAG", (String)"old usb_utils");
                deviceName = UsbUtil.getUsbDevice(this.mSlot);
            } else {
                Log.d((String)"TAG", (String)"new usb_utils");
                deviceName = UsbUtil.getUsbDevicehub(this.mSlot, 1);
            }
        } else {
            deviceName = UsbUtil.getUsbDevice(this.mSlot);
        }
        if (deviceName != null) {
            for (UsbDevice device : this.usbManager.getDeviceList().values()) {
                if (!deviceName.equals(device.getDeviceName())) continue;
                this.switchPsam();
                return device;
            }
        }
        return null;
    }

    private void searchAllIndex(String str, String key, int type) {
        int a = str.indexOf(key);
        int i = -1;
        while (a != -1) {
            ++i;
            if (type == 1) {
                this.portNum[i] = str.substring(a + 5, a + 7);
            } else if (type == 2) {
                this.productNum[i] = str.substring(a + 8, a + 11);
            }
            a = str.indexOf(key, a + 1);
        }
    }

    private void checkPort(String[] port, String[] product) {
        int k = -1;
        int i = 0;
        while (i < 20) {
            if (this.productNum[i] != null && this.productNum[i].equals("EMV")) {
                this.readerNum[++k] = this.portNum[i];
                Log.d((String)"TAG", (String)("readnum[]:" + this.readerNum[k]));
            }
            ++i;
        }
    }

    private void toRegisterReceiver() {
        this.permissionIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_USB_PERMISSION);
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        this.context.registerReceiver(this.mReceiver, filter, null, this.handler);
    }

    private void readerPoweron() {
        String[] paths = new String[]{"/sys/devices/platform/battery/GPIO30_PIN", "/sys/devices/platform/battery/GPIO31_PIN", "/sys/devices/platform/battery/GPIO142_PIN", "/sys/devices/platform/battery/GPIO145_PIN"};
        try {
            int i = 0;
            while (i < paths.length) {
                FileOutputStream fon = new FileOutputStream(paths[i]);
                fon.write(49);
                fon.flush();
                fon.close();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void readerPoweroff() {
        String[] paths = new String[]{"/sys/devices/platform/battery/GPIO30_PIN", "/sys/devices/platform/battery/GPIO31_PIN", "/sys/devices/platform/battery/GPIO142_PIN", "/sys/devices/platform/battery/GPIO145_PIN"};
        try {
            int i = 0;
            while (i < paths.length) {
                FileOutputStream fon = new FileOutputStream(paths[i]);
                fon.write(48);
                fon.flush();
                fon.close();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private int switchPsam() {
        int ret = 0;
        String path = "/sys/class/hdxio/psam_select";
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS510A.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS510A_NHW.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS510D.ordinal() || SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS450C.ordinal()) {
            if (this.mSlot == 2) {
                ret = CardReader.telpo_switch_psam(2);
            } else if (this.mSlot == 3) {
                ret = CardReader.telpo_switch_psam(3);
            }
        } else if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS613.ordinal()) {
            if (this.mSlot == 1) {
                ret = CardReader.telpo_switch_psam(1);
            } else if (this.mSlot == 2) {
                ret = CardReader.telpo_switch_psam(2);
            }
        } else if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS390U.ordinal()) {
            ret = 0;
        } else {
            try {
                FileOutputStream fon = new FileOutputStream(path);
                if (this.mSlot == 2) {
                    if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.FFP2.ordinal()) {
                        fon.write(50);
                    } else {
                        fon.write(49);
                    }
                } else if (this.mSlot == 3) {
                    fon.write(51);
                } else {
                    fon.write(49);
                }
                fon.flush();
                fon.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)("switch slot " + this.mSlot + " failed"));
                ret = -1;
            }
        }
        return ret;
    }
}

