/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.reader;

import android.content.Context;
import com.telpo.tps550.api.InternalErrorException;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.fingerprint.FingerPrint;
import com.telpo.tps550.api.util.StringUtil;
import com.telpo.tps550.api.util.SystemUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ICCardReader {
    private Context mContext = null;

    public ICCardReader(Context context) {
        this.mContext = context;
    }

    public synchronized void open(int slot) throws TelpoException {
        if (SystemUtil.getDeviceType() == StringUtil.DeviceModelEnum.TPS360IC.ordinal()) {
            FingerPrint.iccardPower(1);
        }
        Class<?> iccard = null;
        Method method = null;
        Object obj = null;
        try {
            iccard = Class.forName("com.common.sdk.iccard.ICCardServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("ICCard");
        try {
            method = iccard.getMethod("open", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, slot);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            ICCardReader.throwException(e);
        }
    }

    public synchronized void close(int slot) throws TelpoException {
        Class<?> iccard = null;
        Method method = null;
        Object obj = null;
        try {
            iccard = Class.forName("com.common.sdk.iccard.ICCardServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("ICCard");
        try {
            method = iccard.getMethod("close", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, slot);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            ICCardReader.throwException(e);
        }
    }

    public synchronized int detect(int slot, int timeout) throws TelpoException {
        Class<?> iccard = null;
        Method method = null;
        Object obj = null;
        int result = 0;
        try {
            iccard = Class.forName("com.common.sdk.iccard.ICCardServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("ICCard");
        try {
            method = iccard.getMethod("detect", Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            result = (Integer)method.invoke(obj, slot, timeout);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            ICCardReader.throwException(e);
        }
        return result;
    }

    public synchronized void power_on(int slot) throws TelpoException {
        Class<?> iccard = null;
        Method method = null;
        Object obj = null;
        try {
            iccard = Class.forName("com.common.sdk.iccard.ICCardServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("ICCard");
        try {
            method = iccard.getMethod("power_on", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, slot);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            ICCardReader.throwException(e);
        }
    }

    public synchronized String getAtr(int slot) throws TelpoException {
        Class<?> iccard = null;
        Method method = null;
        Object obj = null;
        String result = null;
        try {
            iccard = Class.forName("com.common.sdk.iccard.ICCardServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("ICCard");
        try {
            method = iccard.getMethod("get_atr", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            result = (String)method.invoke(obj, slot);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            ICCardReader.throwException(e);
        }
        return result;
    }

    public synchronized byte[] transmit(int slot, byte[] sendBuffer, int sendBufferLength) throws TelpoException {
        Class<?> iccard = null;
        Method method = null;
        Object obj = null;
        byte[] result = null;
        try {
            iccard = Class.forName("com.common.sdk.iccard.ICCardServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("ICCard");
        try {
            method = iccard.getMethod("transmit", Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            result = (byte[])method.invoke(obj, slot, sendBuffer, sendBufferLength);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            ICCardReader.throwException(e);
        }
        return result;
    }

    public synchronized void power_off(int slot) throws TelpoException {
        Class<?> iccard = null;
        Method method = null;
        Object obj = null;
        try {
            iccard = Class.forName("com.common.sdk.iccard.ICCardServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("ICCard");
        try {
            method = iccard.getMethod("power_off", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            method.invoke(obj, slot);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            ICCardReader.throwException(e);
        }
    }

    public synchronized int set_mode(int slot, int mode) throws TelpoException {
        Class<?> iccard = null;
        Method method = null;
        Object obj = null;
        int result = 0;
        try {
            iccard = Class.forName("com.common.sdk.iccard.ICCardServiceManager");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        obj = this.mContext.getSystemService("ICCard");
        try {
            method = iccard.getMethod("set_mode", Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        try {
            result = (Integer)method.invoke(obj, slot, mode);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalErrorException();
        }
        catch (InvocationTargetException e) {
            ICCardReader.throwException(e);
        }
        return result;
    }

    private static synchronized void throwException(InvocationTargetException e) throws TelpoException {
        throw new TelpoException();
    }
}

