/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.reader;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.telpo.tps550.api.magnetic.MagneticCard;
import com.telpo.tps550.api.reader.CardReader;
import com.telpo.tps550.api.reader.SLE4428Reader;
import com.telpo.tps550.api.reader.SLE4442Reader;
import com.telpo.tps550.api.reader.SmartCardReader;

public class ReaderMonitor {
    public static final String TAG = "ReaderMonitor";
    public static final String ACTION_ICC_PRESENT = "com.pos.icc.present";
    public static final String EXTRA_IS_PRESENT = "present";
    public static final String EXTRA_CARD_TYPE = "card_type";
    public static final String ACTION_MSC = "com.pos.msc";
    public static final String EXTRA_MSC_TRACK = "track_data";
    private static Object lock = new Object();
    private static CardReader reader;
    private static Context context;
    private static Thread monitorThread;
    private static Thread mscMonitorThread;
    private static int cardType;
    private static boolean openFlag;
    private static boolean poweronFlag;
    private static boolean mscFlag;
    private static boolean isStarted;
    private static boolean iccPresent;
    private static String[] mscData;
    private static int type;

    static {
        context = null;
        monitorThread = null;
        mscMonitorThread = null;
        cardType = 1;
        openFlag = false;
        poweronFlag = false;
        mscFlag = false;
        isStarted = false;
        iccPresent = false;
    }

    public static void setContext(Context c) {
        context = c;
    }

    public static synchronized void startMonitor() {
        if (context == null) {
            Log.e((String)TAG, (String)"context null");
            return;
        }
        monitorThread = new Thread(new Runnable(){
            Intent intent = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!monitorThread.isInterrupted()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return;
                    }
                    if (!openFlag) {
                        reader = new SmartCardReader(context);
                        if (!reader.open()) {
                            Log.e((String)ReaderMonitor.TAG, (String)"reader open failed");
                            continue;
                        }
                        openFlag = true;
                        reader.switchMode(1);
                    }
                    Object object = lock;
                    synchronized (object) {
                        if (iccPresent) {
                            if (!reader.isICCPresent()) {
                                iccPresent = false;
                                this.intent = new Intent();
                                this.intent.setAction(ReaderMonitor.ACTION_ICC_PRESENT);
                                this.intent.putExtra(ReaderMonitor.EXTRA_IS_PRESENT, false);
                                if (context != null) {
                                    context.sendBroadcast(this.intent);
                                }
                                poweronFlag = false;
                                reader.close();
                                openFlag = false;
                            }
                        } else if (reader.isICCPresent()) {
                            iccPresent = true;
                            this.intent = new Intent();
                            this.intent.setAction(ReaderMonitor.ACTION_ICC_PRESENT);
                            this.intent.putExtra(ReaderMonitor.EXTRA_IS_PRESENT, true);
                            if (reader.iccPowerOn()) {
                                Log.e((String)ReaderMonitor.TAG, (String)"smart card poweron success");
                                this.intent.putExtra(ReaderMonitor.EXTRA_CARD_TYPE, 1);
                                if (context != null) {
                                    context.sendBroadcast(this.intent);
                                }
                                poweronFlag = true;
                                cardType = 1;
                            } else {
                                reader.switchMode(3);
                                if (reader.iccPowerOn()) {
                                    type = reader.getCardType();
                                    this.intent.putExtra(ReaderMonitor.EXTRA_CARD_TYPE, type);
                                    if (context != null) {
                                        context.sendBroadcast(this.intent);
                                    }
                                    if (type == 3) {
                                        Log.d((String)ReaderMonitor.TAG, (String)"card type: SLE4428");
                                        cardType = 3;
                                        if (reader.close()) {
                                            openFlag = false;
                                            reader = new SLE4428Reader(context);
                                            if (reader.open()) {
                                                openFlag = true;
                                                if (reader.iccPowerOn()) {
                                                    Log.d((String)ReaderMonitor.TAG, (String)"SLE4428 poweron success");
                                                    poweronFlag = true;
                                                } else {
                                                    Log.d((String)ReaderMonitor.TAG, (String)"SLE4428 poweron failed");
                                                }
                                            }
                                        }
                                    } else if (type == 2) {
                                        Log.d((String)ReaderMonitor.TAG, (String)"card type: SLE4442");
                                        cardType = 2;
                                        if (reader.close()) {
                                            openFlag = false;
                                            reader = new SLE4442Reader(context);
                                            if (reader.open()) {
                                                openFlag = true;
                                                if (reader.iccPowerOn()) {
                                                    Log.d((String)ReaderMonitor.TAG, (String)"SLE4442 poweron success");
                                                    poweronFlag = true;
                                                } else {
                                                    Log.d((String)ReaderMonitor.TAG, (String)"SLE4442 poweron failed");
                                                }
                                            }
                                        }
                                    } else {
                                        Log.e((String)ReaderMonitor.TAG, (String)"card type unknown");
                                        cardType = -1;
                                    }
                                } else {
                                    Log.e((String)ReaderMonitor.TAG, (String)"ICC poweron failed");
                                }
                            }
                        }
                    }
                }
            }
        });
        monitorThread.start();
        isStarted = true;
    }

    public static synchronized void stopMonitor() {
        if (monitorThread != null) {
            monitorThread.interrupt();
        }
        if (mscMonitorThread != null) {
            mscMonitorThread.interrupt();
        }
        if (openFlag && reader.close()) {
            openFlag = false;
        }
        MagneticCard.close();
        mscFlag = false;
        poweronFlag = false;
        isStarted = false;
        iccPresent = false;
    }

    public static synchronized boolean isStarted() {
        return isStarted;
    }

    public static synchronized boolean isICCPresent() {
        return iccPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized byte[] readMainMemory(int addr, int num) {
        if (!openFlag) {
            Log.e((String)TAG, (String)"reader has not opened");
            return null;
        }
        Object object = lock;
        synchronized (object) {
            if (!poweronFlag) {
                if (!reader.iccPowerOn()) {
                    return null;
                }
                poweronFlag = true;
            }
            if (cardType == 2) {
                SLE4442Reader reader4442 = (SLE4442Reader)reader;
                return reader4442.readMainMemory(addr, num);
            }
            if (cardType != 3) return null;
            SLE4428Reader reader4428 = (SLE4428Reader)reader;
            return reader4428.readMainMemory(addr, num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean updateMainMemory(int addr, byte[] data) {
        if (!openFlag) {
            Log.e((String)TAG, (String)"reader has not opened");
            return false;
        }
        Object object = lock;
        synchronized (object) {
            if (cardType == 2) {
                SLE4442Reader reader4442 = (SLE4442Reader)reader;
                return reader4442.updateMainMemory(addr, data);
            }
            if (cardType == 3) {
                SLE4428Reader reader4428 = (SLE4428Reader)reader;
                return reader4428.updateMainMemory(addr, data);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean pscVerify(byte[] psc) {
        if (!openFlag) {
            Log.e((String)TAG, (String)"reader has not opened");
            return false;
        }
        Object object = lock;
        synchronized (object) {
            if (!poweronFlag) {
                if (!reader.iccPowerOn()) {
                    return false;
                }
                poweronFlag = true;
            }
            if (cardType == 2) {
                SLE4442Reader reader4442 = (SLE4442Reader)reader;
                if (reader4442.pscVerify(psc)) return true;
                Log.e((String)TAG, (String)"SLE4442 psc verification failed");
                return false;
            }
            if (cardType != 3) return true;
            SLE4428Reader reader4428 = (SLE4428Reader)reader;
            if (reader4428.pscVerify(psc)) return true;
            Log.e((String)TAG, (String)"SLE4428 psc verification failed");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void reset() {
        if (!openFlag) {
            Log.e((String)TAG, (String)"reader has not opened");
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (reader.iccPowerOff()) {
                poweronFlag = false;
            }
            if (reader.iccPowerOn()) {
                poweronFlag = true;
            }
        }
    }

    public static synchronized byte[] getUserCode() {
        if (cardType == 2 || cardType == 3) {
            return ReaderMonitor.readMainMemory(21, 6);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean pscModify(byte[] pscNew) {
        if (!openFlag) {
            Log.e((String)TAG, (String)"reader has not opened");
            return false;
        }
        Object object = lock;
        synchronized (object) {
            if (cardType == 2) {
                SLE4442Reader reader4442 = (SLE4442Reader)reader;
                return reader4442.pscModify(pscNew);
            }
            if (cardType == 3) {
                SLE4428Reader reader4428 = (SLE4428Reader)reader;
                return reader4428.pscModify(pscNew);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized byte[] transmit(byte[] apdu) {
        if (!openFlag) {
            Log.e((String)TAG, (String)"reader has not opened");
            return null;
        }
        Object object = lock;
        synchronized (object) {
            if (cardType == 1) {
                SmartCardReader smartCardReader = (SmartCardReader)reader;
                return smartCardReader.transmit(apdu);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getProtocol() {
        if (!openFlag) {
            Log.e((String)TAG, (String)"reader has not opened");
            return 2;
        }
        Object object = lock;
        synchronized (object) {
            if (cardType == 1) {
                SmartCardReader smartCardReader = (SmartCardReader)reader;
                return smartCardReader.getProtocol();
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getATRString() {
        if (!openFlag) {
            Log.e((String)TAG, (String)"reader has not opened");
            return null;
        }
        Object object = lock;
        synchronized (object) {
            return reader.getATRString();
        }
    }
}

