/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.reader;

import amlib.ccid.Reader4428;
import android.content.Context;
import android.util.Log;
import com.telpo.tps550.api.reader.CardReader;
import java.security.InvalidParameterException;
import java.util.Arrays;

public class SLE4428Reader
extends CardReader {
    private static final String TAG = "SLE4428Reader";

    public SLE4428Reader() {
        this.cardType = 3;
    }

    public SLE4428Reader(Context context) {
        this.context = context;
        this.cardType = 3;
    }

    public byte[] readMainMemory(int addr, int num) throws InvalidParameterException {
        if (addr < 0 || addr > 1023 || num < 0 || num > 1024 || addr + num > 1024) {
            Log.e((String)TAG, (String)"readMainMemory invalid parameter");
            return null;
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            return SLE4428Reader.read_main_mem(this.cardType, addr, num);
        }
        Reader4428 reader4428 = (Reader4428)this.reader;
        byte[] readData = new byte[num];
        int[] returnLen = new int[1];
        int result = 0;
        int a = addr;
        byte[] tempData = new byte[123];
        int readLen = 0;
        int cnt = num / 123;
        int left = num % 123;
        int i = 0;
        while (i < cnt) {
            result = reader4428.SLE4428Cmd_Read8Bits(a, 123, tempData, returnLen);
            if (result != 0 || returnLen[0] != 123) {
                Log.e((String)TAG, (String)("4428 read 8 bits failed: " + result));
                return null;
            }
            System.arraycopy(tempData, 0, readData, readLen, 123);
            readLen += 123;
            a += 123;
            ++i;
        }
        if (left != 0) {
            result = reader4428.SLE4428Cmd_Read8Bits(a, left, tempData, returnLen);
            if (result != 0 || returnLen[0] != left) {
                Log.e((String)TAG, (String)("4428 read 8 bits failed: " + result));
                return null;
            }
            System.arraycopy(tempData, 0, readData, readLen, left);
            readLen += left;
            a += left;
        }
        return readData;
    }

    public boolean pscVerify(byte[] psc) throws InvalidParameterException, NullPointerException {
        if (psc == null) {
            throw new NullPointerException();
        }
        if (psc.length != 2) {
            throw new InvalidParameterException();
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            if (SLE4428Reader.psc_verify(this.cardType, psc) < 0) {
                return false;
            }
        } else {
            Reader4428 reader4428 = (Reader4428)this.reader;
            int result = 0;
            int[] pIntErrorReason = new int[1];
            result = reader4428.SLE4428Cmd_VerifyPSCAndEraseErrorCounter(psc[0], psc[1], pIntErrorReason);
            if (result != 0) {
                Log.e((String)TAG, (String)("4428 verify psc and erase error counter failed: " + result));
                return false;
            }
        }
        this.correct_psc_verification = true;
        return true;
    }

    public boolean updateMainMemory(int addr, byte[] data) throws InvalidParameterException, NullPointerException {
        byte[] data_r;
        if (data == null) {
            throw new NullPointerException();
        }
        if (addr < 0 || addr > 1020 || data.length < 0 || data.length > 1021 || addr + data.length > 1021) {
            throw new InvalidParameterException();
        }
        if (!this.correct_psc_verification) {
            return false;
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            if (SLE4428Reader.update_main_mem(this.cardType, addr, data) != data.length) {
                return false;
            }
        } else {
            int i;
            Reader4428 reader4428 = (Reader4428)this.reader;
            int result = 0;
            byte[] readData = new byte[data.length];
            byte[] readPB = new byte[data.length];
            int[] returnLen = new int[1];
            result = reader4428.SLE4428Cmd_Read9Bits(addr, data.length, readData, readPB, returnLen);
            if (result == 0) {
                i = 0;
                while (i < returnLen[0]) {
                    if (readPB[i] == 0) {
                        Log.e((String)TAG, (String)"The 4428 protected data byte can not be changed");
                        return false;
                    }
                    ++i;
                }
            }
            i = 0;
            int a = addr;
            while (i < data.length) {
                result = reader4428.SLE4428Cmd_WriteEraseWithoutPB(a, data[i]);
                ++i;
                ++a;
            }
        }
        if ((data_r = this.readMainMemory(addr, data.length)) == null || !Arrays.equals(data, data_r)) {
            Log.e((String)TAG, (String)"The read data is not consistent with the writen data");
            return false;
        }
        return true;
    }

    public boolean pscModify(byte[] pscNew) throws InvalidParameterException, NullPointerException {
        if (pscNew == null) {
            throw new NullPointerException();
        }
        if (pscNew.length != 2) {
            throw new InvalidParameterException();
        }
        if (!this.correct_psc_verification) {
            return false;
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            if (SLE4428Reader.psc_modify(this.cardType, pscNew) != 0) {
                return false;
            }
        } else {
            Reader4428 reader4428 = (Reader4428)this.reader;
            int result = 0;
            int i = 0;
            int addr = 1022;
            while (i < 2) {
                result = reader4428.SLE4428Cmd_WriteEraseWithoutPB(addr, pscNew[i]);
                ++i;
                ++addr;
            }
            byte[] data_r = this.readMainMemory(1022, 2);
            if (data_r == null || !Arrays.equals(pscNew, data_r)) {
                Log.e((String)TAG, (String)"The read data is not consistent with the writen data");
                return false;
            }
        }
        return true;
    }

    public byte[] getUserCode() {
        byte[] userCode = this.readMainMemory(21, 6);
        if (userCode == null || userCode.length != 6) {
            return null;
        }
        return userCode;
    }
}

