/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.reader;

import amlib.ccid.Reader4442;
import android.content.Context;
import android.util.Log;
import com.telpo.tps550.api.reader.CardReader;
import java.security.InvalidParameterException;
import java.util.Arrays;

public class SLE4442Reader
extends CardReader {
    private static final String TAG = "SLE4442Reader";

    public SLE4442Reader() {
        this.cardType = 2;
    }

    public SLE4442Reader(Context context) {
        this.context = context;
        this.cardType = 2;
    }

    public byte[] readMainMemory(int addr, int num) {
        if (addr < 0 || addr > 255 || num < 0 || num > 256 || addr + num > 256) {
            Log.e((String)TAG, (String)"readMainMemory invalid parameter");
            return null;
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            return SLE4442Reader.read_main_mem(this.cardType, addr, num);
        }
        Reader4442 reader4442 = (Reader4442)this.reader;
        byte[] readData = new byte[num];
        int[] returnLen = new int[1];
        if (num == 256) {
            int result = reader4442.SLE4442Cmd_ReadMainMemory((byte)addr, (byte)-1, readData, returnLen);
            if (result == 0) {
                if (returnLen[0] == 255) {
                    byte[] temp = new byte[1];
                    if (reader4442.SLE4442Cmd_ReadMainMemory((byte)-1, (byte)1, temp, returnLen) == 0) {
                        readData[255] = temp[0];
                    }
                    return readData;
                }
                return Arrays.copyOf(readData, returnLen[0]);
            }
            Log.e((String)TAG, (String)("read main memory failed: " + result));
        } else {
            int result = reader4442.SLE4442Cmd_ReadMainMemory((byte)addr, (byte)num, readData, returnLen);
            if (result == 0) {
                return Arrays.copyOf(readData, returnLen[0]);
            }
            Log.e((String)TAG, (String)("read main memory failed: " + result));
        }
        return null;
    }

    public boolean updateMainMemory(int addr, byte[] data) throws InvalidParameterException, NullPointerException {
        byte[] data_r;
        if (data == null) {
            throw new NullPointerException();
        }
        if (addr < 0 || addr > 255 || data.length < 0 || data.length > 256 || addr + data.length > 256) {
            throw new InvalidParameterException();
        }
        if (!this.correct_psc_verification) {
            return false;
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            if (SLE4442Reader.update_main_mem(this.cardType, addr, data) != data.length) {
                return false;
            }
        } else {
            byte[] pm;
            Reader4442 reader4442 = (Reader4442)this.reader;
            int result = 0;
            if (addr < 32 && (pm = this.readProtectionMemory()) != null && pm.length == 4) {
                int pmInt = pm[0] & 0xFF | pm[1] << 8 & 0xFF00 | pm[2] << 16 & 0xFF0000 | pm[3] << 24 & 0xFF000000;
                int cnt = 0;
                cnt = addr + data.length > 32 ? 32 - addr : data.length;
                int a = addr;
                do {
                    if ((pmInt >> a++ & 1) != 0) continue;
                    Log.e((String)TAG, (String)"The 4442 protected data byte can not be changed");
                    return false;
                } while (--cnt > 0);
            }
            int i = 0;
            int a = addr;
            while (i < data.length) {
                result = reader4442.SLE4442Cmd_UpdateMainMemory((byte)a, data[i]);
                ++i;
                ++a;
            }
        }
        if ((data_r = this.readMainMemory(addr, data.length)) == null || !Arrays.equals(data, data_r)) {
            Log.e((String)TAG, (String)"The read data is not consistent with the writen data");
            return false;
        }
        return true;
    }

    public boolean pscVerify(byte[] psc) throws InvalidParameterException, NullPointerException {
        if (psc == null) {
            throw new NullPointerException();
        }
        if (psc.length != 3) {
            throw new InvalidParameterException();
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            if (SLE4442Reader.psc_verify(this.cardType, psc) < 0) {
                return false;
            }
        } else {
            Reader4442 reader4442 = (Reader4442)this.reader;
            byte[] readData = new byte[1];
            int[] returnLen = new int[1];
            int result = 0;
            result = reader4442.SLE4442Cmd_ReadSecurityMemory((byte)1, readData, returnLen);
            if (result != 0) {
                Log.e((String)TAG, (String)("read 4442 error counter failed: " + result));
                return false;
            }
            Log.i((String)TAG, (String)("4442 error counter: " + readData[0]));
            if ((readData[0] & 7) == 0) {
                Log.e((String)TAG, (String)"4442 error counter no free bits");
                return false;
            }
            byte error_counter = readData[0];
            int i = 0;
            while (i < 3) {
                if ((error_counter >> i & 1) == 1) {
                    result = reader4442.SLE4442Cmd_UpdateSecurityMemory((byte)0, error_counter = (byte)(error_counter & ~(1 << i)));
                    if (result == 0) break;
                    Log.e((String)TAG, (String)("4442 error counter write free bit failed: " + result));
                    return false;
                }
                ++i;
            }
            reader4442.SLE4442Cmd_CompareVerificationData((byte)1, psc[0]);
            reader4442.SLE4442Cmd_CompareVerificationData((byte)2, psc[1]);
            reader4442.SLE4442Cmd_CompareVerificationData((byte)3, psc[2]);
            reader4442.SLE4442Cmd_UpdateSecurityMemory((byte)0, (byte)-1);
            readData[0] = 0;
            reader4442.SLE4442Cmd_ReadSecurityMemory((byte)1, readData, returnLen);
            if ((readData[0] & 7) != 7) {
                Log.e((String)TAG, (String)"4442 psc verification failed");
                return false;
            }
        }
        this.correct_psc_verification = true;
        return true;
    }

    public boolean pscModify(byte[] pscNew) throws InvalidParameterException, NullPointerException {
        if (pscNew == null) {
            throw new NullPointerException();
        }
        if (pscNew.length != 3) {
            throw new InvalidParameterException();
        }
        if (!this.correct_psc_verification) {
            return false;
        }
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            if (SLE4442Reader.psc_modify(this.cardType, pscNew) != 0) {
                return false;
            }
        } else {
            Reader4442 reader4442 = (Reader4442)this.reader;
            int result = 0;
            int i = 0;
            while (i < 3) {
                result = reader4442.SLE4442Cmd_UpdateSecurityMemory((byte)(i + 1), pscNew[i]);
                if (result != 0) {
                    Log.e((String)TAG, (String)("4442 update psc failed: " + result));
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public byte[] readProtectionMemory() {
        if (this.reader_type == 2 || this.reader_type == 1 || this.reader_type == 0) {
            return null;
        }
        Reader4442 reader4442 = (Reader4442)this.reader;
        byte[] readData = new byte[4];
        int[] returnLen = new int[1];
        int result = reader4442.SLE4442Cmd_ReadProtectionMemory((byte)4, readData, returnLen);
        if (result != 0) {
            Log.e((String)TAG, (String)("4442 read protection memory failed: " + result));
            return null;
        }
        return Arrays.copyOf(readData, returnLen[0]);
    }

    public byte[] getUserCode() {
        byte[] userCode = this.readMainMemory(21, 6);
        if (userCode == null || userCode.length != 6) {
            return null;
        }
        return userCode;
    }
}

