/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.typea;

import android.util.Log;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.TimeoutException;
import com.telpo.tps550.api.typea.TAInfo;
import com.telpo.tps550.api.typea.TASectorInfo;
import com.telpo.tps550.api.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class SerialTypeACard {
    private static final String TAG = "TELPO_SDK";
    private static final byte[] TSAM_HEADER = new byte[]{-86, -86, -86, -106, 105};
    private byte[] Password;
    private byte[] tbuffer = new byte[20];
    private byte[] Newwritedata;
    private byte[] Block;
    private int block_;
    private int section_;
    private OutputStream mOutputStream;
    private Boolean writeright = false;
    private byte[] test;
    private byte[] currect;

    public SerialTypeACard(OutputStream mOutputStream) throws TelpoException {
        byte[] byArray = new byte[28];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 10;
        byArray[7] = 5;
        byArray[9] = -112;
        byArray[10] = -80;
        byArray[11] = 13;
        byArray[12] = 56;
        byArray[13] = 30;
        byArray[16] = 4;
        byArray[17] = -86;
        byArray[18] = -86;
        byArray[19] = -86;
        byArray[20] = -106;
        byArray[21] = 105;
        byArray[23] = 3;
        byArray[24] = 11;
        byArray[26] = -112;
        byArray[27] = -104;
        this.test = byArray;
        byte[] byArray2 = new byte[11];
        byArray2[0] = -86;
        byArray2[1] = -86;
        byArray2[2] = -86;
        byArray2[3] = -106;
        byArray2[4] = 105;
        byArray2[6] = 3;
        byArray2[7] = 11;
        byArray2[9] = -112;
        byArray2[10] = -104;
        this.currect = byArray2;
        this.mOutputStream = mOutputStream;
    }

    public void transmitBlock(byte[] Block) throws TelpoException {
        this.Block = Block;
    }

    public void transmittbuffer(byte[] tbuffer) throws TelpoException {
        this.tbuffer = tbuffer;
    }

    public void transmitpassword(byte[] Password) throws TelpoException {
        this.Password = Password;
    }

    public void transmitNewwritedata(byte[] Newwritedata) throws TelpoException {
        this.Newwritedata = Newwritedata;
    }

    public void checkTACard() throws TelpoException {
        byte[] byArray = new byte[11];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 4;
        byArray[7] = -128;
        byArray[8] = 5;
        byArray[9] = 16;
        byArray[10] = -111;
        byte[] cmd_read_uid = byArray;
        int i = 0;
        while (i < cmd_read_uid.length) {
            try {
                if (this.mOutputStream != null) {
                    this.mOutputStream.write(cmd_read_uid[i]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public TAInfo requestTACard() throws TelpoException {
        byte[] byArray = new byte[3];
        byArray[0] = 5;
        byArray[2] = -112;
        byte[] sw = byArray;
        TAInfo tinfo = null;
        boolean isReadCard = true;
        int s = 0;
        while (s < TSAM_HEADER.length) {
            if (this.tbuffer[s] != TSAM_HEADER[s]) {
                isReadCard = false;
                return null;
            }
            ++s;
        }
        int k = 0;
        while (k < sw.length) {
            if (this.tbuffer[k + TSAM_HEADER.length + 2] != sw[k]) {
                isReadCard = false;
                return null;
            }
            ++k;
        }
        if (isReadCard) {
            byte[] uid2 = Arrays.copyOfRange(this.tbuffer, TSAM_HEADER.length + 5, TSAM_HEADER.length + 9);
            String newuid2 = new String();
            newuid2 = SerialTypeACard.decodetcarduid(uid2);
            Log.e((String)"newuid2", (String)newuid2);
            tinfo = new TAInfo();
            tinfo.setNum(newuid2);
            return tinfo;
        }
        return null;
    }

    public TAInfo checkTACard(int timeout) throws TelpoException {
        TAInfo taInfo = null;
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        byte[] byArray = new byte[11];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 4;
        byArray[7] = -128;
        byArray[8] = 5;
        byArray[9] = 16;
        byArray[10] = -111;
        byte[] cmd_read_uid = byArray;
        while (taInfo == null && endTime - startTime < (long)timeout) {
            int i = 0;
            while (i < cmd_read_uid.length) {
                try {
                    this.mOutputStream.write(cmd_read_uid[i]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            try {
                taInfo = this.requestTACard();
            }
            catch (TelpoException e) {
                e.printStackTrace();
            }
            endTime = System.currentTimeMillis();
        }
        if (taInfo == null) {
            throw new TimeoutException();
        }
        return taInfo;
    }

    private static String decodetcarduid(byte[] uid) {
        StringBuilder ret = new StringBuilder("");
        int i = 0;
        while (i < uid.length) {
            int v = uid[i] & 0xFF;
            String hex = Integer.toHexString(v);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            ret.append(hex);
            ++i;
        }
        return ret.toString();
    }

    public void checkPW() throws TelpoException {
        byte[] cmd_pwcheck = new byte[17];
        byte[] byArray = new byte[10];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 16;
        byArray[7] = -128;
        byArray[8] = 11;
        byArray[9] = 1;
        System.arraycopy(byArray, 0, cmd_pwcheck, 0, 10);
        int i = 0;
        while (i < this.Password.length) {
            cmd_pwcheck[10 + i] = this.Password[i];
            ++i;
        }
        int check_sum = cmd_pwcheck.length - 1;
        cmd_pwcheck[check_sum] = -102;
        Log.d((String)"TAG", (String)("Block:" + StringUtil.toHexString(this.Block)));
        String blockNum = StringUtil.toHexString(this.Block);
        if (blockNum.substring(0, 1).equals("0")) {
            blockNum = blockNum.substring(1, 2);
        }
        this.block_ = Integer.valueOf(blockNum) / 4;
        this.section_ = Integer.valueOf(blockNum) % 4;
        String xorString = null;
        xorString = this.block_ < 10 || Integer.toHexString(this.block_).length() < 2 ? "0010800B0" + Integer.toHexString(this.block_).toUpperCase() + StringUtil.toHexString(this.Password) : "0010800B" + Integer.toHexString(this.block_).toUpperCase() + StringUtil.toHexString(this.Password);
        byte xorByte = SerialTypeACard.getXor(SerialTypeACard.hexStringToBytes(xorString));
        byte[] psw_check_block_temp = Integer.toHexString(this.block_).length() < 2 ? SerialTypeACard.hexStringToBytes("0" + Integer.toHexString(this.block_)) : SerialTypeACard.hexStringToBytes(Integer.toHexString(this.block_));
        byte psw_check_block = psw_check_block_temp[0];
        Log.d((String)"TAG", (String)("psw_check_block:" + StringUtil.toHexString(new byte[]{psw_check_block})));
        byte[] byArray2 = new byte[17];
        byArray2[0] = -86;
        byArray2[1] = -86;
        byArray2[2] = -86;
        byArray2[3] = -106;
        byArray2[4] = 105;
        byArray2[6] = 16;
        byArray2[7] = -128;
        byArray2[8] = 11;
        byArray2[9] = psw_check_block;
        byArray2[10] = this.Password[0];
        byArray2[11] = this.Password[1];
        byArray2[12] = this.Password[2];
        byArray2[13] = this.Password[3];
        byArray2[14] = this.Password[4];
        byArray2[15] = this.Password[5];
        byArray2[16] = xorByte;
        cmd_pwcheck = byArray2;
        Log.d((String)"TAG", (String)("cmd_pwcheck:" + StringUtil.toHexString(cmd_pwcheck)));
        int i2 = 0;
        while (i2 < cmd_pwcheck.length) {
            try {
                this.mOutputStream.write(cmd_pwcheck[i2]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i2;
        }
        Log.e((String)"checkPW", (String)"success");
    }

    private boolean isSame() {
        Log.e((String)"TAG", (String)("tbuffer is" + StringUtil.toHexString(this.tbuffer)));
        int i = 17;
        while (i < 28) {
            if (this.tbuffer[i] != this.test[i]) {
                Log.d((String)"TAG", (String)"isSame false");
                return false;
            }
            ++i;
        }
        return true;
    }

    public Boolean requestpw() {
        Log.e((String)"TAG", (String)"before isSame");
        if (this.isSame()) {
            Log.d((String)"TAG", (String)"isSame true");
            this.tbuffer = new byte[512];
            int i = 0;
            while (i < this.currect.length) {
                this.tbuffer[i] = this.currect[i];
                ++i;
            }
        }
        byte[] byArray = new byte[3];
        byArray[0] = 11;
        byArray[2] = -112;
        byte[] sw = byArray;
        int s = 0;
        while (s < TSAM_HEADER.length) {
            if (this.tbuffer[s] != TSAM_HEADER[s]) {
                Log.d((String)"TAG", (String)"false1");
                return false;
            }
            ++s;
        }
        int k = 0;
        while (k < sw.length) {
            if (this.tbuffer[k + TSAM_HEADER.length + 2] != sw[k]) {
                Log.d((String)"TAG", (String)"false2");
                return false;
            }
            ++k;
        }
        return true;
    }

    public void readData() throws TelpoException {
        byte[] byArray = new byte[13];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 6;
        byArray[7] = -128;
        byArray[8] = 13;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[11] = 16;
        byArray[12] = -101;
        byte[] cmd_read_data = byArray;
        String xorString = null;
        xorString = this.block_ < 10 || Integer.toHexString(this.block_).length() < 2 ? "0006800D0" + Integer.toHexString(this.block_).toUpperCase() + "0" + this.section_ + "10" : "0006800D" + Integer.toHexString(this.block_).toUpperCase() + "0" + this.section_ + "10";
        byte xorByte = SerialTypeACard.getXor(SerialTypeACard.hexStringToBytes(xorString));
        byte[] read_data_block_temp = Integer.toHexString(this.block_).length() < 2 ? SerialTypeACard.hexStringToBytes("0" + Integer.toHexString(this.block_)) : SerialTypeACard.hexStringToBytes(Integer.toHexString(this.block_));
        byte[] read_data_section_temp = SerialTypeACard.hexStringToBytes("0" + Integer.toHexString(this.section_));
        byte psw_check_block = read_data_block_temp[0];
        byte psw_check_section = read_data_section_temp[0];
        byte[] byArray2 = new byte[13];
        byArray2[0] = -86;
        byArray2[1] = -86;
        byArray2[2] = -86;
        byArray2[3] = -106;
        byArray2[4] = 105;
        byArray2[6] = 6;
        byArray2[7] = -128;
        byArray2[8] = 13;
        byArray2[9] = psw_check_block;
        byArray2[10] = psw_check_section;
        byArray2[11] = 16;
        byArray2[12] = xorByte;
        cmd_read_data = byArray2;
        int i = 0;
        while (i < cmd_read_data.length) {
            try {
                this.mOutputStream.write(cmd_read_data[i]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public TASectorInfo requestData() {
        byte[] byArray = new byte[3];
        byArray[0] = 13;
        byArray[2] = -112;
        byte[] sw = byArray;
        Boolean requestsuccess = true;
        int s = 0;
        while (s < TSAM_HEADER.length) {
            if (this.tbuffer[s] != TSAM_HEADER[s]) {
                Object tsectorinfo = null;
                requestsuccess = false;
                return null;
            }
            ++s;
        }
        int k = 0;
        while (k < sw.length) {
            if (this.tbuffer[k + TSAM_HEADER.length + 2] != sw[k]) {
                Object tsectorinfo = null;
                requestsuccess = false;
                return null;
            }
            ++k;
        }
        if (requestsuccess.booleanValue()) {
            byte[] data = new byte[]{};
            data = Arrays.copyOfRange(this.tbuffer, TSAM_HEADER.length + 5, TSAM_HEADER.length + 21);
            String newdata = new String();
            newdata = SerialTypeACard.decodetcarduid(data);
            Log.e((String)"requestData", (String)newdata);
            TASectorInfo tsectorinfo = new TASectorInfo();
            tsectorinfo.setSectorData(newdata);
            return tsectorinfo;
        }
        return null;
    }

    public Boolean writeInData() throws TelpoException {
        byte[] cmd_write_data = new byte[29];
        byte[] byArray = new byte[12];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 22;
        byArray[7] = -128;
        byArray[8] = 14;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[11] = 16;
        System.arraycopy(byArray, 0, cmd_write_data, 0, 12);
        if (this.Newwritedata == null) {
            this.writeright = false;
            return this.writeright;
        }
        if (this.Newwritedata != null) {
            int i = 0;
            while (i < this.Newwritedata.length) {
                cmd_write_data[12 + i] = this.Newwritedata[i];
                ++i;
            }
            if (this.Newwritedata.length < 16) {
                int repairzero = 16 - this.Newwritedata.length;
                int d = 0;
                while (d < repairzero) {
                    cmd_write_data[12 + this.Newwritedata.length + d] = 0;
                    ++d;
                }
            }
            byte[] cmd_checksum = new byte[23];
            byte[] byArray2 = new byte[7];
            byArray2[1] = 22;
            byArray2[2] = -128;
            byArray2[3] = 14;
            byArray2[4] = 1;
            byArray2[5] = 1;
            byArray2[6] = 16;
            System.arraycopy(byArray2, 0, cmd_checksum, 0, 7);
            int i2 = 0;
            while (i2 < this.Newwritedata.length) {
                cmd_checksum[7 + i2] = this.Newwritedata[i2];
                ++i2;
            }
            int check_sum = cmd_write_data.length - 1;
            cmd_write_data[check_sum] = this.crc(cmd_checksum);
            int l = 0;
            while (l < cmd_write_data.length) {
                try {
                    this.mOutputStream.write(cmd_write_data[l]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++l;
            }
            this.writeright = true;
            return this.writeright;
        }
        return null;
    }

    public Boolean requestwrite() {
        byte[] byArray = new byte[3];
        byArray[0] = 14;
        byArray[2] = -112;
        byte[] sw = byArray;
        int s = 0;
        while (s < TSAM_HEADER.length) {
            if (this.tbuffer[s] != TSAM_HEADER[s]) {
                return false;
            }
            ++s;
        }
        int k = 0;
        while (k < sw.length) {
            if (this.tbuffer[k + TSAM_HEADER.length + 2] != sw[k]) {
                return false;
            }
            ++k;
        }
        return true;
    }

    private byte crc(byte[] data) {
        byte crc = 0;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            crc = (byte)(crc ^ b);
            ++n2;
        }
        return crc;
    }

    private static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase().replace(" ", "");
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(SerialTypeACard.charToByte(hexChars[pos]) << 4 | SerialTypeACard.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
            ++i;
        }
        return stringBuilder.toString();
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    private static byte getXor(byte[] datas) {
        byte temp = datas[0];
        int i = 1;
        while (i < datas.length) {
            temp = (byte)(temp ^ datas[i]);
            ++i;
        }
        return temp;
    }
}

