/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.typea;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.telpo.tps550.api.TelpoException;
import com.telpo.tps550.api.typea.TAInfo;
import com.telpo.tps550.api.typea.TASectorInfo;
import com.telpo.tps550.api.util.StringUtil;
import java.util.Arrays;

public class UsbTypeA {
    private static final String TAG = "TELPO_SDK";
    private UsbManager tUsbManager;
    private UsbDevice tcard_reader;
    private static final byte[] TSAM_HEADER = new byte[]{-86, -86, -86, -106, 105};
    private byte[] Password;
    private byte[] Newwritedata;
    private byte[] Block;
    private int block_;
    private int section_;

    public UsbTypeA(UsbManager manager, UsbDevice device) throws TelpoException {
        this.tUsbManager = manager;
        this.tcard_reader = device;
    }

    public TAInfo checkTACard() throws TelpoException {
        byte[] byArray = new byte[11];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 4;
        byArray[7] = -128;
        byArray[8] = 5;
        byArray[9] = 16;
        byArray[10] = -111;
        byte[] cmd_read_uid = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[0] = 5;
        byArray2[2] = -112;
        byte[] uid = this.requestUid(cmd_read_uid, byArray2);
        if (uid == null) {
            return null;
        }
        String newuid = UsbTypeA.decodetcarduid(uid);
        TAInfo tinfo = new TAInfo();
        tinfo.setNum(newuid);
        return tinfo;
    }

    private byte[] requestUid(byte[] tcmd, byte[] sw) {
        if (this.tcard_reader != null && sw.length == 3) {
            UsbInterface tInterface = this.tcard_reader.getInterface(0);
            UsbEndpoint iEndpoint = tInterface.getEndpoint(0);
            UsbEndpoint oEndpoint = tInterface.getEndpoint(1);
            UsbDeviceConnection tconnection = this.tUsbManager.openDevice(this.tcard_reader);
            tconnection.claimInterface(tInterface, true);
            int output = tconnection.bulkTransfer(oEndpoint, tcmd, tcmd.length, 3000);
            byte[] rec = new byte[1024];
            int input = tconnection.bulkTransfer(iEndpoint, rec, rec.length, 3000);
            int i = 0;
            while (i < TSAM_HEADER.length) {
                if (rec[i] != TSAM_HEADER[i]) {
                    tconnection.close();
                    return null;
                }
                ++i;
            }
            i = 0;
            while (i < sw.length) {
                if (rec[i + TSAM_HEADER.length + 2] != sw[i]) {
                    tconnection.close();
                    return null;
                }
                ++i;
            }
            tconnection.close();
            return Arrays.copyOfRange(rec, TSAM_HEADER.length + 5, TSAM_HEADER.length + 9);
        }
        return null;
    }

    private static String decodetcarduid(byte[] uid) {
        StringBuilder ret = new StringBuilder("");
        int i = 0;
        while (i < uid.length) {
            int v = uid[i] & 0xFF;
            String hex = Integer.toHexString(v);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            ret.append(hex);
            ++i;
        }
        return ret.toString();
    }

    public void transmitpassword(byte[] pwd) {
        this.Password = pwd;
    }

    public void transmitblock(byte[] blk) {
        this.Block = blk;
    }

    public Boolean checkPW() throws TelpoException {
        Boolean pwfeeback = false;
        byte[] cmd_pwcheck = new byte[17];
        byte[] byArray = new byte[9];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 10;
        byArray[7] = -128;
        byArray[8] = 11;
        System.arraycopy(byArray, 0, cmd_pwcheck, 0, 9);
        cmd_pwcheck[9] = this.Block[0];
        int i = 0;
        while (i < this.Password.length) {
            cmd_pwcheck[10 + i] = this.Password[i];
            ++i;
        }
        byte[] cmd_checksum = new byte[11];
        byte[] byArray2 = new byte[4];
        byArray2[1] = 10;
        byArray2[2] = -128;
        byArray2[3] = 11;
        System.arraycopy(byArray2, 0, cmd_checksum, 0, 4);
        if (this.Block != null) {
            cmd_checksum[4] = this.Block[0];
        }
        int i2 = 0;
        while (i2 < this.Password.length) {
            cmd_checksum[5 + i2] = this.Password[i2];
            ++i2;
        }
        int check_sum = cmd_pwcheck.length - 1;
        cmd_pwcheck[check_sum] = this.crc(cmd_checksum);
        String blockNum = StringUtil.toHexString(this.Block);
        if (blockNum.substring(0, 1).equals("0")) {
            blockNum = blockNum.substring(1, 2);
        }
        this.block_ = Integer.valueOf(blockNum) / 4;
        this.section_ = Integer.valueOf(blockNum) % 4;
        String xorString = null;
        xorString = this.block_ < 10 || Integer.toHexString(this.block_).length() < 2 ? "0010800B0" + Integer.toHexString(this.block_).toUpperCase() + StringUtil.toHexString(this.Password) : "0010800B" + Integer.toHexString(this.block_).toUpperCase() + StringUtil.toHexString(this.Password);
        byte xorByte = UsbTypeA.getXor(UsbTypeA.hexStringToBytes(xorString));
        byte[] psw_check_block_temp = Integer.toHexString(this.block_).length() < 2 ? UsbTypeA.hexStringToBytes("0" + Integer.toHexString(this.block_)) : UsbTypeA.hexStringToBytes(Integer.toHexString(this.block_));
        byte psw_check_block = psw_check_block_temp[0];
        byte[] byArray3 = new byte[17];
        byArray3[0] = -86;
        byArray3[1] = -86;
        byArray3[2] = -86;
        byArray3[3] = -106;
        byArray3[4] = 105;
        byArray3[6] = 16;
        byArray3[7] = -128;
        byArray3[8] = 11;
        byArray3[9] = psw_check_block;
        byArray3[10] = this.Password[0];
        byArray3[11] = this.Password[1];
        byArray3[12] = this.Password[2];
        byArray3[13] = this.Password[3];
        byArray3[14] = this.Password[4];
        byArray3[15] = this.Password[5];
        byArray3[16] = xorByte;
        cmd_pwcheck = byArray3;
        byte[] byArray4 = new byte[3];
        byArray4[0] = 11;
        byArray4[2] = -112;
        pwfeeback = this.requestpw(cmd_pwcheck, byArray4);
        return pwfeeback;
    }

    private Boolean requestpw(byte[] pcmd, byte[] psw) {
        if (this.tcard_reader != null && psw.length == 3) {
            UsbInterface pInterface = this.tcard_reader.getInterface(0);
            UsbEndpoint iEndpoint = pInterface.getEndpoint(0);
            UsbEndpoint oEndpoint = pInterface.getEndpoint(1);
            UsbDeviceConnection pconnection = this.tUsbManager.openDevice(this.tcard_reader);
            pconnection.claimInterface(pInterface, true);
            int output = pconnection.bulkTransfer(oEndpoint, pcmd, pcmd.length, 3000);
            byte[] prec = new byte[1024];
            int input = pconnection.bulkTransfer(iEndpoint, prec, prec.length, 3000);
            int i = 0;
            while (i < 30) {
                Log.e((String)"pwcheck", (String)("" + prec[i]));
                ++i;
            }
            i = 0;
            while (i < TSAM_HEADER.length) {
                if (prec[i] != TSAM_HEADER[i]) {
                    pconnection.close();
                    return null;
                }
                ++i;
            }
            i = 0;
            while (i < psw.length) {
                if (prec[i + TSAM_HEADER.length + 2] != psw[i]) {
                    pconnection.close();
                    return false;
                }
                ++i;
            }
            pconnection.close();
            return true;
        }
        return null;
    }

    public TASectorInfo readData() throws TelpoException {
        byte[] cmd_read_data = new byte[13];
        byte[] byArray = new byte[9];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 6;
        byArray[7] = -128;
        byArray[8] = 13;
        System.arraycopy(byArray, 0, cmd_read_data, 0, 9);
        cmd_read_data[9] = this.Block[0];
        cmd_read_data[10] = 16;
        byte[] cmd_checksum = new byte[7];
        byte[] byArray2 = new byte[4];
        byArray2[1] = 6;
        byArray2[2] = -128;
        byArray2[3] = 13;
        System.arraycopy(byArray2, 0, cmd_checksum, 0, 4);
        cmd_checksum[4] = this.Block[0];
        cmd_checksum[5] = 16;
        int check_sum = cmd_read_data.length - 1;
        cmd_read_data[check_sum] = this.crc(cmd_checksum);
        String xorString = null;
        xorString = this.block_ < 10 || Integer.toHexString(this.block_).length() < 2 ? "0006800D0" + Integer.toHexString(this.block_).toUpperCase() + "0" + this.section_ + "10" : "0006800D" + Integer.toHexString(this.block_).toUpperCase() + "0" + this.section_ + "10";
        byte xorByte = UsbTypeA.getXor(UsbTypeA.hexStringToBytes(xorString));
        byte[] read_data_block_temp = Integer.toHexString(this.block_).length() < 2 ? UsbTypeA.hexStringToBytes("0" + Integer.toHexString(this.block_)) : UsbTypeA.hexStringToBytes(Integer.toHexString(this.block_));
        byte[] read_data_section_temp = UsbTypeA.hexStringToBytes("0" + Integer.toHexString(this.section_));
        byte psw_check_block = read_data_block_temp[0];
        byte psw_check_section = read_data_section_temp[0];
        byte[] byArray3 = new byte[13];
        byArray3[0] = -86;
        byArray3[1] = -86;
        byArray3[2] = -86;
        byArray3[3] = -106;
        byArray3[4] = 105;
        byArray3[6] = 6;
        byArray3[7] = -128;
        byArray3[8] = 13;
        byArray3[9] = psw_check_block;
        byArray3[10] = psw_check_section;
        byArray3[11] = 16;
        byArray3[12] = xorByte;
        cmd_read_data = byArray3;
        byte[] byArray4 = new byte[3];
        byArray4[0] = 13;
        byArray4[2] = -112;
        byte[] data = this.requestData(cmd_read_data, byArray4);
        if (data == null) {
            TASectorInfo tsectorinfo = null;
            return tsectorinfo;
        }
        String newdata = UsbTypeA.decodetcarduid(data);
        TASectorInfo tsectorinfo = new TASectorInfo();
        tsectorinfo.setSectorData(newdata);
        return tsectorinfo;
    }

    public void sendAPDU(byte[] dcmd, byte[] dsw) {
        this.requestData(dcmd, dsw);
    }

    private byte[] requestData(byte[] dcmd, byte[] dsw) {
        if (this.tcard_reader != null && dsw.length == 3) {
            UsbInterface dInterface = this.tcard_reader.getInterface(0);
            UsbEndpoint iEndpoint = dInterface.getEndpoint(0);
            UsbEndpoint oEndpoint = dInterface.getEndpoint(1);
            UsbDeviceConnection dconnection = this.tUsbManager.openDevice(this.tcard_reader);
            dconnection.claimInterface(dInterface, true);
            int output = dconnection.bulkTransfer(oEndpoint, dcmd, dcmd.length, 3000);
            Log.d((String)"TAG", (String)("out:" + StringUtil.toHexString(dcmd)));
            byte[] drec = new byte[1024];
            int input = dconnection.bulkTransfer(iEndpoint, drec, drec.length, 3000);
            Log.d((String)"TAG", (String)("in size:" + input));
            Log.d((String)"TAG", (String)("in:" + StringUtil.toHexString(Arrays.copyOfRange(drec, 0, input - 1))));
            int i = 0;
            while (i < TSAM_HEADER.length) {
                if (drec[i] != TSAM_HEADER[i]) {
                    dconnection.close();
                    return null;
                }
                ++i;
            }
            i = 0;
            while (i < dsw.length) {
                if (drec[i + TSAM_HEADER.length + 2] != dsw[i]) {
                    dconnection.close();
                    return null;
                }
                ++i;
            }
            dconnection.close();
            return Arrays.copyOfRange(drec, TSAM_HEADER.length + 5, TSAM_HEADER.length + 21);
        }
        return null;
    }

    public void transmitdata(byte[] data) {
        this.Newwritedata = data;
    }

    public Boolean writeInData(String newwritedata) {
        byte[] Newwritedata = UsbTypeA.hexStringToBytes(newwritedata);
        byte[] cmd_write_data = new byte[29];
        byte[] byArray = new byte[12];
        byArray[0] = -86;
        byArray[1] = -86;
        byArray[2] = -86;
        byArray[3] = -106;
        byArray[4] = 105;
        byArray[6] = 22;
        byArray[7] = -128;
        byArray[8] = 14;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[11] = 16;
        System.arraycopy(byArray, 0, cmd_write_data, 0, 12);
        Boolean writefeeback = false;
        if (Newwritedata == null) {
            writefeeback = false;
            return writefeeback;
        }
        if (Newwritedata != null) {
            int i = 0;
            while (i < Newwritedata.length) {
                cmd_write_data[12 + i] = Newwritedata[i];
                ++i;
            }
            if (Newwritedata.length < 16) {
                int repairzero = 16 - Newwritedata.length;
                int d = 0;
                while (d < repairzero) {
                    cmd_write_data[12 + Newwritedata.length + d] = 0;
                    ++d;
                }
            }
            byte[] cmd_checksum = new byte[23];
            byte[] byArray2 = new byte[7];
            byArray2[1] = 22;
            byArray2[2] = -128;
            byArray2[3] = 14;
            byArray2[4] = 1;
            byArray2[5] = 1;
            byArray2[6] = 16;
            System.arraycopy(byArray2, 0, cmd_checksum, 0, 7);
            int i2 = 0;
            while (i2 < Newwritedata.length) {
                cmd_checksum[7 + i2] = Newwritedata[i2];
                ++i2;
            }
            int check_sum = cmd_write_data.length - 1;
            cmd_write_data[check_sum] = this.crc(cmd_checksum);
            String xorString = null;
            String write_data = StringUtil.toHexString(Newwritedata);
            byte[] read_data_block_temp = Integer.toHexString(this.block_).length() < 2 ? UsbTypeA.hexStringToBytes("0" + Integer.toHexString(this.block_)) : UsbTypeA.hexStringToBytes(Integer.toHexString(this.block_));
            byte[] read_data_section_temp = UsbTypeA.hexStringToBytes("0" + Integer.toHexString(this.section_));
            byte psw_check_block = read_data_block_temp[0];
            byte psw_check_section = read_data_section_temp[0];
            int write_data_length = write_data.length();
            int len = 6 + write_data_length / 2;
            int len_data = write_data_length / 2;
            byte[] LEN = Integer.toHexString(len).length() < 2 ? UsbTypeA.hexStringToBytes("0" + Integer.toHexString(len)) : UsbTypeA.hexStringToBytes(Integer.toHexString(len));
            byte[] LEN_DATA = Integer.toHexString(len_data).length() < 2 ? UsbTypeA.hexStringToBytes("0" + Integer.toHexString(len_data)) : UsbTypeA.hexStringToBytes(Integer.toHexString(len_data));
            xorString = this.block_ < 10 || Integer.toHexString(this.block_).length() < 2 ? (Integer.toHexString(len).length() < 2 ? "00" + StringUtil.toHexString(LEN) + "800E" + "0" + Integer.toHexString(this.block_).toUpperCase() + "0" + this.section_ + "0" + Integer.toHexString(len_data) + write_data : "00" + StringUtil.toHexString(LEN) + "800E" + "0" + Integer.toHexString(this.block_).toUpperCase() + "0" + this.section_ + Integer.toHexString(len_data) + write_data) : (Integer.toHexString(len).length() < 2 ? "00" + StringUtil.toHexString(LEN) + "800E" + Integer.toHexString(this.block_).toUpperCase() + "0" + this.section_ + "0" + Integer.toHexString(len_data) + write_data : "00" + StringUtil.toHexString(LEN) + "800E" + Integer.toHexString(this.block_).toUpperCase() + "0" + this.section_ + Integer.toHexString(len_data) + write_data);
            byte xorByte = UsbTypeA.getXor(UsbTypeA.hexStringToBytes(xorString));
            cmd_write_data = new byte[13 + len_data];
            cmd_write_data[0] = -86;
            cmd_write_data[1] = -86;
            cmd_write_data[2] = -86;
            cmd_write_data[3] = -106;
            cmd_write_data[4] = 105;
            cmd_write_data[5] = 0;
            cmd_write_data[6] = LEN[0];
            cmd_write_data[7] = -128;
            cmd_write_data[8] = 14;
            cmd_write_data[9] = psw_check_block;
            cmd_write_data[10] = psw_check_section;
            cmd_write_data[11] = LEN_DATA[0];
            cmd_write_data[cmd_write_data.length - 1] = xorByte;
            int i3 = 0;
            while (i3 < Newwritedata.length) {
                cmd_write_data[12 + i3] = Newwritedata[i3];
                ++i3;
            }
            byte[] byArray3 = new byte[3];
            byArray3[0] = 14;
            byArray3[2] = -112;
            writefeeback = this.requestwrite(cmd_write_data, byArray3);
            return writefeeback;
        }
        return writefeeback;
    }

    private Boolean requestwrite(byte[] wcmd, byte[] wsw) {
        if (this.tcard_reader != null && wsw.length == 3) {
            UsbInterface wInterface = this.tcard_reader.getInterface(0);
            UsbEndpoint iEndpoint = wInterface.getEndpoint(0);
            UsbEndpoint oEndpoint = wInterface.getEndpoint(1);
            UsbDeviceConnection wconnection = this.tUsbManager.openDevice(this.tcard_reader);
            wconnection.claimInterface(wInterface, true);
            int output = wconnection.bulkTransfer(oEndpoint, wcmd, wcmd.length, 3000);
            byte[] wrec = new byte[1024];
            int input = wconnection.bulkTransfer(iEndpoint, wrec, wrec.length, 3000);
            int i = 0;
            while (i < TSAM_HEADER.length) {
                if (wrec[i] != TSAM_HEADER[i]) {
                    wconnection.close();
                    return null;
                }
                ++i;
            }
            i = 0;
            while (i < wsw.length) {
                if (wrec[i + TSAM_HEADER.length + 2] != wsw[i]) {
                    wconnection.close();
                    return false;
                }
                ++i;
            }
            wconnection.close();
            return true;
        }
        return null;
    }

    private byte crc(byte[] data) {
        byte crc = 0;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            crc = (byte)(crc ^ b);
            ++n2;
        }
        return crc;
    }

    private static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase().replace(" ", "");
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(UsbTypeA.charToByte(hexChars[pos]) << 4 | UsbTypeA.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
            ++i;
        }
        return stringBuilder.toString();
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    private static byte getXor(byte[] datas) {
        byte temp = datas[0];
        int i = 1;
        while (i < datas.length) {
            temp = (byte)(temp ^ datas[i]);
            ++i;
        }
        return temp;
    }
}

