/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.util;

import android.content.Context;
import com.telpo.tps550.api.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LEDUtil {
    private static final String ENCODE = "GB2312";
    private static final String ZK16 = "hzk16";
    private static final String ASC16 = "asc16";
    private byte[][] arr;
    byte[] bitmapC51 = new byte[512];
    private int all_16_32 = 16;
    private int all_2_4 = 2;
    private int all_32_128 = 32;
    private int font_width = 8;
    private int font_height = 16;
    private int all_16 = 16;
    Context mContext;

    public LEDUtil(Context context) {
        this.mContext = context;
    }

    private byte[][] resolveString(String str) {
        byte[] data = null;
        int[] code = null;
        if (str.charAt(0) < '\u0080') {
            this.arr = new byte[this.font_height][this.font_width];
            data = this.read_a(str.charAt(0));
            int byteCount = 0;
            int line = 0;
            while (line < 16) {
                int lCount = 0;
                int k = 0;
                while (k < 1) {
                    int j = 0;
                    while (j < 8) {
                        this.arr[line][lCount] = (data[byteCount] >> 7 - j & 1) == 1 ? (byte)1 : 0;
                        ++lCount;
                        ++j;
                    }
                    ++byteCount;
                    ++k;
                }
                ++line;
            }
        } else {
            this.arr = new byte[this.all_16_32][this.all_16_32];
            code = this.getByteCode(str.substring(0, 1));
            data = this.read(code[0], code[1]);
            int byteCount = 0;
            int line = 0;
            while (line < this.all_16_32) {
                int lCount = 0;
                int k = 0;
                while (k < this.all_2_4) {
                    int j = 0;
                    while (j < 8) {
                        this.arr[line][lCount] = (data[byteCount] >> 7 - j & 1) == 1 ? (byte)1 : 0;
                        ++lCount;
                        ++j;
                    }
                    ++byteCount;
                    ++k;
                }
                ++line;
            }
        }
        return this.arr;
    }

    private byte[] read_a(char char_num) {
        byte[] data = null;
        char ascii = char_num;
        try {
            data = new byte[this.all_16];
            InputStream inputStream = this.mContext.getResources().getAssets().open(ASC16);
            int offset = ascii * 16;
            inputStream.skip(offset);
            inputStream.read(data, 0, this.all_16);
            inputStream.close();
            return data;
        }
        catch (IOException e) {
            e.printStackTrace();
            return data;
        }
    }

    private byte[] read(int areaCode, int posCode) {
        byte[] data = null;
        try {
            int area = areaCode - 160;
            int pos = posCode - 160;
            InputStream in = this.mContext.getResources().getAssets().open(ZK16);
            long offset = this.all_32_128 * ((area - 1) * 94 + pos - 1);
            in.skip(offset);
            data = new byte[this.all_32_128];
            in.read(data, 0, this.all_32_128);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    private int[] getByteCode(String str) {
        int[] byteCode = new int[2];
        try {
            byte[] data = str.getBytes(ENCODE);
            byteCode[0] = data[0] < 0 ? 256 + data[0] : data[0];
            byteCode[1] = data[1] < 0 ? 256 + data[1] : data[1];
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return byteCode;
    }

    public byte[] getTextC51(String lcdText) {
        int rowSize = 0;
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        int[][] pixel = new int[32][128];
        boolean secondBlock = false;
        int i = 0;
        while (i < lcdText.length()) {
            int b;
            int a;
            String checkText = String.valueOf(lcdText.charAt(i));
            Matcher m = p.matcher(checkText);
            if (checkText.equals("\n") || rowSize == 120 && (m.matches() || checkText.equals("\u221a") || checkText.equals("\u03c0") || checkText.equals("\u00f7") || checkText.equals("\u00d7") || checkText.equals("\u00b0") || checkText.equals("\u2105") || checkText.equals("\u00b6") || checkText.equals("\u2206") || checkText.equals("\u00a9") || checkText.equals("\u00ae") || checkText.equals("\u2122"))) {
                secondBlock = true;
                rowSize = 0;
            }
            byte[][] num = checkText.equals("f") ? this.getSpecialChar("f") : (checkText.equals("j") ? this.getSpecialChar("j") : (checkText.equals("\u2022") ? this.getSpecialSign("\u2022") : (checkText.equals("\u2206") ? this.getSpecialSign("\u2206") : (checkText.equals("\u00a5") ? this.getSpecialSign("\u00a5") : (checkText.equals("\u00a2") ? this.getSpecialSign("\u00a2") : (checkText.equals("\u20ac") ? this.getSpecialSign("\u20ac") : (checkText.equals("\u00a3") ? this.getSpecialSign("\u00a3") : this.resolveString(checkText))))))));
            if (!secondBlock) {
                a = 0;
                while (a < num.length) {
                    b = 0;
                    while (b < num[a].length) {
                        pixel[a][b + rowSize] = num[a][b] == 0 ? 0 : 1;
                        ++b;
                    }
                    ++a;
                }
            } else if (secondBlock) {
                a = 0;
                while (a < num.length) {
                    b = 0;
                    while (b < num[a].length) {
                        pixel[a + 16][b + rowSize] = num[a][b] == 0 ? 0 : 1;
                        ++b;
                    }
                    ++a;
                }
            }
            rowSize = m.matches() ? (rowSize += 16) : (checkText.equals("\u221a") || checkText.equals("\u03c0") || checkText.equals("\u00f7") || checkText.equals("\u00d7") || checkText.equals("\u00b0") || checkText.equals("\u2105") || checkText.equals("\u00b6") || checkText.equals("\u2206") || checkText.equals("\u00a9") || checkText.equals("\u00ae") || checkText.equals("\u2122") ? (rowSize += 16) : (rowSize += 8));
            if (rowSize == 128) {
                rowSize = 0;
                secondBlock = true;
            }
            ++i;
        }
        StringBuffer pageOne = new StringBuffer();
        byte[] bitmapC51One = new byte[128];
        int y = 0;
        while (y < 128) {
            pageOne.setLength(0);
            int x = 7;
            while (x > -1) {
                pageOne.append(pixel[x][y]);
                --x;
            }
            bitmapC51One[y] = this.BToH(pageOne.toString());
            ++y;
        }
        StringBuffer pageTwo = new StringBuffer();
        byte[] bitmapC51Two = new byte[128];
        int y2 = 0;
        while (y2 < 128) {
            pageTwo.setLength(0);
            int x = 15;
            while (x > 7) {
                pageTwo.append(pixel[x][y2]);
                --x;
            }
            bitmapC51Two[y2] = this.BToH(pageTwo.toString());
            ++y2;
        }
        StringBuffer pageThree = new StringBuffer();
        byte[] bitmapC51Three = new byte[128];
        int y3 = 0;
        while (y3 < 128) {
            pageThree.setLength(0);
            int x = 23;
            while (x > 15) {
                pageThree.append(pixel[x][y3]);
                --x;
            }
            bitmapC51Three[y3] = this.BToH(pageThree.toString());
            ++y3;
        }
        StringBuffer pageFour = new StringBuffer();
        byte[] bitmapC51Four = new byte[128];
        int y4 = 0;
        while (y4 < 128) {
            pageFour.setLength(0);
            int x = 31;
            while (x > 23) {
                pageFour.append(pixel[x][y4]);
                --x;
            }
            bitmapC51Four[y4] = this.BToH(pageFour.toString());
            ++y4;
        }
        System.arraycopy(bitmapC51One, 0, this.bitmapC51, 0, bitmapC51One.length);
        System.arraycopy(bitmapC51Two, 0, this.bitmapC51, 128, bitmapC51Two.length);
        System.arraycopy(bitmapC51Three, 0, this.bitmapC51, 256, bitmapC51Three.length);
        System.arraycopy(bitmapC51Four, 0, this.bitmapC51, 384, bitmapC51Four.length);
        return this.bitmapC51;
    }

    private byte BToH(String a) {
        String b = Integer.toHexString(Integer.valueOf(this.toD(a, 2)));
        if (b.length() == 1) {
            b = "0" + b;
        }
        return StringUtil.toBytes(b)[0];
    }

    private String toD(String a, int b) {
        int r = 0;
        int i = 0;
        while (i < a.length()) {
            r = (int)((double)r + (double)this.formatting(a.substring(i, i + 1)) * Math.pow(b, a.length() - i - 1));
            ++i;
        }
        return String.valueOf(r);
    }

    private int formatting(String a) {
        int i = 0;
        int u = 0;
        while (u < 10) {
            if (a.equals(String.valueOf(u))) {
                i = u;
            }
            ++u;
        }
        if (a.equals("a")) {
            i = 10;
        }
        if (a.equals("b")) {
            i = 11;
        }
        if (a.equals("c")) {
            i = 12;
        }
        if (a.equals("d")) {
            i = 13;
        }
        if (a.equals("e")) {
            i = 14;
        }
        if (a.equals("f")) {
            i = 15;
        }
        return i;
    }

    private byte[][] getSpecialChar(String character) {
        int j;
        int[][] blackSign = new int[16][8];
        byte[][] num_char = this.resolveString(character);
        int i = 0;
        while (i < num_char.length) {
            j = 0;
            while (j < num_char[i].length) {
                if (num_char[i][j] == 1) {
                    num_char[i][j] = 0;
                    if (character.equals("f")) {
                        blackSign[i][j + 2] = 1;
                    } else if (character.equals("j")) {
                        blackSign[i][j - 1] = 1;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < blackSign.length) {
            j = 0;
            while (j < blackSign[i].length) {
                if (blackSign[i][j] == 1) {
                    num_char[i][j] = 1;
                }
                ++j;
            }
            ++i;
        }
        return num_char;
    }

    private byte[][] getSpecialSign(String character) {
        byte[][] num_sign;
        block8: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                num_sign = null;
                                if (!character.equals("\u2022")) break block7;
                                num_sign = new byte[16][8];
                                num_sign[9][4] = 1;
                                num_sign[9][3] = 1;
                                num_sign[9][2] = 1;
                                num_sign[8][5] = 1;
                                num_sign[8][4] = 1;
                                num_sign[8][3] = 1;
                                num_sign[8][2] = 1;
                                num_sign[8][1] = 1;
                                num_sign[7][5] = 1;
                                num_sign[7][4] = 1;
                                num_sign[7][3] = 1;
                                num_sign[7][2] = 1;
                                num_sign[7][1] = 1;
                                num_sign[6][5] = 1;
                                num_sign[6][4] = 1;
                                num_sign[6][3] = 1;
                                num_sign[6][2] = 1;
                                num_sign[6][1] = 1;
                                num_sign[5][4] = 1;
                                num_sign[5][3] = 1;
                                num_sign[5][2] = 1;
                                break block8;
                            }
                            if (!character.equals("\u2206")) break block9;
                            num_sign = new byte[16][16];
                            num_sign[9][13] = 1;
                            num_sign[9][1] = 1;
                            num_sign[8][12] = 1;
                            num_sign[8][2] = 1;
                            num_sign[7][11] = 1;
                            num_sign[7][3] = 1;
                            num_sign[6][10] = 1;
                            num_sign[6][4] = 1;
                            num_sign[5][9] = 1;
                            num_sign[5][5] = 1;
                            num_sign[4][8] = 1;
                            num_sign[4][6] = 1;
                            num_sign[3][7] = 1;
                            int y = 0;
                            while (y < 15) {
                                num_sign[10][y] = 1;
                                ++y;
                            }
                            break block8;
                        }
                        if (!character.equals("\u00a5")) break block10;
                        num_sign = this.resolveString("Y");
                        int y = 2;
                        while (y < 6) {
                            num_sign[7][y] = 1;
                            ++y;
                        }
                        y = 2;
                        while (y < 6) {
                            num_sign[9][y] = 1;
                            ++y;
                        }
                        num_sign[11][5] = 0;
                        num_sign[11][2] = 0;
                        num_sign[6][5] = 0;
                        num_sign[6][2] = 0;
                        break block8;
                    }
                    if (!character.equals("\u00a2")) break block11;
                    num_sign = this.resolveString("c");
                    int y = 2;
                    while (y < 4) {
                        num_sign[3][y] = 1;
                        num_sign[4][y] = 1;
                        num_sign[12][y] = 1;
                        num_sign[13][y] = 1;
                        ++y;
                    }
                    break block8;
                }
                if (!character.equals("\u20ac")) break block12;
                num_sign = new byte[16][8];
                int x = 2;
                while (x < 11) {
                    num_sign[x][1] = 1;
                    num_sign[x][2] = 1;
                    ++x;
                }
                num_sign[1][5] = 1;
                num_sign[1][4] = 1;
                num_sign[1][3] = 1;
                num_sign[11][5] = 1;
                num_sign[11][4] = 1;
                num_sign[11][3] = 1;
                num_sign[5][4] = 1;
                num_sign[5][3] = 1;
                num_sign[5][0] = 1;
                num_sign[7][4] = 1;
                num_sign[7][3] = 1;
                num_sign[7][0] = 1;
                break block8;
            }
            if (!character.equals("\u00a3")) break block8;
            num_sign = new byte[16][8];
            int x = 2;
            while (x < 10) {
                num_sign[x][1] = 1;
                num_sign[x][2] = 1;
                ++x;
            }
            num_sign[1][4] = 1;
            num_sign[1][3] = 1;
            num_sign[2][5] = 1;
            num_sign[6][4] = 1;
            num_sign[6][3] = 1;
            num_sign[6][0] = 1;
            num_sign[10][1] = 1;
            int y = 0;
            while (y < 6) {
                num_sign[11][y] = 1;
                ++y;
            }
        }
        return num_sign;
    }
}

