/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import com.telpo.tps550.api.util.ShellUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReaderUtils {
    static String[] nation_list = new String[]{"\u6c49", "\u8499\u53e4", "\u56de", "\u85cf", "\u7ef4\u543e\u5c14", "\u82d7", "\u5f5d", "\u58ee", "\u5e03\u4f9d", "\u671d\u9c9c", "\u6ee1", "\u4f97", "\u7476", "\u767d", "\u571f\u5bb6", "\u54c8\u5c3c", "\u54c8\u8428\u514b", "\u50a3", "\u9ece", "\u5088\u50f3", "\u4f64", "\u7572", "\u9ad8\u5c71", "\u62c9\u795c", "\u6c34", "\u4e1c\u4e61", "\u7eb3\u897f", "\u666f\u9887", "\u67ef\u5c14\u514b\u5b5c", "\u571f", "\u8fbe\u65a1\u5c14", "\u4eeb\u4f6c", "\u7f8c", "\u5e03\u6717", "\u6492\u62c9", "\u6bdb\u5357", "\u4ee1\u4f6c", "\u9521\u4f2f", "\u963f\u660c", "\u666e\u7c73", "\u5854\u5409\u514b", "\u6012", "\u4e4c\u5b5c\u522b\u514b", "\u4fc4\u7f57\u65af", "\u9102\u6e29\u514b", "\u5fb7\u6602", "\u4fdd\u5b89", "\u88d5\u56fa", "\u4eac", "\u5854\u5854\u5c14", "\u72ec\u9f99", "\u9102\u4f26\u6625", "\u8d6b\u54f2", "\u95e8\u5df4", "\u73de\u5df4", "\u57fa\u8bfa", "\u5176\u4ed6", "\u5916\u56fd\u8840\u7edf\u4e2d\u56fd\u7c4d\u4eba\u58eb"};

    public static String get_nation(int index) {
        return nation_list[index];
    }

    public static int count_chinese(String str) {
        int count = 0;
        Pattern p = Pattern.compile("[\\u4e00-\\u9fa5]");
        Matcher m = p.matcher(str);
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public static String get_finger_info(Context ctx, byte[] fpData) {
        String fingerInfo = "";
        if (fpData != null && fpData.length == 1024 && fpData[0] == 67) {
            fingerInfo = String.valueOf(fingerInfo) + ReaderUtils.GetFingerName(ctx, fpData[5]);
            fingerInfo = fpData[4] == 1 ? String.valueOf(fingerInfo) + " \u6307\u7eb9\u8d28\u91cf= " + String.valueOf(fpData[6]) : String.valueOf(fingerInfo) + ReaderUtils.GetFingerStatus(ctx, fpData[4]);
            fingerInfo = String.valueOf(fingerInfo) + "  ";
            if (fpData[512] == 67) {
                fingerInfo = String.valueOf(fingerInfo) + ReaderUtils.GetFingerName(ctx, fpData[517]);
                fingerInfo = fpData[516] == 1 ? String.valueOf(fingerInfo) + " \u6307\u7eb9\u8d28\u91cf= " + String.valueOf(fpData[518]) : String.valueOf(fingerInfo) + ReaderUtils.GetFingerStatus(ctx, fpData[516]);
            }
        } else {
            fingerInfo = "(\u6307\u7eb9\u672a\u8bfb\u53d6\u6216\u4e0d\u542b\u6307\u7eb9)";
        }
        return fingerInfo;
    }

    private static String GetFingerName(Context ctx, int fingerPos) {
        String fingerName = "";
        switch (fingerPos) {
            case 11: {
                fingerName = "\u53f3\u624b\u62c7\u6307";
                break;
            }
            case 12: {
                fingerName = "\u53f3\u624b\u98df\u6307";
                break;
            }
            case 13: {
                fingerName = "\u53f3\u624b\u4e2d\u6307";
                break;
            }
            case 14: {
                fingerName = "\u53f3\u624b\u73af\u6307";
                break;
            }
            case 15: {
                fingerName = "\u53f3\u624b\u5c0f\u6307";
                break;
            }
            case 16: {
                fingerName = "\u5de6\u624b\u62c7\u6307";
                break;
            }
            case 17: {
                fingerName = "\u5de6\u624b\u98df\u6307";
                break;
            }
            case 18: {
                fingerName = "\u5de6\u624b\u4e2d\u6307";
                break;
            }
            case 19: {
                fingerName = "\u5de6\u624b\u73af\u6307";
                break;
            }
            case 20: {
                fingerName = "\u5de6\u624b\u5c0f\u6307";
                break;
            }
            case 97: {
                fingerName = "\u53f3\u624b\u4e0d\u786e\u5b9a\u6307\u4f4d";
                break;
            }
            case 98: {
                fingerName = "\u5de6\u624b\u4e0d\u786e\u5b9a\u6307\u4f4d";
                break;
            }
            case 99: {
                fingerName = "\u5176\u4ed6\u4e0d\u786e\u5b9a\u6307\u4f4d";
                break;
            }
            default: {
                fingerName = "\u6307\u4f4d\u672a\u77e5";
            }
        }
        return fingerName;
    }

    private static String GetFingerStatus(Context ctx, int fingerStatus) {
        String fingerStatusName = "";
        switch (fingerStatus) {
            case 1: {
                fingerStatusName = "\u6ce8\u518c\u6210\u529f";
                break;
            }
            case 2: {
                fingerStatusName = "\u6ce8\u518c\u5931\u8d25";
                break;
            }
            case 3: {
                fingerStatusName = "\u672a\u6ce8\u518c";
                break;
            }
            case 9: {
                fingerStatusName = "\u6ce8\u518c\u72b6\u6001\u672a\u77e5";
                break;
            }
            default: {
                fingerStatusName = "\u6ce8\u518c\u72b6\u6001\u672a\u77e5";
            }
        }
        return fingerStatusName;
    }

    public static boolean check_package(Context ctx, String packageName) {
        Intent intent;
        PackageManager manager = ctx.getPackageManager();
        List infos = manager.queryIntentActivities(intent = new Intent().setPackage(packageName), 32);
        return infos != null && infos.size() >= 1;
    }

    public static byte get_checksum(byte[] data, int start, int length) {
        byte crc = 0;
        int i = 0;
        while (i < length && start + i < length) {
            crc = (byte)(crc ^ data[start + i]);
            ++i;
        }
        return crc;
    }

    public static boolean check_checksum(byte[] data, int start, int length) {
        if (start < 0 || data.length < start + length) {
            return false;
        }
        byte crc = 0;
        int i = 0;
        while (i < length - 1) {
            crc = (byte)(crc ^ data[start + i]);
            ++i;
        }
        return crc == data[start + i];
    }

    public static byte[] merge(byte[] hand, byte[] tail) {
        if (hand == null) {
            return tail;
        }
        byte[] data3 = new byte[hand.length + tail.length];
        System.arraycopy(hand, 0, data3, 0, hand.length);
        System.arraycopy(tail, 0, data3, hand.length, tail.length);
        return data3;
    }

    public static String byte2HexString(byte[] data, int start, int len) {
        if (data == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            String hex = Integer.toHexString(data[start + i] & 0xFF).toUpperCase();
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    public static String byte2HexString(byte[] data) {
        if (data == null) {
            return "";
        }
        int length = data.length;
        return ReaderUtils.byte2HexString(data, 0, length);
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        if ((hexString = hexString.toUpperCase()).length() % 2 != 0) {
            hexString = String.valueOf('0') + hexString;
        }
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(ReaderUtils.charToByte(hexChars[pos]) << 4 | ReaderUtils.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static void idcard_poweron() {
        ShellUtils.execCommand("echo 3 > /sys/class/telpoio/power_status", false);
    }

    public static void idcard_poweroff() {
        ShellUtils.execCommand("echo 4 > /sys/class/telpoio/power_status", false);
    }
}

