/*
 * Decompiled with CFR 0.152.
 */
package com.telpo.tps550.api.util;

import android.util.Log;
import com.telpo.tps550.api.util.ShellUtils;
import java.io.File;
import java.io.RandomAccessFile;

public class SystemUtil {
    public static final int READER_VPOS3583 = 0;
    public static final int READER_AU9540_GCS = 1;
    public static final int READER_AU9560_GCS = 2;
    public static final int READER_AU9540_GBS = 3;
    public static final int READER_AU9560_GBS = 4;
    public static final int READER_MSR = 5;
    public static final int PRINTER_HDX = 0;
    public static final int PRINTER_PRT_COMMON = 1;
    public static final int PRINTER_PRT_BAIDU = 2;
    public static final int PRINTER_JX3R02 = 3;
    public static final int PRINTER_JX3R03 = 4;
    public static final int PRINTER_JX2R22 = 5;
    public static final int PRINTER_PT486F08401MB = 6;
    public static final int PRINTER_PT723F08401 = 7;
    public static final int PRINTER_SY581 = 8;

    static {
        System.loadLibrary("system_util");
    }

    private static native int get_device_type();

    private static native int get_icc_reader_type();

    private static native int get_printer_type();

    private static native int get_printer581_type();

    public static int getDeviceType() {
        return SystemUtil.get_device_type();
    }

    public static int getICCReaderType() {
        return SystemUtil.get_icc_reader_type();
    }

    public static int getPrinterType() {
        return SystemUtil.get_printer_type();
    }

    public static int checkPrinter581() {
        Log.d((String)"tagg", (String)"checkPrinter581");
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand("cat /sys/kernel/debug/usb/devices", false);
        if (commandResult.successMsg.contains("USB Thermal Printer")) {
            return 1;
        }
        int printerCheck = SystemUtil.get_printer581_type();
        if (printerCheck == 8) {
            SystemUtil.writeTxtToFile("SY581", "/sdcard/tpsdk/printerVersion.txt");
        } else if (printerCheck == 7) {
            SystemUtil.writeTxtToFile("PT72", "/sdcard/tpsdk/printerVersion.txt");
        } else if (printerCheck == 2) {
            SystemUtil.writeTxtToFile("PT72", "/sdcard/tpsdk/printerVersion.txt");
        }
        return printerCheck;
    }

    private static void writeTxtToFile(String strcontent, String fileName) {
        String strContent = strcontent;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            } else {
                file.delete();
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            RandomAccessFile raf = new RandomAccessFile(file, "rwd");
            raf.seek(file.length());
            raf.write(strContent.getBytes());
            raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

