/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.android.IDReader;

import android.graphics.Bitmap;
import android.graphics.Matrix;

public class IDPhotoHelper {
    public static Bitmap Bgr2Bitmap(byte[] bgrbuf) {
        int width = 102;
        int height = 126;
        Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        int row = 0;
        int col = width - 1;
        int i = bgrbuf.length - 1;
        while (i >= 3) {
            int color = bgrbuf[i] & 0xFF;
            color += bgrbuf[i - 1] << 8 & 0xFF00;
            bmp.setPixel(col--, row, color += bgrbuf[i - 2] << 16 & 0xFF0000);
            if (col < 0) {
                col = width - 1;
                ++row;
            }
            i -= 3;
        }
        return bmp;
    }

    public static Bitmap createMyBitmap(byte[] data, int width, int height) {
        int[] colors = IDPhotoHelper.convertByteToColor(data);
        if (colors == null) {
            return null;
        }
        Bitmap bmp = null;
        try {
            bmp = Bitmap.createBitmap((int[])colors, (int)0, (int)width, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (Exception e) {
            return null;
        }
        return bmp;
    }

    private static int[] convertByteToColor(byte[] data) {
        int size = data.length;
        if (size == 0) {
            return null;
        }
        int arg = 0;
        if (size % 3 != 0) {
            arg = 1;
        }
        int[] color = new int[size / 3 + arg];
        if (arg == 0) {
            int i = 0;
            while (i < color.length) {
                color[i] = data[i * 3] << 16 & 0xFF0000 | data[i * 3 + 1] << 8 & 0xFF00 | data[i * 3 + 2] & 0xFF | 0xFF000000;
                ++i;
            }
        } else {
            int i = 0;
            while (i < color.length - 1) {
                color[i] = data[i * 3] << 16 & 0xFF0000 | data[i * 3 + 1] << 8 & 0xFF00 | data[i * 3 + 2] & 0xFF | 0xFF000000;
                ++i;
            }
            color[color.length - 1] = -16777216;
        }
        return color;
    }

    private static Bitmap rotateBitmap(Bitmap origin, float alpha) {
        if (origin == null) {
            return null;
        }
        int width = origin.getWidth();
        int height = origin.getHeight();
        Matrix matrix = new Matrix();
        matrix.setRotate(alpha);
        Bitmap newBM = Bitmap.createBitmap((Bitmap)origin, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
        if (newBM.equals(origin)) {
            return newBM;
        }
        origin.recycle();
        return newBM;
    }
}

