/*
 * Decompiled with CFR 0.152.
 */
package com;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import com.softwinner.Gpio;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Calendar;

public class zcapi {
    private Context mContext = null;
    private String TAG = "zcapi";
    private final String zcApiVersion = "2.7";

    public void getContext(Context context) {
        this.mContext = context;
        zcapi.setProperty("sys.zc.ZCAPIversion", "2.7");
    }

    public void shutDown() {
        Intent intent = new Intent("wits.action.shutdown");
        this.mContext.sendBroadcast(intent);
    }

    public void reboot() {
        Intent intent = new Intent("wits.action.reboot");
        this.mContext.sendBroadcast(intent);
    }

    public void factoryReset() {
        Intent intent = new Intent("com.zc.factorymaster");
        this.mContext.sendBroadcast(intent);
    }

    public void updateOta() {
        Intent intent = new Intent("com.zc.update");
        this.mContext.sendBroadcast(intent);
    }

    public void setStatusBar(boolean enable) {
        if (enable) {
            Intent intent = new Intent("show.systemui");
            this.mContext.sendBroadcast(intent);
        } else {
            Intent intent = new Intent("hide.systemui");
            this.mContext.sendBroadcast(intent);
        }
    }

    public void setGestureStatusBar(boolean enable) {
        if (enable) {
            Intent intent = new Intent("com.zc.open_gesture");
            this.mContext.sendBroadcast(intent);
        } else {
            Intent intent = new Intent("com.zc.close_gesture");
            this.mContext.sendBroadcast(intent);
        }
    }

    public void setPowetOnOffTime(boolean enable, int[] timeOn, int[] timeOff) {
        Calendar calendar = Calendar.getInstance();
        long currentTime = System.currentTimeMillis();
        long pastTime = currentTime - 1000000L;
        calendar.setTimeInMillis(pastTime);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int[] outTime = new int[]{year, month, day, hour, minute};
        int[] Time1 = new int[]{year, month, day, hour, minute + 5};
        int[] Time2 = new int[]{year, month, day, hour, minute + 3};
        if (!enable) {
            Intent intent = new Intent("android.56iq.intent.action.setpoweronoff");
            intent.putExtra("timeon", Time1);
            intent.putExtra("timeoff", Time2);
            intent.putExtra("enable", false);
            this.mContext.sendBroadcast(intent);
            return;
        }
        if (timeOn == null && timeOff == null) {
            Log.i((String)"", (String)"============Time setting cannot be empty======================");
        } else if (timeOff == null && timeOn != null) {
            if (timeOn[0] >= 1970 && outTime[0] >= 1970) {
                Intent intent = new Intent("android.56iq.intent.action.setpoweronoff");
                intent.putExtra("timeon", timeOn);
                intent.putExtra("timeoff", outTime);
                intent.putExtra("enable", enable);
                this.mContext.sendBroadcast(intent);
            } else {
                Log.i((String)"", (String)"============time set fail======================");
            }
        } else if (timeOn == null && timeOff != null) {
            if (outTime[0] >= 1970 && timeOff[0] >= 1970) {
                Intent intent = new Intent("android.56iq.intent.action.setpoweronoff");
                intent.putExtra("timeon", outTime);
                intent.putExtra("timeoff", timeOff);
                intent.putExtra("enable", enable);
                this.mContext.sendBroadcast(intent);
            } else {
                Log.i((String)"", (String)"============time set fail======================");
            }
        } else if (timeOn[0] >= 1970 && timeOff[0] >= 1970) {
            Intent intent = new Intent("android.56iq.intent.action.setpoweronoff");
            intent.putExtra("timeon", timeOn);
            intent.putExtra("timeoff", timeOff);
            intent.putExtra("enable", enable);
            this.mContext.sendBroadcast(intent);
        } else {
            Log.i((String)"", (String)"============time set fail======================");
        }
    }

    public String getBuildModel() {
        return Build.MODEL;
    }

    @SuppressLint(value={"NewApi"})
    public String getBuildSerial() {
        String serial = "";
        if (Build.VERSION.SDK_INT >= 28) {
            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method get = c.getMethod("get", String.class);
                serial = (String)get.invoke(c, "ro.serialno");
            }
            catch (Exception var4) {
                var4.printStackTrace();
            }
        } else {
            serial = Build.SERIAL;
        }
        return serial;
    }

    private String loadFileAsString(String filePath) throws IOException {
        int numRead;
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        boolean var5 = false;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
        }
        reader.close();
        return fileData.toString();
    }

    public String getEthMacAddress() {
        try {
            return this.loadFileAsString("/sys/class/net/eth0/address").toUpperCase().substring(0, 17);
        }
        catch (IOException var2) {
            var2.printStackTrace();
            return "no eth";
        }
    }

    public String getEthMacAddress(String ifaceName) {
        try {
            String ethPath = "/sys/class/net/";
            if (ifaceName != null) {
                return this.loadFileAsString(ethPath + ifaceName + "/address").toUpperCase().substring(0, 17);
            }
            return this.loadFileAsString("/sys/class/net/eth0/address").toUpperCase().substring(0, 17);
        }
        catch (IOException var2) {
            var2.printStackTrace();
            return "no eth";
        }
    }

    public String getWifiMacAddress() {
        try {
            File mfile = new File("/sys/class/net/wlan0/address");
            return mfile.exists() ? this.loadFileAsString("/sys/class/net/wlan0/address").toUpperCase().substring(0, 17) : "please open wifi";
        }
        catch (IOException var2) {
            var2.printStackTrace();
            return "please open wifi";
        }
    }

    public void setLcdOnOff(boolean enable) {
        if (enable) {
            Intent intent = new Intent("com.zc.zclcdon");
            this.mContext.sendBroadcast(intent);
        } else {
            Intent intent = new Intent("com.zc.zclcdoff");
            this.mContext.sendBroadcast(intent);
        }
    }

    public void setLcdOnOff(boolean enable, int lcdOrHdmi) {
        if (enable) {
            Intent intent = new Intent("com.zc.zclcdon");
            intent.putExtra("LcdHdmiOn", lcdOrHdmi);
            this.mContext.sendBroadcast(intent);
        } else {
            Intent intent = new Intent("com.zc.zclcdoff");
            intent.putExtra("LcdHdmiOff", lcdOrHdmi);
            this.mContext.sendBroadcast(intent);
        }
    }

    public void SetStaticIP(String ip, String gateway, String netMask, String dns1, String dns2) {
        Intent intent = new Intent();
        intent.putExtra("ipAddr", ip);
        intent.putExtra("gateway", gateway);
        intent.putExtra("netMask", netMask);
        intent.putExtra("dns1", dns1);
        intent.putExtra("dns2", dns2);
        intent.setAction("wits.intent.action.setethernetconfig");
        this.mContext.sendBroadcast(intent);
    }

    public void SetStaticIP(String ip, String gateway, String netMask, String dns1, String dns2, String ifaceName) {
        Intent intent = new Intent();
        intent.putExtra("ipAddr", ip);
        intent.putExtra("gateway", gateway);
        intent.putExtra("netMask", netMask);
        intent.putExtra("dns1", dns1);
        intent.putExtra("dns2", dns2);
        intent.putExtra("ifaceName", ifaceName);
        intent.setAction("wits.intent.action.setethernetconfig");
        this.mContext.sendBroadcast(intent);
    }

    public void setDHCP() {
        Intent intent = new Intent("wits.intent.action.setethernetdhcp");
        this.mContext.sendBroadcast(intent);
    }

    public void setDHCP(String ifaceName) {
        Intent intent = new Intent("wits.intent.action.setethernetdhcp");
        intent.putExtra("ifaceName", ifaceName);
        this.mContext.sendBroadcast(intent);
    }

    public void setMulSelGpio(char group, int num, int value) {
        Gpio.setMulSel((char)group, (int)num, (int)value);
    }

    public int readGpio(char group, int num) {
        return Gpio.readGpio((char)group, (int)num);
    }

    public void writeGpio(char group, int num, int value) {
        Gpio.writeGpio((char)group, (int)num, (int)value);
    }

    public void execShellCmd(String cmd) {
        Intent intent = new Intent("com.zc.zcCmd");
        intent.putExtra("cmd", cmd);
        this.mContext.sendBroadcast(intent);
    }

    public void setSystemTime(int[] time) {
        Intent intent = new Intent("wits.intent.action.setsystimes");
        intent.putExtra("year", time[0]);
        intent.putExtra("month", time[1]);
        intent.putExtra("monthDay", time[2]);
        intent.putExtra("hour", time[3]);
        intent.putExtra("minute", time[4]);
        intent.putExtra("msecond", time[5]);
        this.mContext.sendBroadcast(intent);
    }

    public void watchDogEnable(boolean dog) {
        if (dog) {
            Intent intent = new Intent("com.zc.open_and_eat_dog");
            this.mContext.sendBroadcast(intent);
        } else {
            Intent intent = new Intent("com.zc.close_dog");
            this.mContext.sendBroadcast(intent);
        }
    }

    public void screenshot(String path, String name) {
        Intent intent = new Intent("com.zc.screenshot");
        intent.putExtra("path", path);
        intent.putExtra("name", name);
        this.mContext.sendBroadcast(intent);
    }

    public void InstallApk(String path, boolean mode) {
        Intent intent = new Intent("com.zc.InstallApk");
        intent.putExtra("path", path);
        intent.putExtra("mode", mode);
        this.mContext.sendBroadcast(intent);
    }

    public int getCameraStatus() {
        return 0;
    }

    public int getDisplayScreenStatus() {
        return 0;
    }

    public int getMicStatus() {
        return 0;
    }

    public int getSpeakerStatus() {
        return 0;
    }

    public int getStorageStatus() {
        return 0;
    }

    public int getTouchPanelStatus() {
        return 0;
    }

    public int getWifiStatus() {
        zcapi.setProperty("sys.zc.wifiCheck", "1");
        String state = zcapi.getProperty("sys.zc.wifiStatus", "1");
        int i = Integer.valueOf(state);
        if (i == 1) {
            return 0;
        }
        return -1;
    }

    public String getZcapiVersion() {
        return "2.7";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String key, String defaultValue) {
        String value = defaultValue;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class, String.class);
            value = (String)get.invoke(c, key, "unknown");
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return value;
        }
    }

    public static void setProperty(String key, String value) {
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method set = c.getMethod("set", String.class, String.class);
            set.invoke(c, key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setWlanIpAddress(boolean useStatic, String ip, String gateway, String netMask, String dns1, String dns2) {
        Intent intent = new Intent();
        intent.putExtra("useStatic", useStatic);
        intent.putExtra("ipAddr", ip);
        intent.putExtra("gateway", gateway);
        intent.putExtra("netMask", netMask);
        intent.putExtra("dns1", dns1);
        intent.putExtra("dns2", dns2);
        intent.setAction("wits.intent.action.setwlanconfig");
        this.mContext.sendBroadcast(intent);
    }

    public void openCloseEth(String ifaceName, boolean ethEnable) {
        Intent intent = new Intent();
        intent.putExtra("ifaceName", ifaceName);
        intent.putExtra("ethEnable", ethEnable);
        intent.setAction("zc.intent.action.ethEnable");
        this.mContext.sendBroadcast(intent);
    }

    public void openCloseWifi(boolean wifiEnable) {
        Intent intent = new Intent();
        intent.putExtra("wifiEnable", wifiEnable);
        intent.setAction("zc.intent.action.wifiEnable");
        this.mContext.sendBroadcast(intent);
    }

    public void openCloseBluetooth(boolean bluetoothEnable) {
        Intent intent = new Intent();
        intent.putExtra("bluetoothEnable", bluetoothEnable);
        intent.setAction("zc.intent.action.bluetoothEnable");
        this.mContext.sendBroadcast(intent);
    }

    public void silentUninstallApk(String name) {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.setAction("action.zc.silentUninstall");
        this.mContext.sendBroadcast(intent);
    }

    public void setInstallApkControl(String enable) {
        zcapi.setProperty("persist.sys.install", enable);
    }

    public String getZckjID() {
        String serial = "unknown";
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            serial = (String)get.invoke(c, "persist.zc.serialno");
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return serial;
    }
}

